﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="../WebAppPanel.master" validateRequest="false" 
    AutoEventWireup="true" CodeBehind="ServoHomeDriveEnable.aspx.cs" Inherits="GladinetPayFlow.ServoHomeDriveEnable"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

        .checkstyle{
            font-size: 18px!important;
        }
        label{
            font-size: 20px!important;
        }

    </style>
    <script type="text/javascript">

        function ReturnLast() {
            window.location = "ServoHomeDrive.aspx";
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocTheSpeUseDoeHavEnoPer" meta:resourcekey="str_theSpeUseDoeHavEnoPer" Visible="false">The specified user doesn't have enough permission:</asp:Localize>
<asp:Localize runat="server" ID="LocSpecStoConCanNotVer" meta:resourcekey="str_specStoConCanNotVer" Visible="false">The specified storage configuration cannot be verified. Error code:</asp:Localize>
    <asp:Localize id="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>

    <div style="width: 100%; padding: 5px;height:60px; border-bottom:1px solid #cccccc;" class="meubardrop1">
    <table style="width: 100%">
            <tr>
                <td height="60px" valign="middle" >
                    <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;"><asp:Localize runat="server" meta:resourcekey="str_enaPerHomDri">Enable Personal Home Drive</asp:Localize></span>
                </td>
                <td style="font-size: 16">
                <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                  { %>
                <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" 
                    meta:resourcekey="ErrorMsgResource1"></asp:Label>
                <%} %>
            </td>
                <td align="right" style="padding-right: 10px;" valign="middle">
                    <div class="sectextcolor" style="width: 40px; font-size: 32px; font-weight: 100; cursor: pointer; padding-top: 5px;" onclick="ReturnLast();">&times;</div>
                </td>
            </tr>
        </table>
    </div>
      
    
    <div class="wrapper" style="background-color: white; width:100%;margin-top: 30px;font-size: 18px; align-content:center;">
        <asp:Panel ID="Step1Panel" runat="server">
            <table width="100%">
                
                <tr>
                    <td align="center">
                        <table  width="100%" align="center" style="max-width:800px; padding: 3px; padding-top: 0px; padding-bottom: 0px; background-color: white;"
        cellspacing="0" >
                   <tr>
                    <td style="padding:5px; font-size:20px; font-weight:400; padding-bottom:40px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_pleSpeStoLocFor">Please specify the storage location for Personal Home Drive</asp:Localize></td>
                </tr>
                    <tr>
                        <td >
                            <asp:RadioButton ID="CIFSStorage" runat="server" CausesValidation="false" ForeColor="#565656" CssClass="checkstyle"
                                AutoPostBack="True" Text="Use an existing file server or local disk as enterprise storage"
                                GroupName="StorageTypeGroup"  
                               
                                oncheckedchanged="CIFSStorage_CheckedChanged" 
                                meta:resourcekey="CIFSStorageResource1" />
                        </td>
                    </tr>
                    <tr>
                        <td valign="top" style="padding-left:45px;">
                            <asp:Panel ID="CIFSPanel" runat="server" meta:resourcekey="CIFSPanelResource1" Visible="False">
                                            <table width="100%">
                                                <tr>
                                                    <td>
                                                        <asp:Localize meta:resourcekey="asp_string2" runat="server" Visible="False" ID="StoreLoc">Local Storage Location (C:\myfolder or \\myfileserver\share)</asp:Localize><asp:RequiredFieldValidator
                                                            ControlToValidate="StorageLocation" ID="RequiredFieldValidator1" 
                                                            runat="server" ErrorMessage="Required"
                                                            ForeColor="Red" Display="Dynamic" CssClass="errmsg" 
                                                            ValidationGroup="CIFSSetting" 
                                                            meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style=" font-weight: 100;">
                                                        <asp:TextBox ID="StorageLocation" runat="server" Width="95%" 
                                                            meta:resourcekey="StorageLocationResource1" placeholder="Local Storage Location (C:\myfolder or \\myfileserver\share)"
                                                            CssClass="dark form-control"  ></asp:TextBox>
                                                    </td>
                                                </tr>
                                                    <tr>
                                                    <td>
                                                        <asp:Localize meta:resourcekey="asp_string3" runat="server" Visible="False" ID="StrUser">User Name (for local storage access)</asp:Localize>&nbsp;<asp:RequiredFieldValidator
                                                            ControlToValidate="StorageUser" ID="RequiredFieldValidator2" 
                                                            runat="server" ErrorMessage="Required"
                                                            ForeColor="Red" Display="Dynamic" CssClass="errmsg" 
                                                            ValidationGroup="CIFSSetting" 
                                                            meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td  style="padding-bottom:6px; font-weight: 100;!important">
                                                        <asp:TextBox ID="StorageUser" runat="server" Width="95%" 
                                                            meta:resourcekey="StorageUserResource1" placeholder="User Name (for local storage access)"
                                                            CssClass="form-control"></asp:TextBox>
                                                    </td>
                                                </tr>
                                                    <tr>
                                                    <td>
                                                        <asp:Localize meta:resourcekey="asp_string4" runat="server" Visible="False" ID="StrPwd">Password (for local storage access):</asp:Localize>&nbsp;<asp:RequiredFieldValidator
                                                            ControlToValidate="StoragePassword" ID="RequiredFieldValidator3" 
                                                            runat="server" ErrorMessage="Required"
                                                            ForeColor="Red" Display="Dynamic" CssClass="errmsg" 
                                                            ValidationGroup="CIFSSetting" 
                                                            meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td  style="padding-bottom:6px; font-weight: 100;">
                                                        <asp:TextBox ID="StoragePassword" runat="server" Width="95%" placeholder="Password (for local storage access)"
                                                            TextMode="Password" meta:resourcekey="StoragePasswordResource1" 
                                                            CssClass="form-control dark"></asp:TextBox>
                                                    </td>
                                                </tr>
                                                <tr style="display:none;">
                                                <td style="padding-top:5px;">
                                                    <asp:CheckBox ID="SambaShare" runat="server" Font-Bold=True 
                                                        Text="The share is from a Linux/Unix/ZFS Server" 
                                                        meta:resourcekey="SambaShareResource1"/> 
                                                </td>
                                                </tr>
                                                <tr style="display:none;">
                                                <td style="padding-top:5px;">
                                                    <asp:CheckBox ID="DFSShare" runat="server" Font-Bold=True 
                                                        Text="The share is a DFS share" 
                                                        /> 
                                                </td>
                                                </tr>
                                            </table>
                            </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-top:20px;">
                            <asp:RadioButton ID="CloudStorage" runat="server"  CssClass="checkstyle"  CausesValidation="false"
                                Text="Use cloud storage as enterprise storage" GroupName="StorageTypeGroup" 
                                AutoPostBack="True" oncheckedchanged="CloudStorage_CheckedChanged" 
                                meta:resourcekey="CloudStorageResource1" />
                        </td>
                    </tr>
                    <tr>
                        <td style="padding-top:5px;padding-left:45px;" valign="top">
                            <asp:Panel ID="CloudPanel" runat="server" Visible="False" 
                                meta:resourcekey="CloudPanelResource1">
                                <table width="100%" align="center" style="padding: 3px; padding-top: 0px; padding-bottom: 0px;"
                                    cellspacing="0">
                                    
                                    <tr>
                                        <td   height="80px">
                                            <asp:DropDownList ID="StorageType" runat="server" Width="100%" meta:resourcekey="StorageTypeResource1"  CssClass="browser-default custom-select secsubbordercolor"
                                               >
                                            </asp:DropDownList>
                                        </td>
                                       
                                    </tr>
                                    <tr>
                                        <td height="150px">&nbsp;</td>
                                    </tr>
                                </table>
                                <%if (!IsServiceProviderPackage())
                                  { %>
                                 <table width="100%" style="display:none;">
                <tr>
                <td style="padding:5px">
                    <asp:CheckBox ID="EnableDARE" runat="server" 
                        Text="Enable data at rest encryption" Font-Size="12pt" ForeColor="#009000" 
                        meta:resourcekey="EnableDAREResource1"/> 
                </td>
                </tr>
                <tr>
                <td style="padding:5px">
                    <asp:Localize meta:resourcekey="asp_string5" runat="server">If "Encryption" is checked, your data will be stored in encrypted form using a key derived from the password specified below. 
                        Enabling this option may reduce the performance of uploads and downloads. You cannot mix plain files and encrypted files in your account. 
                        Please specify the encryption password below, and save it away in a safe place in case you need to recover encrypted files with a new account setup.  </asp:Localize>                  
                </td>
                </tr>
                <tr>
                <td style="padding:5px">
                    <asp:TextBox ID="DAREPwd" runat="server" width="95%" 
                        meta:resourcekey="DAREPwdResource1"></asp:TextBox>
                </td>
                </tr>
                </table>
                <%} %>
                            </asp:Panel>
                        </td>
                    </tr>
                    <tr>
                    <td align="right" style="padding-top:40px;">
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step1Contine" runat="server"  CausesValidation="false" OnClick="Step1Contine_Click" meta:resourcekey="str_nex">Next</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="CancelBtn" runat="server"  CausesValidation="false" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>
                </table>
                    </td>
                </tr>
            </table>
            
        </asp:Panel>
        <asp:Panel ID="Step2Panel" runat="server" Visible="false">
            <table width="100%"  style="max-width:800px;" align="center">
         
                <tr>
                    <td style="height:60px">&nbsp;</td>
                </tr>
                <tr>
                    <td style="padding:5px; font-size:20px; font-weight:400; padding-bottom:40px; color:#565656;"><asp:Localize runat="server" meta:resourcekey="str_set">Settings</asp:Localize></td>
                </tr>
         <tr>
             <td style="padding-bottom:20px;">
                 
                                     <asp:CheckBox ID="DisableAttach" runat="server" checked="true"
                    Text="Disable backup/attach local folder from client device" 
                    meta:resourcekey="DisableAttachResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;">
                    <asp:Localize ID="Localize9" meta:resourcekey="asp_string6" runat="server" Text="When set, the functionality of backup or attaching local folder from a client device
                        is disabled"></asp:Localize></p>
                 
             </td>
         </tr>

        

         
         <tr>
                    <td align="right" style="padding-top:40px; border-top:1px solid #f0f0f0;">
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="Step2Back" runat="server" OnClick="Step2Back_Click" meta:resourcekey="str_bac">Back</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step2ContinueBtn" runat="server" OnClick="Step2Contine_Click" meta:resourcekey="str_app">Apply</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton2" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>
        </table>
        </asp:Panel>
        

     
        </div>
    
    <asp:Localize ID="NOTConfig"  meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 

            <asp:HiddenField ID="FUserCode" runat="server" />
                            <asp:HiddenField ID="FSessionId" runat="server" />
                            <asp:HiddenField ID="FCode" runat="server" />
                            <asp:HiddenField ID="FInCode" runat="server" />

    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>
     
    <script type="text/javascript">
     
    </script>
    
</asp:Content>
