﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="ServoDashboard.aspx.cs" Inherits="GladinetPayFlow.ServoDashboard" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
       .edge{
           box-shadow: 5px 0px 2px 0 rgba(0,0,0,0.25);
       }
       @media (max-width: 1200px) {
           #info_td {width:310px !important;}
       }
       @media (min-width: 1201px) {
           #info_td {width:600px !important;}
       }

    .hintd{ font-size:16px;font-weight:200;white-space:nowrap;padding:0px 20px 0px 20px;text-align:left;line-height:45px; }
    .leftmeuitem{clear:both;border-bottom:1px solid #f0f0f0;display: block !important;padding-left:5px;padding-right:0px;height:47px;}
    #leftMenuBody,#leftmenu {display:block;width:230px;overflow-x:hidden;}
    #leftMenuBody .icond{display:block;float:left;padding:0px 10px 0px 5px;width:55px;}
    .gladinet-icons.md-32 { font-size: 32px; line-height:45px; }
    .frameArea{border-right: 1px solid #eeeeee;padding-left:20px;width:100%;}
    .frameArea iframe{width:100%;border:none;height:calc(100vh - 7px);}
    #main_body{position:relative; overflow:hidden;}
       
       .menucollapsed{
            width :70px;
             transition-timing-function: cubic-bezier(0,0,0.58,1);

       }
      .menuexpanded{
            width :280px;
             transition-timing-function: cubic-bezier(0,0,0.58,1);

       }   
      #pinIcon{line-height:12px;margin-left:5px;}
      #pinIcon.pinned{margin-top:0px;}
      #pinIcon.unpinned{margin-top:-10px;}
    </style>
    <script type="text/javascript">  
        try {
            if (window.location.href == window.top.location.href) {
                console.log("reload with parent frame");
                window.top.location.href = "/management/clustermgrconsole";
            }
        } catch (ex) {}

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':').replace(/'/g, '%27');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }
            return s;
        }
        function EditFolderPermission(location) {
            CurrentActiveIFrame = 'edit_perm_window';
            var uri = "/portal/FolderPerms.aspx?location=";
            uri += gEncodeUri(location);
            uri += "&src=filebrowser";
            OpenMainWindow(uri, "<asp:Localize meta:resourcekey="str_ediFolPer" runat="server">Edit Folder Permissions</asp:Localize> - "+ location);
            RefreshOnClose = true;
        }
        function AddServer() {
            br = true;
            qw = document.getElementById('servers_f');
            

            OpenQuickWindow("AddServer.aspx", "<%=AddNewServer.Text %>");
         }

        function clickSvrs() {
            
            parent.SetRootPageTitleNoLoading("Dashboard", "/management/servo/DashboadInfo.aspx");
            
            var f = document.getElementById('servers_f');
            f.src = "DashboadInfo.aspx";

            /*f = document.getElementById('info_f');
            f.style.width = "600px";
            f.src = "RootInfo.aspx";
            f = document.getElementById('info_td');
            f.style.display = "";
            */
            return;

        }

        function SetRootItem(u, n)
        {
            OpenLeftMain(u, n);

        }

        function closeCancelActiveWin() {
            if (OpenQuick) {
                CloseQuickWindow();
            } else if (SubSubUri != "") {
                closeThirdMenu();
            } else {


            }

        }

        function ClickCloudFileServer() {

            SetSecondMenuView( "CloudFileServer.aspx?vdid=<%=SessionDomainId%>", "Cloud File Server");

        }
        
         function ClickSvr(name, hid, fqdn) {
             
             if (name.indexOf("$$") == 0) {
                 SetSecondMenuView("RemoteFileServer.aspx?vdid=<%=SessionDomainId%>&hid=" + hid, fqdn);
             } else {
                 SetSecondMenuView("ServerShares.aspx?vdid=<%=SessionDomainId%>&svr=" + name, fqdn);
             }
         }

        var SubMainUri = "";
        var SubMainTitle = "";
        function SetSecondMenuView(url, fqdn) {
             
             var f = document.getElementById('servers_f');
             Wait();
             
             SubMainUri = url;
             SubMainTitle = fqdn;
             f.src = url;

             parent.SetSubMainMenu(fqdn);

        }

        function ClearSubMenu()
        {
            parent.ClearSubMenu();
        }

        function OnClickMainView() {
            
            SetSecondMenuView(SubMainUri, SubMainTitle);
        }


        function OpenLeftMain(src, n) {
            if (!n)
                n = "";

            SetSecondMenuView(src, n);

        }

        function OnClickSubMain() {
            OnClickMainView();
        }

        var SubSubUri = "";
        var SubSubTitle = "";
        function OnClickSubView() {
            SetThirdMenuView(SubSubUri, SubSubTitle);
        }

        function closeThirdMenu() {
            if (SubSubUri != "") {
                SubSubUri = "";
                SubSubTitle = "";
                OnClickMainView();
            }

        }
        function SetThirdMenuView(url, fqdn) {

            var f = document.getElementById('servers_f');
            f.src = "/portal/WaitWin.htm";


            setTimeout(function () {
                SubSubUri = url;
                SubSubTitle = fqdn;
                f.src = url;
                f = document.getElementById('info_td');
                f.style.display = "none";
                f = document.getElementById('servers_td');
                f.style.display = "";

                parent.SetSubSubTitle(fqdn);
            }, 100);
            return;
        }

        function ClickSvrShare(svrName, ShareName, dsharename) {
            
            if (dsharename == null)
                dsharename = ShareName; 
            SetThirdMenuView("ShareInfo.aspx?vdid=<%=SessionDomainId%>&svr=" + svrName + "&sh=" + encodeURIComponent(ShareName), dsharename);
            
        }
        function ClickSASvrShare(svrName, ShareName, hid) {
            SetThirdMenuView("ShareInfo.aspx?vdid=<%=SessionDomainId%>&svr=" + svrName+"&sh="+ShareName+"&hid="+hid, ShareName);
        }

        function OnStorageDetail()
        {
            SetThirdMenuView('/management/UserStorageStat.aspx?child=1&domain=1&uid=<%=SessionDomainId%>&vdid=<%=SessionDomainId%>', "Storage Detail");
            
        }

        function MigrateStorage() {
            SetThirdMenuView('/management/AddHomeStorageMigrateTask.aspx?vdid=<%=ViewSessionDomainId %>', "Migrate Personal Home Storage"); 
        }
        function EditLocalStorage() {
            SetThirdMenuView('/management/AddLocalStorage.aspx?f=/&did=<%=SessionDomainId %>', "Edit Personal Home Storage"); 
          }

          function EditCloudStorage() {

              SetThirdMenuView('/management/SelectProvider.aspx?c=1&f=/&did=<%=SessionDomainId %>', "Edit Personal Home Storage");

            return;


        }

        var lurl;
        function SetCurrentRelativeTitle(n) {
            parent.SetSubMainMenu(n);
        }

        

        function ReturnLastSub() {
            OnClickSubMain();
        }
        function SetRelativePageTitle(n,src) {
            SetThirdMenuView(src, n);
        }




        function CloseLeftMain() {
            clickSvrs();
        }
        function OnUserManager() {
            SetActiveLeftMenuItem("user_menu");
            SetRootItem("/portal/UserMgrPage.aspx?vdid=<%=SessionDomainId%>&child=1", "User Manager");
            
            
        }
        function OnUserManager() {
            SetActiveLeftMenuItem("user_menu");
            SetRootItem("/portal/UserMgrPage.aspx?vdid=<%=SessionDomainId%>&child=1", "User Manager");
            
            
        }

        function OnRansomwarePanel() {            
                    SetRootItem("/management/csbiz/CSBizRansomPanel.aspx?vdid=<%=SessionDomainId%>&child=1", "Ransomware Protection");
        }
        function OnDLPPanel() {
            
            SetRootItem("/management/csbiz/CSBizDLPPanel.aspx?vdid=<%=SessionDomainId%>&child=1", "Data Leak Protection");
            
            
        }

        function onLicenseInfo() {

            SetRootItem("/management/servo/ServoLicense.aspx", "License Info");


        }
        function SetSelectedUser(UserList) {

            var child = document.getElementById("servers_f");
            try {
                SelWin.close();
            } catch (e) {
            }
            try {
                CloseQuickWindow();
            } catch (e) {
            }

            child.contentWindow.OnUserSelected(UserList);


        }

        function OnUserSelected(UserList) {

            var child = document.getElementById("servers_f");
            try {
                SelWin.close();
            } catch (e) {
            }
            try {
                CloseQuickWindow();
            } catch (e) {
            }

            child.contentWindow.OnUserSelected(UserList);


        }

       
        function SetActiveLeftMenuItem(id) {
            
            try {
                var elements = document.getElementsByClassName("leftmeuitem");
                if (elements && elements.length != 0) {
                    for (var i = 0; i < elements.length; ++i) {
                        elements[i].className = "filerow leftmeuitem";
                    }
                }
            } catch (e) {

            }
            var e = document.getElementById(id);
            if(e)
                e.className = "filerow leftmeuitem selbox";
        }

        function DownloadClient()
        {
            OpenLeftMain("ServoClients.aspx", "Client Downloads");
        }

        function OnCloudBackup()
        {
            OpenLeftMain("ServoBackupSummary.aspx", "Cloud Backup");
        }

        function OnDeviceMgr() {
            
            SetActiveLeftMenuItem("devs_menu");
            SetRootItem("/management/servo/MDevicesPage.aspx?vdid=<%=SessionDomainId%>", "Device Manager");
        }
        function OnServers() {
            
            SetActiveLeftMenuItem("svrs_menu");
            SetRootItem("/management/servo/ServersMgr.aspx", "File Servers");
        }
        function OnPublishedShares() {
            
            SetActiveLeftMenuItem("pshares_menu");
            SetRootItem("/management/servo/PublishedShares.aspx", "Published Shares");
        }

        

        function OnGroupMgr() {

            OpenLeftMain("/portal/GroupMgrPage.aspx?vdid=<%=SessionDomainId%>", "Group Manager");
        }
        function OnRoleMgr() {

            OpenLeftMain("/management/RoleMgrPage.aspx?vdid=<%=SessionDomainId%>", "Role Manager");
        }
        
        function onUpgradeBiz(f)
        {
            OpenLeftMain("ServoUpgradeBiz.aspx?child=1&f="+f, "Upgrade to Business Edition");
        }
        function on2FA()
        {
            OpenLeftMain("Servo2FA.aspx?child=1", "2-Step Verification");
        }
            
        function OnEnable2FA()
        {
            OpenLeftMain("Servo2FAEnable.aspx?child=1", "Enable 2-Step Verification");
        }
        function OnGuestUserMgr() {

            OpenLeftMain("/management/GuestUserMgrPage.aspx?vdid=<%=SessionDomainId%>&child=1", "Guest User Manager");
        }
        function OnReports() {

            SetActiveLeftMenuItem("report_menu");
            SetRootItem("/management/servo/ServoReportsPanel.aspx?vdid=<%=SessionDomainId%>", "Reports");
        }

        function OnEnableSSO() {
            OpenLeftMain("ServoSecSSOCfg.aspx?child=1&f=saml", "Enable Single-Sign-On");
        }

        function OnEnableAD()
        {
            OpenLeftMain("ServoLDAPEnable.aspx?child=1", "Enable Active Directory Integration");
        }
        
        function OnEnablePersonalHome()
        {
            OpenLeftMain("ServoHomeDriveEnable.aspx", "Enable Personal Home Drive");
        }

        function onPersonalHome() {
            OpenLeftMain("ServoHomeDrive.aspx?vdid=<%=SessionDomainId %>", "Personal Home Drive");
        }
        
        function OnRasomeProtection() {

            OpenLeftMain("ShareVirus.aspx?vdid=<%=SessionDomainId %>", "Ransomware Protection");
        }
         function OnSettings() {
             SetActiveLeftMenuItem("settings_menu");
             //SetRootItem("/management/servo/rootinfo.aspx", "Settings");
             SetRootItem("/management/csbiz/CsBizSettings.aspx", "Settings");
             
         }
         function OnClientDownload() {
             SetActiveLeftMenuItem("download_menu");
             SetRootItem("/management/servo/servoclients.aspx", "Client Downloads");
         }

         

        function OnEditWorkerNode(s) {

            OpenLeftMain("/management/WorkerNode.aspx?f=" + s, "Edit Worker Node -" + s);
        }

        function OnLDAPCfg() {

            OpenLeftMain("ServoLDAPCfgPage.aspx?c=1&g=<%=SessionDomainId%>", "Active Directory");
        }

        function onSingleSignon()
        {
            OpenLeftMain("ServoSecSSO.aspx?child=1", "Single Sign On");
        }


        function OnCpl()
        {
            SetThirdMenuView("ServoControlPanel.aspx", "Advanced Settings");
        }

        function ReturnLast()
        {
            
            parent.SetRootPageTitleNoLoading("Dashboard", "/management/servo/ServoDashboard.aspx");
            CloseLeftMain();
        }

        function OnDashboard() {
            parent.SetRootPageTitleNoLoading("Dashboard", "/management/servo/ServoDashboard.aspx");
            CloseLeftMain();
        }

        


        function GetCurrentQuickWinUrl() {
            if (document.documentElement.clientHeight < 750) {
                var f = document.getElementById('quickwindowalt');
                return f.src;

            }

            e = document.getElementById("ShortWindow");
            return e.src;
        }

        function OpenMainWindow(u, t) {
            OpenQuickWindow(u, t);
        }

        var br = false;
        var qw = null;

        function RightOpenQuickWindow(u, t) {
            br = true;
            OpenQuickWindow(u, t);
        }
        var OpenQuick = false;
        function OpenQuickWindow(u, t) {
            OpenQuick = true;
            if (document.documentElement.clientHeight < 750) {
                var f = document.getElementById('quickwindowalt');
                f.src = u;

                f = document.getElementById('alttitle');
                f.innerHTML = t;


                f = document.getElementById('alttable');
                f.style.display = "";
                f = document.getElementById('main_body');
                f.style.display = "none";

                f = document.getElementById('alttable');
                f.style.height = (document.documentElement.clientHeight - 25) + "px";

                
                f = document.getElementById('quickwindowalt');
                f.style.height = (document.documentElement.clientHeight - 112) + "px";

                return;
            }

            var e = document.getElementById("ShortTitle");
            e.innerHTML = t;

            e = document.getElementById("ShortBody");

            if (document.documentElement.clientHeight < 750)
                e.style.height = "500px"
            else
                e.style.height = "600px"

            e = document.getElementById("ShortWindow");
            e.src = u;
            
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }

        function CloseQuickWindow(u, t) {
            OpenQuick = false;
            br = false;
            try {
                var e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

            } catch (ee) {

            }
            try {
                $('#ShortWindowModal').modal('hide');

            } catch (e) {

            }

            try {
                var f = document.getElementById('quickwindowalt');
                f.src = "/portal/WaitWin.htm";
                f = document.getElementById('alttable');
                f.style.display = "none";
                f = document.getElementById('main_body');
                f.style.display = "";


            } catch (e) {

            }

        }

        function closeActiveWin() {
            
            closeThirdMenu();
            
            var br1 = br;
            CloseQuickWindow();
            
            
            if (br1) {
                try {
                    
                    if (qw.contentWindow.OnRefresh)
                        qw.contentWindow.OnRefresh();
                } catch (e) {
                    alert(e);
                }
            }
            
              CloseLeftMain();
        }

        function adjust() {

            var f = document.getElementById('main_body');
            f.style.height = (document.documentElement.clientHeight - 10) + "px";
            //f.style.width = (document.documentElement.clientWidth-48) + "px";

            f = document.getElementById('alttable');
            f.style.height = (document.documentElement.clientHeight - 10) + "px";

            f = document.getElementById('quickwindowalt');
            f.style.height = (document.documentElement.clientHeight - 48) + "px";

            

        }
        
        function getMenuPinState(){
            var dashmenu = localStorage.getItem("dashmenu");
            if(dashmenu!="pinned_open" && dashmenu!="pinned_closed" && dashmenu!="unpinned"){
                dashmenu = "unpinned"; 
            }
            return dashmenu;
        }
        function togglePinMenu(initialSet)
        {     
            var unpinnedIconCode = "&#x00eb;";
            var pinnedIconCode = "&#x01bb;";
            var dashmenuState = getMenuPinState();
            if(initialSet){
                //page loaded
                if(dashmenuState=="pinned_open"){  
                    ToggleLeftMenu('open', false); 
                } else {       
                    ToggleLeftMenu('close', false); 
                }
            }else{    
                //user clicked on pin
                if(dashmenuState=="pinned_closed" || dashmenuState=="pinned_open")
                {                
                    dashmenuState="unpinned";
                }
                else if(dashmenuState=="unpinned")
                {                                     
                    if(_menuMode == "open"){       
                        dashmenuState="pinned_open";
                    }else{            
                        dashmenuState="pinned_closed";
                    }
                }
            }    
            $("#pinIcon").removeClass("pinned");  
            $("#pinIcon").removeClass("unpinned"); 
            if(dashmenuState=="pinned_closed" || dashmenuState=="pinned_open"){   
                $("#pinIcon").html(pinnedIconCode);   
                $("#pinIcon").addClass("pinned");  
            }else{ 
                $("#pinIcon").html(unpinnedIconCode);  
                $("#pinIcon").addClass("unpinned"); 
            }
            setPinTooltip();
            localStorage.setItem("dashmenu", dashmenuState); 
        }
        function setPinTooltip(){
            var dashmenuState = getMenuPinState();
            if(dashmenuState=="pinned_closed" || dashmenuState=="pinned_open"){   
                $("#pinIcon").prop("title", "        <%=LocReleaseMenu.Text%>   ");   
            }else{
                if(_menuMode == "open"){   
                    $("#pinIcon").prop("title", "        <%=LocKeepMenuOpen.Text%>   "); 
                }else{   
                    $("#pinIcon").prop("title", "        <%=LocKeepMenuClosed.Text%>   "); 
                }
            }
        }
    </script>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">                                  
    <asp:Localize ID="LocKeepMenuOpen" meta:resourcekey="str_keepMenuOpen" runat="server" Visible="false">Keep Menu Open</asp:Localize>   
    <asp:Localize ID="LocKeepMenuClosed" meta:resourcekey="str_keepMenuClosed" runat="server" Visible="false">Keep Menu Closed</asp:Localize>
    <asp:Localize ID="LocReleaseMenu" meta:resourcekey="str_releaseMenu" runat="server" Visible="false">Release Menu</asp:Localize>
    
    <table style="width: 100%; margin-top:-2px; " id="main_body"  >
        <tr>
            <td style="border-right: 1px solid #f0f0f0;padding:30px 0px 0px 0px;vertical-align: top;height:100vh;" id="leftmenu" class="lightbgcolor">
                
                <i id="pinIcon" class="icond gladinet-icons md-12 md-dark hand center" onclick="togglePinMenu(false)" onmouseover="setPinTooltip()"></i>
                <div id="leftMenuBody" onmouseover="OnExpandLeft()">
                       <% if (m_CanViewShares) { %> 
                       <div class="filerow leftmeuitem" onclick="OnPublishedShares(this);" id="pshares_menu">
                           <i class="icond gladinet-icons md-32 md-dark hand center">a</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_pubSha">Published Shares</asp:Localize></div>
                       </div>
                      <% } %> 
                       <% if (!SessionIsClusterAdminByRole) { %>  
                      <div class="filerow leftmeuitem" onclick="OnServers(this);" id="svrs_menu">
                          <i class="icond gladinet-icons md-32 md-dark hand center">W</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_filSer">File Servers</asp:Localize></div>
                      </div>                  
                      <div class="filerow leftmeuitem" onclick="OnDeviceMgr()" id="devs_menu">
                          <i class="icond gladinet-icons md-32 md-dark hand center">)</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_dev">Devices</asp:Localize></div>
                      </div>     
                      <% } %> 
                      <% if (m_CanViewUsers) { %> 
                      <div class="filerow leftmeuitem" onclick="OnUserManager();" id="user_menu">
                          <i class="icond gladinet-icons md-32 md-dark hand center">M</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_use">Users</asp:Localize></div>
                      </div>
                      <% } %> 
                      <% if (m_CanViewReports) { %>  
                      <div class="filerow leftmeuitem" onclick="OnReports();" id="report_menu">
                          <i class="icond gladinet-icons md-32 md-dark hand center">R</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_rep">Reports</asp:Localize></div>
                      </div>
                      <% } %>     
                       <% if (!SessionIsClusterAdminByRole) { %>     
                      <div class="filerow leftmeuitem" onclick="OnSettings();" id="settings_menu">
                          <i class="icond gladinet-icons md-32 md-dark hand center">g</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_set">Settings</asp:Localize></div>
                      </div>     
                      <% } %> 
                      <div class="filerow leftmeuitem" onclick="OnClientDownload();" id="download_menu">
                          <i class="icond gladinet-icons md-32 md-dark hand center">&#xe1;</i><div class="sectextcolor hintd"><asp:Localize runat="server" meta:resourcekey="str_cliDow">Client Downloads</asp:Localize></div>
                      </div>
                  </div>
                
            </td>
            <td class="frameArea" id="servers_td" onmouseover="OnCloseLeft()">
                <iframe src="DashboadInfo.aspx" id="servers_f" ></iframe>
            </td>
            <td class="frameArea" style="display: none;" id="share_td" onmouseover="OnCloseLeft()">
                <iframe id="share_f"></iframe>
            </td>
            
            <td class="frameArea" style="display:none;" id="info_td" onmouseover="OnCloseLeft()">
                <iframe src="" id="info_f"></iframe>
            </td>
        </tr>
    </table>
    <div width="100%" style="display: none;" id="alttable">
        <div style="width:100%; padding:10px;" class="meubardrop">
            <table style="width:100%">
        <tr >
            <td style="height: 32px; padding-right: 10px; font-size: 16px; font-size: 100; text-transform: uppercase; color:#404040;" valign="middle"  id="alttitle"></td>
            <td align="right" style="height: 48px; padding-right: 10px; font-size: 20px" valign="middle" >
                <i class="btn btn-primary gladmbtn gladinet-icons" style="font-weight:400!important; font-size:20px!important;" onclick="CloseQuickWindow(); return false;">&#XFB;</i> 
                
        </tr>

            </table>
        </div>
            <table style="width:100%; margin-top:12px;">
        <tr>
            <td colspan="2">
                <iframe width="100%" frameborder="0"
                    border="0" id="quickwindowalt"></iframe>
            </td>
        </tr>
                </table>
    </div>
    <div id="ShortWindowModal" class="modal fade" role="dialog">
        <div class="modal-dialog " style="max-width: 850px!important; width: 850px!important; padding: 0px!important;">

            <!-- Modal content-->
            <div class="modal-content" style="padding: 0px!important;">
                <div class="modal-header">

                    <h4 class="modal-title" style="color: #808080;" id="ShortTitle"></h4>
                    <button type="button" class="close" onclick="CloseQuickWindow();">&times;</button>
                </div>
                <div class="modal-body" style="height: 600px; padding-top: 0px; padding: 0px!important;" id="ShortBody">
                    <iframe id='ShortWindow' width="100%" style="padding: 0px;" src="/portal/WaitWin.htm"
                        frameborder="0" border="0" height="100%"></iframe>
                </div>
            </div>

        </div>
    </div>
    <asp:Localize ID="AddNewServer" meta:resourcekey="AddNewServer" runat="server" Visible="false">Add New Server</asp:Localize>
    <script type="text/javascript">
        var _menuMode = "close";
        function SetMenuPos(step, menuMode) {
            $('#leftMenuBody,#leftmenu').css({ "width": step + "px" });
            _menuMode = menuMode;
        }
        function ToggleLeftMenu(mode, animate) {
            var menuPinState = getMenuPinState();
            var totalMenuSize = 230;
            var iconSize = 60;
            var hideableMenuArea = (totalMenuSize - iconSize);//total menu size minus icons
            var stepSize = parseInt(hideableMenuArea / 4);
            var left1, left2, left3, left4;
            if (mode == "close") {
                    left1 = stepSize * 4;
                    left2 = stepSize * 3;
                    left3 = stepSize * 2;
                    left4 = iconSize;
            } else {
                    left1 = iconSize;
                    left2 = stepSize * 2;
                    left3 = stepSize * 3;
                    left4 = totalMenuSize;  
            }    
            if(menuPinState=="pinned_open"){
                SetMenuPos(totalMenuSize, mode);
                return;
            } else if(menuPinState=="pinned_closed"){
                SetMenuPos(iconSize, mode); 
                return;
            }
            if(animate){    
                setTimeout(function () { SetMenuPos(left1, "animate"); }, 50);
                setTimeout(function () { SetMenuPos(left2, "animate"); }, 100);
                setTimeout(function () { SetMenuPos(left3, "animate"); }, 150);
                setTimeout(function () { SetMenuPos(left4, mode); }, 200);
            }else{
                SetMenuPos(left4, mode);
            }    
            setPinTooltip();
        }
        function AdjustSize() {

        }
        
        function OnExpandLeft() {
            if (_menuMode == "close") {
                ToggleLeftMenu('open');
            }
        }

        function OnCloseLeft() {
            if (_menuMode == "open") {
                ToggleLeftMenu('close');
            }
        }

        Ext.onReady(function () {
            setTimeout("ToggleLeftMenu('close');", 2000);

            AdjustSize();      
            togglePinMenu(true);

        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });




    </script>

</asp:Content>
