﻿<%@ Page Title="" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true" EnableSessionState="false" 
    CodeBehind="ServoClients.aspx.cs" Inherits="GladinetPayFlow.ServoClients" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .appheader
        {
            background-color:#f0f0f0;
            border-bottom: 1px solid #cccccc;
            height: 40px;
            color: #404040;
            font-weight: 200;
            font-size: 20px;
            padding-bottom:5px;
            text-align:center;
            padding-top:5px;
        }
                
       .svgImg{
           height:64px;
       }
        .mobileStoreCell{width:160px;text-align: center;margin:0px auto 20px auto;}
        .mobileStoreCell a{font-size:15px !important;line-height:15px;}
        ::-webkit-scrollbar {width: auto !important;}
        .fullContainer {width:100%;padding-top:20px;padding-left:20px;padding-right:20px;}
        .inlineItem {display:inline-block;position:relative;top:6px;margin-right:5px;}
        .idea_flex{white-space:nowrap;}
        @media (max-width: 640px){
           #divWinLogos{
             background-image:url(/portal/images/windows-logo-sm.jpg);width:131px;height:299px;margin:0px auto 0px auto;
           }
           #divWinSvrLogos{
             background-image:url(/portal/images/winsvr-logo-sm.jpg);width:131px;height:299px;margin:0px auto 0px auto;
           }
           #divMacLogos{
             background-image:url(/portal/images/macosx-logo-sm.jpg);width:131px;height:205px;margin:0px auto 0px auto;
           }
           .mobileStoreCell{width:200px;}
           #bottomSpacer{height:250px;clear:both;width:100%;}
        }
        @media (min-width: 641px) and (max-width: 992px){
           #divWinLogos{
             background-image:url(/portal/images/windows-logo-md.jpg);width:349px;height:96px;margin:0px auto 0px auto;
           }
           #divWinSvrLogos{
             background-image:url(/portal/images/winsvr-logo-md.jpg);width:349px;height:96px;margin:0px auto 0px auto;
           }
           #divMacLogos{
             background-image:url(/portal/images/macosx-logo-md.jpg);width:227px;height:96px;margin:0px auto 0px auto;
           }
           .mobileStoreCell{width:200px;}
           #bottomSpacer{height:250px;clear:both;width:100%;}
        }
        @media (min-width: 993px){
           #divWinLogos{
             background-image:url(/portal/images/windows-logo.jpg);background-size:250px 51px;width:250px;height:51px;margin:0px auto 10px auto;
           }
           #divWinSvrLogos{
             background-image:url(/portal/images/winsvr-logo.jpg);background-size:250px 51px;width:250px;height:51px;margin:0px auto 10px auto;
           }
           #divMacLogos{
             background-image:url(/portal/images/macosx-logo.jpg);background-size:162px 51px;width:162px;height:51px;margin:0px auto 10px auto;
           }
           .mobileStoreCell{width:160px;}
           #bottomSpacer{height:120px;clear:both;width:100%;}
        }
        .mobileStoreCell a img {width:100%;margin-left:auto;margin-right:auto;}
        .mobileStoreCell .captcha {width:80%;margin-left:auto;margin-right:auto;}
    </style>
<script type="text/javascript">
    function isAppleDesktop() {
        var isMac = navigator.platform.toUpperCase().indexOf('MAC') >= 0;
        var isMacLike = navigator.platform.match(/(Mac|iPhone|iPod|iPad)/i) ? true : false;
        return (isMac && isMacLike);
    }
    function downloadInIFrame(url) {
        //downloads in iframe to prevent electron from leaving a blank window opened
        $("#downloadframe").prop("src", url);
    }
    function onClickDeviceManager()
    {
        window.location = "/management/servo/MDevicesPage.aspx?vdid=<%=SessionDomainId%>";
    }

</script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
     <div style="width:100%; height:48px; border-bottom:1px solid #eeeeee; display:none;" >
        <button class="btn btn-primary gladbtn" style="font-weight:400!important; font-size:20px!important;"><asp:Localize runat="server" meta:resourcekey="str_cliDow">Client Downloads</asp:Localize></button>
        <div style="display:none;">
        <i class="gladinet-icons md-24 md-dark hand center" onclick="onClickDeviceManager();" title="<asp:Localize runat="server" meta:resourcekey="str_devMan">Device Manager</asp:Localize>">c</i>
        </div>
      </div>
    
    <div style="width:100%;padding:20px 30px 0px 30px;font-size:18px;display:none;">
        <p><asp:Localize runat="server" meta:resourcekey="str_broFilExpProMos">The browser-based file explorer provides most of the basic functionality. For a richer, native experience, you can download native clients.</asp:Localize></p>
    </div>
    <div style="width:100%; padding:20px">
    <asp:Panel ID="WindowsClientPanel" runat="server" meta:resourcekey="WindowsClientPanelResource1">   
        <div style="width:100%;margin-top:10px;" class="staticviewcard">
            <div class="appheader">
                <%: m_ProductName %> <asp:Localize meta:resourcekey="string2" runat="server" Text="Desktop Client (Windows)"></asp:Localize>
            </div>
            <div class="fullContainer">
                <p style="font-size:16px;">
                    <asp:Localize meta:resourcekey="string3" runat="server" Text="Installs on a ( Windows XP, Vista, 7, 8, 8.1, 10, 11) x86/x64 PC, access your file server and/or personal home storage as a local drive, sync file across multiple machines."></asp:Localize>
                </p>          
                <div class="row">
                    <div class="col-12 col-lg-7">
                        <div id="divWinLogos"></div>
                    </div>
                    <div class="col-12 col-lg-5 linkColor" style="text-align:center;padding-top:10px;padding-bottom:20px;" onclick="downloadInIFrame(&quot;<%=m_WinLink%>&quot;);">
                        <div class="inlineItem">
                        <i class="gladinet-icons" style="margin-top: 10px;margin-right: 5px;">&#xC5;</i>
                        </div>
                        <div class="inlineItem">
                        <span> <asp:Localize runat="server" meta:resourcekey="str_winCliIns">Window Client Installer</asp:Localize> <%=mWinVersion %></span>
                        </div>
                    </div>
                </div>
            </div>    
            </div>  
    </asp:Panel>  

    <asp:Panel ID="ServerAgentPanel" runat="server" meta:resourcekey="ServerAgentPanelResource1">
        <div style="width:100%;margin-top:10px;" class="staticviewcard">
            <div class="appheader">
                <%: m_ProductName %> <asp:Localize meta:resourcekey="string6" runat="server" Text="Server Agent"></asp:Localize>
            </div>
            <div class="fullContainer">
                <p style="font-size:16px;">
                     <asp:Localize meta:resourcekey="string7" runat="server" Text="Runs as a windows service. Operates with your storage account as a cloud file server or used as proxy agent to migrate your existing file server or active directory users."></asp:Localize>
                    <b><asp:Localize ID="Localize1" meta:resourcekey="string11" runat="server" Text="Please do not install Windows Client and Server Agent on the same machine."></asp:Localize></b>
                </p>         
                <div class="row">
                    <div class="col-12 col-lg-7">
                        <div id="divWinSvrLogos"></div>
                    </div>
                    <div class="col-12 col-lg-5 linkColor" style="text-align:center;padding-top:10px;padding-bottom:20px;" onclick="downloadInIFrame(&quot;<%=m_WinSvrLink%>&quot;);">
                        <div class="inlineItem">
                        <i class="gladinet-icons" style="margin-top: 10px;margin-right: 5px;">&#xC5;</i>
                        </div>
                        <div class="inlineItem">
                        <span> <asp:Localize runat="server" meta:resourcekey="str_serAgeIns">Server Agent Installer</asp:Localize> <%=mWinSvrVersion %></span>
                        </div>
                    </div>
                </div>
            </div>       
            </div>
    </asp:Panel>       

    <asp:Panel ID="MacClientPanel" runat="server" >
        <div style="width:100%;margin-top:10px;" class="staticviewcard">
            <div class="appheader">
                <%:m_ProductName%> <asp:Localize meta:resourcekey="string12" runat="server" Text="Desktop Client (Mac OS X)"></asp:Localize>
            </div>
            <div class="fullContainer">
                <p style="font-size:16px;">
                     <asp:Localize meta:resourcekey="string13" runat="server" Text="Installs on Mac OS X, access your storage account as a local drive (mounted volume in Finder)."></asp:Localize>
                </p> 
                <div class="row">
                    <div class="col-12 col-lg-7">
                        <div id="divMacLogos"></div>
                    </div>
                    <div class="col-12 col-lg-5" style="text-align:center;padding-top:10px;padding-bottom:20px;">
                        <div class="linkColor" style="margin-top:10px;white-space:nowrap;" onclick="downloadInIFrame(&quot;<%=m_MacLink%>&quot;);">
                            <div class="inlineItem">
                            <i class="gladinet-icons">&#xC5;</i>
                            </div>
                            <div class="inlineItem">
                                <span><asp:Localize meta:resourcekey="string14" runat="server" Text="Installer Package (MacOS 10.9/10.10/10.11/10.12)"></asp:Localize></span>
                            </div>
                        </div>
                        <div class="linkColor" style="margin-top:10px;white-space:nowrap;" onclick="downloadInIFrame(&quot;<%=m_MacLink9%>&quot;);">
                            <div class="inlineItem">
                            <i class="gladinet-icons">&#xC5;</i>
                            </div>
                            <div class="inlineItem">
                                <span><asp:Localize meta:resourcekey="string15" runat="server" Text="Installer Package (MacOS 10.13/10.14/10.15/11.0)"></asp:Localize></span>
                            </div>
                        </div>
                        <div style="display: none">
                            <a target="_blank" href="docs/V4/Gladinet-Cloud-Mac-Client-Release-History.html"><asp:Localize meta:resourcekey="string16" runat="server" Text="Release History"></asp:Localize></a>
                        </div>
                    </div>
                </div>
            </div>       
            </div>
      </asp:Panel>

    <asp:Panel ID="MobilePanel" runat="server" meta:resourcekey="MobilePanelResource1">
        <div style="width:100%;margin-top:10px;" class="staticviewcard">
        <div class="appheader" id="mobileLinksTbl">
            <%:m_ProductName%> <asp:Localize meta:resourcekey="string17" runat="server" Text="Mobile"></asp:Localize>
        </div>
        <div class="fullContainer">
            <div class="row">
                <asp:Panel ID="IOSPanel" runat="server" meta:resourcekey="IOSPanelResource1">
                        <div class="mobileStoreCell">
                            <a target="_blank" href="<%=m_IOSLink%>"><img src="/portal/images/ios_appstore.svg" class="svgImg" /></a>
                            <br />
                            <a target="_blank" href="<%=m_IOSLink%>">
                                <asp:Localize meta:resourcekey="string18" runat="server" Text="View in Apple App Store"></asp:Localize>
                            </a>
                            <br /><br /><br />
                        </div>
                    <div class="mobileStoreCell">
                         <img class="captcha" src="/storage/captcha.dn?b=1&f=<%=m_IOSLinkEnc %>" />
                    </div>
                </asp:Panel>
                <asp:Panel ID="AndroidPanel" runat="server" meta:resourcekey="AndroidPanelResource1">
                        <div class="mobileStoreCell">
                            <a target="_blank" href="<%=m_AndroidLink%>"><img src="/portal/images/android_appstore.svg" class="svgImg" /></a>
                            <br />
                            <a target="_blank" href="<%=m_AndroidLink%>">
                                <asp:Localize meta:resourcekey="string19" runat="server" Text="Available in &quot;Google Play&quot; Market Store. Android OS 4.4+"></asp:Localize>
                            </a>
                        </div>
                    <div class="mobileStoreCell">
                         <img class="captcha" src="/storage/captcha.dn?b=1&f=<%=m_AndroidLinkEnc %>" />
                    </div>
                </asp:Panel>
                <asp:Panel ID="WindowsPhome" runat="server" meta:resourcekey="WindowsPhomeResource1">

                        <div class="mobileStoreCell">
                            <a target="_blank" href="<%=m_WindowsPhoneLink%>">
                            <img src="/portal/images/wphone_appstore.svg" class="svgImg" /></a>
                            <br />
                            <a target="_blank" href="<%=m_WindowsPhoneLink%>">
                                <asp:Localize meta:resourcekey="string20" runat="server" Text="Available in &quot;Windows Phone&quot; Store. Windows Phone 8+"></asp:Localize>
                            </a>
                        </div>
                </asp:Panel>

                <asp:Panel ID="WindowsStoreApp" runat="server" meta:resourcekey="WindowsPhomeResource1">
                        <div class="mobileStoreCell">
                            <a target="_blank" href="<%=m_WindowsStoreLink%>"><img src="/portal/images/wrt_appstore.svg" class="svgImg" /></a>
                            <br />
                            <a target="_blank" href="<%=m_WindowsStoreLink%>">
                                <asp:Localize meta:resourcekey="string21" runat="server" Text="Available in Windows Store. Windows 8+ (Windows RT, Surface)"></asp:Localize>
                            </a>
                        </div>
                </asp:Panel>
            </div>
        </div>               
            </div>
    </asp:Panel>
        </div>     
    <div style="clear:both;width:100%;height:1px;"></div>
    <iframe id='downloadframe' style="display: none;"></iframe>
     <script type="text/javascript">



        function AdjustSize() {
            
            var f = document.getElementById('mainwnd');
            f.style.height = (document.documentElement.clientHeight - 165) + "px";

        }


        Ext.onReady(function () {
            //AdjustSize();
            
            if (isAppleDesktop()) {
            try{
                $("html, body").scrollTop($('#<%=MacClientPanel.ClientID%>').offset().top - 30);
            }catch(ex){}
            }
            <%if (IsMobile()){%>
            try{
                $("html, body").scrollTop($('#<%=MobilePanel.ClientID%>').offset().top - 30);
            }catch(ex){}
            <%}%>
        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });
   

 

    </script>
</asp:Content>
