﻿<%@ Page Title="Gladinet Cloud - Cluster Settings" Language="C#" MasterPageFile="../WebAppPanel.master" ValidateRequest="false" EnableSessionState="false" 
    AutoEventWireup="true" CodeBehind="Servo2FAEnable.aspx.cs" Inherits="GladinetPayFlow.Servo2FAEnable"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">


    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }
    </style>
    <script type="text/javascript">
        
        function GenerateDummyTextFromField(id) {
            var dummy = "";
            var str = "";
            try{
                str = document.getElementById(id).innerHTML;
                for (var i = 0; i < str.length; i++) {
                    dummy += "&bull;";
                }
            }catch(ex){}
            return dummy;
        }
        function showSecret() {
            closedEyeIcon();
        }
        function hideSecret() {     
            openEyeIcon();
        }   
        var _asterisks = "******";
        function openEyeIcon() {
            $("#sctCdeHid").html("<span style='font-size:26px;line-height:26px;'>" + _asterisks + '</span>&nbsp;&nbsp;<span class="gladinet-icons md-24 hand" style="line-height:26px;" onclick="showSecret()">&#xDB;</span>');
        }
        function closedEyeIcon() {
            $("#sctCdeHid").html("<span style='font-size:16px;line-height:26px;'>" + $("#sctCde").text() + '</span>&nbsp;&nbsp;<span class="gladinet-icons md-24 hand" style="line-height:26px;" onclick="hideSecret()">&#x1B9;</span>');
        }
        function ReturnLast() {
            window.location = "<%=GetLastSubPage("Servo2fa.aspx?vdid="+SessionDomainId)%>";
        }
        var oldOnload = window.onload;
        window.onload = function () {
            try {
                _asterisks = GenerateDummyTextFromField("sctCde");
                openEyeIcon();
            } catch (ex) { }

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocInvEma" meta:resourcekey="str_invEma" Visible="false">Invalid email</asp:Localize>
    <asp:Localize ID="LocSSO" meta:resourcekey="str_sso" runat="server" Visible="false"></asp:Localize>


    
        <div style="width: 100%; padding: 5px;height:60px; border-bottom:1px solid #cccccc;" class="meubardrop1">
            <table style="width:100%">
            <tr>
                <td>
                    <span class="gladbtn" style="font-weight: 400!important; font-size: 20px!important; text-transform: uppercase; color:#808080!important;">
                        <asp:Localize runat="server" meta:resourcekey="str_ena2StVer">Enable 2-Step Verification</asp:Localize></span>
                </td>
                <td style="font-weight: 100; font-size: 18px; color: red;">
                    <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
                </td>
                <td style="padding-right: 10px;">
                    <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="ReturnLast();">&times;</div>
                </td>
            </tr>
        </table>
    </div>

    <div class="wrapper" style="background-color: white; width: 100%; margin-top: 30px; font-size: 18px; align-content: center;">
        <asp:Panel ID="Step1Panel" runat="server">
            <table width="100%" style="max-width: 1200px;" align="center">

                <tr>
                    <td style="padding: 15px;">
                        <table width="100%">
                            <tr>
                                <td height="220px" valign="top" style="padding-bottom: 10px;">
                                    <table width="100%">

                                        <tr>
                                            <td style="vertical-align: text-top;">
                                                <b>
                                                    <label style="color: #202020; padding-left: 0px; font-size: 15px !important;">
                                                        <asp:Localize meta:resourcekey="str_step1" runat="server"
                                                            Text="Step 1: Do This from Authenticator App"></asp:Localize></label></b><br />
                                                <p class="text-muted">
                                                    <asp:Localize meta:resourcekey="str_use" runat="server"
                                                        Text="Use your app to scan the QR code, or use the following secret key to set up your account in the app."></asp:Localize>
                                                </p>            
                                                <div id="sctCde" style="color:#008000;font-size:14px;display:none;width:200px;line-height:40px;"> <%=FCode.Value %> </div>
                                                <div id="sctCdeHid" style="color:#008000;font-size:14px;width:300px;margin:8px 0 8px 5px;"></div>
                                                <p class="text-muted">
                                                    <asp:Localize meta:resourcekey="str_savecode" runat="server"
                                                        Text="You may also want to right-click and save the QR code image to re-create your account in the authenticator app at a later time. Keep this code or secret key safe. This is the only chance you will have to see them."></asp:Localize>

                                                </p>
                                                <br />
                                                <b>
                                                    <label style="color: #202020; padding-left: 0px; font-size: 15px !important;">
                                                        <asp:Localize meta:resourcekey="str_step2" runat="server"
                                                            Text="Step 2: Verify the Security Code"></asp:Localize></label></b><br />
                                                <p class="text-muted">
                                                    <asp:Localize meta:resourcekey="str_entercode" runat="server"
                                                        Text="Enter a security code from authenticator (it expires every 30 seconds) below to verify and confirm the 2-step verification is setup correctly."></asp:Localize>
                                                </p>

                                                <asp:TextBox ID="Code" runat="server" Width="300px"
                                                    CssClass="form-control" meta:resourcekey="CodeResource1"></asp:TextBox>
                                                <script type="text/javascript">
                                                    setTimeout(function () {
                                                        document.getElementById("<%=Code.ClientID %>").focus();
                                }, 500);
                                                </script>
                                            </td>
                                            <td width="220px" align="center" valign="top">
                                                <img src="/storage/captcha.dn?b=1&f=<%=FSessionId.Value %>" /><br />
                                                <asp:LinkButton ID="ReGenCode" runat="server" OnClick="ReGenCode_Click"
                                                    meta:resourcekey="ReGenCodeResource1" Text="Generate New Code"></asp:LinkButton><br />

                                                <a href="#" data-toggle="modal" data-target="#NewCodeMoodal"><%=UserMyOwnCodeBtn.Text %></a>
                                            </td>
                                        </tr>
                                    </table>

                                    <div id="NewCodeMoodal" class="modal fade" role="dialog">
                                        <div class="modal-dialog">

                                            <!-- Modal content-->
                                            <div class="modal-content">
                                                <div class="modal-header"></div>
                                                <div class="modal-body">
                                                    <asp:Localize ID="Localize2" meta:resourcekey="EnterCodeResource2" runat="server"
                                                        Text="Enter the code:"></asp:Localize>
                                                    <asp:TextBox ID="UserCode" CssClass="form-control" runat="server"></asp:TextBox>
                                                </div>
                                                <div class="modal-footer">
                                                    <asp:LinkButton ID="UserMyOwnCodeBtn" runat="server" OnClick="EnterCode_Click" CssClass="btn btn-primary gladbtn"
                                                        meta:resourcekey="EnterCodeResource1" Text="Use My Own Code"></asp:LinkButton>
                                                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_clo">Close</asp:Localize></button>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="border-top: 0px solid #f0f0f0; padding-top: 10px;">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding-left: 0px;">
                                                <b>
                                                    <label style="color: #202020; padding-left: 0px; font-size: 15px !important;">
                                                        <asp:Localize meta:resourcekey="str_step3" runat="server"
                                                            Text="Step 3: Backup Email"></asp:Localize>
                                                    </label>
                                                </b>
                                                <p class="text-muted">
                                                    <asp:Localize ID="Localize1" meta:resourcekey="str_backupemailhint" runat="server"
                                                        Text="The backup email will be used when authenticator doesn't work or not available."></asp:Localize>
                                                </p>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-left: 0px;">
                                                <asp:TextBox ID="BackupEmail" runat="server" Width="568px"
                                                    CssClass="form-control" meta:resourcekey="BackupEmailResource1"></asp:TextBox>
                                            </td>

                                        </tr>
                                        <tr>
                                            <td style="padding-left: 0px;">
                                                <label style="color: #202020; padding-left: 0px; font-size: 15px !important;">
                                                    <asp:Localize meta:resourcekey="str_backupemail1" runat="server"
                                                        Text="Re-Enter Backup Email"></asp:Localize>
                                                </label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding-left: 0px;">
                                                <asp:TextBox ID="BackupEmail1" runat="server" Width="568px"
                                                    CssClass="form-control" meta:resourcekey="BackupEmail1Resource1"></asp:TextBox>
                                            </td>

                                        </tr>


                                    </table>

                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step1Contine" runat="server" OnClick="Step1Contine_Click" meta:resourcekey="str_nex">Next</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="CancelBtn" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
        </asp:Panel>
        <asp:Panel ID="Step2Panel" runat="server" Visible="false">
            <table width="100%">
                <tr>
                    <td align="center">

            <table  style="max-width: 1000px;" align="center">

                <tr>
                    <td style="height: 60px">&nbsp;</td>
                </tr>
                <tr>
                    <td>

                        <table width="100%">
                            <tr class="filerow">
                                <td width="500px" style="padding: 15px; color: #565656; font-weight: 100; padding-left: 35px; border: 0px solid white!important;">
                                    <asp:Label runat="server" Text="Do not enforce 2-Step Verification on Windows client" meta:resourcekey="NoForceWinClientResources1"></asp:Label>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="NoFoceWindows" runat="server" />
                                </td>
                            </tr>
                            <tr class="filerow">

                                <td width="500px" style="padding: 15px; color: #565656; font-weight: 100; padding-left: 35px; border: 0px solid white!important;">
                                    <asp:Label runat="server" Text="Do not enforce 2-Step Verification on Mac client" meta:resourcekey="NoForceMacClientResources1"></asp:Label>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="NoFoceMac" runat="server" />
                                </td>
                            </tr>
                            <tr class="filerow">
                                <td width="500px" style="padding: 15px; color: #565656; font-weight: 100; padding-left: 35px; border: 0px solid white!important;">
                                    <asp:Label runat="server" Text="Do not enforce 2-Step Verification on Mobile client" meta:resourcekey="NoForceMobileClientResources1"></asp:Label>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="NoFoceMobile" runat="server" />
                                </td>
                            </tr>


                            <tr class="filerow">
                                <td width="500px" style="padding: 15px; color: #565656; font-weight: 100; padding-left: 35px; border: 0px solid white!important;">
                                    <asp:Localize meta:resourcekey="str_noguestlock" runat="server"> Do NOT enforce 2-Step Verification on guest users</asp:Localize>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="NoGuestForceTwoFactor" runat="server" />
                                </td>
                            </tr>
                            <tr class="filerow">
                                <td width="500px" style="padding: 15px; color: #565656; font-weight: 100; padding-left: 35px; border: 0px solid white!important;">
                                    <asp:Localize meta:resourcekey="str_disaemail" runat="server">Disable option to request 2-step verification code by mail</asp:Localize>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="DisableTwoEmail" runat="server" />
                                </td>
                            </tr>
                            <tr class="filerow">
                                <td width="500px" style="padding: 15px; color: #565656; font-weight: 100; padding-left: 35px; border: 0px solid white!important;">
                                    <asp:Localize meta:resourcekey="str_nocodesubject" runat="server">Do not send verification code in email subject</asp:Localize>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="NoAuthSubject" runat="server" />
                                </td>
                            </tr>


                        </table>

                    </td>
                </tr>




                <tr>
                    <td align="right" style="padding-top: 40px;">
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="Step2Back" runat="server" OnClick="Step2Back_Click" meta:resourcekey="str_bac">Back</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-primary gladbtn" ID="Step2ContinueBtn" runat="server" OnClick="Step2Contine_Click" meta:resourcekey="str_app">Apply</asp:LinkButton>
                        <asp:LinkButton CssClass="btn btn-default gladbtn" ID="LinkButton2" runat="server" OnClientClick="ReturnLast();return false;" meta:resourcekey="str_can">Cancel</asp:LinkButton>
                    </td>
                </tr>
            </table>
                                            </td>
                </tr>
            </table>

        </asp:Panel>



    </div>

    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
    <div style="display: none;">
        <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize>
        <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize>

        <asp:HiddenField ID="FUserCode" runat="server" />
        <asp:HiddenField ID="FSessionId" runat="server" />
        <asp:HiddenField ID="FCode" runat="server" />
        <asp:HiddenField ID="FInCode" runat="server" />

    </div>
    <asp:Localize meta:resourcekey="str_failedapply" ID="FailedApply" runat="server" Visible="False">Failed to apply changes</asp:Localize>

    <script type="text/javascript">
     
    </script>

</asp:Content>
