﻿<%@ Page Title="Dashboard" Language="C#" MasterPageFile="../WebAppPanel.master" EnableSessionState="false"
    AutoEventWireup="true" CodeBehind="DashboadInfo.aspx.cs" Inherits="GladinetPayFlow.DashboadInfo" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style>
        .infocard {
            border-radius: 3px;
            background-color: white;
            border: 1px solid #f0f0f0;
        }

        .infocardex {
            border-radius: 5px;
            background-color: white;
            border: 1px solid #dddddd;
        }

        .nopadding {
            padding: 0px !important;
        }

        .dashChart {
            margin-top: 10px;
        }

        #chart1.dashChart.col-12, #chart1.dashChart.col-6, #chart2.dashChart.col-6 {
            margin-top: 0px;
        }

        .circle {
            width: 20px;
            height: 20px;
            -webkit-border-radius: 10px;
            -moz-border-radius: 10px;
            border-radius: 10px;
            align-content: center;
            vertical-align: middle;
            cursor: default;
        }
    </style>
    <script type="text/javascript">
        function copyToClipboard(text) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    showAlertMessge("Link copied to clipboard");

                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        showAlertMessge("Link copied to clipboard");
                    } catch (ex) {
                        console.warn("Copy to clipboard failed.", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }

        function OnPublishShare()
        {
            window.location = "AddShareName.aspx?vdid=<%=SessionDomainId%>";
        }

        function OnManageShares() {
            parent.OnPublishedShares();
        }
        function FormatFileSize(size) {
            try{
                if (size < 1024) { //pow(2,10)
                    return size + " <asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>";
                } else if (size < 1048576) { //pow(2,20)
                    return (Math.round(((size * 10) / 1024)) / 10) + " KB";
                } else if (size < 1073741824) { //pow(2,30)
                    return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
                } else if (size < 1099511627776) { //pow(2,40)
                    return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
                } else if (size < 1125899906842624) { //pow(2,50)
                    return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
                } else { //pow(2,60)
                    return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
                }
            }catch(e){
                alert(e);
            }

            return size;

        }
        function ConfigCurrentWorkerNode() {


            var name = "<%=CurrentHost.Value %>";
            parent.OnEditWorkerNode(name);
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocTheDnsNamIsNotAva" meta:resourcekey="str_theDnsNamIsNotAva" Visible="false">the DNS name is not available</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToCreTun" meta:resourcekey="str_faiToCreTun" Visible="false">failed to create tunel</asp:Localize>
<asp:Localize runat="server" ID="LocTunNamHasInvCha" meta:resourcekey="str_tunNamHasInvCha" Visible="false">tunnel name has invalid chars</asp:Localize>
<asp:Localize runat="server" ID="LocTunNamIsMis" meta:resourcekey="str_tunNamIsMis" Visible="false">tunnel name is missing</asp:Localize>
<asp:Localize ID="LocUnl" meta:resourcekey="str_unl" runat="server" Visible="False">Unlicensed</asp:Localize>
<asp:Localize ID="LocTri" meta:resourcekey="str_tri" runat="server" Visible="False">Trial</asp:Localize>
    <div class="wrapper" id="DashboardView" style="width: 100%; padding: 0px;">
        <table style="width: 100%;">
            <tr>
                <td align="center" style="padding-top: 20px;">
                    <table style="max-width:calc(100% - 60px); width: 100%;">
                        <tr>
                            <td style="height: 48px; padding: 10px; padding-top: 0px; font-size: 24px; display: none;" class="boxbordercolor menubox sectextcolor">
                                <%=ProductName %>
                            </td>
                        </tr>


                        <tr style="">
                            <td valign="top">
                                <div class="row " style="width: 100%;">
                                    <% if (mCanViewReports) { %>
                                    <div class="col-8" style="">     
                                    <% } else { %>      
                                    <div class="col-12" style="">  
                                    <% } %>
                                        <div class="row " style="width: 100%;">
                                            <% if(mCanViewShares){ %>
                                            <div class="col-12" style="padding-bottom: 20px;">
                                                <table style="width: 100%">
                                                    <tr style="border-bottom: 1px solid #cccccc;">
                                                        <td style="font-size: 20px; color: #202020;"><asp:Localize runat="server" meta:resourcekey="str_pubSha">Published Shares</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; font-weight: 100; padding-top: 10px; padding-bottom: 5px;">
                                                            <%if (mPublishedShareCount == 0)
                                                                { %>
																<asp:Localize runat="server" meta:resourcekey="str_youDonHavAnyFil">You don't have any file share published yet.</asp:Localize>
                                         
                                        <%}
                                            else
                                            { %>
											<asp:Localize runat="server" meta:resourcekey="str_youHav">You have</asp:Localize>
                                        
                                                            <asp:LinkButton Font-Size="18px" ID="LinkButton3" runat="server" OnClientClick="OnManageShares(); return false;"><%=mPublishedShareCount %></asp:LinkButton>
                                                            <asp:Localize runat="server" meta:resourcekey="str_filShaPub">file share(s) published.</asp:Localize> 
                                        
                                        <%} %>
                                                        </td>
                                                    </tr> 
                                                  
                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; font-weight: 100; padding-top: 10px; padding-bottom: 10px;">
                                                            <% if (mCanAddShares) { %>
                                                            <asp:LinkButton Font-Size="18px" ID="LinkButton1" runat="server" OnClientClick="OnPublishShare(); return false;" meta:resourcekey="str_addSha">Add a share.</asp:LinkButton>
                                                            <% } %>  
                                                            <% if (!SessionIsClusterAdminByRole) { %>
                                                            <span style="width: 10px">&nbsp;</span><asp:LinkButton ID="LinkButton4" runat="server" OnClientClick="parent.OnServers(); return false;" meta:resourcekey="str_broFilSer">Browse file servers.</asp:LinkButton>
                                                            <% } %>
                                                        </td>
                                                    </tr>
                                                   
                                                </table>
                                            </div>
                                            <%} %>   
                                            <% if (!SessionIsClusterAdminByRole) { %>     
                                            <div class="col-12" style="padding-bottom: 20px;">
                                                <table style="width: 100%">
                                                    <tr style="border-bottom: 1px solid #cccccc;">
                                                        <td style="font-size: 20px; color: #202020;">
														<asp:Localize runat="server" meta:resourcekey="str_webURL">My Website URL</asp:Localize>
                                                            <span data-toggle="modal" data-target="#myModal" style="font-size: 16px; padding-left:5px;padding-right:5px; float: right; font-weight:100;border:0px solid #f0f0f0; border-radius:4px;" class="toolnavbtn iconviewitemcolor hand secsubbordercolor sectextcolor">
                                                                <i class="gladinet-icons md-16 iconviewitemcolor hand center">c</i>
                                                                <span style="padding-left: 1px; color: #565656; font-weight: 100;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_ediURL">Edit URL</asp:Localize></span>
                                                            </span>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; padding-top: 10px; border-bottom: 0px solid #eeeeee; font-weight: 100; padding-bottom: 15px;"><asp:Localize runat="server" meta:resourcekey="str_youAndYouUseCan">You and your users can access the published shares (and/or management console) from the following web site URL:</asp:Localize></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; font-weight: 100; padding-top: 0px; padding-bottom: 20px;" align="center">
                                                            <table>
                                                                <tr>
                                                                    <td style="padding: 5px; font-size: 18px; color: #202020; font-weight: 400;" align="right"><asp:Localize runat="server" meta:resourcekey="str_webFilBro">Web File Browser:</asp:Localize></td>
                                                                    <td style="padding: 5px;">
                                                                        <a style="font-size: 18px; padding-right: 10px;" class="sectextcolor" href="<%=mExtDns%>/portal/files" target="_blank"><%=mExtDns%>/portal/files</a>
                                                                        <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" onclick='copyToClipboard("<%=mExtDns %>/portal/files")'>&#0192;</i>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td style="padding: 5px; font-size: 18px; color: #202020; font-weight: 400;" align="right"><asp:Localize runat="server" meta:resourcekey="str_admCon">Admin Console:</asp:Localize></td>
                                                                    <td style="padding: 5px;">
                                                                        <a style="font-size: 18px; padding-right: 10px;" class="sectextcolor" href="<%=mExtDns%>/management/clustermgrconsole" target="_blank"><%=mExtDns%>/management/clustermgrconsole</a>
                                                                        <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" onclick='copyToClipboard("<%=mExtDns %>/management/clustermgrconsole")'>&#0192;</i>
                                                                    </td>
                                                                </tr>
                                                                <%if (mCanDeviceBackup)
                                                                    { %>
                                                                <tr>
                                                                    <td style="padding: 5px; font-size: 18px; color: #202020; font-weight: 400;" align="right"><asp:Localize runat="server" meta:resourcekey="str_devBacCon">Device Backup Console:</asp:Localize></td>
                                                                    <td style="padding: 5px;">
                                                                        <a style="font-size: 18px; padding-right: 10px;" class="sectextcolor" href="<%=mExtDns%>/management/clusterbackupconsole" target="_blank"><%=mExtDns%>/management/clusterbackupconsole</a>
                                                                        <i class="gladinet-icons  md-dark hand center toolbtn" style="display: inline-block; font-size: 18px; margin-top: -3px; padding-left: 10px;" title="" onclick='copyToClipboard("<%=mExtDns %>/management/clusterbackupconsole")'>&#0192;</i>
                                                                    </td>
                                                                </tr>
                                                                <%} %>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>    
                                            <% } %> 
                                            <div class="col-12" style="padding-bottom: 20px;">
                                                <table style="width: 100%">
                                                    <tr style="border-bottom: 1px solid #cccccc;">
                                                        <td style="font-size: 20px; color: #202020;"><asp:Localize runat="server" meta:resourcekey="str_sta">Statistics</asp:Localize></td>
                                                        <td style="width: 48px; padding: 5px;" align="center"></td>
                                                    </tr>
                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; font-weight: 100; padding-top: 10px; padding-bottom: 5px;" align="center" colspan="2">
                                                            <table width="100%">
                                                                <tr>
                                                                    <td width="50%" style="border-right: 1px solid #f0f0f0; padding: 10px;" valign="top">
                                                                        <table width="100%">
                                                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="<% if (mCanViewUsers)
                                                                                { %>parent.OnUserManager();return false;<% } %>">

                                                                                <td style="padding: 5px; width:140px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_norUse">Normal Users</asp:Localize></td>
                                                                                <td> 
                                                                                    <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                                        <asp:Label ID="UserCount" runat="server" Text=""></asp:Label>
                                                                                    </span>
                                                                                </td>
                                                                                <td width="30px"><% if (mCanViewUsers)
                                                                                                     { %>
                                                                                    <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i><% } %>
                                                                                </td>

                                                                            </tr>
                                                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="parent.OnGuestUserMgr();return false;">

                                                                                <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_gueUse">Guest Users</asp:Localize></td>

                                                                                <td>
                                                                                    <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                                        <asp:Label ID="GuestUserCount" runat="server" Text=""></asp:Label>
                                                                                    </span>
                                                                                </td>
                                                                                <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>

                                                                            </tr>
                                                                            <tr style="border-bottom: 0px solid #f0f0f0;" class="filerow" onclick="parent.OnGroupMgr();return false;">

                                                                                <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_gro">Groups</asp:Localize></td>
                                                                                <td>
                                                                                    <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                                        <asp:Label ID="GroupCount" runat="server" Text=""></asp:Label>
                                                                                    </span>
                                                                                </td>
                                                                                 <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                            </tr>

                                                                        </table>
                                                                    </td>
                                                                    <td style="padding: 10px;" valign="top">   
                                                                        <% if (!SessionIsClusterAdminByRole) { %>    
                                                                        <table width="100%">
                                                                            <tr style="border-bottom: 1px solid #f0f0f0;" <%if (SessionIsClusterAdmin)
                                                                                { %>class="filerow"
                                                                                onclick="parent.onLicenseInfo();return false;" <% } %>>

                                                                                <td style="padding: 5px; width:140px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_assLic">Assigned License</asp:Localize></td>
                                                                                <td>
                                                                                    <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                                        <asp:Label ID="LicenseText" runat="server" Text=""></asp:Label>
                                                                                    </span>
                                                                                </td>
                                                                                <td width="30px">
                                                                                    <%if (SessionIsClusterAdmin)
                                                                                        { %>
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="parent.onLicenseInfo();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                    <% } %>
                                                                                </td>
                                                                            </tr>
                                                                            <tr style="border-bottom: 1px solid #f0f0f0;" class="filerow" onclick="parent.OnDeviceMgr();return false;">

                                                                                <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_dev">Devices</asp:Localize></td>
                                                                                <td>
                                                                                    <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                                        <asp:Label ID="DeviceCount" runat="server" Text=""></asp:Label>
                                                                                    </span>
                                                                                </td>
                                                                                 <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="parent.OnDeviceMgr();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                            </tr>
                                                                            <tr style="border-bottom: 0px solid #f0f0f0; display: ;" class="filerow" onclick="parent.OnRoleMgr();return false;">

                                                                                <td style="padding: 5px; font-size: 16px"><asp:Localize runat="server" meta:resourcekey="str_rol">Roles</asp:Localize></td>
                                                                                <td>
                                                                                    <span class="hollowbadge badge" style="font-size: 16px; margin-left: 10px;">
                                                                                        <asp:Label ID="RoleCount" runat="server" Text=""></asp:Label>
                                                                                    </span>
                                                                                </td>
                                                                                <td width="30px">
                                                                                    <i class="gladinet-icons md-24  hand center" onclick="On2FA();return false;" style="color: #808080!important; font-size: 16px!important">&#xdd;</i>
                                                                                </td>
                                                                            </tr>
                                                                        </table>          
                                                                        <%} %>   
                                                                    </td>
                                                                </tr>
                                                            </table>


                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>  
                                            <% if (!SessionIsClusterAdminByRole) { %>    
                                            <div class="col-12" style="padding-bottom: 20px;">
                                                <table style="width: 100%">
                                                    <tr style="border-bottom: 1px solid #cccccc;">
                                                        <td style="font-size: 20px; color: #202020;">
														<asp:Localize runat="server" meta:resourcekey="str_ranProAle">Ransomware Protection Alerts</asp:Localize>
                                                            
                                                            <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px; float: right; margin-top: 5px;" onclick="parent.OnRansomwarePanel()">c</i>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; font-weight: 100; padding-top: 10px; padding-bottom: 20px;" >
                                                            <%if (RanRepeater.Items.Count != 0)
                                                                { %>
                                                            <div style="max-height: 200px; overflow-y: auto; width: 100%;">
                                                                <table width="100%">


                                                                    <asp:Repeater ID="RanRepeater" runat="server">
                                                                        <ItemTemplate>
                                                                            <tr style="border-bottom: 1px solid #f0f0f0">
                                                                                <td width="20px" style="padding: 2px;">
                                                                                    <div class="circle" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>"
                                                                                        style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; font-size: 12px; padding-top: 0px; margin-top: -3px;"
                                                                                        align="center" valign="middle">

                                                                                        <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%>
                                                                                    </div>
                                                                                </td>
                                                                                <td>
                                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>
                                                                        </td>
                                                                                <td style="font-size: 12px; text-align: left; padding-left: 13px; font-weight: 100; color: #565656;" title=" <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "TraceLocalTime").ToString())%>">
                                                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Action").ToString())%>
                                                                                </td>
                                                                                <td style="font-size: 12px; text-align: left; padding-left: 5px; font-weight: 100; color: #565656;" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Trace").ToString())%>">
                                                                                    <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "DisplayTrace").ToString())%>
                                                                                </td>


                                                                            </tr>
                                                                        </ItemTemplate>
                                                                    </asp:Repeater>
                                                                </table>
                                                            </div>
                                                            <%}
                                                                else
                                                                { %>
															<asp:Localize runat="server" meta:resourcekey="str_noRanProRelAle">No ransomware protection related alerts in last 7 days.</asp:Localize>
                                                             

                                                            <%} %>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="col-12" style="padding-bottom: 20px;">
                                                <table style="width: 100%">
                                                    <tr style="border-bottom: 1px solid #cccccc;">
                                                        <td style="font-size: 20px; color: #202020;">
														<asp:Localize runat="server" meta:resourcekey="str_datLeaProAle">Data Leak Protection Alerts</asp:Localize>
                                                             <i class="gladinet-icons md-24 md-dark hand center toolbtnb toolbtn" style="font-size: 16px; float: right; margin-top: 5px;" onclick="parent.OnDLPPanel()">c</i>
                                                        </td>
                                                    </tr>

                                                    <tr>
                                                        <td style="font-size: 18px; color: #202020; font-weight: 100; padding-top: 10px; padding-bottom: 20px;" >
                                                           <%if (DLPRepeater.Items.Count != 0)
                                                               { %>
                                                        <div style="max-height: 200px; overflow-y: auto; width: 100%;">
                                                        <table width="100%">


                                                            <asp:Repeater ID="DLPRepeater" runat="server">
                                                                <ItemTemplate>
                                                                    <tr style="border-bottom: 1px solid #f0f0f0">
                                                                        <td width="20px" style="padding: 2px;">
                                                                            <div class="circle" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>"
                                                                                style="background-color: white; border: 1px solid <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; color: <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevColor").ToString())%>; font-size: 12px; padding-top: 0px; margin-top: -3px;"
                                                                                align="center" valign="middle">

                                                                                <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "AbbrevName").ToString())%>
                                                                            </div>
                                                                        </td>
                                                                        <td>
                                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserEmail").ToString())%>
                                                                        </td>
                                                                        <td style="font-size: 12px; text-align: left; padding-left: 13px; font-weight: 100; color: #565656;" title=" <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "TraceLocalTime").ToString())%>">
                                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Action").ToString())%>
                                                                        </td>
                                                                        <td style="font-size: 12px; text-align: left; padding-left: 5px; font-weight: 100; color: #565656;" title="<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "Trace").ToString())%>">
                                                                            <%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "DisplayTrace").ToString())%>
                                                                        </td>


                                                                    </tr>
                                                                </ItemTemplate>
                                                            </asp:Repeater>
                                                        </table>
                                                            </div>
                                                        <%}
                                                            else
                                                            { %>
														<asp:Localize runat="server" meta:resourcekey="str_noDatLeaProRel">No data leak protection related alerts in last 7 days.</asp:Localize>
                                                         

                                                        <%} %>
                                                        </td>
                                                    </tr>
                                                </table>
                                            </div>   
                                            <%} %>   
                                            
                                        </div>
                                    </div>                 
                                    <% if (mCanViewReports) { %>
                                    <div class="col-4" style="padding-top:30px;">
                                        <div class="col-12 dashChart" id="chart1" style="padding-bottom: 0px;">

                                            <div class=" staticviewcarddark mainColorBgLight" style="padding: 2px;">
                                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: none;" class="boxbordercolor secsubcolor">
                                                    <asp:Localize runat="server" ID="str_filUpdInLstMns" meta:resourcekey="str_filUpdInLstMns">File uploads in last 60 minutes</asp:Localize>
                                                </div>
                                                <div class="panel-body" style="height: 180px!important; width: 100%" id="upload60div">
                                                    <canvas id="upload60"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 dashChart" id="chart2" style="padding-bottom: 0px;">

                                            <div class=" staticviewcarddark mainColorBgLight" style="padding: 2px;">
                                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: none;" class="boxbordercolor secsubcolor">
                                                    <asp:Localize runat="server" ID="str_filUpdInLstHrs" meta:resourcekey="str_filUpdInLstHrs">File uploads in last 24 hours</asp:Localize>
                                                </div>
                                                <div class="panel-body" style="height: 180px; width: 100%" id="upload24div">
                                                    <canvas id="upload24"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-12 dashChart" id="chart3">

                                            <div class=" staticviewcarddark mainColorBgLight" style="padding: 2px;">
                                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: none;" class="boxbordercolor secsubcolor">
                                                    <asp:Localize runat="server" ID="str_bdupload" meta:resourcekey="str_bdupload">Bandwidth usage in last 60 minutes (Upload)</asp:Localize>
                                                </div>
                                                <div class="panel-body" style="height: 180px; width: 100%" id="bandwidthupdiv">
                                                    <canvas id="bandwidthup"></canvas>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-12 dashChart" id="chart4" style="padding-bottom: 0px;">

                                            <div class=" staticviewcarddark mainColorBgLight" style="padding: 2px;">
                                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0; display: none;" class="boxbordercolor secsubcolor">
                                                    <asp:Localize runat="server" ID="str_bddownload" meta:resourcekey="str_bddownload">Bandwidth usage in last 60 minutes (Download)</asp:Localize>
                                                </div>
                                                <div class="panel-body" style="height: 180px; width: 100%;" id="bandwidthdowndiv">
                                                    <canvas id="bandwidthdown"></canvas>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <% } %>
                                </div>
                            </td>

                        </tr>

                        <tr style="display: none;">
                            <td>
                                <div style="width: 1px; height: 1px; overflow: hidden">
                                    <%if (!string.IsNullOrEmpty(mHiddenLoginUrl))
                                        { %>
                                    <iframe id='Iframe1' src="<%=mHiddenLoginUrl%>"
                                        frameborder="0" border="0" style="width: 1px; height: 1px"></iframe>
                                    <%}%>
                                </div>
                            </td>
                        </tr>

                        <tr style="display: none;">
                            <td style="text-align: center; padding-top: 30px;" onclick="top.onServoDownloads()">
                                <div class="gladrootbtnw" title="Client Downloads" style="cursor: pointer; white-space: nowrap;">
                                    <i class="gladinet-icons sectextcolor" style="font-size: 22px!important; cursor: pointer;">ñ</i>
                                    <i class="gladinet-icons sectextcolor" style="padding-left: 5px; font-size: 22px!important; cursor: pointer;">î</i>
                                    <i class="gladinet-icons sectextcolor" style="padding-left: 5px; font-size: 22px!important; cursor: pointer;">ï</i>
                                </div>
                                <div class="sectextcolor hand">
                                    <asp:Localize runat="server" meta:resourcekey="str_locADSvcMsg">Download Client Software</asp:Localize>
                                </div>
                            </td>
                        </tr>

                    </table>
                </td>
            </tr>
        </table>


    </div>
    <div id="myModal" class="modal fade" role="dialog">

        <div class="modal-dialog">

            <div class="modal-content" style="width: 600px;">
                <div class="modal-header" style="display: none;">


                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table width="100%">
                        <tr>
                            <td style="font-size: 16px; font-weight: 100; color: #202020;">
                                <asp:Localize meta:resourcekey="asp_string2" runat="server">External URL</asp:Localize>
                                (https://example.com)
                    <p style="font-size: 12px; color: #565656; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_thiExtAddThaWil">This is the external address that will be used for offsite access. Please consult your IT administrator if you are not sure what it should be.</asp:Localize></p>
                        </tr>
                        <tr>
                            <td>
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <asp:RadioButton GroupName="extdnsgroup" ID="UseTunel" runat="server" Text="Use default tunneled DNS" meta:resourcekey="str_useDefTunDNS" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <table>
                                                <tr>
                                                    <td style="font-size: 16px; font-weight: 100; color: #202020;">https://</td>
                                                    <td>
                                                        <asp:TextBox ID="TunelDnsName" runat="server" Text="mydns" CssClass="form-control"></asp:TextBox>
                                                    </td>
                                                    <td style="font-size: 16px; font-weight: 100; color: #202020;">
                                                        <asp:Label ID="DnsZoneName" runat="server" Text=".triofox.io"></asp:Label>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>

                                    </tr>
                                </table>

                            </td>
                        </tr>

                        <tr>
                            <td style="padding-top: 20px;">
                                <table style="width: 100%;">
                                    <tr>
                                        <td>
                                            <asp:RadioButton GroupName="extdnsgroup" ID="UseOwnExt" runat="server" Text="Use my own public DNS" meta:resourcekey="str_useOwnPubDNS" />
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <asp:TextBox ID="ExternalDNS" runat="server" Text="http://localhost"
                                                CssClass="form-control"></asp:TextBox>
                                        </td>

                                    </tr>
                                </table>
                            </td>
                        </tr>

                    </table>

                </div>
                <div class="modal-footer">
                    <asp:Button ID="ApplyExtDns" runat="server" meta:resourcekey="str_app" Text="Apply" CssClass="btn btn-primary gladbtn"
                        OnClick="ApplyExtDns_Click" OnClientClick="CloseAndWait();" />

                    <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_can">Cancel</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>

    <div style="display: none">
        <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg"
            meta:resourcekey="ErrorMsgResource1"></asp:Label>

        <asp:Label ID="ClusterId" runat="server" CssClass="badge"></asp:Label>
        <asp:Localize ID="LocFilUpd" runat="server" meta:resourcekey="str_filUpd" Visible="false">Files Uploaded</asp:Localize>
        <asp:Localize ID="LocTme" runat="server" meta:resourcekey="str_tme" Visible="false">Time</asp:Localize>
        <asp:Localize ID="LocFil" runat="server" meta:resourcekey="str_fil" Visible="false">Files</asp:Localize>
        <asp:Localize meta:resourcekey="str_impNtkFilShr" runat="server" Visible="false">Imported Network File Shares</asp:Localize>
        <span id="sectextcolor" class="sectextcolor"></span>
        <span id="lighttextcolor" class="lighttextcolor"></span>
        <asp:HiddenField ID="CurrentHost" runat="server" />
                <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Visible="False"> Days ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Visible="False"> Hours ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Visible="False"> Minutes ago</asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Visible="False">Less than 1 minute ago</asp:Localize>

    </div>
    <script type="text/javascript">
        
        function CloseAndWait(){
            $('#myModal').modal('hide');
            Wait('Uploading');
        }
        function DisplayError() {

            var d = document.getElementById("ctl00_MainContent_ErrorMsg");
            if (d) {
                if (d.innerHTML != "") {
                    
                    alert( d.innerHTML);
                    
                }
            }
        }
        
        var Upload60Data = [
        <asp:Repeater ID="Upload60DataRep" runat="server" >
          <ItemTemplate>         
          <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
                date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Files:<%#DataBinder.Eval(Container.DataItem,"Value") %>
                }
            </ItemTemplate>
        </asp:Repeater>      
        ];

        var Upload24Data = [
            <asp:Repeater ID="Upload24DataRep" runat="server" >
              <ItemTemplate>         
              <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
                date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Files:<%#DataBinder.Eval(Container.DataItem,"Value") %>
                }
            </ItemTemplate>
        </asp:Repeater>      
          ];

          var BandwidthUpData = [
            <asp:Repeater ID="BandwidthUpDataRep" runat="server" >
              <ItemTemplate>         
              <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
                date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Files:<%#DataBinder.Eval(Container.DataItem,"Value") %>
                }
            </ItemTemplate>
        </asp:Repeater>      
      ];

      var BandwidthDownData = [
    <asp:Repeater ID="BandwidthDownDataRep" runat="server" >
      <ItemTemplate>         
      <%#(Container.ItemIndex == 0)? "": "," %>      
            {        
                date:'<%#DataBinder.Eval(Container.DataItem,"Name") %>',
                Files:<%#DataBinder.Eval(Container.DataItem,"Value") %>
                }
            </ItemTemplate>
        </asp:Repeater>      
        ];
        function newDraewChart(rid, fields, data,  xtitle, ytitle, xfield, yfield, charttype)
        {
            
            var xs = [];
            var ys = [];
            for(var i=0; i<data.length;++i){
                xs[i] = data[i].date;
                ys[i] = data[i].Files;
            }
            var ctx = document.getElementById(rid).getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: xs,
                    datasets: [{
                        label: xtitle,
                        backgroundColor:  $("#lighttextcolor").css("color"),
                        borderColor: $("#sectextcolor").css("color"),
                        data: ys,
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:false
                            }
                        }]
                    }
                }
            });
        }

        function newDraewChartBytes(rid, fields, data,  xtitle, ytitle, xfield, yfield, charttype)
        {
            
            var xs = [];
            var ys = [];
            for(var i=0; i<data.length;++i){
                xs[i] = data[i].date;
                ys[i] = data[i].Files;
            }
            var ctx = document.getElementById(rid).getContext('2d');
            var myChart = new Chart(ctx, {
                type: 'line',
                data: {
                    labels: xs,
                    datasets: [{
                        label: xtitle,
                        backgroundColor:  $("#lighttextcolor").css("color"),
                        borderColor: $("#sectextcolor").css("color"),
                        data: ys,
                        borderWidth: 1
                    }]
                },
                options: {
                    scales: {
                        yAxes: [{
                            ticks: {
                                beginAtZero:false,
                                callback: function(value, index, values) {
                                    return  FormatFileSize(value);
                                }
                            }
                        }]
                    }
                }
            });
        }
        function DrawChartF()
        {
            
            newDraewChart('upload60', ['date', 'Files'], Upload60Data, '<%=str_filUpdInLstMns.Text %>', '<%=LocFilUpd.Text %>', 'date', '<%=LocFil.Text %>','column');
            
                newDraewChart('upload24', ['date', 'Files'], Upload24Data, '<%=str_filUpdInLstHrs.Text %>', '<%=LocFilUpd.Text %>', 'date', '<%=LocFil.Text %>','line');
                newDraewChartBytes('bandwidthup', ['date', 'Files'], BandwidthUpData, "<%=str_bdupload.Text%>", "<asp:Localize meta:resourcekey="str_bdwUsg" runat="server">Bandwidth Usage</asp:Localize>", 'date', "<asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>",'column');
                newDraewChartBytes('bandwidthdown', ['date', 'Files'], BandwidthDownData, "<%=str_bddownload.Text%>", "<asp:Localize meta:resourcekey="str_bdwUsg" runat="server">Bandwidth Usage</asp:Localize>", 'date', "<asp:Localize meta:resourcekey="str_bts" runat="server" >Bytes</asp:Localize>",'column');

            }
        
            function adjust() {
        
                var e = document.getElementById("upload60div");
                var h = Math.floor(e.offsetWidth*0.5)
                if(e.offsetHeight <  h)
                    e.style.height = h+"px";

            
                e = document.getElementById("upload24div");
                if(e.offsetHeight <  h)
                    e.style.height = h+"px";

                e = document.getElementById("bandwidthupdiv");
                if(e.offsetHeight <  h)
                    e.style.height = h+"px";

                e = document.getElementById("bandwidthdowndiv");
                if(e.offsetHeight <  h)
                    e.style.height = h+"px";

            
            }
            Ext.onReady(function () {
           
            <%if (!string.IsNullOrEmpty(mRedirUrl))
        {%>
                parent.parent.OnSetNewDns("<%=mRedirUrl%>");
            return;
            <%}%>
            adjust();
        
              
            DrawChartF();
            DisplayError();
        
        });
        
        
    </script>
</asp:Content>
