﻿<%@ Page Title="Gladinet Cloud - Upgrade" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="RegisterGCECluster.aspx.cs" Inherits="GladinetPayFlow.RegisterGCECluster"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td
        {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        .badgefont
        {
            font-size: 15px;
            
        }
    </style>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        *
        {
            margin: 0;
        }
        html, body
        {
            height: 100%;
        }
        .main, #aspnetForm
        {
            height: 100%;
        }
        .wrapper
        {
            min-height: 100%;
            height: auto !important;
            height: 100%;
            padding: 0px;
            background-color: white;
            margin: 0 auto -69px; /* the bottom margin is the negative value of the footer's height */
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        function OnCancelUpgrade() {
            window.location = "PartnerGCEMgrPage.aspx";
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocCluHasAlrBeeReg" meta:resourcekey="str_cluHasAlrBeeReg" Visible="false" runat="server">Cluster has already been registered</asp:Localize>

    <div id="errmsgdiv">
        <b>
            <asp:Label ID="ErrorMessage" runat="server" Style="color: Red;" meta:resourcekey="ErrorMessageResource1"></asp:Label></b>
    </div>
    <div class="wrapper" style="padding: 10px;">
        <table width="100%" border="0">            <tr> <td align="center" style="padding-top:30px;">
        <table  width="100%" style="max-width:800px;">
            <tr>
                <td colspan="2" style="border-bottom: 0px solid #c0c0c0; color:#565656;"><h2 style="font-weight:100; font-size:24px;" class="sectextcolor"><asp:Localize runat="server" meta:resourcekey="str_regCtr">Register a Cluster</asp:Localize></h2></td>
            </tr>
            <tr>
                <td style="padding-top:10px;">
                    <asp:Localize ID="Localize1" meta:resourcekey="asp_string2" runat="server">Cluster Id:</asp:Localize>
                    <p class="text-muted" style="font-size: smaller;">
                        <asp:Localize ID="Localize2" meta:resourcekey="asp_string1" runat="server">You can find the cluster id from the cluster manager page of the cluster you want to register</asp:Localize></p>
                </td>
            </tr>
            <tr>
                <td style="padding-bottom: 10px; padding-top: 10px;" align="left">
                    <asp:TextBox ID="ClusterId" runat="server" meta:resourcekey="ClusterIdResource1" 
                        CssClass="form-control"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td>
                    <asp:Localize ID="Localize3" meta:resourcekey="asp_string3" runat="server">Admin Email:</asp:Localize>
                </td>
            </tr>
            <tr>
                <td style="padding-bottom: 10px; padding-top: 10px;" align="left">
                    <asp:TextBox ID="AdminEmail" runat="server" CssClass="form-control" meta:resourcekey="AdminEmailResource1"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td><asp:Localize runat="server" meta:resourcekey="str_Mem">Memo:</asp:Localize></td>
            </tr>
            <tr>
                <td style="padding-bottom: 10px; padding-top: 10px;" align="left">
                    <asp:TextBox ID="Memo" runat="server" CssClass="form-control" meta:resourcekey="AdminEmailResource1"></asp:TextBox>
                </td>
            </tr>
            <tr>
                <td style="padding-right: 1px; height: 32px;" align="right">
                    
                    <asp:Button ID="UpgradeNow" runat="server" Text="Register" CssClass="btn btn-primary gladbtn"
                        OnClick="UpgradeNow_Click" Width="128px" OnClientClick="Wait('Applying Settings');"
                        meta:resourcekey="UpgradeNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                    <asp:Button ID="CancelChange" runat="server" Text="Cancel" CssClass="btn"
                        OnClientClick="OnCancelUpgrade();return false;" Width="128px" meta:resourcekey="CancelChangeResource1" />
                </td>
            </tr>
        </table>
            </td></tr></table>
    </div>
    <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0;width:100%; display:none;
        border-bottom: 0; vertical-align: middle;">
        <table  style="height: 64px; text-align: right; padding-right: 64px; "
            align="right">
            
        </table>
    </div>
    <asp:HiddenField ID="AdminUserId" runat="server" />
</asp:Content>
