﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="PerfMon.aspx.cs" Inherits="GladinetPayFlow.PerfMon" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="str_dltCfmMsg" runat="server">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }

        function PrePurge() {
            $('#purgeModal').modal('hide');
            Wait('Purging...');
        }
    function closeCancelActiveWin()
    {
       activewin.close();
    }

    function closeActiveWin() {
        window.location =  "/management/AttachedFolders.aspx";
    }
    
    function OnWipeDevice(id, name) {
        var ng = document.getElementById("ctl00_MainContent_DeviceId");
        var btn = document.getElementById("ctl00_MainContent_WipeDevice");

        if (confirm("<asp:Localize meta:resourcekey="str_dthCfmMsg" runat="server">Do you really want to detach the folder</asp:Localize> (" + unescape(id) + ")?")) {
            
            Wait('Detaching...');
            ng.value = id;
            btn.click();            
        }
    }

    function OnAttachFolder() {        
        window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
    }
   
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
  
     <div class="meubardrop navbar navbar-default" role="navigation">
         <div class="container-fluid">
             <p class="navbar-text">
                 <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1" CssClass="badge"></asp:Label>
                 <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota" meta:resourcekey="GuestQuotaResource1"></asp:Label>
             </p>
             <div id="errmsgdiv" class="navbar-text">
                 <b>
                     <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
             </div>
             <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;" title="<%=LinkButton2.Text %>">
                 <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" onclick="__doPostBack('LinkButton2', '');">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px; display:none;"><asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" OnClick="LinkButton2_Click" meta:resourcekey="LinkButton2Resource1"
                     ForeColor="#565656"></asp:LinkButton></div>                 
             </div>
         </div>
        </div>

    <table id="grid-table" width="100%" style="padding: 2px; background-color: white; margin-top: 20px" cellspacing="0" cellpadding="0">
        <tr>
            <td colspan="3"  valign="top" style="padding: 10px; overflow:auto;" valign="top">
                <div style="width: 100%; align-content: center; margin: 0;overflow:auto; padding:5px;" align="center" id="grid-example">
                 <div class="row" style="width: 100%; align-content: center; margin: 0;" align="center">
                     <div class="gridobject col-3 " >
                                    <div class="panel panel-success viewcard">
                                        <div style="height:32px; padding:10px;">
                                            <span style="font-size: 18px; font-weight: 100;" class="sectextcolor">
                                                <asp:Localize meta:resourcekey="str_db" runat="server">Database</asp:Localize>
                                                </span>
                                            </div>
                                    <div class="panel-body" style="padding:10px; border:0px!important;">
                                <table width="100%">
                                    <tr>
                                       <td  style="height: 400px!important;color: #404040; font-size: 16px; font-weight: 100;" align="center" valign="top">
                                           
                                         <table width="100%" class="table-striped">
                                             <tr><td colspan="2" style="border:0px!important; display:none;">
                                                 <!-- Modal -->
                                                    
                                             </td></tr>
                                             <tr><td colspan="2" align="right">
                                                 <button type="button" class="btn btn-info btn-lg" data-toggle="modal" data-target="#purgeModal"><asp:Localize meta:resourcekey="str_pug" runat="server">Purge</asp:Localize></button>
                                                 
                                             </td></tr>
                                             <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_totCfgRec" runat="server">Total Configuration Records</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <asp:Label ID="ConfigCount" runat="server" Text=""></asp:Label>
                                                     
                                                 </td>
                                            </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_totFilChgRec" runat="server">Total File Change Records</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <asp:Label ID="ChangeRecords" runat="server" Text=""></asp:Label>
                                                     
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_totFilIdxRec" runat="server">Total File Index Records</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <asp:Label ID="FileIndexRecord" runat="server" Text=""></asp:Label>
                                                 </td>
                                             </tr>
                                                
                                             
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_totAudTrcRec" runat="server">Total Audit Trace Records</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <asp:Label ID="AuditRecord" runat="server" Text=""></asp:Label>
                                                 </td>
                                             </tr>
                                         </table>
                                           
                                       </td> 
                                    </tr>
                                </table>
                                 
                            </div>
                           
                        </div>

                                </div>
                     <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
                        OnItemDataBound="OnUserItemBound">
                        <ItemTemplate>         
                             <div class="gridobject col-3 ">
                                    <div class="panel panel-success AssetBox2 viewcard" >
                                       <div style="height:32px; padding:10px;">
                                            <span style="font-size: 18px; font-weight: 100;" class="sectextcolor"><%#DataBinder.Eval(Container.DataItem, "NodeName")%></span>
                                            </div>
                                     <div class="panel-body" style="padding:10px; border:0px!important;">
                                <table width="100%">
                                    <tr>
                                       <td  style="height: 400px!important;color: #404040; font-size: 16px; font-weight: 100;" align="center" valign="middle">
                                           
                                         <table width="100%" class="table-striped">
                                             <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="js_string2" runat="server">Last Reported</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"LastReportStr") %>
                                                 </td>
                                            </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_totReqPrc" runat="server">Total Requests Processed</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"TotalRequests") %>
                                                     
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="js_string4" runat="server">Request Executing</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"Requests") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="js_string5" runat="server">Last Request Time</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"RequestTime") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_pndChgNot" runat="server">Pending Change Notifications</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"ChangeNotificationQLength") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_actNdeReq" runat="server">Active Node Request</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"PendingNodeRequests") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_pndChgPol" runat="server">Pending Changes Polling</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"PollStatusQueueLength") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_actClt" runat="server">Active Clients</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"RegisteredClientCount") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_pndDirReqH" runat="server">Pending Dir Request (H)</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"PendingDirRequestInHighPriorityQueue") %>
                                                 </td>
                                             </tr>
                                                 <tr>
                                                 <td style="padding: 5px; color: #565656; font-size: 16px; font-weight: 100">
                                                     <asp:Localize meta:resourcekey="str_pndDirReqL" runat="server">Pending Dir Request (L)</asp:Localize>
                                                 </td>
                                                 <td width="120px">
                                                     <%#DataBinder.Eval(Container.DataItem,"PendingDirRequestInLowPriorityQueue") %>
                                                 </td>
                                             </tr>

                                         </table>
                                           
                                       </td> 
                                    </tr>
                                </table>
                                 
                            </div>
                           
                        </div>

                                </div>
                        </ItemTemplate>
                        </asp:Repeater>      
                 </div>
                    </div>
                <div id="purgeModal" class="modal fade" role="dialog">
                                                      <div class="modal-dialog">

                                                        <!-- Modal content-->
                                                        <div class="modal-content">
                                                          <div class="modal-header">
                                                              <h4 class="modal-title" style="font-weight:400;"><asp:Localize meta:resourcekey="str_pug" runat="server">Purge</asp:Localize></h4>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                            
                                                          </div>
                                                          <div class="modal-body">
                                                            <table width="90%">
                                                                <tr>
                                                                    <td style="padding: 5px; width: 130px;"><asp:Localize meta:resourcekey="str_filChgLog" runat="server">File Change Logs</asp:Localize>:</td>
                                                                    <td style="padding: 5px">

                                            <asp:Localize ID="LocNoPug" meta:resourcekey="ddl_noPug" runat="server" Visible="false">Do not purge</asp:Localize>
                                            <asp:Localize ID="Loc5Das" meta:resourcekey="ddl_5Dys" runat="server" Visible="false">5 days old</asp:Localize>
                                            <asp:Localize ID="Loc10Dys" meta:resourcekey="ddl_10Dys" runat="server" Visible="false">10 days old</asp:Localize>
                                            <asp:Localize ID="Loc15Dys" meta:resourcekey="ddl_15Dys" runat="server" Visible="false">15 days old</asp:Localize>
                                            <asp:Localize ID="Loc1Mth" meta:resourcekey="ddl_1Mth" runat="server" Visible="false">1 month old</asp:Localize>
                                            <asp:Localize ID="Loc3Mth" meta:resourcekey="ddl_3Mth" runat="server" Visible="false">3 months old</asp:Localize>
                                            <asp:Localize ID="Loc1Yer" meta:resourcekey="ddl_1Yer" runat="server" Visible="false">1 year old</asp:Localize>

                                            <asp:Localize ID="Loc3Yer" meta:resourcekey="ddl_3Yer" runat="server" Visible="false">3 years old</asp:Localize>


                                                                        <asp:DropDownList ID="FCDays" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList>
                                                                    </td>
                                                                </tr>
                                                                                                                                <tr>
                                                                    <td style="padding: 5px"><asp:Localize meta:resourcekey="str_audTrc" runat="server">Audit Trace</asp:Localize>:</td>
                                                                    <td style="padding: 5px">
                                                                        <asp:DropDownList ID="ATDays" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList>
                                                                    </td>
                                                                </tr>
                                                                                                                                <tr>
                                                                    <td style="padding: 5px"><asp:Localize meta:resourcekey="str_filIdx" runat="server">File Index</asp:Localize>:</td>
                                                                    <td style="padding: 5px">
                                                                        <asp:DropDownList ID="FIDays" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList>
                                                                    </td>
                                                                </tr>
                                                                <tr>
                                                                    <td colspan="2" style="padding: 5px;">
                                                                        <div class="alert alert-warning">
  <strong><asp:Localize meta:resourcekey="str_wrn" runat="server">Warning!</asp:Localize></strong> <asp:Localize meta:resourcekey="str_pugMsg" runat="server">Purging may take long time. Purged items cannot be recovered.</asp:Localize>
</div>
                                                                        
                                                                    </td>
                                                                </tr>
                                                            </table>
                                                          </div>
                                                          <div class="modal-footer">
                                                              <asp:LinkButton ID="PurgeBtn" runat="server" class="btn btn-primary gladbtn" OnClick="PurgeBtn_Click" OnClientClick="PrePurge();return true;"><asp:Localize meta:resourcekey="str_pugNow" runat="server">Purge Now</asp:Localize></asp:LinkButton>
                                                            <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                                                          </div>
                                                        </div>

                                                      </div>
                                                    </div>
            </td>
        </tr>
        <tr>
            <td colspan="6">
            </td>
        </tr>
    </table>
<asp:HiddenField ID="DeviceId" runat="server" />
  <div style="display:none;">
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />

        </div>
  
  <script type="text/javascript">
      function AdjustGrodObj()
      {
          var eleClassName ="gridobject col-3";
          try{
              if(document.documentElement.clientWidth > 1900)
                  eleClassName = "gridobject col-2";
              else if(document.documentElement.clientWidth > 1300)
                  eleClassName = "gridobject col-4";
              else if(document.documentElement.clientWidth > 800)
                  eleClassName = "gridobject col-6";
              else
                  eleClassName = "gridobject col-6";
          }catch(e){

          }

          try{
              var elements = document.getElementsByClassName("gridobject");
              if(elements && elements.length != 0){
                  for(var i=0; i< elements.length; ++i){
                      elements[i].className = eleClassName;
                  }
              }
          }catch(e){

          }

          var e= document.getElementById("grid-example");
          
          e.style.height = (document.documentElement.clientHeight -110)+"px";
      }

      function adjust(){
          AdjustGrodObj();
      }
      adjust();
  </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
</asp:Content>
