﻿<%@ Page Title="Pending Approval Devices" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="PendingDevicesPage.aspx.cs" Inherits="GladinetPayFlow.PendingDevicesPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .dark {
            color: #565656 !important;
        }

        .ncell{
            padding:5px;
            font-weight:100;
            color:#565656;
            font-size:16px;
        }
        .tcell{
            padding:5px;
            font-weight:300;
            color:#404040;
            font-size:18px;
        }
    </style>
    <script type="text/javascript">



        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

      

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        
        function OnApproveDevice(id, name) {

            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_ApproveDevice");

            ng.value = id;
            btn.click();
        }
        

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">wiping...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        
   
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocDvcFnd" meta:resourcekey="str_dvcFnd" runat="server" Visible="false">Device(s) found</asp:Localize>
   
    <table width="100%" class="topnavcolor">
                            <tr>
                                <td style='padding-top: 2px; padding-left: 8px; height: 68px;'>
                                    <asp:Image ID="WebAppIcon" runat="server" Height="48px" meta:resourcekey="WebAppIconResource1" />
                                </td>
                                <td>
                                    <asp:Panel ID="DefaultLogo" runat="server" meta:resourcekey="DefaultLogoResource1">
                                        <img class="gladinetcloud" src="images/s.gif" />
                                    </asp:Panel>
                                    <asp:Panel ID="BrandedLogo" runat="server" meta:resourcekey="BrandedLogoResource1">
                                        <table>
                                            <tr>
                                                <td style="padding-left: 4px; overflow: hidden; height:48px" nowrap valign="middle">
                                                    <span style='font-family: "Lucida Grande" , "Lucida Sans Unicode" ,Verdana,Helvetica,Arial,sans-serif; font-size: 21px; color: white; font-weight: bold;'
                                                        id="PanelTitle">
                                                        <asp:Label ID="ProductLable" runat="server" Font-Size="20px" ForeColor="White" BackColor="Transparent"
                                                            meta:resourcekey="ProductLableResource1"></asp:Label>
                                                    </span>
                                                </td>
                                            </tr>
                                        </table>
                                    </asp:Panel>
                                </td>
                                <td>
                                      <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                </td>
                                <td style="padding-right: 10px;" align="right" valign="bottom">
                                    <h2 style="color: white;">
                                        <asp:Localize runat="server" meta:resourcekey="str_pndApvDvc">Pending Approval Devices</asp:Localize>
                                    </h2>
                                </td>
                            </tr>
                        </table>
    <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: 13px" cellspacing="0" id="grid-table"
                    cellpadding="0">
                   
                    
                    <tr>
                        <td  style="vertical-align: top;" id="result_div" align="center">
                            <div style="width:100%; max-width:1020px; max-height:600px; overflow:auto">
                                 <%if (EmptyPanel.Visible){ %>
                                <div style="font-size:24px; color:#565656; font-weight:100; padding-top:60px; height:400px">
                                <asp:Localize runat="server" meta:resourcekey="str_noDvcPndApv">No devices that are pending approval were found.</asp:Localize>
                                    </div>
                                <%}else    { %>
                            <table style="width:100%; max-width:1000px">
                                <tr>
                                    <td colspan="6" style="padding:10px;">
                                        <table width="100%">
                                            <tr>
                                                <td>
                                                    <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="badge tcell"></asp:Label>
                                                </td>
                                                <td align="right">
                                                    
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                                <tr  style="border-bottom:2px solid #cccccc;">
                                    <td class="tcell"><asp:Localize runat="server" meta:resourcekey="str_owr">Owner</asp:Localize></td>
                                    <td class="tcell"><asp:Localize runat="server" meta:resourcekey="str_hstNme">Host Name</asp:Localize></td>
                                    <td class="tcell"><asp:Localize runat="server" meta:resourcekey="str_typ">Type</asp:Localize></td>
                                    <td class="tcell"><asp:Localize runat="server" meta:resourcekey="str_os">OS</asp:Localize></td>
                                    <td class="tcell"><asp:Localize runat="server" meta:resourcekey="str_CliVer">Client Version</asp:Localize></td>
                                    <td class="tcell"><asp:Localize runat="server" meta:resourcekey="str_LasLog">Last Login</asp:Localize></td>
                                    <td></td>
                                    
                                </tr>
                                 <asp:Repeater ID="PubsRepeater" runat="server"  >
                            <ItemTemplate>
                                <tr class="filerow" style="border-bottom:1px solid #f0f0f0;">
                                    <td class="ncell"><%#DataBinder.Eval(Container.DataItem, "UserEmail")%></td>
                                    <td class="ncell"><%#DataBinder.Eval(Container.DataItem, "HostName")%></td>
                                    <td class="ncell"><%#DataBinder.Eval(Container.DataItem, "DeviceType")%></td>
                                    <td class="ncell"><%#DataBinder.Eval(Container.DataItem, "OsVer")%></td>
                                    <td class="ncell"><%#DataBinder.Eval(Container.DataItem, "ClientVer")%></td>
                                    <td class="ncell"><%#DataBinder.Eval(Container.DataItem, "LastLogin")%></td>
                                    <td>
                                        <button class="btn btn-primary gladbtn" onclick='OnApproveDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false'>Approve</button>
                                        <button class="btn btn-default gladbtn" onclick='OnDeleteDevice("<%#DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%#DataBinder.Eval(Container.DataItem, "HostName")%>");return false'><%=str_deldev.Text %></button>
                                    </td>
                                    
                                </tr>
                                 </ItemTemplate>
                       </asp:Repeater>
                                <tr>
                                    <td colspan="6" align="right" style="padding-right:10px;padding-top:20px;">
                                        <asp:LinkButton ID="CloseBtn" CssClass="btn btn-primary gladbtn" runat="server" OnClick="CloseBtn_Click" meta:resourcekey="str_cls">Close</asp:LinkButton>
                                       
                                    </td>
                                </tr>
                            </table>
                                <%} %>
                                                </div>
                        </td>
                    </tr>
                   
                </table>
    
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
                                <asp:Localize meta:resourcekey="str_deldev" ID="str_deldev" Visible="False" runat="server">Delete</asp:Localize>
                        <asp:Localize meta:resourcekey="str_wipe" ID="str_wipedev" runat="server" Visible="False">Wipe Device</asp:Localize>
                        <asp:Localize meta:resourcekey="str_mgrdev" ID="str_mgrdev" Visible="False" runat="server">View Details</asp:Localize>
                        <asp:Localize meta:resourcekey="str_delTkn" ID="str_delTkn" Visible="False" runat="server">Delete the Token</asp:Localize>
         <asp:LinkButton ID="ApproveDevice" runat="server" OnClick="ApproveDevice_Click">Approve</asp:LinkButton>
                                        <asp:LinkButton ID="DeleteDevice" runat="server" OnClick="DeleteDevice_Click">Delete</asp:LinkButton>
        <asp:Panel ID="EmptyPanel" runat="server" ></asp:Panel>
    </div>
    
    <div style="display: none;">
        <asp:HiddenField ID="DeviceId" runat="server" />
    </div>
   
    <script type="text/javascript">

      

      
       function AdjustGridTable () {
           
    
      }

      Ext.onReady(function () {


          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
      });
    </script>
</asp:Content>
