﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="LinkLocalFolder.aspx.cs" Inherits="GladinetPayFlow.LinkLocalFolder" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }            
        .csFlexRow {font-size:1rem;font-weight:100;width:100%;display:flex;align-items:center;gap:10px 10px;}
        #Div2 .bmd-form-group {width:100%;}
        </style>
    <script type="text/javascript">

        function Toggle(name) {
            var d = document.getElementById(name);
            if (d.style.display == 'none')
                d.style.display = 'block';
            else
                d.style.display = 'none';
        }

        function TogglePubUser() {
            var d = document.getElementById("pubusers");
            var t = document.getElementById("pubusersc");
            if (d.style.display == 'none') {
                d.style.display = 'block';
                t.style.height = "300px";
            } else {
                t.style.height = "10px";
                d.style.display = 'none';
            }
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var SelItem = null;
        var cursel = "";

        function setAttachBtn() {
            var e = document.getElementById("ctl00_MainContent_Location");
            var g = document.getElementById("ctl00_MainContent_OkBtn");
            if (e.value.indexOf("\\") != -1) {
                g.style.display = "";
            } else {
                g.style.display = "none";
            }
            
        }

        function onfolderselect(obj, key) {
            key = key.replace('|', "'");
            obj.style.backgroundColor = "#CBE1FC";
            if (SelItem) {
                SelItem.select = 0;
                SelItem.style.backgroundColor = "";
            }
            obj.select = 1;
            SelItem = obj;
            cursel = key;
            
            var e = document.getElementById("ctl00_MainContent_Location");
            e.value = key;

            setAttachBtn();

        }

        function onfolderdblclick(obj, key) {
            key = key.replace('|', "'");
            var e = document.getElementById("ctl00_MainContent_Location");
            e.value = key;

            e = document.getElementById("ctl00_MainContent_Browse");
            e.click();
            

        }

        function onfolderout(obj) {

            if (obj.select == 1)
                obj.style.backgroundColor = "#CBE1FC";
            else
                obj.style.backgroundColor = "";
        }

        function OnNewFolder(parent) {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'block';
            d.style.left = (document.body.offsetWidth - 450) / 2 + "px";

            d = document.getElementById("MainContent_CurrentParentFolder");

            d.value = parent;

        }

        function OnCancelNewFolder() {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'none';
            d.style.left = (document.body.offsetWidth - 600) / 2 + "px";
        }

        function onOk() {
            var e = document.getElementById("ctl00_MainContent_Location");
            if (e.value.indexOf("\\") == -1) {
                alert("<asp:Localize meta:resourcekey="str_badfolder" runat="server">Invalid local folder location</asp:Localize>");
                return false;
            }

            e = document.getElementById("ctl00_MainContent_FolderName");
            
            if (e.value == "") {
                alert("<asp:Localize meta:resourcekey="str_needname" runat="server">Name is required</asp:Localize>");
                return false;                
            }

            Wait("Please wait...")
            return true;
        }

        function onRoot() {
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder("");
            else
                parent.parent.SetSelectedFolder("");
        } 

        function refreshRightPanelAndThenClose() {
            var parentFrame = parent.document.querySelector(".fileDashboardIFrame"); 
            if(parentFrame){         
                if(parentFrame.contentWindow.forceRefreshRightSidePanel) { 
                    console.log("Refreshing right-side panel");
                    parentFrame.contentWindow.forceRefreshRightSidePanel();
                }
            }
            location.href = "/portal/closewin.htm";
        }           
        function CancelLink() {
            if (window.frameElement) {
                if (window.frameElement.id == "ShortWindow" || window.frameElement.id == "QuickAppView") {
                    //is inside of a quick window popup iframe
                    //close the popup and abort postback  
                    if (parent.CloseQuickWindow) {
                        parent.CloseQuickWindow();
                        return;
                    }
                }
            }
            if (parent.OnClickMainView) {
                //navigate away from the Two-Way Sync Tab of the Team Folder management
                parent.OnClickMainView();
            } 
        }
        <asp:Literal ID="LtlScripts" runat="server" />
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaFol" meta:resourcekey="str_faiToLoaFol" Visible="false">Failed to load folder</asp:Localize>
    <div class="navbar navbar-default meubardrop" role="navigation">
               <div class="container-fluid">
                   <div id="Div1" class="navbar-text">
                    <% if (!string.IsNullOrEmpty(CurParent) && CurParent.Length > 1){%>
                    <a href="javascript:;" style=" padding: 5px;padding-left: 10px;font-size: 16px; " onclick="onfolderdblclick(this, Ext.util.Format.htmlDecode('<%:PrevParent%>'));return false;">
                                 <span class="fa fa-level-up" aria-hidden="true"></span>&nbsp;<asp:Localize ID="Localize1" meta:resourcekey="asp_string3" runat="server">Parent Folder</asp:Localize></a>
                    <%} %>
                    </div>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                         
                     <div id="Div2" style="width:100%;vertical-align: middle; padding-top: 3px; color:#565656;">
                       <div class="csFlexRow" style="">
                            <div style="width:100px;white-space:nowrap;flex:0 4;">
                                <div style="padding-top:5px;"><asp:Localize meta:resourcekey="str_cloudfolder" runat="server">Cloud Folder</asp:Localize></div>
                            </div> 
                           <asp:Label ID="FolderName" runat="server" CssClass="form-control" Width="100%" style="flex:4 0;"></asp:Label>
                       </div>
                       <div class="csFlexRow" style="">
                            <div style="width:100px;white-space:nowrap;flex:0 4;">   
                                <div style="padding-top:5px;"><asp:Localize runat="server" meta:resourcekey="str_LocFol">Local Folder</asp:Localize></div>
                            </div> 
                           <asp:TextBox ID="Location" runat="server" CssClass="form-control" Width="100%" style="flex:4 0;margin-top: -1.75rem;"></asp:TextBox>
                       </div>
                   </div>
                   <div class="csFlexRow" style="justify-content:flex-end;">
                        <asp:Button ID="OkBtn"  Width="128px" runat="server" CssClass="btn btn-primary gladbtn  navbar-btn navbar-right" Text="Link" onclientclick="return onOk();" CausesValidation="False" meta:resourcekey="OkBtnResource1" onclick="OkBtn_Click" />
                        <asp:Button ID="CancelBTn"  Width="128px" runat="server" Text="Cancel"  CssClass="btn btn-default  navbar-btn navbar-right" OnClientClick="CancelLink();return false;" CausesValidation="False" meta:resourcekey="CancelBTnResource1"/>

                   </div>
              
           </div>
    </div>
    <div id="filecontent" style="width: 100%; height:300px; background-color: white; padding-top: 10px; margin-top: 20px; overflow: auto;">
    <table width="100%"  align="center" cellpadding="0" cellspacing="0"
        style="background-color: WHITE;" >
       
        <tr >
            <td colspan="2" valign="top" style="overflow: auto; padding:10px; "> 
               
                <%if (!EmptyFolder)
                  { %>
                    <table class="table" width="100%" onmousedown="return false;" onselectstart="return false;" >
                    <asp:Repeater ID="FolderList" runat="server">
                        <ItemTemplate>
                           
                                <tr style="padding-top: 5px; cursor:pointer;"
                                     onclick='onfolderselect(this, "<%# DataBinder.Eval(Container.DataItem, "OrigKey").ToString().Replace("'","|") %>")'
                                
                                ondblclick='onfolderdblclick(this, &#034;<%# DataBinder.Eval(Container.DataItem, "OrigKey").ToString().Replace("'","|") %>&#034;)'
                                    >
                                    <td  width="30px" style="padding: 5px;" >
                                       <span class="fa fa-folder-open" style="font-size: 16px; color:#808080;" aria-hidden="true"></span>
                                    </td>
                                    <td style=" padding: 5px;padding-left: 10px;font-size: 16px;color:#404040; ">
                                        <%#DataBinder.Eval(Container.DataItem, "Key")%>
                                    </td>
                                </tr>
                                
                           
                        </ItemTemplate>
                    </asp:Repeater>
                    </table>
                
                <%}
                  else
                  {%>
                  <div class='idea_flex'><asp:Localize meta:resourcekey="str_empty" runat="server">Folder is empty. You can navigate up a level to select a folder .</asp:Localize></div>
                <%}%>
             
            </td>
        </tr>
        
    </table>
    </div>
    <div style="display: none;">
                        <asp:Button ID="Browse"  Width=128px runat="server" CssClass="btn btn-primary gladbtn  navbar-btn navbar-right" 
                Text="Browse"   
                CausesValidation=False onclick="Browse_Click" />

    </div>
    <div id="NewFolderCtrl" style="top: 0px; left: 0px; position: absolute; display: none;">
        <div style="height: 30px;">
            <asp:HiddenField ID="CurrentParentFolder" runat="server" />
        </div>
        <table width="450" align="center" border="0" cellspacing="0" cellpadding="0" class="checkout3" style="background-color: white;">
            <tr>
                <td width="55" height="45" background="images/d-left-top-big-1.png">
                    <img width='32' height='32' src="images/adduser.png" style="margin-left: 15px; margin-top: 10px;" />
                </td>
                <td background="images/d-top-middle-1.png" style="color: White; font-size: 14px; padding-left: 0px;
                    padding-top: 5px;" align="left">
                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string1" runat="server">Create New Folder</asp:Localize>
                </td>
                <td width="30" background="images/d-right-top-1.png">
                    &nbsp;
                </td>
            </tr>
        </table>
        <table width="450" align="center" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td background="images/left-middle.jpg">
                    &nbsp;
                </td>
                <td>
                    <table width="100%" height="100%" align="center" style="background-color: WHITE;
                        padding: 10px;">
                        <tr>
                            <td class="InputLabel">
                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string2" runat="server">New Folder Name</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="NewFolderName" runat="server" Width="95%" class="InputText" 
                                    meta:resourcekey="NewFolderNameResource1"></asp:TextBox>
                                <div style="color: #D00000">
                                    <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="NewFolderName"
                                        ErrorMessage="Folder name is required!" Display="Dynamic" 
                                        CssClass="errmsg" meta:resourcekey="reqNameResource1" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <table width="100%" align="center">
                                    <tr>
                                        <td align="left">
                                        </td>
                                        <td align="right" colspan="2" style="border-top: 0px solid #d0d0d0; padding-top: 15px;">
                                            <asp:Button ID="CreateButtonNow" runat="server" Text="Apply Change" Font-Size="12px"
                                                Height="26px" OnClick="CreateButtonNow_Click" Width="90px" 
                                                meta:resourcekey="CreateButtonNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                                            <asp:Button ID="CancelChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                                                OnClientClick="OnCancelNewFolder()" Width="90px" 
                                                meta:resourcekey="CancelChangeResource1" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
                <td background="images/right-middle.jpg">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td width="30" height="30" background="images/bottom-left.jpg">
                    &nbsp;
                </td>
                <td background="images/bottom-middle.png">
                    &nbsp;
                </td>
                <td width="30" height="30" background="images/bootom-right.jpg">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td height="40px">
                    &nbsp;
                </td>
            </tr>
        </table>
    </div>
    <asp:HiddenField ID="InstanceId" runat="server" />
    
    <script type="text/javascript">
        function AdjustSize() {
            var e = document.getElementById("filecontent");
            e.style.height = (document.documentElement.offsetHeight - 92) + "px";

        }

        AdjustSize();
        document.body.onresize = AdjustSize;
        setAttachBtn();
    </script>
</asp:Content>
