﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="LDAPDomainCfgPage.aspx.cs" Inherits="GladinetPayFlow.LDAPDomainCfgPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
         td
        {
            font-size: 14px;
            
            font-weight: 100;
        }
        
        b
        {
            font-weight: 500;
        }
        
        label
        {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "LDAPCfgPage.aspx";
        }

        function OnCancelAddUser() {
            parent.closeCancelActiveWin();
        }
        function MyWait() {
            Wait("<asp:Localize meta:resourcekey="str_verify" runat="server">Verifying Settings...</asp:Localize>");
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToAddAdDom" meta:resourcekey="str_faiToAddAdDom" Visible="false">Failed to add ad domain</asp:Localize>
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label>
    
    
    <table width="100%" align="center" id='ldap1' >
        
        <tr>
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string1" runat="server" 
                    Text="Domain Controller or LDAP Server Address (myhost:389)"></asp:Localize><asp:RequiredFieldValidator
                    ControlToValidate="LDAPSvr" ID="RequiredFieldValidator1" runat="server" 
                    ErrorMessage="Required" Display="Dynamic" CssClass="errmsg" 
                    ValidationGroup="Setting" meta:resourcekey="RequiredFieldValidator1Resource1"></asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:TextBox ID="LDAPSvr" Width="95%" runat="server" 
                    CssClass="form-control" meta:resourcekey="LDAPSvrResource1"></asp:TextBox><br />
                <asp:CheckBox ID="LDAPS" runat="server" Text="Enable LDAPS for secure access" 
                    meta:resourcekey="LDAPSResource1" />
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string2" runat="server" 
                    Text="User name (used to connect to your Active Directory Service)"></asp:Localize><asp:RequiredFieldValidator
                    ControlToValidate="UserName" ID="RequiredFieldValidator2" runat="server" 
                    ErrorMessage="Required" Display="Dynamic" CssClass="errmsg" 
                    ValidationGroup="Setting" meta:resourcekey="RequiredFieldValidator2Resource1"></asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:TextBox ID="UserName" Width="95%" runat="server" 
                    CssClass="form-control" meta:resourcekey="UserNameResource1"></asp:TextBox>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string3" runat="server" Text="Password :"></asp:Localize><asp:RequiredFieldValidator ControlToValidate="Password" ID="RequiredFieldValidator3"
                    runat="server" ErrorMessage="Required" Display="Dynamic" CssClass="errmsg"
                    ValidationGroup="Setting" 
                    meta:resourcekey="RequiredFieldValidator3Resource1"></asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:TextBox ID="Password" Width="95%" runat="server" TextMode="Password" 
                    CssClass="form-control" meta:resourcekey="PasswordResource1"></asp:TextBox>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string4" runat="server" 
                    Text="Friendly Domain Name (i.e. mydomain.com, the domain name you see in Active Directory tools)"></asp:Localize><asp:RequiredFieldValidator ControlToValidate="Domain"
                    ID="RequiredFieldValidator4" runat="server" ErrorMessage="Required"
                    Display="Dynamic" CssClass="errmsg" ValidationGroup="Setting" 
                    meta:resourcekey="RequiredFieldValidator4Resource1"></asp:RequiredFieldValidator>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:TextBox ID="Domain" Width="95%" runat="server" 
                    CssClass="form-control" meta:resourcekey="DomainResource1"></asp:TextBox>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:Localize meta:resourcekey="asp_string5" runat="server" Text="Only include users and groups from the following Organizational Units (e.g. OU=ou1,OU=ou2.
                    Leave this blank to include all OUs)"></asp:Localize>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px">
                <asp:TextBox ID="ScopeOU" Width="95%" runat="server" Enabled="True"
                    CssClass="form-control" meta:resourcekey="ScopeOUResource1"></asp:TextBox>
            </td>
        </tr>
        
        
        <tr>
            <td height="90px">&nbsp;
                
            </td>
        </tr>
    </table>
     <div class="footer x-panel-header-light" style="border-left: 0; border-right: 0; padding: 10px; border-bottom: 0; vertical-align: middle; margin: 0;">
    <table width="100%" id='buttons'>
        <tr>
            <td style="padding-right: 10px;" align="right">
                <% if (m_CanEdit)
                   { %>
                <asp:Button ID="Button1"  runat="server" Text="Apply" CssClass="btn btn-primary gladbtn"
                    OnClick="Button1_Click" OnClientClick="MyWait();" 
                    Width="168px" meta:resourcekey="Button1Resource1" />
                    <% } %>
                    <% if (!string.IsNullOrEmpty(CancelMode.Value))
                       { %>
            
                <asp:Button ID="Button2"  CssClass="btn" runat="server"
                    meta:resourcekey="str_can" Text="Cancel" CausesValidation="False"
                    OnClientClick="Wait('Verify settings...');" 
                    Width="168px" onclick="Button2_Click1"  />
       <% } %>

            </td>

        </tr>
    </table>
    </div>
    <asp:HiddenField ID="CancelMode" runat="server" />
    <asp:HiddenField ID="SettingId" runat="server" />
    <asp:HiddenField ID="ReturnPage" runat="server" />
</asp:Content>
