﻿<%@ Page Title="Gladinet Cloud - Access Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ImportedGroup.aspx.cs" Inherits="GladinetPayFlow.ImportedGroup" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="css/css.css" type="text/css" />
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

    </style>
    <script type="text/javascript">
        

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var activewin;

        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "EditAcl.aspx";
        }

        function OnCancelAddUser() {
            parent.closeCancelActiveWin();
        }

       
        function OnUserSelected(UserList) {
            var ng = document.getElementById("ctl00_MainContent_NewUsers");
            var btn = document.getElementById("ctl00_MainContent_AddNewUsers");
            
            ng.value = UserList;
            btn.click();
        }

        function DeleteUser(name, UserId) {
            var ng = document.getElementById("ctl00_MainContent_UserId");
            var btn = document.getElementById("ctl00_MainContent_DeleteUser");

            if (confirm("<asp:Localize meta:resourcekey="js_string3" runat="server">Confirm you want to delete (</asp:Localize>" + unescape(name) + ")?")) {
                ng.value = UserId;
                btn.click();
            }
        }

        function SetPerm(userid) {
            var read = document.getElementById("read_" + userid);
            var write = document.getElementById("write_" + userid);
            var del = document.getElementById("delete_" + userid);
            var edit = document.getElementById("edit_" + userid);            
            var ng = document.getElementById("ctl00_MainContent_NewUsers");
            var btn = document.getElementById("ctl00_MainContent_SetUser");
            var ng1 = document.getElementById("ctl00_MainContent_UserId");
            
            ng1.value = userid;
            ng.value = read.checked + "," + write.checked + "," + del.checked + "," + edit.checked + ",false" ;

            btn.click();

        }

        function SelectLDAPGroup() {
            
            
            if (parent.parent.OnLDAPSelectGroup) {
                parent.parent.OnLDAPSelectGroupWithDomain('<%=SessionDomainId %>');
            } else {
                parent.OnLDAPSelectGroupWithDomain('<%=SessionDomainId %>');
            }

        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

   
    <table width="100%"  style="padding:8px; margin:0px; height:100%" align="center">
           <tr>
            <td valign="top" class="checkout3" style="background-color: white;">
                <table width="96%" style="height: 98%; padding: 8px;" cellspacing="0" cellpadding="0">
        <tr>
            
            <td align=right style="height:58px;">
                <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <table style="height:58px;">
                                        <tr>
                                        
                                            <td width="32px">
                                                <img width="24px" src="images/adduser.png" />
                                            </td>
                                            <td>
                                                <a href="javascript:;" onclick="SelectLDAPGroup();return false;" style="font-size: 12px;"><asp:Localize meta:resourcekey="str_impAdGro" runat="server">Import AD Group</asp:Localize></a>
                                            </td>
                                        </tr>
                                    </table>
            </td>
        </tr>
        <tr>
        <td colspan=3 style="padding-top:3px; vertical-align:top;">
         <div id="grid-example"></div> 
        </td>
        </tr>
        <tr>
        <td colspan=3 align=center class="idea_flex" style="padding:5px;padding-left:32px; vertical-align: middle;"><asp:Localize runat="server" meta:resourcekey="str_IfAnAdUseBelToTheImpGroTheUseEntWilBeCreAutWheTheUseLogTheFirTim">if an AD user belongs to the imported group, the user entry will be created automatically when the user login the first time.</asp:Localize></td>
        </tr>
        <tr>
           <td>&nbsp;</td>
        </tr>
                </table>
            </td>
          </tr>

    </table>
  
    <asp:HiddenField ID="ObjectName" runat="server" />
    <asp:HiddenField ID="NewUsers" runat="server" />
    <asp:HiddenField ID="UserId" runat="server" />
    <div style="display:none;">
    <asp:Button ID="AddNewUsers" runat="server" 
        onclick="AddNewUsers_Click" meta:resourcekey="AddNewUsersResource1" />
    <asp:Button ID="DeleteUser" runat="server" 
        onclick="DeleteUser_Click" meta:resourcekey="DeleteUserResource1" />
    <asp:Button ID="SetUser" runat="server" 
        onclick="SetUser_Click" meta:resourcekey="SetUserResource1" />

        </div>

<script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       [
       '<%#(((RepeaterItem)Container).ItemIndex+1) %>',
       '<%#DataBinder.Eval(Container.DataItem, "Name")%>', 
       '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Value").ToString())%>'
       ]        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();


          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'guid' },
                  { name: 'name' }
              ],
              data: myData
          });



          var grid = Ext.create('Ext.grid.Panel', {
              title: ' ',
              border:true,
              store: store,
              stripeRows: true,
              columnLines: true,
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "Group Name",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + value + "</b>";
                      }

                  },{
                      xtype: 'actioncolumn',
                      width: 30,
                      items:
                      [

                   
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "Delete",
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            DeleteUser(d.name,d.guid);
                        }
                        ,
                        getClass: function (v, meta, rec) {

                        }
                    }
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });
  </script>
</asp:Content>
