﻿<%@ Page Title="Hosted Cluster Manager" Language="C#" MasterPageFile="~/WebApp.master" AutoEventWireup="true"
    CodeBehind="HostedClusterMgr.aspx.cs" Inherits="GladinetPayFlow.HostedClusterMgr"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .MenuItem
        {
            padding-left: 0px;
            padding-right: 0px;
            margin-right: 10px;
            background-image: url(images/button2.png);
            font-weight: bold;
            width: 164px;
            height: 32px;
            color: #f0f0f0;
            text-align: center;
            background-repeat: no-repeat;
            cursor: hand;
        }
        
        .MenuItemSplit
        {
            padding-left: 0px;
            padding-right: 0px;
            margin-right: 10px;
            background-image: url(images/button2_split.png);
            font-weight: bold;
            width: 164px;
            height: 32px;
            color: #f0f0f0;
            text-align: center;
            background-repeat: no-repeat;
            cursor: hand;
        }
        .SubMenuItem
        {
            padding-left: 8px;
            padding-right: 0px;
            margin-right: 0px;
            margin-left: 2px;
            margin-top: 2px;
            width: 150px;
            height: 28px;
            color: #f0f0f0;
            text-align: left;
            background-repeat: no-repeat;
            background-position: 1px 1px;
            border-bottom: 1px solid #E0E0E0;
            cursor: hand;
        }
        
        .MenuSpep
        {
            width: 5px;
            padding: 0px;
        }
        
        .style5
        {
            width: 640px;
        }
        .dashboard16
        {
            background-image: url(images/dashboard16.png);
            background-repeat: no-repeat;
            background-position: 0 0;
        }
        
        .usermgmt16
        {
            background-image: url(images/user16.gif);
            background-repeat: no-repeat;
            background-position: 0 0;
        }
        
        .pubfolder16
        {
            background-image: url(images/pubfolder16.png);
            background-repeat: no-repeat;
            background-position: 0 0;
        }
        
        .browse16
        {
            background-image: url(images/browse16.png);
            background-repeat: no-repeat;
            background-position: 0 0;
        }
        
        .optionaltext
        {
            overflow: hidden;
        }
        .iconleft
        {
            padding-left: 8px;
            padding-bottom: 5px;
        }
        
        .sidelink
        {
            color: #404040;
        }
        .sidelink2
        {
            padding: 0px;
            margin: 0px;
            border-left: 0px;
            border-right: 0px;
            border-bottom: 0px;
        }
        
        tr.x-tab-bar-default td .sidelink
        {
            color: #fff;
            font-weight: 700;
        }
        
        .textbox
        {
            border-radius: 6px 6px 6px 6px;
            border: 1px solid #c0c0c0;
            padding: 2px;
            -moz-box-shadow: 0 0 8px #909090;
            -webkit-box-shadow: 0 0 8px #909090;
            box-shadow: 0 0 8px #909090;
            background-color: white;
        }
        
        .headlink
        {
            color: #ffffff;
            font-size: 14px;
            font-style: normal;
            font-weight: 700; /*height: 36px;*/ /*padding: 3px 16px 5px;*/
            text-align: right;
            text-decoration: none;
            width: 100px;
            text-transform: uppercase;
            white-space: nowrap;
            line-height: 100%;
        }
        
        td.headlink
        {
            text-align: left;
            padding-left: 0px;
            padding-top: 0px;
            line-height: 100%;
        }
        
        .headlink2
        {
            color: #e7e7e7;
            font-size: 12px;
            font-style: normal;
            font-weight: 700;
            height: 36px;
            padding-right: 6px;
            text-align: right;
            text-decoration: none;
            width: 100px;
            padding-left: 16px;
            padding-right: 16px;
            padding-top: 3px;
            padding-bottom: 5px;
        }
        .headlinktxt
        {
            white-space: nowrap;
        }
        
        
        a.headlink2:hover
        {
            color: #FFF;
            -moz-box-shadow: 0 0 8px #ccc;
            -webkit-box-shadow: 0 0 8px;
            background-image: url(images/backlit.png);
            background-position: center;
            background-repeat: no-repeat;
            border-radius: 12px 12px 12px 12px;
            border-color: #fff;
            box-shadow: 0 0 8px #fff;
        }
        
        .signupbtn
        {
            background: url(images/cart36_white.png);
            padding-left: 32px;
            height: 32px;
            background-repeat: no-repeat;
            cursor: pointer;
        }
        
        #north.x-tab-bar-default
        {
            background-color: #fefefe !important;
        }
        
          .navbar-default {
            background-color: #ffffff!important;            
            border-bottom: 1px solid #d0d0d0;
        }
        
        .x-panel-header-light {
            background-color: white !important;   
        }  
    </style>
    <style>
        @import url("/portal/css/<%=this.CSSTHEME%>");
    </style>
    <script type="text/javascript">

        var menuid = "WebAppListPanel_Dashboard";
        document.title = Ext.util.Format.htmlDecode("<%=Server.HtmlEncode(m_ProductName) %> - " +" <%=Server.HtmlEncode(SessionFullName) %>"+" (<%=Server.HtmlEncode(AccountEmail) %>)" );
        var ActiveWin;

        function adjust() {
            
            var f = document.getElementById('DashboardView');
            f.style.height = (document.documentElement.clientHeight - 0) + "px";
            //f.style.width = (document.documentElement.clientWidth-48) + "px";

            f = document.getElementById('main_body');
            f.style.height = (document.documentElement.clientHeight - 48) + "px";
            //f.style.width = (document.documentElement.clientWidth-48) + "px";
           
            //alert ("height"+ f.style.height);
            f = document.getElementById('MainDiv');
            f.style.backgroundColor = "white";

            f = document.getElementById("north");
            f.style.display = "none";
        }

        function OnUserMgr() {
            var btn = document.getElementById("ctl00_MainContent_UserManager");

            btn.click();

        }
        function SelfClusterInfo() {
            
            try{
                $('#myModal').modal('show');
            } catch (e) {
                
            }
        }

        function OnClickMyFiles()
        {
            window.location = "/portal/files";
        }

        function OnTenantMgr() {
            window.location = "/management/TeamsMgrPage.aspx";
        }
        var t_OnImportShare = "<asp:Localize meta:resourcekey="js_string1" runat="server">Import Network Share</asp:Localize>";
        var t_Close = "<asp:Localize meta:resourcekey="js_string2" runat="server">Close</asp:Localize>";
        var t_ShowMyAccount = "<asp:Localize meta:resourcekey="js_string3" runat="server">My Account</asp:Localize>";
        var t_OnUpgrade = "<asp:Localize meta:resourcekey="js_string4" runat="server">Upgrade</asp:Localize>";
        var t_OpenPubManager = "<asp:Localize meta:resourcekey="js_string5" runat="server">Published (team) Folders</asp:Localize>";
        var t_OpenAuditTrace = "<asp:Localize meta:resourcekey="js_string7" runat="server">System Audit Trace</asp:Localize>";
        var t_OpenFileAuditTrace = "<asp:Localize meta:resourcekey="js_string9" runat="server">File Change Audit Trace</asp:Localize>";
        var t_OpenShareManager = "<asp:Localize meta:resourcekey="js_string11" runat="server">Shared Objects</asp:Localize>";
        var t_WizardClicked = "<asp:Localize meta:resourcekey="js_string12" runat="server">Migration Wizards</asp:Localize>";
        var t_SyncPermWizard = "<asp:Localize meta:resourcekey="js_string20_2" runat="server">Sync Permissions</asp:Localize>";
        var t_WizardMigrateShare = "<asp:Localize meta:resourcekey="js_string13" runat="server">Migrate File Server</asp:Localize>";
        var t_WizardAddUser = "<asp:Localize meta:resourcekey="js_string14" runat="server">Add New User</asp:Localize>";
        var t_onFeedback = "<asp:Localize meta:resourcekey="js_string15" runat="server">Feedback</asp:Localize>";
        var t_OpenUserMgr = "<asp:Localize meta:resourcekey="js_string17" runat="server">Manage Users</asp:Localize>";
        var t_EditLDAP = "<asp:Localize meta:resourcekey="js_string19" runat="server">Edit AD Settings</asp:Localize>";
        var t_OnEditGroup = "<asp:Localize meta:resourcekey="js_string21" runat="server">User Info</asp:Localize>";
        var t_OpenGroupMgr = "<asp:Localize meta:resourcekey="js_string22" runat="server">Manage Groups</asp:Localize>";
        var t_BrowseLocalTree = "<asp:Localize meta:resourcekey="js_string23" runat="server">Select Folder</asp:Localize>";
        var t_AttachFolder = "<asp:Localize meta:resourcekey="js_string24" runat="server">Attach Folder from </asp:Localize>";
        var t_EditNoDownloadList = "<asp:Localize meta:resourcekey="js_string25" runat="server">List of Users with Client Download Disabled</asp:Localize>";
        var t_EditNoCacheList = "<asp:Localize meta:resourcekey="js_string26" runat="server">Allowed Users/Groups</asp:Localize>";
        var t_EditWhiteList = "<asp:Localize meta:resourcekey="js_string27" runat="server">Allowed Users/Groups</asp:Localize>";
        var t_SetAcls = "<asp:Localize meta:resourcekey="js_string28" runat="server">Security</asp:Localize>";
        var t_AddNewTeamFoleWizard = "<asp:Localize meta:resourcekey="js_string20_1" runat="server">Create New Team Folder</asp:Localize>";
        var t_AddNewPubFolder = "<asp:Localize meta:resourcekey="js_string29" runat="server">Publish Team Folder</asp:Localize>";
        var t_OnManageAdmin = "<asp:Localize meta:resourcekey="js_string31" runat="server">Manage Delegate Administrators</asp:Localize>";
        var t_AddUserGroup = "<asp:Localize meta:resourcekey="js_string32" runat="server">Edit Group</asp:Localize>";
        var t_EditPubFolder = "<asp:Localize meta:resourcekey="js_string33" runat="server">Edit Team Folder</asp:Localize>";
        var t_EditGroup = "<asp:Localize meta:resourcekey="js_string34" runat="server">Edit Group</asp:Localize>";
        var t_EditFolderPermission = "<asp:Localize meta:resourcekey="js_string35" runat="server">Edit Folder Permissions</asp:Localize>";
        var t_OnSelectUser = "<asp:Localize meta:resourcekey="js_string36" runat="server">Select User</asp:Localize>";
        {
        var t_OnSvrAgentGroup = "<asp:Localize meta:resourcekey="js_string37" runat="server">Select Group from Server Agent</asp:Localize>";
        }
        var t_OnLDAPSelectUser = "<asp:Localize meta:resourcekey="js_string38" runat="server">Select User</asp:Localize>";
        var t_OnSelectUserNoGroup = "<asp:Localize meta:resourcekey="js_string39" runat="server">Select User</asp:Localize>";
        var t_OnSelectUserGroupOnly = "<asp:Localize meta:resourcekey="js_string41" runat="server">Select Group</asp:Localize>";
        var t_OnChangePwd = "<asp:Localize meta:resourcekey="js_string42" runat="server">Change Password</asp:Localize>";
        var t_OnGroupPolicy = "<asp:Localize meta:resourcekey="js_string43" runat="server">Group Policy Manager</asp:Localize>";
        var t_OnChangeEmail = "<asp:Localize meta:resourcekey="js_string44" runat="server">Change Email</asp:Localize>";
        function getTzOffset() {
            var d = new Date().getTimezoneOffset();
            var i = document.getElementById("ctl00_MainContent_ClientTimeZoneOffset");
            i.value = d;

        }

        function SignupNowEx() {
            var btn = document.getElementById("ctl00_WebAppListPanel_Button3");
            
            btn.click();
        }

        function onLogoutEx() {
            var btn = document.getElementById("ctl00_WebAppListPanel_Button2");

            btn.click();
            
        }
        var SubViewUrl;
        var SubViewTitle;

        function OnClickSubView() {
            SetSubView(SubViewUrl, SubViewTitle);
        }

        function SetSecondPageTitle(t, u) {
            SetSubView(u, t);
        }
        function SetSubView(Url, t) {
            SubViewUrl = Url;
            SubViewTitle = t;

            var e = document.getElementById("main_body");
            e.src = Url;

            SetSubTitle(t);
        }

        function SetSubTitle(t) {
            
            parent.SetSubSubTitle(t);
           
        }

         function GetObjectsByClassName(c) {
          var els = [], found = [];
          
            els = document.getElementsByTagName('div');
            
            for (var i=0, end=els.length; i<end; i++) {
              try{
                if (els[i].className === c) {
                    found.push(els[i]);
                  }
              }catch(e){
                
              }
              
            }
          
          return found;
        };

        function ClickBtn(id)
        {
            var btn = document.getElementById("ctl00_MainContent_"+id);

            btn.click();

        }
        function ShowLeftPanel(){
            var s = document.getElementById("left_td");
            s.style.width = "300px";

             var divs = GetObjectsByClassName('right_link');
            for (var i=0, end=divs.length; i<end; i++) {
                divs[i].style.display ="block";
                divs[i].className = "right_link";
            }
        }

        function HideLeftPanel(){
            
            var s = document.getElementById("left_td");
            s.style.width = "48px";
            try{
             var divs = GetObjectsByClassName('right_link');
             
                for (var i=0, end=divs.length; i<end; i++) {             
                    divs[i].style.display ="none";
                }
            }catch(e){
                alert(e);
            }

        }

        var activewin;
        function ResetPassword() {

            var uri = "/portal/ResetUserPassword.aspx?t=<%=TargetEmail.Value %>";

            

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="str_rstPwd" runat="server">Reset Password</asp:Localize>",
                width: 680,
                height: maxh(460),
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                constrainHeader: true,
                constrain: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }]
            });
            activewin.show();
        }

    function OpenHtmlWindowShort(id, title, Html, w, h) {

          activewin = new Ext.Window({
              id: id,
              title: title,
              width: w,
              height: maxh(h),
              plain: true,
              modal: true,
              constrain: true,
              maximizable: false,
              maximized: false,
              bodyPadding: 5,
              resizable: false,
              shadow: 'drop',
              iconCls: 'publish',
              bodyStyle: 'background:#dfe8f6;border:0px; ',
              shadowOffset: 10,
              html: Html,
              defaults: {
                  border: false
              }
          });
          activewin.show();

      }
      function EditCloudStorageEx() {
            
          var uri = "<iframe id='add_local' src='SelectProvider.aspx?c=1&f=/&did=<%=TargetDomainId.Value %>&vdid=<%=SessionDomainId %>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            
          OpenHtmlWindowShort("edit_cloud", '<asp:Localize meta:resourcekey="str_ediCloSto" runat="server">Edit Cloud Storage</asp:Localize>', uri,800,620);



      }

     function EditCloudStorage() {
            
          var uri = "<iframe id='add_local' src='SelectProvider.aspx?f=/&did=<%=TargetDomainId.Value %>&vdid=<%=SessionDomainId %>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";

            
         OpenHtmlWindowShort("edit_cloud", '<asp:Localize meta:resourcekey="str_ediCloSto" runat="server">Edit Cloud Storage</asp:Localize>', uri,800,620);

      }
      function EditLocalStorage() {
          var uri = "<iframe id='add_local' src='AddLocalStorage.aspx?f=/&did=<%=TargetDomainId.Value %>&vdid=<%=SessionDomainId %>' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>";
            
          OpenHtmlWindowShort("edit_local", "<asp:Localize meta:resourcekey="str_edtLclStg" runat="server">Edit Local Storage</asp:Localize>", uri,800,620);


        }

      function EditStorage() {
          <% if (m_IsCloudStorage)
             { %>
          EditCloudStorage();
          <% }
             else
             { %>
          EditLocalStorage();
          <% } %>
      }

        function OpenDropMenu(l) {
            var e = document.getElementById("dashmenu");
            e.style.marginLeft = l + "px";
            $("#dropdownMenu1").dropdown('toggle');    
        }


    function closeCancelActiveWin() {        
       activewin.close();
    }

    function closeActiveWin() {
        window.location =  window.location;
    }

        var MainViewUrl = 'ClusterDashboard.aspx';
        var MainViewTitle = "<asp:Localize meta:resourcekey="str_dsh" runat="server">Dashboard</asp:Localize>";

        
        try {
            parent.SetSubMainMenu(MainViewTitle);
        } catch (op) {
        }

        function OnClickMainView() {
            SetView(MainViewUrl, MainViewTitle);
        }


    function SetView(Url, t) {
           
        MainViewUrl = Url;
        MainViewTitle = t;

        
        var e = document.getElementById("main_body");
        e.src = Url;

           
     

        parent.SetSubMainMenu(t);
        
    }
    function SetViewex(Url, t) {
        var e = document.getElementById("main_body");
        e.src = Url;

        e = document.getElementById("brandingctl");
        if (Url.indexOf("BrandingGeneral.aspx") != -1) {
            e.style.display = '';
            var e1 = document.getElementById("BrandingGeneral");
            ClearActiveItems();
            e1.className = "active";

        } else {
            e.style.display = 'none';
        }

        e = document.getElementById("grouppolicyctl");
        if (Url.indexOf("GroupPolicySecGeneral.aspx") != -1) {
            e.style.display = '';
            var e1 = document.getElementById("groupsec");
            ClearActiveItems();
            e1.className = "dropdown active";

        } else {
            e.style.display = 'none';
        }

        

        e = document.getElementById("currentview");
        e.innerHTML = t;

    }

    function ClearActiveItems() {
        try {
            var ee = document.getElementsByClassName("active");
            var i = 0;
            for (i = 0; i < ee.length; ++i) {
                ee[i].className = '';
            }
        } catch (e) {
            
        }
        
    }
    function SetBrandingPage(Url) {
        var e = document.getElementById("main_body");
        var e1 = document.getElementById(Url);
        
        e.src = Url+".aspx?mode=edit&brid=<%=TargetDomainId.Value%>";

        ClearActiveItems();
        
        
        e1.className = "active";
    }

    
    function SetGroupPolicyPage(Url) {
        var e = document.getElementById("main_body");
        var e1 = document.getElementById(Url);
        
        e.src = Url+".aspx?vdid=<%=TargetDomainId.Value%>";

        ClearActiveItems();
        
        
        e1.className = "active";
    }

    function SetSubSecurityGroupPolicyPage(Url) {
        var e = document.getElementById("main_body");
        
        
        e.src = Url+".aspx?vdid=<%=TargetDomainId.Value%>";

        
        
        var e1 = document.getElementById("groupsec");
        ClearActiveItems();
        e1.className = "dropdown active";        
    }

    function SetSubClientGroupPolicyPage(Url) {
        var e = document.getElementById("main_body");
        
        
        e.src = Url+".aspx?vdid=<%=TargetDomainId.Value%>";

        
        
        var e1 = document.getElementById("groupclient");
        ClearActiveItems();
        e1.className = "dropdown active";        
    }

    var CurrentActiveIFrame = "main_body";
     function OnUserSelected(UserList) {
            var child = document.getElementById(CurrentActiveIFrame);            
            child.contentWindow.OnUserSelected(UserList);
     }

        
        function closeWait() {
            try {
                if (WaitWnd !== null)
                    WaitWnd.close();
            } catch (e) {
            }
        }


        function SetItem(img, name, url) {
            SetSubView(url, name);
        }

        function SetSelfItem(img, name, url) {
            var m = document.getElementById("menubtn");
            var n = document.getElementById("PageName");
            var u = document.getElementById("main_body");

            CloseLeftMenu();
            //HideUserMenu();

            //Wait('Loading...');

            m.src = img;
            n.innerHTML = name;
            u.src = url;
            SetRootPageTitle(name, url);
        }
        var t_OnImportShare = "<asp:Localize meta:resourcekey="js_string1" runat="server">Import Network Share</asp:Localize>";
        var t_Close = "<asp:Localize meta:resourcekey="js_string2" runat="server">Close</asp:Localize>";
        var t_ShowMyAccount = "<asp:Localize meta:resourcekey="js_string3" runat="server">My Account</asp:Localize>";
        var t_OnUpgrade = "<asp:Localize meta:resourcekey="js_string4" runat="server">Upgrade</asp:Localize>";
        var t_OpenPubManager = "<asp:Localize meta:resourcekey="js_string5" runat="server">Published(team) Folders</asp:Localize>";
        var t_OpenAuditTrace = "<asp:Localize meta:resourcekey="js_string7" runat="server">System Audit Trace</asp:Localize>";
        var t_OpenFileAuditTrace = "<asp:Localize meta:resourcekey="js_string9" runat="server">File Change Audit Trace</asp:Localize>";
        var t_OpenShareManager = "<asp:Localize meta:resourcekey="js_string11" runat="server">Shared Objects</asp:Localize>";
        var t_WizardClicked = "<asp:Localize meta:resourcekey="js_string12" runat="server">Migration Wizards</asp:Localize>";
        var t_SyncPermWizard = "<asp:Localize meta:resourcekey="js_string20_2" runat="server">Sync Permissions</asp:Localize>";
        var t_WizardMigrateShare = "<asp:Localize meta:resourcekey="js_string13" runat="server">Migrate File Server</asp:Localize>";
        var t_WizardAddUser = "<asp:Localize meta:resourcekey="js_string14" runat="server">Add New User</asp:Localize>";
        var t_onFeedback = "<asp:Localize meta:resourcekey="js_string15" runat="server">Feedback</asp:Localize>";
        var t_OpenUserMgr = "<asp:Localize meta:resourcekey="js_string17" runat="server">Manage Users</asp:Localize>";
        var t_EditLDAP = "<asp:Localize meta:resourcekey="js_string19" runat="server">Edit AD Settings</asp:Localize>";
        var t_OnEditGroup = "<asp:Localize meta:resourcekey="js_string21" runat="server">User Info</asp:Localize>";
        var t_OpenGroupMgr = "<asp:Localize meta:resourcekey="js_string22" runat="server">Manage Groups</asp:Localize>";
        var t_BrowseLocalTree = "<asp:Localize meta:resourcekey="js_string23" runat="server">Select Folder</asp:Localize>";
        var t_AttachFolder = "<asp:Localize meta:resourcekey="js_string24" runat="server">Attach Folder from </asp:Localize>";
        var t_EditNoDownloadList = "<asp:Localize meta:resourcekey="js_string25" runat="server">List of Users with Client Download Disabled</asp:Localize>";
        var t_EditNoCacheList = "<asp:Localize meta:resourcekey="js_string26" runat="server">Allowed Users/Groups</asp:Localize>";
        var t_EditWhiteList = "<asp:Localize meta:resourcekey="js_string27" runat="server">Allowed Users/Groups</asp:Localize>";
        var t_SetAcls = "<asp:Localize meta:resourcekey="js_string28" runat="server">Security</asp:Localize>";
        var t_AddNewTeamFoleWizard = "<asp:Localize meta:resourcekey="js_string20_1" runat="server">Create New Team Folder</asp:Localize>";
        var t_AddNewPubFolder = "<asp:Localize meta:resourcekey="js_string29" runat="server">Publish Team Folder</asp:Localize>";
        var t_OnManageAdmin = "<asp:Localize meta:resourcekey="js_string31" runat="server">Manage Delegate Administrators</asp:Localize>";
        var t_AddUserGroup = "<asp:Localize meta:resourcekey="js_string32" runat="server">Edit Group</asp:Localize>";
        var t_EditPubFolder = "<asp:Localize meta:resourcekey="js_string33" runat="server">Edit Team Folder</asp:Localize>";
        var t_EditGroup = "<asp:Localize meta:resourcekey="js_string34" runat="server">Edit Group</asp:Localize>";
        var t_EditFolderPermission = "<asp:Localize meta:resourcekey="js_string35" runat="server">Edit Folder Permissions</asp:Localize>";
        var t_OnSelectUser = "<asp:Localize meta:resourcekey="js_string36" runat="server">Select User</asp:Localize>";
      
        var t_OnSvrAgentGroup = "<asp:Localize meta:resourcekey="js_string37" runat="server">Select Group from Server Agent</asp:Localize>";
        
        var t_OnLDAPSelectUser = "<asp:Localize meta:resourcekey="js_string38" runat="server">Select User</asp:Localize>";
        var t_OnSelectUserNoGroup = "<asp:Localize meta:resourcekey="js_string39" runat="server">Select User</asp:Localize>";
        var t_OnSelectUserGroupOnly = "<asp:Localize meta:resourcekey="js_string41" runat="server">Select Group</asp:Localize>";
        var t_OnChangePwd = "<asp:Localize meta:resourcekey="js_string42" runat="server">Change Password</asp:Localize>";
        var t_OnGroupPolicy = "<asp:Localize meta:resourcekey="js_string43" runat="server">Group Policy Manager</asp:Localize>";
        var t_OnChangeEmail = "<asp:Localize meta:resourcekey="js_string44" runat="server">Change Email</asp:Localize>";

        function TenantManager() {

            SetItem("/portal/images/addcompany.png", "<asp:Localize meta:resourcekey="str_tntMgr" runat="server">Tenant Manager</asp:Localize>", "TeamsMgrPage.aspx");
        }

        function EditAdmin() {
            
            SetItem("images/admin.png", "<asp:Localize meta:resourcekey="str_clrAdm" runat="server">Cluster Admin</asp:Localize>", "ClusterEditUserInfo.aspx?cluster=1");
        }

        function ClusterBranding() {
            
            SetItem("images/branding.png", "<asp:Localize meta:resourcekey="str_ctrBrd" runat="server">Cluster Branding</asp:Localize>", "BrandingMgrPage.aspx?mode=cluster");
        }

        function EmailService() {
            
            SetItem("images/email-server.png", "<asp:Localize meta:resourcekey="str_emlSvc" runat="server">Email Service</asp:Localize>", "SMTPCfg.aspx");
        }

        function ServerFarm() {
            
            SetItem("images/serverfarm.png", "<asp:Localize meta:resourcekey="str_svrFrm" runat="server">Server Farm</asp:Localize>", "ClusterFarm.aspx");
        }

        function ClusterInfo() {
            
            SetItem("images/info.png", "<asp:Localize meta:resourcekey="str_ctrInf" runat="server">Cluster Info</asp:Localize>", "ClusterInfo.aspx");
        }
        function Reports() {
        
            SetItem("images/reports.png", "<asp:Localize meta:resourcekey="str_rpt" runat="server">Reports</asp:Localize>", "ClusterReports.aspx");
        }
        function ClusterSettings() {
            SetItem("images/settings.png", "<asp:Localize meta:resourcekey="str_ctrStg" runat="server">Cluster Settings</asp:Localize>", "ClusterSettingsPage.aspx");
        }
        function ClusterLang() {
            SetItem("images/langs.png", "<asp:Localize meta:resourcekey="str_lng" runat="server">Languages</asp:Localize>", "localize/Default.aspx");
        }

        function onDashboard() {
            
            SetSelfItem("images/langs.png", "<asp:Localize meta:resourcekey="str_dshBrd" runat="server">Dashboard</asp:Localize>", "ClusterDashboard.aspx");
        }


        function ClientVer() {
            
            SetItem("images/serverfarm.png", "<asp:Localize meta:resourcekey="str_cltVrnMgr" runat="server">Client Version Manager</asp:Localize>", "ClientVersion.aspx");
        }


                function WorkerNodeMgr() {
            
                    SetItem("images/serverfarm.png", "<asp:Localize meta:resourcekey="str_wkrNde" runat="server">Worker Nodes</asp:Localize>", "WorkerNodesMgr.aspx");
        }
        

        function AntiVirus() {
            
            SetItem("images/serverfarm.png", "<asp:Localize meta:resourcekey="str_antVir" runat="server">Anti Virus/Ransomware</asp:Localize>", "AntiVirus.aspx");
        }
        
        function ActiveUsers() {
            
            SetItem("images/reports.png", "<asp:Localize meta:resourcekey="str_actUsr" runat="server">Active Users</asp:Localize>", "ActiveUsers.aspx");
        }
         
        function BandReport() {
            
            SetItem("images/reports.png", "<asp:Localize meta:resourcekey="str_bndWthUsg" runat="server">Bandwidth Usage</asp:Localize>", "BandwidthStat.aspx");
        }
         
        function UploadReport() {
            
            SetItem("images/reports.png", "<asp:Localize meta:resourcekey="str_updRpt" runat="server">Upload Report</asp:Localize>", "UploadStat.aspx");
        }

        function StorageReport() {
            
            SetItem("images/reports.png", "<asp:Localize meta:resourcekey="str_strSts" runat="server">Storage Statistics</asp:Localize>", "StorageStat.aspx");
        }

         function GroupPolicy() {
            
             SetItem("images/email-server.png", "<asp:Localize meta:resourcekey="str_grpPlc" runat="server">Group Policy</asp:Localize>", "GroupPolicyMgrPage.aspx?vdid=2CD45C43-114F-406C-998C-C6B477148FC3");
        }

    </script>
    <script type="text/javascript" src="/portal/gladwebapp.js?ver=<%=WebUiVer%>"></script>
</asp:Content>
<asp:Content ID="WebApps" runat="server" ContentPlaceHolderID="WebAppListPanel">
    <table width="100%" cellspacing="0" cellpadding="0" style="padding: 0px; height: 40px;
        display: none;" border="0" valign="top">
        <tr>
            <td style="color: #606060; font-weight: bold; overflow: hidden;" nowrap="nowrap"
                valign="middle">
                <table>
                    <tr>
                        <td>
                        </td>
                        <td width="240px" align="left" style="font-size: 16px;">
                            <asp:Label ID="AdminName" runat="server" Text=""></asp:Label>
                        </td>
                    </tr>
                </table>
            </td>
            <td width="30px" align="left" style="padding-left: 4px; display: none;" nowrap="nowrap">
            </td>
            <td align="center" style="overflow: hidden;">
                 
            </td>
            <td valign="middle" style="padding: 0px; text-align: right;">
                <table cellspacing="0" cellpadding="0" align="right" style="height: 50px;">
                    <tr>
                        <td align="center" style="padding-right: 10px">
                            <a href="javascript:;" title="Change Tenant Admin Password" onclick="ResetPassword();return false;" runat="server" meta:resourcekey="str_chgTntAdmPwd">
                                <img src="/portal/images/changepassword.png" alt="" /></a>
                        </td>
                        <td align="center" style="padding-right: 10px">
                            <a href="javascript:;" title="<asp:Localize meta:resourcekey="str_edtExtDftStg" runat="server">Edit existing default storage</asp:Localize>" onclick="EditStorage();return false;">
                                <img src="/portal/images/editstor.png" alt="" /></a>
                        </td>
                        <% if (m_CanChangeDefaultStorage)
                           { %>
                        <td align="center" style="padding-right: 10px">
                            <a href="javascript:;" title="<asp:Localize meta:resourcekey="str_rpcDftStgWthCld" runat="server">Replace default storage with new cloud storage</asp:Localize>" onclick="EditCloudStorageEx();return false;" runat="server" meta:resourcekey="str_rpcDftStrCldStr">
                                <img src="/portal/images/mystorage.png" alt="" /></a>
                        </td>
                        <td align="center" style="padding-right: 10px">
                            <a href="javascript:;" title="<asp:Localize meta:resourcekey="str_rpcDftStgWthLcl" runat="server">Replace default storage with new local storage</asp:Localize>" onclick="EditLocalStorage();return false;" runat="server" meta:resourcekey="str_rpcDftStrLclStr">
                                <img width="32" src="/portal/images/addlocal.png" alt="" /></a>
                        </td>
                        <% } %>
                        <td width="16px">
                            &nbsp;
                        </td>
                    </tr>
                </table>
            </td>
            <td width="50px" align="left" style="padding-left: 4px; display: none;">
            </td>
            <td style="width: 1px; overflow: hidden">
                <%if (GetWebSessionTimeout() != 0)
                  { %>
                <iframe id='Iframe1' src="/portal/RefreshPage.aspx" frameborder="0" border="0" style="width: 1px;
                    height: 1px"></iframe>
                <%} %>
            </td>
        </tr>
    </table>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
              <div style="height: 1px;" class="dropdown" id="dashmenu">
              <div class="dropdown " style="height: 1px;">
                  <button class="btn btn-info  dropdown-toggle " type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" style="padding: 0px!important; height: 1px; padding-right: 0px; cursor: pointer; ">
                  </button>
                  <div class="dropdown-menu  dropdown-menu-left" aria-labelledby="dropdownMenu1" style="width:660px; padding-bottom: 20px; ">
                      
                   <div class="container" style=" width:660px; color: #565656;">
                        <div class="row ">
                             <div class="col-md-3 text-center topbuffer" onclick='SetView("/management/ClusterDashboard.aspx","<asp:Localize meta:resourcekey="str_dshBrd" runat="server">Dashboard</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >O</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_dshBrd" runat="server">Dashboard</asp:Localize>
                                    </td>
                                </tr>
                            </table>
                             
                         </div>
                             
                        <div class="col-md-3 text-center topbuffer" onclick='SetView("TeamsMgrPage.aspx","<asp:Localize meta:resourcekey="str_tntMgr" runat="server">Tenant Manager</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center" style="font-size: 32px; font-weight: 100;">U</i>
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_tntMgr" runat="server">Tenant Manager</asp:Localize>
                                    </td>
                                </tr>
                            </table>
                             
                         </div>
                         
                             
                        <div class="col-md-3 text-center topbuffer" onclick='SetView("ClusterEditUserInfo.aspx?cluster=1", "<asp:Localize meta:resourcekey="str_clrAdm" runat="server">Cluster Admin</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >M</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_clrAdm" runat="server">Cluster Admin</asp:Localize>
                                    </td>
                                </tr>
                            </table>
                             
                         </div>        
                         
                          <div class="col-md-3 text-center topbuffer" onclick='SetView("SMTPCfg.aspx","<asp:Localize meta:resourcekey="str_emlSvc" runat="server">Email Service</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >E</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_emlSvc" runat="server">Email Service</asp:Localize>
                                    </td>
                                </tr>
                            </table>
                             
                         </div>     
                         
                          
                         <div class="col-md-3 text-center topbuffer" onclick='SetView("ClusterReports.aspx","<asp:Localize meta:resourcekey="str_rpt" runat="server">Reports</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                    <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >R</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_rpt" runat="server">Reports</asp:Localize>
                                    </td>
                                </tr>
                            </table>
                             
                         </div>     
                         
                         
                         <div class="col-md-3 text-center topbuffer" onclick='SetView("ClusterControlPanel.aspx","<asp:Localize meta:resourcekey="str_stg" runat="server">Settings</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >c</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_stg" runat="server">Settings</asp:Localize>
                                    </td>
                                </tr>
                            </table>                             
                         </div>     
                         
                         
                         <div class="col-md-3 text-center topbuffer" onclick='SetView("WorkerNodesMgr.aspx","<asp:Localize meta:resourcekey="str_svrFrm" runat="server">Server Farm</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >W</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_svrFrm" runat="server">Server Farm</asp:Localize>
                                    </td>
                                </tr>
                            </table>                             
                         </div>   
                         
                         <div class="col-md-3 text-center topbuffer" onclick='SetView("BrandingMgrPage.aspx?mode=cluster","<asp:Localize meta:resourcekey="str_brd" runat="server">Branding</asp:Localize>");return false;' style="padding-top: 10px; cursor:pointer;">
                            <table width="100%">
                                <tr>
                                    <td height="40px" align="center" valign="middle">
                                     <i class="gladinet-icons md-32 iconviewitemcolor hand center toolbtnb" >B</i>
                                        
                                    </td>
                                </tr>
                                <tr>
                                    <td height="20px" align="center" valign="middle">
                                        <asp:Localize meta:resourcekey="str_brd" runat="server">Branding</asp:Localize>
                                    </td>
                                </tr>
                            </table>                             
                         </div>   
                         
                         
                    </div>
                    
                      
                      
                    </div>
                  </div>
               </div>
                  </div>

    <nav class="navbar navbar-default" role="navigation" style="display: none;">
         <div class="container-fluid" style="background-color: white;">
             <%if (!IsTennatOwner)
               { %>
             <button type="button" class="btn btn-default navbar-btn navbar-left " title="return to tenant manager" onclick="OnTenantMgr()" style="display: none;"> 
                <span class="fa fa-menu-left"></span> <asp:Localize meta:resourcekey="str_tntMgr" runat="server">Tenant Manager</asp:Localize>
             </button>
             <%} %>
             
             <span class="navbar-text navbar-right" style="width: 10px;">
                 <div id="myModal" class="modal fade" role="dialog" style="color: #565656;">
        <div class="modal-dialog" style="padding-top: 15%; ">
            <!-- Modal content-->
            <div class="modal-content" style="width: 100%;">
                <div class="modal-header">
                    <table>
                        <tr>
                            <td width="36px">
                                <asp:Image ID="WebAppIcon" runat="server" Height="32px" meta:resourcekey="WebAppIconResource1" />
                            </td>
                            <td>
                                <h4 class="modal-title">
                                    <%=m_ProductName%></h4>
                            </td>
                        </tr>
                    </table>
                                        <button type="button" class="close" data-dismiss="modal">
                        &times;</button>

                </div>
                <div class="modal-body">
                    <table class="table-striped" style="font-size: 16px; width: 100%;">
                        <tr>
                            <td colspan="2" align="center">
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; font-size: 16px;" nowrap="nowrap">
                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string2" runat="server" Text="Cluster Id:"></asp:Localize>
                            </td>
                            <td style="padding: 5px; font-size: 12px;">
                                <asp:Label ID="ClusterId" runat="server"></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td style="padding: 5px; font-size: 16px;">
                                <asp:Localize meta:resourcekey="str_vrs" runat="server">Version:</asp:Localize>
                            </td>
                            <td style="padding: 5px; font-size: 12px;">
                                <asp:Label ID="Version" runat="server"></asp:Label>
                            </td>
                        </tr>
                        
                        
                    </table>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">
                       <asp:Localize meta:resourcekey="str_cls" runat="server">Close</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>
             </span>
              
                
                
                <span class="navbar-text navbar-right" style="width: 20px;">
                 
             </span>
             <ul class="nav navbar-nav navbar-right" id="brandingctl" style="display: none; color: #565656;padding-top: 10px;">
      <li class="active" onclick="SetBrandingPage('BrandingGeneral');return false;" id="BrandingGeneral"><a href="javascript:;"><asp:Localize meta:resourcekey="str_gnl" runat="server">General</asp:Localize></a></li>
      <li id="BrandingWeb"><a href="javascript:;" onclick="SetBrandingPage('BrandingWeb');return false;" ><asp:Localize meta:resourcekey="str_webPrt" runat="server">Web Portal</asp:Localize></a></li>
      <li id="BrandingDownload"><a href="javascript:;" onclick="SetBrandingPage('BrandingDownload');return false;" ><asp:Localize meta:resourcekey="str_cltDwd" runat="server">Client Download</asp:Localize></a></li> 
      <li id="BrandingWin"><a href="javascript:;" onclick="SetBrandingPage('BrandingWin');return false;" ><asp:Localize meta:resourcekey="str_winClt" runat="server">Windows Client</asp:Localize></a></li> 
      <li id="BrandingMac"><a href="javascript:;" onclick="SetBrandingPage('BrandingMac');return false;" ><asp:Localize meta:resourcekey="str_macClt" runat="server">Mac Client</asp:Localize></a></li> 
      <li id="BrandingEmail"><a href="javascript:;" onclick="SetBrandingPage('BrandingEmail');return false;" ><asp:Localize meta:resourcekey="str_eml" runat="server">Email</asp:Localize></a></li> 
      <li id="BrandingSMTPCfg"><a href="javascript:;" onclick="SetBrandingPage('BrandingSMTPCfg');return false;" ><asp:Localize meta:resourcekey="str_emlSvc" runat="server">Email Service</asp:Localize></a></li> 
    </ul>
    
    <ul class="nav navbar-nav navbar-right" id="grouppolicyctl" style="display:none;color: #565656;padding-top: 10px;">
      <li class="dropdown active" onclick="return false;" id="groupsec" style="cursor: pointer;">         
                <a class="dropdown-toggle" type="button" data-toggle="dropdown"><asp:Localize meta:resourcekey="str_sec" runat="server">Security</asp:Localize>
                    <span class="caret"></span>
                </a>
                  <ul class="dropdown-menu" style="color: #565656;padding-top: 10px;">
                    <li onclick="SetSubSecurityGroupPolicyPage('GroupPolicySecGeneral');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_gnl" runat="server">General</asp:Localize></a></li>
                    <li onclick="SetSubSecurityGroupPolicyPage('GroupPolicySecShare');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_shr" runat="server">Sharing</asp:Localize></a></li>
                    <li  onclick="SetSubSecurityGroupPolicyPage('GroupPolicySecUserAccount');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_usrAct" runat="server">User Account</asp:Localize></a></li>
                    <li onclick="SetSubSecurityGroupPolicyPage('GroupPolicySecStorage');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_fldStg" runat="server">Folder and Storage</asp:Localize></a></li>
                    <li onclick="SetSubSecurityGroupPolicyPage('GroupPolicyPwd');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_pwdPol" runat="server">Password Policy</asp:Localize></a></li>
                    <li onclick="SetSubSecurityGroupPolicyPage('GroupPolicySecSSO');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_sglSon" runat="server">Single Signon</asp:Localize></a></li>
                     <li onclick="SetSubSecurityGroupPolicyPage('TenantAzureAD');return false;"><a href="javascript:;"><asp:Localize meta:resourcekey="str_azrAd" runat="server">Azure AD</asp:Localize></a></li>
                  </ul>

      </li>
       <li class="dropdown" onclick="return false;" id="groupclient" style="cursor: pointer;color: #565656;">         
                <a class="dropdown-toggle" type="button" data-toggle="dropdown"><asp:Localize meta:resourcekey="str_cliCon" runat="server">Client Control</asp:Localize>
                    <span class="caret"></span>
                </a>
                  <ul class="dropdown-menu">
                    <li onclick="SetSubClientGroupPolicyPage('GroupPolicyClientLock')"><a href="javascript:;"><asp:Localize meta:resourcekey="str_filLck" runat="server">File Locking</asp:Localize></a></li>
                    <li onclick="SetSubClientGroupPolicyPage('GroupPolicyClientAttachedFolder')"><a href="javascript:;"><asp:Localize meta:resourcekey="str_atdFld" runat="server">Attached Folder</asp:Localize></a></li>
                    <li onclick="SetSubClientGroupPolicyPage('GroupPolicyClientWeb')"><a href="javascript:;"><asp:Localize meta:resourcekey="str_webPrt" runat="server">Web Portal</asp:Localize></a></li>
                    <li onclick="SetSubClientGroupPolicyPage('GroupPolicyClientNative')"><a href="javascript:;"><asp:Localize meta:resourcekey="str_ntvClt" runat="server">Native Clients</asp:Localize></a></li>
                    <li onclick="SetSubClientGroupPolicyPage('GroupPolicyClientFilter')"><a href="javascript:;"><asp:Localize meta:resourcekey="str_ftr" runat="server">Filters</asp:Localize></a></li>
                    <li onclick="SetSubClientGroupPolicyPage('GroupPolicyClientSettings')"><a href="javascript:;"><asp:Localize meta:resourcekey="str_cltStgMgr" runat="server">Client Settings Manager</asp:Localize></a></li>
                  </ul>

      </li>      
      <li id="GroupPolicyRe"><a href="javascript:;" onclick="SetGroupPolicyPage('GroupPolicyRe');return false;" ><asp:Localize meta:resourcekey="str_rtnPol" runat="server">Retention Policy</asp:Localize></a></li> 
      <li id="GroupPolicyHome"><a href="javascript:;" onclick="SetGroupPolicyPage('GroupPolicyHome');return false;" ><asp:Localize meta:resourcekey="str_hmeDir" runat="server">Home Directory</asp:Localize></a></li> 
      <li id="GroupPolicyAV"><a href="javascript:;" onclick="SetGroupPolicyPage('GroupPolicyAV');return false;" ><asp:Localize meta:resourcekey="str_antVir" runat="server">Anti Virus/Ransomware</asp:Localize></a></li> 
      <li id="NotificationSettings"><a href="javascript:;" onclick="SetGroupPolicyPage('NotificationSettings');return false;" ><asp:Localize meta:resourcekey="str_ntfStg" runat="server">Notification Settings</asp:Localize></a></li> 
    </ul>
         </div>
    </nav>
    <table width="100%" id='DashboardView' cellspacing="0" cellpadding="0" style="padding: 0px;
        margin: 0px; margin-top: -18px;">
        <tr>
            <td style="vertical-align: top; padding: 0px; margin: 0px;">
                <iframe width="100%" src="<%Response.Write(GetCurrentPageSrc());%>" frameborder="0"
                    border="0" id="main_body"></iframe>
            </td>
            <asp:Panel ID="LeftPanel" runat="server">
                <td id="left_td" width="48px" onmouseover="ShowLeftPanel();" onmouseout="HideLeftPanel();"
                    style="background-color: #f8f8f8; border-right: 2px solid #d0d0d0; padding: 6px;
                    display: none; padding-left: 0px; padding-right: 0px;" valign="top">
                    <table width="100%" cellspacing="0" cellpadding="0">
                        <tr>
                            <td height="5px" id="su_c" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr id="su">
                            <td width="40px" class="iconleft">
                                <img id="Img1" src="/portal/images/dashboard.png" width="32" height="32" onclick="ClickBtn('StorageUsage')" alt="" />
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px;">
                                <div class='right_link' style="display: none;">
                                    <asp:LinkButton ID="StorageUsage" runat="server" Font-Size="16px" OnClick="Dashboard_Click"
                                        CssClass="sidelink" meta:resourcekey="str_tntInf">Tenant Info</asp:LinkButton>
                                </div>
                            </td>
                        </tr>
                        <%if (m_ShowTeamFolder)
                          { %>
                        <tr>
                            <td id="pfm_c" height="10px" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr id="pfm" style="padding-left: 5px; padding-bottom: 5px;">
                            <td width="40px" class="iconleft">
                                <img id="pfm_i" src="s.gif" width="32" height="32" onclick="ClickBtn('LinkButton5')" alt="" />
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px;">
                                <div class='right_link' style="display: none;">
                                    <asp:LinkButton ID="LinkButton5" runat="server" Font-Size="16px" OnClick="Collab_Click"
                                        meta:resourcekey="LinkButton5Resource1" CssClass="sidelink">Collaboration</asp:LinkButton>
                                </div>
                            </td>
                        </tr>
                        <%} %>
                        <%if (m_ShowUserManager)
                          { %>
                        <tr>
                            <td height="5px" id="um_c" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr id="um">
                            <td width="40px" class="iconleft">
                                <img id="um_i" src="s.gif" width="32" height="32" onclick="ClickBtn('UserManager')" alt="" />
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px;">
                                <div class='right_link' style="display: none;">
                                    <asp:LinkButton ID="UserManager" runat="server" Font-Size="16px" OnClick="UserManager_Click"
                                        meta:resourcekey="UserManagerResource1" CssClass="sidelink">User Manager</asp:LinkButton>
                                </div>
                            </td>
                        </tr>
                        <%} %>
                        <%if (m_ShowGroupPolicy)
                          {%>
                        <tr>
                            <td height="5px" id="gp_c" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr id="gp">
                            <td width="40px" class="iconleft">
                                <img id="gp_i" src="s.gif" width="32" height="32" onclick="ClickBtn('LinkButton4')" alt="" />
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px;">
                                <div class='right_link' style="display: none;">
                                    <asp:LinkButton ID="LinkButton4" runat="server" Font-Size="16px" CssClass="sidelink"
                                        OnClick="LinkButton4_Click2" meta:resourcekey="LinkButton4Resource1">Group Policy</asp:LinkButton>
                                </div>
                            </td>
                        </tr>
                        <%} %>
                        <%if (m_ShowEditAdmin)
                          {%>
                        <tr>
                            <td height="5px" id="am_c" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr id="am">
                            <td width="40px" class="iconleft">
                                <img id="am_i" src="s.gif" width="32" height="32" onclick="ClickBtn('LinkButton1')" alt="" />
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px;">
                                <div class='right_link' style="display: none;">
                                    <asp:LinkButton ID="LinkButton1" runat="server" Font-Size="16px" CssClass="sidelink"
                                        OnClick="EditAdmin_Click" meta:resourcekey="LinkButton1Resource1">Tenant Administrators</asp:LinkButton>
                                </div>
                            </td>
                        </tr>
                        <%} %>
                        <% if (m_ShowAdvanced)
                           { %>
                        <tr>
                            <td height="5px" id="adv_c" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr id="adv">
                            <td width="40px" class="iconleft">
                                <img id="adv_i" src="s.gif" width="32" height="32" onclick="ClickBtn('LinkButton3')" />
                            </td>
                            <td style="padding-left: 5px; padding-bottom: 5px;">
                                <div class='right_link' style="display: none;">
                                    <asp:LinkButton ID="LinkButton3" runat="server" Font-Size="16px" CssClass="sidelink"
                                        OnClick="Advanced_Click" meta:resourcekey="LinkButton3Resource1">Advanced</asp:LinkButton>
                                </div>
                            </td>
                        </tr>
                        <% } %>
                        <tr>
                            <td height="5px" id="lm_c" colspan="2" style="border-top: 1px solid #e0e0e0; color: #A0A0A0;"
                                class="sidelink2">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td>
                            </td>
                            <td align="right">
                                <div class='right_link' style="display: none;" onclick="HideLeftPanel();">
                                    <img src="images/s.gif" class="x-toolbar-scroll-left" alt="" />
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </asp:Panel>
            <asp:Label ID="TenantName" runat="server" CssClass="badge" Visible="False"></asp:Label>
        </tr>
    </table>
    <asp:HiddenField ID="ClientTimeZoneOffset" runat="server" />
    <asp:HiddenField ID="TargetDomainId" runat="server" />
    <asp:HiddenField ID="TargetAdminId" runat="server" />
    <asp:HiddenField ID="TargetEmail" runat="server" />
    <script type="text/javascript">
        function setActiveItem() {
            var m = document.getElementById('<%=ActiveItem%>');
            var mc = document.getElementById('<%=ActiveItem%>_c');
            var mi = document.getElementById('<%=ActiveItem%>_i');

            try {
                //m.style.backgroundColor = "#a0ccfe";
                //mc.style.backgroundColor = "#a0ccfe";
                m.className = "x-tab-bar-default";
                mc.className += " x-tab-bar-default";
                mi.className = "x-tab-bar-default";

            } catch (e) {
            }

            var a = document.getElementById("north");
            a.style.height = "50px";
            a = document.getElementById("buttons");
            a.style.height = "50px";
            a = document.getElementById("bgleft");
            a.style.display = "none";


        }
        setActiveItem();


        adjust();

        try {
            getTzOffset();
        } catch (e) {
        }


        function SetRelativePageTitle(t, l) {
        }
        function SwitchToRootTitle() {

            
        }
    </script>
</asp:Content>
