﻿<%@ Page Title="Gladinet Cloud - Guest User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GuestUserMgrPage.aspx.cs" Inherits="GladinetPayFlow.GuestUserMgrPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .actiontbl{
        display: table;
        }
        .actioncol{
        display: table-cell;margin-top:5px;
        }
        .actioncol .gladinet-icons {
        padding-left:10px;
        }
		.actioncol .tooltip{
            margin:20px 0px 0px 5px !important;  /*tooltip positioning*/ 
		}
        
        
        .securityicon
        {
            background-image: url(/portal/images/security2.png);
        }
        
        .dark {
            color: #565656!important;
        }
        .centerText{text-align:center !important;}
        .centerText .x-grid-cell-inner{text-align:center !important;}
    </style>
    <script type="text/javascript">
        
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



        var activewin;
        function onHelp() {
            var d = document.getElementById("help_text");
            activewin = new Ext.Window({
                id: 'quota_win',
                title: "<asp:Localize meta:resourcekey="str_whatisguest" runat="server">What is a guest user</asp:Localize>",
                width: 680,
                height: 540,
                plain: true,
                modal: true,
                maximizable: false,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: d.innerHTML,
                defaults: {
                    border: false
                }
            });
            activewin.show();
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        // parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id.replace('+', ':')+"&vdid=<%=SessionDomainId %>";

             gConfirm("<asp:Localize meta:resourcekey="str_confirm" runat="server">Do you really want to delete (</asp:Localize>" + unescape(name) + ")?", "", function(btn1) {

                    if (btn1 != 'ok')
                        return;
            Wait("<asp:Localize meta:resourcekey="str_deleting" runat="server">Deleting</asp:Localize>");
            window.location = h;
                });
           

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/GuestUserMgrPage.aspx?vdid=<%=SessionDomainId %>";
        }
        
        function encodePlus(str) {
            if (str.indexOf("+") > -1) {
                str = str.replace(/\+/g,"%2B");  
            }
            return str;
        }
        function ResetPassword(t) {

            

            var uri = "/portal/ResetUserPassword.aspx?t=";

            uri += encodePlus(t);

            var Html = "<iframe id='openwin' src='" + uri;
            Html += "' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0;border:0;'></iframe>";

            activewin = new Ext.Window({
                id: 'resetpwd_win',
                title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Reset Password</asp:Localize>",
                width: 650,
                height: 570,
                plain: true,
                modal: true,
                constrain: true,
                maximizable: true,
                maximized: false,
                bodyPadding: 0,
                resizable: true,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#f0f0f0;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });



            activewin.show();
        }
        function OnAddUser() {
            parent.SetRelativePageTitle('<asp:Localize meta:resourcekey="str_adduser" runat="server">Add User</asp:Localize>','/management/AddGuestUserPage.aspx?vdid=<%=SessionDomainId %>');
            window.location = '/management/AddGuestUserPage.aspx?vdid=<%=SessionDomainId %>';
            return;
           



        }
        function OnLDAPAddUser() {
            var closeAction = new Ext.Action({
                text: "<asp:Localize meta:resourcekey="js_string4" runat="server">Close</asp:Localize>",
                width: 108
            });

            activewin = new Ext.Window({
                id: 'On_Ads_AddUser',
                title: "<asp:Localize meta:resourcekey="js_string5" runat="server">Add Active Directory User(s)</asp:Localize>",
                width: 680,
                height: 650,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='LDAPUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                },
                buttons: [closeAction],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            closeAction.setHandler(function () { activewin.close(); });

            activewin.show();



        }
        function OnBatchAddUser() {

            activewin = new Ext.Window({
                id: 'pubs_win',
                title: "<asp:Localize meta:resourcekey="js_string8" runat="server">Batch Create New User</asp:Localize>",
                width: 680,
                height: 550,
                plain: true,
                modal: true,
                maximizable: true,
                constrain: true,
                maximized: false,
                layout: 'fit',
                bodyPadding: 3,
                html: "<iframe id='openwin' src='BatchAddUserPage.aspx' scrolling='auto' style='width:100%;height:100%;margin:0;padding:0'></iframe>",
                defaults: {
                    border: false
                }
            });
            activewin.show();



        }

        function OnManageAdmin() {
            if (parent.OnManageAdmin)
                parent.OnManageAdmin();
            else
                parent.parent.OnManageAdmin();
        }
        function OnEditGroup(t, f, l, e) {

            parent.OnEditGroup(t, f, l, e);

        }

        function OnChangeName(t, f, l) {

            var uri = "EditUserPage.aspx?uid=";

            uri += t;
            uri += "&firstname=";
            uri += f;
            uri += "&lastname=";
            uri += l;



            activewin = new Ext.Window({
                id: 'resetuname_win',
                title: "<asp:Localize meta:resourcekey="js_string9" runat="server">Change User Name</asp:Localize>",
                width: 550,
                height: 250,
                layout: 'fit',
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }
        function OnChangeEmail(t) {

            var uri = "ChangeEmailPage.aspx?uid=";

            uri += t;



            activewin = new Ext.Window({
                id: 'resetacct_win',
                title: "<asp:Localize meta:resourcekey="js_string10" runat="server">Change Email</asp:Localize>",
                width: 550,
                height: 310,
                plain: true,
                modal: true,
                maximizable: true,
                resizable: true,
                layout: 'fit',
                bodyPadding: 5,
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                items: [{
                    xtype: "component",
                    autoEl: {
                        tag: "iframe",
                        src: uri
                    }
                }],
                listeners: {
                    "close": function () {
                        window.location = window.location;
                    }
                }
            });
            activewin.show();
        }

        function OnClickUser() {
            window.location = "/portal/UserMgrPage.aspx";
        }
        function OnClickGroup() {
            window.location = "/portal/GroupMgrPage.aspx";
        }
        <asp:Localize ID="LocPlsWat" meta:resourcekey="js_plsWat" runat="server" Visible="False">Please wait</asp:Localize>
        function OnSuspend(did) {
            var domainid = document.getElementById('ctl00_MainContent_HiddenUserId');
            var btn = document.getElementById('ctl00_MainContent_SuspendUser');
            domainid.value = did;
                    Wait("<%=LocPlsWat.Text %>");
            btn.click();
        }
        function OnResume(did) {
            var domainid = document.getElementById('ctl00_MainContent_HiddenUserId');
            var btn = document.getElementById('ctl00_MainContent_ResumeUser');
            domainid.value = did;
            Wait("<%=LocPlsWat.Text %>");
            btn.click();
        }

        function OnConvert(did) {
            var domainid = document.getElementById('ctl00_MainContent_HiddenUserId');
            var btn = document.getElementById('ctl00_MainContent_Convert');
            domainid.value = did;
            Wait("<%=LocPlsWat.Text %>");
            btn.click();
        }
        
        function onViewShares(uid){
            
            window.location = "UserShareMgrPage.aspx?uid="+uid;
        }
        function ReturnLast() {
            parent.ReturnLast();
        }
        function onEditMemo(rowIndex,uid){
            $("#memoHeader").html($("#name_"+rowIndex).html());
            $("#<%=txtMemo.ClientID%>").val($("#memo_"+rowIndex).html());
            $("#<%=hidUid.ClientID%>").val(uid)
            $('#MemoModal').on('shown.bs.modal', function () {
                //focus on the textbox
                $('#<%=txtMemo.ClientID%>').focus();
            })
            $('#MemoModal').modal({ backdrop: 'static', keyboard: false });
        }
        function memoSave(){
            $('#<%=btnSaveMemo.ClientID%>').click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNoEnoUseLic" meta:resourcekey="str_noEnoUseLic" Visible="false">No enough user license</asp:Localize>
<asp:Localize ID="LocUnl" meta:resourcekey="str_unl" Visible="false" runat="server">Unlimited</asp:Localize>    
      <div style="padding:5px; min-height:48px; " <% if (!IsChildUi){ %>class="meubardrop"<% } %>>
          <table width="100%">
              <tr>
                  <td>
                      <table>
                          <tr>
                              <td style="padding:5px;">
                      <a href="javascript:;" onclick="OnAddUser();return false;" style="font-size: 12px;" >
                                 <button type="button" class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right:-2px;" title="<%=str_adduser.Text %>">   <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 11px; margin-top: 14px; cursor: pointer; display: inline-block; position: absolute;" ></span>

                                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >6</i>
                                   
                                 </button>
                                </a>

                              </td>
                              <td style="padding:5px;">
                                   <asp:LinkButton ID="ExportBtn" runat="server" OnClick="ExportBtn_Click">
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; " title="<asp:Localize runat="server" meta:resourcekey="str_exp">Export</asp:Localize>">&#0178;</i>
                    </asp:LinkButton>
                              </td>

                              <td style="padding:5px; padding-left:14px;">
                                   
                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; " data-toggle="modal" data-target="#searchModal" title="Search">&#xA7;</i>
                    <div class="modal fade" id="searchModal" tabindex="-1" role="dialog" aria-labelledby="searchModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="searchModalLabel"><%=Button1.Text %></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
          <table width="100%" border="0">
              <tr>

        <td>
                            <asp:TextBox ID="Contains" runat="server"  CssClass="form-control dark"
                                meta:resourcekey="ContainsResource1"></asp:TextBox>
                                </td>
                                </tr>
          </table>

      </div>
      <div class="modal-footer">
         <asp:LinkButton ID="AllUsers" runat="server" CssClass="btn btn-primary gladbtn " 
                                OnClick="AllUsers_Click" meta:resourcekey="AllUsersResource1">All Guest Users</asp:LinkButton>
        <asp:Button ID="Button1" OnClick="FileterUsers_Click" runat="server" Text="Search" CssClass="btn btn-primary gladbtn " 
                                 meta:resourcekey="Button1Resource2" />
          <button type="button" class="btn btn-secondary gladbtn" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>
                              </td>
                          </tr>
                      </table>
                  </td>
                  <td>
                      <table>
                          <tr>
                              <td style="padding:5px;">
                                  <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1" CssClass="badge hollowbadge"></asp:Label>
                              </td>
                              <td style="padding:5px;">
                                  <span class="badge hollowbadge" style="padding: 3px!important; ">
               <asp:Localize meta:resourcekey="str_avguest" ID="AvaText" runat="server" >Available Guest User Quota:</asp:Localize>
              <asp:Label ID="AvaliableQuota" runat="server" Text="0" ></asp:Label>
                   </span>
                              </td>
                              
                          </tr>
                      </table>
                  </td>
                  <td>
                      <table>
                          <tr>
            <td style="padding-bottom:10px;" >
                <p id="DelSelDiv" style="display: none;margin-bottom:0;">
                    <asp:LinkButton ID="lnkDelSelUsers" runat="server" CssClass="btn btn-primary gladbtn navbar-btn" OnClientClick="DelSelUsers();return false;">
                        <asp:Localize meta:resourcekey="str_delusers" runat="server">Delete Selected User(s)</asp:Localize>
                    </asp:LinkButton>              
                </p>
            </td>
            <td colspan="5" align="right" style="padding-bottom:10px;" >
                <table>
                    <tr>
                        <td></td>
                        <td style="display:none;">
                 <%if (m_CanAdd)
                                                  { %>
    
                    <asp:Localize ID="asp_string11" Visible="False" meta:resourcekey="asp_string11" runat="server">Create a New Guest User</asp:Localize>
                    <a href="javascript:;" onclick="OnAddUser();return false;" style="font-size: 12px;" title="<%=asp_string11.Text %>">
                         <button type="button" class="btn btn-primary gladbtn navbar-btn " style="margin-right:8px;">   <span class="glyphicon glyphicon-plus" aria-hidden="true"></span>
                             <asp:Localize meta:resourcekey="str_adduser" ID="str_adduser" runat="server">Add Guest User</asp:Localize>
                                 </button>
                      </a>
    
                    <%} %>
                            </td>
                        </tr>
                    </table>
            </td>
        </tr>
                      </table>
                  </td>
                   <td valign="top" style="text-align: left;" align="left">
                                                    <table width="99%" align="center" border="0" cellspacing="0" cellpadding="0">
                                                        <tr>
                                                            <td>
                                                                <div id="errmsgdiv">
                                                                    <b>
                                                                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>
                                                </td>
                  <td align="right">
                      
                           <div class="navbar-right sectextcolor" style="width:40px; font-size:32px;  font-weight:100; cursor:pointer;" onclick="ReturnLast();">&times;</div>
                    

         
                  </td>
              </tr>
          </table>
          
         
      </div>
    
    <table  style=" padding: 0px; background-color: white; margin-top: 20px;" cellspacing="0" cellpadding="0" id="grid-table" align="center">
                    <tr style="background-color: #f0f0f0; display: none;">
                        <td  valign="middle" style="padding: 2px; border-top: 0px solid #c0c0c0;border-bottom: 3px solid #e0e0e0;
                            border-left: 0px solid #c0c0c0;">
                            
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest users in quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                        </td>
                        <td height="60px" colspan="3" valign="middle" style="padding: 2px; border-top: 0px solid #c0c0c0;border-bottom: 3px solid #e0e0e0
                           " align="right"></td>
                        <td style="width: 100px;  border-right: 0px solid #c0c0c0;border-top: 0px solid #c0c0c0; padding-top:10px;border-bottom: 3px solid #e0e0e0">
                            <table>
                                <tr>
                                    <td colspan="6" style="padding: 0px; vertical-align: top; height: 32px;" id="input_panel"
                                        valign="middle">
                                        <table cellspacing="0" cellpadding="0" width="100%" align="left" style="height: 43px;">
                                            <tr>
                                                <asp:Panel ID="Panel1" runat="server" Visible="false">
                                                    <td class="tabhead" style="background-color: white; padding: 3px; background: #E0e0e0;
                                                        border: 1px solid #f0f0f0; width: 200px; border-right: 1px solid white; border-bottom: 0px solid GRAY;"
                                                        onclick="OnClickUser();" align="center">
                                                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string12" runat="server"> User Manager</asp:Localize>
                                                    </td>
                                                    <%if (m_ShowGuestUserManager)
                                                      { %>
                                                    <td style="background-color: white; cursor: hand; padding: 3px; border: 1px solid #d0d0d0;
                                                        border-right: 2px solid #a0a0a0; width: 200px; border-bottom: 0px solid #C0C0C0;"
                                                        align="center" class="tabhead tabheadfront">
                                                        <b style='font-size: 14px;'>
                                                            <asp:Localize ID="Localize2" meta:resourcekey="asp_string13" runat="server">Guest User Manager</asp:Localize></b>
                                                    </td>
                                                    <%} %>
                                                    <%if (m_ShowGroupManager)
                                                      { %>
                                                    <td class="tabhead" style="background-color: white; padding: 3px; background: #E0e0e0;
                                                        border: 1px solid #f0f0f0; width: 200px; border-right: 1px solid white; border-bottom: 0px solid GRAY;"
                                                        onclick="OnClickGroup();" align="center">
                                                        <asp:Localize ID="Localize3" meta:resourcekey="asp_string14" runat="server">Group Manager</asp:Localize>
                                                    </td>
                                                    <%} %>
                                                </asp:Panel>
                                                <td>&nbsp;</td>
                                                <td width="20px" style="border-left:0px solid #c0c0c0;">&nbsp;</td>
                                               
                                                
                                                <%if (m_CanSetPerm && !m_SimpleMode && !EditingTenant)
                                                  { %>
                                                <td align="right" width="42px" style="display: none;">
                                                    <asp:LinkButton ID="LinkButton1" runat="server" Font-Size="Larger" ForeColor="Green"
                                                        OnClientClick="parent.SetAcls('/GuestUserManager');return false;" meta:resourcekey="LinkButton1Resource1">
                                                        <asp:Localize ID="asp_string1" meta:resourcekey="asp_string1" Visible="false" runat="server">Security</asp:Localize>
                                                        <img src="/portal/images/security2.png" title="<%=asp_string1.Text %>" alt="" />
                                                    </asp:LinkButton>
                                                </td>
                                                <%} %>
                                                <td align="right" width="42px">
                                                    <a href="javascript:;" onclick="onHelp();return false;">
                                                        <img src="images/help.png" width="32" alt="" /></a>
                                                </td>
                                            </tr>
                                        </table>
                                    </td>
                                </tr>
                            </table>
                        </td>
                    </tr>
        
                    <tr>
                        <td colspan="6" id="grid-example" style="padding: 5px; border-bottom: 0px solid #c0c0c0;
                            border-left: 0px solid #c0c0c0; border-right: 0px solid #c0c0c0;"></td>
                    </tr>
                </table>
    <div id="help_text" style="display: none; position: absolute;">
        <table>
            <tr>
                <td style="background-color: white; border: 1px solid #c0c0c0;" class="checkout3"
                    valign="top">
                    <table width="96%" align="center" style="height: 100%">
                        <tr>
                            <td colspan="6" height="100px">
                                <div width="90%" style="padding: 10px;">
                                    <div class='idea_flex' style="height: auto;">
                                        <asp:Localize meta:resourcekey="asp_string2" runat="server">Guest User</asp:Localize>
                                        <ul>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string3" runat="server">What is a guest user?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string4" runat="server">A guest user is a user who you can invite to collaborate on a shared folder and assign full-control permission.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string5" runat="server">What can a guest user do?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string6" runat="server">A guest user can use all the access clients such as the web browser, desktop client, and mobile application to collaborate on the shared folder.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string7" runat="server">What limitations does a guest user have?</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string8" runat="server">Guest users only get to see the shared folders that are assigned to them. Guest users don't have a home directory and have less functionality compared to  regular users. However, they can have full control of the shared folders when permissions are given.</asp:Localize></p>
                                            </li>
                                            <li><b>
                                                <asp:Localize meta:resourcekey="asp_string9" runat="server">Charge</asp:Localize></b>
                                                <p>
                                                    <asp:Localize meta:resourcekey="asp_string10" runat="server">Your account includes a quota of guest users. When the quota is exceeded, guest users will be charged a fraction of the regular user costs.</asp:Localize>
                                                    (<%= user.GladinetCloud.IsInstalledApp()? "50%":"67%" %>)
                                                </p>
                                            </li>
                                        </ul>
                                    </div>
                                </div>

                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>
            <div style="display:none;">
    <asp:HiddenField ID="HiddenUserId" runat="server" />
                
    <asp:Button ID="Convert" runat="server" Text="Buxxxtton" OnClick="Convert_Click" />
<asp:Button ID="SuspendUser" runat="server" Text="Button" 
        onclick="SuspendUser_Click" />
<asp:Button ID="ResumeUser" runat="server" Text="Button" 
        onclick="ResumeUser_Click" />
        
                

        </div>

    </div>

  <div id="MemoModal" class="modal fade" role="dialog">
      <div class="modal-dialog">
      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header" id="memoHeader" style="color:#404040;font-weight:100;"></div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
              <asp:Localize meta:resourcekey="str_mem" runat="server">Memo</asp:Localize>: <textarea class="form-control" rows="3" id="txtMemo" style="height:100px;" runat="server"></textarea>
          </div>
          <div class="modal-footer" style="font-size: 16px;">
            <div style="display:none">
            <input type="hidden" id="hidUid" runat="server" />
            <asp:button id="btnSaveMemo" runat="server" Text="" onclick="BtnSaveMemo_Click" />
            </div>
            <button type="button" id="memoSaveBtn" class="btn btn-primary" onclick="memoSave()" runat="server"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_sav" runat="server">Save</asp:Localize></span></asp:LinkButton></button>         
            <button type="button" id="memoCloseBtn" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_close" runat="server">Close</asp:Localize></span></button>
          </div>
        </div>
    </div>
  </div>
    <script type="text/javascript">
        var myData = [
            <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand" EnableViewState="False"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
         "<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "FirstName").ToString())%>&nbsp;<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "LastName").ToString())%>",
          "<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Email").ToString())%>", 
          "<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Description").ToString().Replace("\r\n","\\n").Replace("\r","\\n").Replace("\n","\\n"))%>", 
           '',
           '<%#DataBinder.Eval(Container.DataItem,"IsAdmin") %>',
           '<%#DataBinder.Eval(Container.DataItem,"UserGuid") %>',
           "<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"FirstName").ToString())%>",
           "<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LastName").ToString())%>",
           '<%#DataBinder.Eval(Container.DataItem,"Edition").ToString().Replace("'","%27") %>',
           "<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"CreateByEmail").ToString())%>"
           ,'<%#DataBinder.Eval(Container.DataItem,"IsActivated") %>'
           ,'<%#DataBinder.Eval(Container.DataItem,"EncId") %>'           ] 
        </ItemTemplate>
    </asp:Repeater>      
        ];

        function chkChanged(obj){
            <%if(m_CanDelete){ %>
            if($(".chkSel:checked").length>0) $("#DelSelDiv").show();
            else $("#DelSelDiv").hide();
            <%} %>
        }
        function DelSelUsers() {
            var csvid = document.getElementById('<%=HiddenSelectedGuestUsersId.ClientID%>');
            var btn = document.getElementById('<%=DelSelUsers.ClientID%>');

            var csvEmails = [];
            $(".chkSel:checked").each(function(){ csvEmails.push($(this)[0].dataset.email);});
            csvid.value = csvEmails.join(";");
            
            if (confirm("<asp:Localize meta:resourcekey="str_delSelUsr" runat="server">Do you really want to delete selected users</asp:Localize>")) {
                btn.click();
            }
        }

    </script>
    <div style="display: none;">
        <asp:HiddenField ID="HiddenSelectedGuestUsersId" runat="server" />
        <asp:Button ID="DelSelUsers" runat="server" Text="Button" OnClick="DelSelUsers_Click" />
    </div>
    <script type="text/javascript">

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();
            var e = document.getElementById("grid-table");
            e.style.width = document.documentElement.clientWidth-15+"px";

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'fullname' },
                    { name: 'email' }, 
                    {name: 'description'},
                    { name: 'action' },
                    { name: 'isadmin' },
                    {name: 'userguid'},
                    {name: 'firstname'},
                    {name: 'lastname'},
                    {name: 'lastvisit'},
                    {name: 'createby'},
                    {name: 'isactive'},
                    {name: 'encid'}
                ],
                data: myData
            });


            var d = document.getElementById("grid-example");
            var h = 400;
          
            try {
                h = d.offsetHeight-60;  // in IE8, this is very narrow like = 1
                h1 = document.body.offsetHeight;
                if (h1 > 300) {
                    h1 = h1 - 36; // paddings , margins, whatever
                }
                if (h<50) {
                    // this shall only happen for IE8
                    gridY = Ext.get("grid-example").getY();
                    h = h1 - gridY;
                    if (h<218) {
                        h=218;
                    }
                }
            } catch (err) {
            }


            var grid = Ext.create('Ext.grid.Panel', {
                frame: false,
                border:1,
                store: store,
                stripeRows: true,
                columnLines: false,
                minHeight : 218,
                height:h, 
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        tdCls:"centerText",
                        hideable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hdide';
                        }
                    },
                    {
                        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_sel" runat="server">Select</asp:Localize></span>",
                        width: 70,
                        sortable: false,
                        tdCls:"centerText",
                        hideable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hdide';
                        },
                        renderer: function (value, metaData, record, rowIndex) {
                              
                          if (record.data.isadmin != 'True')
                          { 
                            <% if (m_CanEdit) { %>
                              return '<input id="chk_'+record.data.userguid+'" type="checkbox" onclick="chkChanged(this);" data-email="'+record.data.email+'" class="chkSel" />';     
                            <% }else { %>
                              return '<input id="chk_'+record.data.userguid+'" type="checkbox" disabled class="chkSel" />'; 
                            <% } %>
                           }
                        }
                    },
                    {
                        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_string12" runat="server">Full Name</asp:Localize></span>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'fullname',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span id='name_"+rowIndex+"' style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }

                    },
                    {
                        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_string13" runat="server">Email</asp:Localize></span>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'email',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }

                    },
                    {
                        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_mem" runat="server">Memo</asp:Localize></span>",
                        flex: 1,
                        sortable: true,
                        dataIndex: 'description',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span id='memo_"+rowIndex+"' style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }

                    },
                    {
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="js_string14" runat="server">Last Login</asp:Localize></span>",
                        width: 175,
                        sortable: true,
                        dataIndex: 'lastvisit',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }
                    },
                    {
                        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_createby" runat="server">Created By</asp:Localize></span>",
                        width: 175,
                        sortable: true,
                        dataIndex: 'createby',
                        renderer: function (value, metaData, record, rowIndex) {
                            return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                        }
                    }, {
        text: "<span style='color:#565656; font-weight:100'><asp:Localize meta:resourcekey="str_active" runat="server">Active</asp:Localize></span>",                      
                      width: 75,
                          
                      sortable: true,
                      tdCls:"centerText",
                      dataIndex: 'isactive',
                      renderer: function (value, metaData, record, rowIndex) {
                          
                          
                          if (record.data.isadmin != 'True')
                          { 
                            <% if (m_CanEdit)
                               { %>
                            
                              if( value == 'True' ){
                                return "<input type='checkbox' checked onclick='OnSuspend(\"" +record.data.userguid +  "\")'/>";                       
                              }else{
                                return "<input type='checkbox' onclick='OnResume(\"" +record.data.userguid +  "\")'/>";                       
                              }
                              <% }
                               else
                               { %>
                              if( value == 'True' ){
                                return "<input disabled type='checkbox' checked onclick='OnSuspend(\"" +record.data.userguid +  "\")'/>";                       
                              }else{
                                return "<input disabled type='checkbox' onclick='OnResume(\"" +record.data.userguid +  "\")'/>";                       
                              }

                              <% } %>
                           }
                              
                          
                      }
        }, 
         {
          sortable: false,
          width:180,
          renderer: function (value, metaData, record, rowIndex) {
              //var rec = grid.getStore().getAt(rowIndex);
              var d = record.data;
              var ndeNme = d.nodename; 
              var delTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="js_string15" runat="server">Delete User</asp:Localize>\""; 
              var shrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_filFldShrWthThsUsr" runat="server">File(s)/folder(s) shared with this user</asp:Localize>\"";
              var edtMemTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_edtMem" runat="server">Edit Memo</asp:Localize>\"";
              var resPwTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_resetpwd" runat="server">Reset Password</asp:Localize>\""; 
              var cvtUsrTTip = "data-toggle=\"tooltip\" data-placement=\"bottom\" data-original-title=\"<asp:Localize meta:resourcekey="str_convert" runat="server">Convert to normal user</asp:Localize>\""; 
              //==================================================================
              var delBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onDelUser(&quot;"+d.email+"&quot;,&quot;"+d.email+"&quot;)\" "+delTTip+">n</i></div>";
              <%if(!m_CanDelete){ %>
              delBtn = "";
              <%} %>
              if (d.isadmin == 'True') delBtn = "";
              //==================================================================
              var shrBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onViewShares('"+d.userguid+"')\" "+shrTTip+">k</i></div>";
              //==================================================================
              var edtMemBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"onEditMemo('"+rowIndex+"','"+d.userguid+"')\" "+edtMemTTip+">/</i></div>";
              //==================================================================
              var resPwBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-24 md-dark hand\" onclick=\"ResetPassword('"+d.encid+"')\" "+resPwTTip+">r</i></div>";
              <%if(!m_CanEdit){ %>
              edtMemBtn = "";
              resPwBtn = "";
              <%} %>
              if (d.isadmin == 'True') resPwBtn = "";
              //==================================================================
              var cvtUsrBtn = "<div class=\"actioncol\"><i class=\"gladinet-icons md-34 md-dark hand\" onclick=\"OnConvert('"+d.userguid+"')\" "+cvtUsrTTip+" style=\"margin-top:3px;\">Ć</i></div>";
              <%if(!m_CanEdit){ %>
              cvtUsrBtn = "";
              <%} %>
              if (d.isadmin == 'True') cvtUsrBtn = "";
              //==================================================================
              return "<div class=\"actiontbl\">"+delBtn+shrBtn+edtMemBtn+resPwBtn+cvtUsrBtn+"</div>";
              }
            }
                ],
                renderTo: 'grid-example'
            });
            try {
            parent.ClearRelativePageTitle();
        } catch (e) {
            
        }
            //Ext.EventManager.onWindowResize(grid.doLayout, grid);
            Ext.EventManager.onWindowResize(function () {
                var e = document.getElementById("grid-table");
                e.style.width = document.documentElement.clientWidth-15+"px";
                grid.setWidth(document.documentElement.clientWidth-15  );
                grid.doComponentLayout();
            });
        });
    </script>
</asp:Content>
