﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicySec.aspx.cs" Inherits="GladinetPayFlow.GroupPolicySec"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">


        Ext.onReady(function () {
            Ext.define('GroupAccordion', {
                extend: 'Ext.panel.Panel',
                alias: 'widget.policygroup',

                requires: [
                    'Ext.layout.container.Accordion',
                    'Ext.grid.*'
                ],
                xtype: 'layout-accordion',

                border: false,

                layout: 'accordion',
                renderTo: 'allgroup',

                height: document.documentElement.clientHeight - 8,
                defaults: {
                    bodyPadding: 2
                },
                fbar: {
                    xtype: 'panel',
                    contentEl: 'buttons'
                },

                initComponent: function () {
                    Ext.apply(this, {
                        items: [
                            {
                                title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Security</asp:Localize>",
                                contentEl: 'group1',
                                autoScroll: true
                            },
                            {
                                title: "<asp:Localize meta:resourcekey="str_Sharing" runat="server">Sharing</asp:Localize>",
                                contentEl: 'group2',
                                autoScroll: true
                            }
                            ,
                            {
                                title: "<asp:Localize meta:resourcekey="str_useraccount" runat="server">User Account</asp:Localize>",
                                contentEl: 'group3',
                                autoScroll: true
                            }
                            ,
                            {
                                title: "<asp:Localize meta:resourcekey="str_folder" runat="server">Folder and Storage</asp:Localize>",
                                contentEl: 'group4',
                                autoScroll: true
                            }
                        ]
                    });
                    this.callParent();
                }
            });

            var panel = Ext.create('widget.policygroup');

            Ext.EventManager.onWindowResize(function (w, h) {
                panel.setHeight(document.documentElement.clientHeight - 8);
                panel.doComponentLayout();
            });
        });
    </script>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }

        function EditNoCacheList() {
            parent.parent.EditNoCacheListWithDomain('<%=SessionDomainId %>');

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
    <table width="100%" class="checkout3 x-panel-header-light" style="margin: 0px; padding: 0px;"
        align="center">
        <tr>
            <td>
                <div id='allgroup' style="overflow: auto; width: 100%;">
                </div>
            </td>
        </tr>
    </table>
    <asp:Panel ID="PolicyPanel" runat="server" meta:resourcekey="PolicyPanelResource1">
        <table width="99%" id='group1' style="margin: 8px;">
            <tr>
                <td colspan="2" style="padding-top: 8px; padding-left: 8px; background-color: white;
                    color: black;" id="ext">
                    <% if (string.Compare(SessionDomainId, "2CD45C43-114F-406C-998C-C6B477148FC3", true) != 0){ %>
                    <asp:CheckBox ID="ClusterImpersonation" runat="server" Text="Allow Cluster Admin to manage my tenant"
                        meta:resourcekey="ClusterImpersonation" /><br />
                    <% } %>
                    <br />
                            <p style="padding-top: 8px;">
                                <asp:CheckBox ID="ShowSecurityOption" runat="server" Text="Show 'Security' Option."
                                    meta:resourcekey="ShowSecurityOption" /><br />
                                <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string6_1" runat="server" Text="When this setting is set, you will be able to grant normal user permission to manage certain part of the tenant"></asp:Localize></p>
                                <%if (!SessionIsInstalledApp)
                                  { %>
                                <asp:CheckBox ID="AllowGoogleAppLogin" runat="server" Text="Enable authenticating user with Google Apps credential"
                                    meta:resourcekey="AllowGoogleAppLoginResource1" /><br />
                                <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                    <asp:Localize meta:resourcekey="asp_string7" runat="server" Text="When this setting is set, user can login to the system with Google Apps credential."></asp:Localize></p>
                                <%} %>
                                <%if (SessionIsInstalledApp)
                                  { %>
                                <p style="padding-top: 8px;">
                                    <asp:CheckBox ID="OnlyLocalMMC" runat="server" Text="Accessing management related pages from Intranet Only"
                                        meta:resourcekey="Only_LOCAL_MMC" /><br />
                                    <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                        <asp:Localize meta:resourcekey="Only_LOCAL_MMC_DESC" runat="server" Text="When the setting is set, the management related pages can only be accessed from a set of defined intranet addresses."></asp:Localize></p>
                                    <p style="padding-top: 8px;">
                                        <asp:CheckBox ID="WebOnly" runat="server" Text="File upload and download must go through worker node"
                                            meta:resourcekey="WebOnly" /><br />
                                        <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                            <asp:Localize ID="Localize3" meta:resourcekey="WebOnlyDESC" runat="server" Text="When this option is enabled, uploading files and downloading files will always go through worker node."></asp:Localize></p>
                                        <%} %>
                                        
                                            
                </td>
            </tr>
        </table>
        <table width="99%" id='group2' style="margin: 8px;">
            <tr>
                <td>
                <p style="padding-top: 8px;">
                        <asp:CheckBox ID="ShareMustLogin" runat="server" Text="User must login to access file/folder shared to him/her."
                            meta:resourcekey="ShareMustLoginResource1" /><br />
                        <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                            <asp:Localize ID="Localize8" meta:resourcekey="asp_string5" runat="server" Text="When this setting is set, user must login to his/her account to access received
                            share in &quot;Files shared with me&quot; folder."></asp:Localize></p>                    
                    <div style="display: none;">
                        <asp:CheckBox ID="DisableUserList" runat="server" Text="Don't show user list in create share wizard"
                            meta:resourcekey="DisableUserListResource1" /><br />
                        <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                            <asp:Localize ID="Localize9" meta:resourcekey="asp_string3" runat="server" Text="When this setting is set, the system will not populate the user list to recipient dropdown list."></asp:Localize></p>
                    </div>
                    <asp:CheckBox ID="DisableHomeDirShare" runat="server" Text="Disable team-user share home directory content externally"
                        meta:resourcekey="DisableHomeDirShareResource1" /><br />
                    <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                        <asp:Localize ID="Localize10" meta:resourcekey="asp_string4" runat="server" Text="When this setting is not set, you can enable/disable the sharing on per-user basis."></asp:Localize></p>
                    <br />
                            
                    <asp:CheckBox ID="InternalPublicLink" runat="server" Text="Enable internal public share URL"
                        meta:resourcekey="InternalPublicLinkResource1" /><br />
                    <asp:CheckBox ID="EnablePDL" runat="server" Text="Enable distribution group detection in file/folder sharing user interface"
                        meta:resourcekey="EnablePDLResource1" />
                    
                    <p style="padding-top: 8px;">
                        <asp:CheckBox ID="ShowUserInShare" runat="server" Text="Show user list in sharing dialog"
                            meta:resourcekey="ShowUserInShare" /><br />
                    </p>
                    <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                        <asp:Localize ID="Localize5_1" meta:resourcekey="ShowUserInShareDesc" runat="server"
                            Text="When this option is enabled, the user list will be shown in the recipient dropdown list."></asp:Localize></p>
                    <p style="padding-top: 8px;">
                        <asp:Localize ID="Localize6" meta:resourcekey="str_shareex" runat="server" Text="Expiration Time for Shared Folder/File (Days):"></asp:Localize>
                        <br />
                        <asp:TextBox ID="ShareExpireDays" runat="server" Text="0" meta:resourcekey="ShareExpireDaysResource1"></asp:TextBox>
                    </p>
                    <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                        <asp:Localize ID="Localize7" meta:resourcekey="str_shareexphelp" runat="server" Text=" If left as zero, users will have an option to set the expiration time for a shared item, otherwise any new shared item will expire after the number of days set above since the shared item is created."></asp:Localize>
                    </p>
                    <p style="padding-top: 8px;">
                        <asp:Label ID="Label3" runat="server" Text="Don't create guest user account if recipent is from following domains (i.e. company.com;company1.com)"
                            meta:resourcekey="Label3Resource1"></asp:Label><br />
                        <asp:TextBox ID="NoGuestDomainList" runat="server" Width="90%" meta:resourcekey="NoGuestDomainListResource1"></asp:TextBox>
                    </p>
                    <p style="padding-top: 8px;">
                        <asp:Label ID="Label1" runat="server" Text="only allow sending share to specified domain (i.e. company.com;company1.com)"
                            meta:resourcekey="Label1Resource1"></asp:Label><br />
                        <asp:TextBox ID="ShareDomainWhiteList" runat="server" Width="90%" meta:resourcekey="ShareDomainWhiteListResource1"
                            CssClass="x-form-field x-form-text"></asp:TextBox>
                        <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                            <asp:Localize ID="Localize5" meta:resourcekey="asp_string8" runat="server" Text="When this setting is NOT set, your team users can share files with any email address.
                        When this setting is set, team users can only send share to the email addresses
                        in the specified domain."></asp:Localize></p>
                </td>
            </tr>
        </table>
        <table width="99%" id='group3' style="margin: 8px;">
            <tr>
                <td>
                    <asp:CheckBox ID="AllowGuestUser" runat="server" Text="Allow creating guest user"
                        meta:resourcekey="AllowGuestUser" /><br />
                    
                    <asp:CheckBox ID="ForceTwoFactor" runat="server" Text="Enforce 2-Step Verification on users"
                        meta:resourcekey="ForceTwoFactorResource1" /><br />
                     <asp:CheckBox ID="DisableTwoFactor" runat="server" 
                        Text="Disable 2-Step Verification" meta:resourcekey="DisableTwoFactorResource1"
                         /><br />

                    <p style="padding-top: 8px;">
                        <asp:Localize ID="Localize11" meta:resourcekey="str_lockout" runat="server" Text="Account Lockout Threshold (0 - never lockout):"></asp:Localize><br />
                        <asp:TextBox ID="LockOutTimes" runat="server" Text="0" meta:resourcekey="LockOutTimesResource1"></asp:TextBox>
                    </p>
                    <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                        <asp:Localize ID="Localize12" meta:resourcekey="str_lockout" runat="server" Text="The Account lockout threshold sets the number of invalid logon attempts that are allowed before an account is locked out."></asp:Localize>
                    </p>
                    <p style="padding-top: 8px;">
                        <asp:CheckBox ID="DelayedLogin" runat="server" 
                            Text="Enforce progressively longer waiting times after invalid logon attempts" 
                            meta:resourcekey="DelayedLoginResource1"/>
                    </p>
                    <table>
                                                <tr>
                                                    <td width="32px">
                                                        <img width="32px" src="/portal/images/whitelist.png" />
                                                    </td>
                                                    <td align="left">
                                                        <asp:LinkButton ID="LinkButton3" runat="server" Font-Size="Larger" ForeColor="Green"
                                                            OnClientClick="EditNoCacheList();return false;" meta:resourcekey="LinkButton3Resource1"
                                                            Text="List of Users with Cache Disabled "></asp:LinkButton>
                                                    </td>
                                                </tr>
                                            </table>
                </td>
            </tr>
        </table>
        <table width="99%" id='group4' style="margin: 8px;">
            <tr>
                <td>
                    <p style="padding-top: 8px;">
                                            <asp:CheckBox ID="NoUserHomeDirectory" runat="server" Text="Disable user's home directory"
                                                meta:resourcekey="NoUserHomeDirectory" /><br />
                                            <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                                <asp:Localize ID="Localize4" meta:resourcekey="NoUserHomeDirectoryDesc" runat="server"
                                                    Text="When this option is enabled, user can only access team folder assigned to him."></asp:Localize></p>
                    <asp:Panel ID="Attach" runat="server" meta:resourcekey="AttachResource1">
                        <asp:CheckBox ID="AllowAttach" runat="server" Text="Allow users to attach external cloud storage"
                            meta:resourcekey="AllowAttachResource1" />
                        <table width="96%">
                            <tr>
                                <td class="idea_flex" style="vertical-align: middle; height: 40px; margin: 8px;">
                                    <p>
                                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server" Text="This setting will not take effect until your user login next time."></asp:Localize></p>
                                </td>
                            </tr>
                        </table>
                    </asp:Panel>
                    <asp:CheckBox ID="DisableVersion" runat="server" Text="Disable versioned folder"
                        meta:resourcekey="DisableVersionResource1" /><br />
                    <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                        <asp:Localize ID="Localize1_1" meta:resourcekey="asp_string2" runat="server" Text="When this setting is set, the feature of versioned folder will be hidden."></asp:Localize></p>
                    <asp:CheckBox ID="HideDeniedFolder" runat="server" Text="Don't show folder that user doesn't have read permission"
                        meta:resourcekey="HideDeniedFolderResource1" /><br />
                    
                        <p style="padding-top: 8px;">
                            <asp:CheckBox ID="RemoveTeamFolderSuffix" runat="server" Text="Do not append '(Team Folder)' to published folder."
                                meta:resourcekey="RemoveTeamFolderSuffixResource1" /><br />
                            <p style="font-size: 12px; color: #808080; margin-left: 16px;">
                                <asp:Localize ID="Localize13" meta:resourcekey="asp_string6" runat="server" Text="When this setting is NOT set, system will automatically append '(Team Folder)' for
                            team user."></asp:Localize></p>

                </td>
            </tr>
        </table>
    </asp:Panel>
    <table width="100%" id='buttons'>
        <tr>
            <td align="right" style="padding: 10px;">
                <% if (m_CanEdit)
                   { %>
                <asp:Button ID="ApplylNow" runat="server" Text="Apply" Font-Size="12px" Height="26px"
                    Width="128px" OnClientClick="Wait('Applying Settings');this.style.display='none'"
                    OnClick="ApplylNow_Click" meta:resourcekey="ApplylNowResource1" />
                <% } %>
                &nbsp;&nbsp;&nbsp;&nbsp;
                <asp:Button ID="CancelAChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                    OnClientClick="parent.closeActiveWin();return false;" Width="128px" Visible="False"
                    meta:resourcekey="CancelAChangeResource1" />
            </td>
        </tr>
    </table>
</asp:Content>
