﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClientWeb.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClientWeb" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">


        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocFldApl" meta:resourcekey="str_fldApl" Visible="false">Failed to apply</asp:Localize>
   <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>  
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;      
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                   } %>
            </div>
            </nav>
    
     <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
     
        <tr>
            <td width="500px" style="padding: 15px;">
                <asp:Label ID="Label1" runat="server" Text="Disable folder download from web client" 
                    meta:resourcekey="DisableFolderDownloadResource1"></asp:Label>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize ID="Localize6" meta:resourcekey="asp_string7" runat="server" Text="When enabled, the functionality of downloading multiple item selections and folders from the web client as zip files will be disabled."></asp:Localize>
                        
                    </p>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="DisableFolderDownload" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <%if (SessionIsInstalledApp){ %>
        <tr>
            <td style="padding: 15px;">
                <asp:Label ID="Label2" runat="server" Text="Disable Search" 
                    meta:resourcekey="DisableSearch" ></asp:Label>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="DisableSearch"  runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <%} %>
        
        <tr style="display:none;">
            <td style="padding: 15px;">
                <asp:Label ID="Label3" runat="server" Text="Web Browser - Disable Java Uploader" meta:resourcekey="DisableJavaUploaderResource1" ></asp:Label>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox Checked="True" ID="DisableJavaUploader"  runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        
        
        <tr style="display:none;">
            <td style="padding: 15px;">
                <asp:Label ID="Label4" runat="server" Text="Web Browser - Disable Flash Uploader" meta:resourcekey="DisableFlashUploaderResource1" ></asp:Label>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox Checked="True" ID="DisableFlashUploader"  runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        

        <tr style="display:none;">
            <td style="padding: 15px;">
                <asp:Label ID="Label11" runat="server" Text="Disable Web Client" meta:resourcekey="DisableWebClientResource1" ></asp:Label>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="DisableWebClient"  runat="server" onclick="ShowSavePanel();" />

            </td>
        </tr>
         <tr style="display:none;">
                <td style="padding: 15px;">
                    <asp:Localize meta:resourcekey="DisableWebClientHint" runat="server">Disable Web Client access from following IPs </asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="DisableWebClientIPHint" runat="server">(IP/Mask;IP/Mask, i.e. 254.234.234.128/255.255.255.0; 192.234.234.128/255.255.255.0 empty: no restriction) </asp:Localize>
                    </p>
                </td>
                <td style="padding: 15px;">
                    <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="DisableWebClientIP"  runat="server"  meta:resourcekey="ShareExpireDaysResource1"  CssClass="form-control"></asp:TextBox>
                     <asp:Label ID="LDisableWebClientIP" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
                        <asp:Localize ID="NOTConfig"  meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
                </td>
            </tr>

        <tr>
            <td style="padding: 15px;">
                <asp:Label ID="Label5" runat="server" Text="Web Browser - Disable Local Uploader" meta:resourcekey="DisableLocalUploaderResource1" ></asp:Label>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox Checked="True" ID="DisableLocalUploader"  runat="server" onclick="ShowSavePanel();" />

            </td>
        </tr>
        
        <tr style="display:none;">
            <td style="padding: 15px;">
                <asp:Label ID="Label6" runat="server" Text="Enable Tabbed-Browsing in User Manager" 
                    meta:resourcekey="TabedUserMgr"></asp:Label>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="TabedUserMgr"  runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <% if (!IsServo) { %>
        <tr>
            <td style="padding: 15px;">
                <asp:Label ID="Label7" runat="server" Text="Only show search interface in User Manager" meta:resourcekey="SearchOnlyUserMgrResource1" ></asp:Label>
            </td>  
            <td style="padding: 15px;">
                 <asp:CheckBox ID="SearchOnlyUserMgr"  runat="server" onclick="ShowSavePanel();" />
            </td>  
        </tr>
        <%} %>     
        <tr>
            <td style="padding: 15px;">
                <asp:Label ID="LblLodAllMyFilFrt" runat="server" Text="Load All My Files as the first page" meta:resourcekey="txtLodAllMyFilFrt" ></asp:Label>
            </td>  
            <td style="padding: 15px;">
                 <asp:CheckBox ID="ShowAllMyFilesFirst"  runat="server" onclick="ShowSavePanel();" />
            </td>  
        </tr>

        <tr>
            <td style="padding: 15px;">
                <asp:Label ID="Label8" runat="server" Text="Show tutorial page for non-admin users" meta:resourcekey="ShowTutorForSubUserResource1" ></asp:Label> 
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ShowTutorForSubUser" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <% if (!IsServo) { %>
        <tr style="display: none;">
            <td style="padding: 15px;">
                <asp:Label ID="Label9" runat="server" Text="Show advanced settings in team folder publishing dialog" meta:resourcekey="ShowPubAdvModeResource1"  ></asp:Label>  
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ShowPubAdvMode" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
         
         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_showteamacl" runat="server">Show team folder level permissions in team folder publishing dialog</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ShowTeamAcl" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
         <% if(m_ShowPublishStorageAsTeamFolder){ %>
                  <tr>
            <td style="padding: 15px;">
                
                <asp:Localize meta:resourcekey="str_notntf" runat="server">Disable 'Publish Tenant Home Storage As a Team Folder'</asp:Localize>
                
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="NoTenantStorageTF" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <% }} %>

         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_ddconfirm" runat="server">Confirm before moving via drag-and-drop</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="DDConfirm" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <% if (!IsServo) { %>
                  <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_showlefttree" runat="server">Show left tree-view by default (Classic File Browser Only)</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ShowLeftTreeDef" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <% } %>

         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_norecent" runat="server">Do not show Quick Access on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="NoRecent" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        
        

        <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_myFav" runat="server">Do not show My Favorites on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="chkHidMyFav" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>  
         
        <% if (!IsServo) { %>
        <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_myTemFld" runat="server">Do not show My Team Folders on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="chkHidMyTemFld" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>  
        <% } %>  
        <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_shdFilFld" runat="server">Do not show Shared Files/Folders on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="chkHidShdFilFld" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>     

        <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_dvcDwn" runat="server">Do not show device download on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="chkHidDvcDwn" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr> 

        <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_stgSts" runat="server">Do not show Storage Statistics on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="chkHidStgSts" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>   







         <% if (!IsServo) { %>
         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_showlinktolocal" runat="server">Show "link to local" option to non-admin user</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ShowLinkToLocal" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>
        <% } %>
         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_hideDeviceBackups" runat="server">Do not show Device Backups on File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="HideDeviceBackups" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>

         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_hideComments" runat="server">Do not show Comments on the File Browser right-panel</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="HideComments" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>

        <tr>
            <td style="padding: 15px;">
                <asp:Localize runat="server" meta:resourcekey="str_dntShwFilIcn">Do not show file icon preview if file size is larger than (KB, 0-No icon preview)</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:TextBox onkeypress="ShowSavePanel();" onchange="ShowSavePanel();" ID="PreviewThreshold" runat="server" CssClass="form-control"
                    Text="5000" meta:resourcekey="WebSessionTimeOutResource1"></asp:TextBox>
                <asp:Label ID="LPreviewThreshold" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
            </td>
        </tr>
         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_tmeZneOst" runat="server">Time Zone Offset</asp:Localize>
                <asp:Localize id="locIvdTmeZne" meta:resourcekey="str_ivdTmeZne" runat="server" Visible="false">Invalid >Time Zone Offset</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <table><tr>
                    <td><asp:DropDownList onchange="ShowSavePanel();" ID="ddl_timezoneSign" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                        <asp:ListItem meta:resourcekey="str_sel">Select</asp:ListItem>
                        <asp:ListItem>+</asp:ListItem>
                        <asp:ListItem>-</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                    <td><asp:DropDownList onchange="ShowSavePanel();" ID="ddl_timezoneHour" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                        <asp:ListItem meta:resourcekey="str_sel">Select</asp:ListItem>
                        <asp:ListItem>00</asp:ListItem>
                        <asp:ListItem>01</asp:ListItem>
                        <asp:ListItem>02</asp:ListItem>
                        <asp:ListItem>03</asp:ListItem>
                        <asp:ListItem>04</asp:ListItem>
                        <asp:ListItem>05</asp:ListItem>
                        <asp:ListItem>06</asp:ListItem>
                        <asp:ListItem>07</asp:ListItem>
                        <asp:ListItem>08</asp:ListItem>
                        <asp:ListItem>09</asp:ListItem>
                        <asp:ListItem>10</asp:ListItem>
                        <asp:ListItem>11</asp:ListItem>
                        <asp:ListItem>12</asp:ListItem>
                        <asp:ListItem>13</asp:ListItem>
                    </asp:DropDownList></td>
                    <td>:</td>
                    <td><asp:DropDownList onchange="ShowSavePanel();" ID="ddl_timezoneMins" runat="server" CssClass="browser-default custom-select secsubbordercolor">
                        <asp:ListItem meta:resourcekey="str_sel">Select</asp:ListItem>
                        <asp:ListItem>00</asp:ListItem>
                        <asp:ListItem>30</asp:ListItem>
                        <asp:ListItem>45</asp:ListItem>
                    </asp:DropDownList></td>
               </tr></table>
            </td>
        </tr>

         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_maxcount" runat="server">Show max count of file/folder items</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="WebMaxCount" Text="1000" runat="server" 
                     CssClass="form-control"></asp:TextBox>
                    <asp:Label ID="LWebMaxCount" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
            </td>
        </tr>



         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_dftUsrMgrLstViw" runat="server">Show User Manager in List-View by default</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ChkUsrMgrDftLstViw" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>

         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_dftLstViw" runat="server">Show File Browser in List-View by default</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ChkDftLstViw" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>


         <tr>
            <td style="padding: 15px;">
                <asp:Localize meta:resourcekey="str_hidOptToCrtDcs" runat="server">Hide options to create documents on the File Browser</asp:Localize>
            </td>
            <td style="padding: 15px;">
                <asp:CheckBox ID="ChkHidOptToCrtDcs" runat="server" onclick="ShowSavePanel();" />
            </td>
        </tr>

         <tr><td colspan="2"></td></tr>
        <tr>
            <td>
                
                <asp:CheckBox onclick="ShowSavePanel();" ID="NoTopWebPanel" runat="server" Visible="False"
                    Text="Don't show top help panel in the web portal" 
                    meta:resourcekey="NoTopWebPanel" />
                

            </td>
        </tr>
    </table>
    </div>
        
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
