﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClientLock.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClientLock" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }  
        .subSetting {
          opacity: 1;
        }
        .subSetting.faded {
          opacity: 0.25;
        }
    </style>
    <script type="text/javascript">
        function ToggleSetting(jRef, disabledBool) {
            console.log(jRef,disabledBool)
            if (disabledBool === false) {
                jRef.removeAttr('disabled');
            } else {
                jRef.attr('disabled', 'disabled');
            }
        }
        function ToggleAllSettings(chkBxRef) {
            console.log(chkBxRef)
            if (chkBxRef.checked) {
                $(".subSetting").removeClass("faded");
            } else {
                $(".subSetting").addClass("faded");
            }
            $(".subSetting input,.subSetting select").each(function (indx) {
                ToggleSetting($(this), !chkBxRef.checked);
            });
        }
        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocMts" meta:resourcekey="str_mts" Visible="false">Minutes</asp:Localize>
<asp:Localize runat="server" ID="LocHur" meta:resourcekey="str_hur" Visible="false">Hour</asp:Localize>
<asp:Localize runat="server" ID="LocHrs" meta:resourcekey="str_hrs" Visible="false">Hours</asp:Localize>
<asp:Localize runat="server" ID="LocFldApl" meta:resourcekey="str_fldApl" Visible="false">Failed to apply</asp:Localize>
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <p class="navbar-text">
            <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server" 
                                     Text="The following setting will apply to all clients (Desktop Client/File Server Client)."></asp:Localize>
        </p>
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" meta:resourcekey="asp_edt"></asp:Button>     
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" meta:resourcekey="asp_cnl"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;         
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>

    
   <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped">
         <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Label ID="Label1" runat="server" Text="Enable distributed locking when accessing files" 
                    meta:resourcekey="EnableDistributedLockingResource1"></asp:Label>
                    <p class="text-muted" style="font-size: smaller">
                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string2" runat="server" Text="When enabled, the file will be locked when accessed. This will prevent multiple users
                        from editing the same file at the same time. This may not take effect if the application used to access the file does not support locking."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox ID="EnableDistributedLocking" runat="server" onclick="ShowSavePanel();ToggleAllSettings(this);" />
             </td>
         </tr>
         
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Label ID="Label2" runat="server" Text="Lock file exclusively" 
                    meta:resourcekey="ForceLockResource1"></asp:Label>
                    <p class="text-muted" style="font-size: smaller">
                    
                    <asp:Localize ID="Localize3" meta:resourcekey="asp_string3" runat="server" Text="When enabled, the locked file will be locked exclusively. When disabled, the other user who is trying to open the locked file will be notified about the lock status, but will still be able to open the file."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="ForceLock" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_autoreadonly" runat="server">Automatically open file in read-only mode when file is locked and "Lock file exclusively" is not checked.</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox Checked="True"
                    ID="AutoReadOnly" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Label ID="Label3" runat="server" Text="Delay sync until file is unlocked" 
                    meta:resourcekey="DelaySyncResource1"></asp:Label> 
                    <p class="text-muted" style="font-size: smaller">
                
                    <asp:Localize ID="Localize4" meta:resourcekey="asp_string4" runat="server" 
                        Text="When enabled, the sync of modified file will be delayed until the file is unlocked (when the editing process exits)."></asp:Localize></p>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="DelaySync" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_delayunlock" runat="server">Unlock file after it is uploaded</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="DelayUnlock" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_lockback" runat="server">Lock file natively on network shares</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="LockBackend" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_locksa" runat="server">Lock file natively for files inside an attached folder from server agent. </asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="LockSA" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
                  <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_lockofficeweb" runat="server">Lock file when file is opened from Office Web Apps. </asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="LockOfficeWeb" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>
                  <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_nolocklost" runat="server">Do not show 'Lock Lost' message. </asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:CheckBox
                    ID="NoLockLost" runat="server" onclick="ShowSavePanel();" />
             </td>
         </tr>

         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_delaysync" runat="server">Enable scheduled sync for files with the following extensions (i.e.: [.mdb][.qbw]) when the file is locked: </asp:Localize>
                    <p class="text-muted" style="font-size: smaller">
                        <asp:Localize meta:resourcekey="str_dhint" runat="server">When files are locked, the client will consolidate multiple changes into one upload event and use Volume Shadow Copy to avoid interfering with applications that are using the files. This option is best suited for database files that are both large and are changed frequently.</asp:Localize>
                   </p>
             </td>
             <td style="padding: 15px;">
                  <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="LockFreqUpdateFile" runat="server" Width="90%" meta:resourcekey="FreqUpdateFileResource1" CssClass="form-control"
                        ></asp:TextBox>
                        <asp:Label ID="LLockFreqUpdateFile" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         <tr style="display: none;">
             <td colspan="2"></td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px; padding-left: 30px;">
                 <asp:Localize meta:resourcekey="str_often" runat="server">How often to sync the files with above extensions </asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:DropDownList ID="FreqUpdateSyncIntervalMin" runat="server" Width="180px" onchange="ShowSavePanel();"
                     CssClass="browser-default custom-select secsubbordercolor" meta:resourcekey="FreqUpdateSyncIntervalMinResource1">
                 </asp:DropDownList>
             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize5" meta:resourcekey="asp_string5" runat="server" Text="Apply lock to the following processes that support native locking (lower case, semi-colon separated)"></asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  Width="100%" ID="LockProcess" CssClass="form-control"
                    runat="server" Text="winword.exe;excel.exe;powerpnt.exe;" 
                    meta:resourcekey="LockProcessResource1"></asp:TextBox>
                                        <asp:Label ID="LLockProcess" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>

             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize ID="strAlwaysLock" meta:resourcekey="strAlwaysLock" runat="server" Text="Apply lock to the following processes that don't support native locking (lower case, semi-colon separated. I.e.: notepad.exe)"></asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  Width="100%" ID="AlwaysLockProcess" CssClass="form-control"
                    runat="server" Text="" 
                    ></asp:TextBox>
                                        <asp:Label ID="LAlwaysLockProcess" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>

             </td>
         </tr>
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize ID="Localize6" meta:resourcekey="str_lockmacprocess" runat="server" Text="Apply
                    lock only to the following Mac process (lower case):"></asp:Localize>
             </td>
             
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  CssClass="form-control"
                    Width="100%" ID="MacLockProcess"
                    runat="server" 
                    Text="microsoft word;microsoft excel;microsoft powerpoint;textedit" meta:resourcekey="MacLockProcessResource1" 
                    ></asp:TextBox>
                    <asp:Label ID="LMacLockProcess" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
         
          
         <tr class="subSetting">
             <td style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_lockdisable" runat="server">Locking is disabled for files with the following extensions (i.e.: [.xml][.exe]):</asp:Localize>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"  ID="LockExcludeList" runat="server"  CssClass="form-control"
                        Text="" 
                        ></asp:TextBox>
                        <asp:Label ID="LLockExcludeList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
         </tr>
        
    </table>
   </div>
       
                <asp:CheckBox onclick="ShowSavePanel();" ID="NoSharesFolder" runat="server" Visible="False"
                    Text="Hide 'Files shared with me' folder" 
                    meta:resourcekey="NoSharesFolderResource1" /><br />
                <p style="line-height: 16px; font-size: 12px; color: #808080; margin-left: 16px;display: none;">
                    <asp:Localize ID="Localize7" meta:resourcekey="asp_string8" runat="server" 
                        Text="When enabled, the folder 'Files shared with me' will be hidden"></asp:Localize></p>
                        
    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfiged" runat="server" Visible="False">Not Configured</asp:Localize>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>

    <script type="text/javascript">  
        Ext.onReady(function () {
            ToggleAllSettings(document.getElementById("<%=EnableDistributedLocking.ClientID%>"));
        });
    </script>
</asp:Content>
