﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyClientAttachedFolder.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyClientAttachedFolder" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    

    <style type="text/css">
        td {
            font-size: 15px;            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
        .badgefont {
            font-size: 15px;
            
        }

    </style>
    <script type="text/javascript">

      

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocMts" meta:resourcekey="str_mts" Visible="false">Minutes</asp:Localize>
<asp:Localize runat="server" ID="LocHur" meta:resourcekey="str_hur" Visible="false">Hour</asp:Localize>
<asp:Localize runat="server" ID="LocHrs" meta:resourcekey="str_hrs" Visible="false">Hours</asp:Localize>
<asp:Localize runat="server" ID="LocFldAplStg" meta:resourcekey="str_fldAplStg" Visible="false">Failed to apply settings</asp:Localize>
   <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" 
                     meta:resourcekey="EditBtnResource1" ></asp:Button>      
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108px" 
                     meta:resourcekey="CancelBtnResource1"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="ApplylNowResource1" 
                            Text="Apply" Width="108px"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;          
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>
   
        <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
     <table width="100%" class="table-striped" style="margin-bottom: 100px;">
     
            <tr>
                <td width="500px" style="padding: 15px;">
                    <asp:Label ID="Label1" runat="server" Text="Disable backup/attach local folder from client device" 
                    meta:resourcekey="DisableAttachResource1" ></asp:Label>
                     <p class="text-muted" style="font-size: smaller;">
                    <asp:Localize ID="Localize9" meta:resourcekey="asp_string6" runat="server" Text="When enabled, the functionality of backing up or attaching a local folder from a client device will be disabled."></asp:Localize></p>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox onclick="ShowSavePanel();" ID="DisableAttach" runat="server" meta:resourcekey="DisableAttachResource2" 
                    />
                </td>
            </tr>
            
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label2" runat="server" Text="Enable snapshot backup for server agent" meta:resourcekey="EnableSnapShotResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox onclick="ShowSavePanel();" ID="EnableSnapShot" runat="server" meta:resourcekey="EnableSnapShotResource2" 
                    
                     />
                </td>
            </tr>
            
            
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label4" runat="server" Text="Allow syncing of empty files" meta:resourcekey="AllowEmptyFileResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox onclick="ShowSavePanel();" ID="AllowEmptyFile" runat="server" meta:resourcekey="AllowEmptyFileResource2" 
                    
                     />
                </td>
            </tr>

          <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label5" runat="server" Text="Allow syncing of hidden files" meta:resourcekey="AllowHiddenFileResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox onclick="ShowSavePanel();" ID="AllowHiddenFile" runat="server" meta:resourcekey="AllowEmptyFileResource2" 
                    
                     />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label6" runat="server" Text="Allow executable files (.exe)" meta:resourcekey="AllowExeFileResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="AllowBackupExes" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label7" runat="server" Text="Allow ISO files (.iso)" meta:resourcekey="AllowIsoFileResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="AllowBackupIso" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
            <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label8" runat="server" Text="Allow backup files(.bck, .bkf,.rbf, .tib)" meta:resourcekey="AllowBackupFileResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="AllowBackupBackup" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label9" runat="server" Text="Allow VMs (.hdd, .hds, .pvm, .pvs, .vdi, .vfd, .vhd, .vmc, .vmdk, .vmem, .vmsd, .vmsn, .vmss, .vmtm, .vmwarevm, .vmx, .vmxf, .vsv, .nvram, .vud, .xva)" meta:resourcekey="AllowVMResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="AllowBackupVM" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label10" runat="server" Text="Allow application folders" meta:resourcekey="AllowAppFolderResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="AllowBackupAppFolder" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label ID="Label11" runat="server" Text="Allow application data folders" meta:resourcekey="AllowAppDataFolderResource1" ></asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="AllowBackupAppData" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>
             <tr>
             <td width="500px" style="padding: 15px;">
                 
                 <asp:Localize meta:resourcekey="str_sdelay" runat="server">Enable scheduled sync for files with the following extensions (i.e.[.mdb][.qbw]):</asp:Localize>
                       <p class="text-muted" style="font-size: smaller;">
                           <asp:Localize meta:resourcekey="str_sdelyhint" runat="server">When the scheduled sync is on, the client will consolidate multiple changes into one upload event and use Volume Shadow Copy to avoid interfering with applications that are using the files. This option is best suited for database files that are both large and are changed frequently.</asp:Localize>
                       </p>
                        
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="FreqUpdateFile" runat="server" Width="90%" meta:resourcekey="FreqUpdateFileResource1"  CssClass="form-control"
                        ></asp:TextBox>
                        <asp:Label ID="LFreqUpdateFile" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
             
         </tr>
                      <tr>
             <td width="500px" style="padding: 15px; padding-left: 60px;">
                 
                 <asp:Localize meta:resourcekey="str_syncdelay" runat="server">How often to sync the files with above extensions</asp:Localize>
                        
             </td>
             <td style="padding: 15px;">
                 <asp:DropDownList ID="FreqUpdateSyncIntervalMin" runat="server" Width="180px" onchange="ShowSavePanel();"
                     CssClass="browser-default custom-select secsubbordercolor" meta:resourcekey="FreqUpdateSyncIntervalMinResource1">
                 </asp:DropDownList>
             </td>
             
         </tr>
         <tr >
                <td style="padding: 15px; ">
                    <asp:Label ID="Label3" runat="server" Text="Allow attaching folders in proxy mode" meta:resourcekey="AllowProxyModeResource1"></asp:Label>
                </td>
                <td style="padding: 15px;">
                    <asp:CheckBox onclick="ShowSavePanel();" ID="AllowProxyMode" runat="server" meta:resourcekey="AllowProxyModeResource2"                      
                     />
                </td>
            </tr>
         <tr>
                <td style="padding: 15px;">
                    <asp:Label runat="server" meta:resourcekey="str_alwTryForUseImp" >Always try to force user impersonation when accessing storage</asp:Label>
                </td>
                <td style="padding: 15px;">
                     <asp:CheckBox ID="ForceImpersonation" runat="server" onclick="ShowSavePanel();" />
                </td>
            </tr>   
        </table>
                
            <asp:Localize meta:resourcekey="str_notfiged1" ID="NOTConfig" Visible="False" runat="server">Not Configured</asp:Localize>
   </div>
        
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
