﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyAccess.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyAccess" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script type="text/javascript">


        Ext.onReady(function () {
            Ext.define('GroupAccordion', {
                extend: 'Ext.panel.Panel',
                alias: 'widget.policygroup',

                requires: [
                    'Ext.layout.container.Accordion',
                    'Ext.grid.*'
                ],
                xtype: 'layout-accordion',
                


                layout: 'accordion',
                renderTo: 'allgroup',

                height: document.documentElement.clientHeight - 8,
                defaults: {
                    bodyPadding: 2
                },
                fbar: {
                    xtype:'panel',
                    contentEl: 'buttons'
                },

                initComponent: function () {
                    Ext.apply(this, {
                        items: [{
                            title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Access Policy</asp:Localize>",
                            contentEl: 'group6',
                            autoScroll: true
                        }]
                    });
                    this.callParent();
                }
            });

            var panel = Ext.create('widget.policygroup');

            Ext.EventManager.onWindowResize(function (w, h) {
                panel.setHeight(document.documentElement.clientHeight - 8);
                panel.doComponentLayout();
            });
        });
    </script>
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }

        function EditNoDownloadList() {
            parent.parent.EditNoDownloadListWithDomain("<%=SessionDomainId %>");
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" 
        meta:resourcekey="ErrorMsgResource1"></asp:Label>
    <table width="100%" class="checkout3" style="background-color: white; margin: 0px;
        padding: 0px;" align="center">
        <tr>
            <td>
                <div id='allgroup' style="overflow: auto; width: 100%;">
                </div>
            </td>
        </tr>
    </table>
    <asp:Panel ID="PolicyPanel" runat="server" 
        meta:resourcekey="PolicyPanelResource1">
    
    <table id='group6' width="100%" class="checkout3">
    <tr>
                        <td width="32px">
                            <img width="32px" src="/portal/images/whitelist.png" />
                        </td>
                        <td align="left">
                            <asp:LinkButton ID="LinkButton1" runat="server" Font-Size="Larger" ForeColor="Green"
                                OnClientClick="EditNoDownloadList();return false;" 
                                meta:resourcekey="LinkButton1Resource1" 
                                Text="List of Users with Client Download Disabled "></asp:LinkButton>
                        </td>
                    </tr>            
        </table>
        </asp:Panel>
        <table width="100%" id='buttons' style="display:none;">
        <tr>
                <td align="right" style="padding: 10px;">
                    <% if (m_CanEdit)
                       { %>
                    <asp:Button ID="ApplylNow" runat="server" Text="Apply" Font-Size="12px" Height="26px"
                        Width="128px" OnClientClick="Wait('Applying Settings');this.style.display='none'"
                        OnClick="ApplylNow_Click" meta:resourcekey="ApplylNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                        <% } %>
                    <asp:Button ID="CancelAChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                        OnClientClick="parent.closeActiveWin();return false;" Width="128px" 
                        Visible="False" meta:resourcekey="CancelAChangeResource1" />
                </td>
            </tr>
        </table>

</asp:Content>
