﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="GroupPolicyAV.aspx.cs" Inherits="GladinetPayFlow.GroupPolicyAV"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        .policygroup
        {
            -moz-border-radius: 5px 5px;
            -webkit-border-radius: 5px 5px;
            -o-border-radius: 5px 5px;
            -ms-border-radius: 5px 5px;
            -khtml-border-radius: 5px 5px;
            border-radius: 5px 5px;
            border: 1px solid #d0d0d0;
            padding-left: 2px;
            background-color: #f0f0f0;
            color: #008000;
            box-shadow: 0pt 0pt 4px 0pt rgb(136, 136, 136);
            padding-bottom: 5px;
        }
        
         .badgefont {
            font-size: 15px;
            
        }
    </style>
    <script type="text/javascript">

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocTrsMstBeNum" meta:resourcekey="str_trsMstBeNum" Visible="false">Threshold must be a number</asp:Localize>
<asp:Localize runat="server" ID="LocFldAplChg" meta:resourcekey="str_fldAplChg" Visible="false">Failed to apply changes</asp:Localize>
    <nav class="navbar navbar-default navbar-fixed-top" role="navigation" style="display: none;">
        <div class="navbar-left">
            <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
        </div>
            <div class="container-fluid" style="padding-right: 30px;">
                 <% if (m_CanEdit){ %>
                    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="False">Please Wait</asp:Localize> 
                    <asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg" Visible="False">Applying Changes</asp:Localize> 
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" meta:resourcekey="asp_edt"></asp:Button>
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" 
                            CssClass="btn  navbar-btn navbar-right btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" meta:resourcekey="asp_cnl"></asp:Button>    
                            &nbsp;&nbsp;&nbsp;&nbsp; 
                        <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="ApplylNow_Click" 
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" meta:resourcekey="asp_apy" 
                            Text="Apply" Width="108"></asp:Button>       
                            &nbsp;&nbsp;&nbsp;&nbsp;        
                    <%
                        EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                        CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                        ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    } %>
            </div>
            </nav>
    
            <div class="wrapper" style="background-color: white; width:100%;margin-top: 10px;font-size: 16px;">
    
                    <table width="100%" class="table-striped" style="margin-bottom: 100px;">
                        <tr>
                            <td width="500px" style="padding: 15px;">
                                <asp:Localize meta:resourcekey="str_allowprocess" runat="server">Only allow the following processes to update files (empty: allow all, separate using semicolon (;), i.e. winword.exe;excel.exe)</asp:Localize>
                            </td><td style="padding: 15px;">        
                                <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"
                                    ID="WhiteListProcess" Text="" runat="server" 
                                    CssClass="form-control"></asp:TextBox>
                                    <asp:Label ID="LWhiteListProcess" runat="server" meta:resourcekey="str_notconfigured" CssClass="badge"
                                        ></asp:Label>
                            </td>
                        </tr>
                         
                        <tr>
                            <td width="500px" style="padding: 15px;">
                                <asp:Localize meta:resourcekey="str_disableddev" runat="server">The following executables will not be allowed to open files directly from the cloud drive (i.e. qbw32.exe;excel.exe)</asp:Localize>
                            </td><td style="padding: 15px;">        
                                <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"
                                    ID="DisabledProcess" Text="" runat="server" 
                                    CssClass="form-control"></asp:TextBox>
                                    <asp:Label ID="LDisabledProcess" runat="server" meta:resourcekey="str_notconfigured" CssClass="badge"
                                        ></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td width="500px" style="padding: 15px;">
                                <asp:Localize meta:resourcekey="str_disable" runat="server">Disable a device if the device changes more than n files in 10 minutes</asp:Localize>
                            </td><td style="padding: 15px;">        
                                <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"
                                    ID="UpdateThreshold" Text="" runat="server" 
                                    CssClass="form-control"></asp:TextBox>
                                    <asp:Label ID="LUpdateThreshold" runat="server" meta:resourcekey="str_notconfigured" CssClass="badge"
                                        ></asp:Label>
                            </td>
                        </tr>
                        <tr>
                            <td width="500px" style="padding: 15px;">
                                <asp:Localize runat="server" meta:resourcekey="ignPrcMsg">Ignore the following processes when applying the above policy (i.e. qbw32.exe; excel.exe)</asp:Localize>
                                    
                            </td><td style="padding: 15px;">        
                                <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();"
                                    ID="SkipProcess" Text="" runat="server" 
                                    CssClass="form-control"></asp:TextBox>
                                    <asp:Label ID="LSkipProcess" runat="server" meta:resourcekey="str_notconfigured" CssClass="badge"
                                        ></asp:Label>
                            </td>
                        </tr>
                                <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_stopputstr" runat="server">Disable uploading of files whose names contain the following text patterns</asp:Localize>
                 <asp:Localize runat="server" ID="LocIe" meta:resourcekey="str_ie" Visible="false">i.e.</asp:Localize>
                 <p class="text-muted"><%=LocIe.Text %> badfile1;badfile2</p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DisablePutList" runat="server" Width="90%" Text="" CssClass="form-control"></asp:TextBox>
                        <asp:Label ID="LDisablePutList" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
             
         </tr>
                        <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_prelist" runat="server">Disable uploading of files whose names start with the following strings</asp:Localize>
                 <p class="text-muted"><%=LocIe.Text %> bad1;bad2</p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DisablePutListPre" runat="server" Width="90%" Text=""  CssClass="form-control"
                        ></asp:TextBox>
                        <asp:Label ID="LDisablePutListPre" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
             
         </tr>
                        <tr>
             <td width="500px" style="padding: 15px;">
                 <asp:Localize meta:resourcekey="str_endlist" runat="server">Disable uploading of files whose names end with the following strings</asp:Localize>
                 <p class="text-muted"><%=LocIe.Text %> bad1;bad2</p>
             </td>
             <td style="padding: 15px;">
                 <asp:TextBox onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" ID="DisablePutListEnd" runat="server" Width="90%" Text=""  CssClass="form-control"
                        ></asp:TextBox>
                        <asp:Label ID="LDisablePutListEnd" runat="server" meta:resourcekey="str_notconfiged" CssClass="badge"
                                        ></asp:Label>
             </td>
             
         </tr>
                    </table>
        </div>
    
    <asp:Localize ID="NOTConfig" meta:resourcekey="str_notconfigured" runat="server" Visible="False">Not Configured</asp:Localize>
 <% if (!string.IsNullOrEmpty(ErrorMsg.Text)){ %>
        <script type="text/javascript">
            Ext.onReady(function () {
                            gWMsgBox("<%=ErrorMsg.Text%>");
            ShowSavePanel();

            });
        </script>
    <% } %>
</asp:Content>
