﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ExcludedFolderList.aspx.cs" Inherits="GladinetPayFlow.ExcludedFolderList"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="str_dltMsg" runat="server">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnDeleteExcludedFolder(id) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_cfrDltMsg" runat="server">Confirm delete the excluded folder</asp:Localize> (" + unescape(id) + ")?")) {

                Wait('wait');
                ng.value = unescape(id);
                btn.click();
            }
        }

        function OnAddFolder() {
            window.location = "/management/AddExcludedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
        }
        function OnDeviceList() {
            window.location = "DeviceAttachedFolders.aspx?id=<%=HiddenInstanceId.Value %>";
        }

        function RefreshList() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");
            Wait("Loading...");
            e.click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocThiDev" meta:resourcekey="str_thiDev" Visible="false" runat="server">This Device</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToDel" meta:resourcekey="str_faiToDel" Visible="false">Failed to delete:</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaExcFol" meta:resourcekey="str_faiToLoaExcFol" Visible="false">Failed to load excluded folder</asp:Localize>
<asp:Localize runat="server" ID="LocExcFolLst" meta:resourcekey="str_excFolLst" Visible="false">Excluded Folder List</asp:Localize>
    <nav class="navbar navbar-default" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " title="<%=STRDevList.Text %>" onclick="parent.SetPage(4);return false;" > 
                <span class="fa fa-menu-left"></span>  
                       <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server" 
                           Text="Return"></asp:Localize>
             </button>

                   <p class="navbar-text">
                        <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <table>
                       <tr>
                           <td>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right"  onclick="RefreshList();">
                       <span class="fa fa-refresh" aria-hidden="true"></span>
                    
                   </div>

                           </td>
                           <td>
                               <div  class="btn btn-primary gladbtn navbar-btn navbar-right"  onclick="OnAddFolder();">
                        <span class="fa fa-plus" aria-hidden="true"></span>
                       </div>
                           </td>
                       </tr>
                   </table>
                   
               </div>
           </nav>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent;
        margin-top: -10px;" cellspacing="0" cellpadding="0">
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
        
                       <asp:LinkButton ID="RefreshBtn" ForeColor="White" runat="server" 
                           OnClick="LinkButton2_Click"><asp:Localize meta:resourcekey="str_rfs" runat="server">Refresh</asp:Localize> <asp:Label ID="DeviceName" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label></asp:LinkButton>
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>
    
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
    
     <script type="text/javascript">    
var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" enableviewstate="false" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Value").ToString().Replace("'","%27").Replace("\\","%5c")) %>'
         ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

      

    var grid;
      
       function AdjustGridTable () {
           
        var h = 400;
          
        try {

           
            h = document.body.offsetHeight-120;
           
              grid.setWidth(document.documentElement.clientWidth - 20);
              grid.setHeight(h);
              grid.doComponentLayout();

              var e = document.getElementById("grid-example");
              e.style.height = h + "px";


          } catch (err) {
          }


      }

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'path' }
              ],
              data: myData
          });


           grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              border: false,
              columnLines: false,
              minHeight: 208,              
              minButtonWidth: 28,
              viewConfig: {
                  emptyText: "<asp:Localize meta:resourcekey="str_noEcdFldMsg" runat="server">no excluded folder defined</asp:Localize>",
                  deferEmptyText: false
              },
          
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hide';
                      }
                  },
                           
                  {
                      text: "<asp:Localize meta:resourcekey="str_fldPth" runat="server">Folder Path</asp:Localize>",
                      flex: 1,
                      minWidth:68,
                      sortable: true,
                      dataIndex: 'path',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-size:14px; font-weight:100;'>"+unescape(value)+"</span>";
                      }

                  },
                   {
                       text: '',
                       width: 50,
                       sortable: false,
                       hideable: false,
                       dataIndex: 'index',
                       renderer: function (value, metaData, record, rowIndex) {
                           var d = record.data;

                           return "<span class='fa fa-remove' style='color:#404040; font-size:14px; font-weight:100;' onclick='OnDeleteExcludedFolder(\""+d.path+"\")'></span>";
                        }
                   }
                  ],
              renderTo: "grid-example"
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
      });
    </script>
    <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" 
        Visible="False" Text=" Days ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" 
        Visible="False" Text=" Hours ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" 
        Visible="False" Text=" Minutes ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" 
        Visible="False" Text="Less than 1 minute ago"></asp:Localize>
</asp:Content>
