﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="EncryptedEmails.aspx.cs" Inherits="GladinetPayFlow.EncryptedEmails" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        td {font-size: 15px;font-weight: 100;}
        b {font-weight: 500;}
        .badgefont {font-size: 15px;}
        .clickable {text-decoration:none;}
        .clickable:hover {text-decoration:underline;cursor:pointer;}
        .table-striped td {padding:10px;}
        .gladbtn:hover{cursor:pointer;}
        .newMail,.userIcon {font-size:22px !important;float:left;line-height:27px;padding-right:10px;}
        .nowrap {white-space:nowrap;}    
        #tblSent tr.expired td{text-decoration:line-through;}
        /*Calendar styles<<<*/
        .calendarIco{padding:3px 0px 0px 10px;font-size:24px !important;}
        #cal{margin:50px auto;font:14px;display:table;position:absolute;}
        /*header bar---------------------*/
        #cal .header{cursor:default;height:34px;position:relative;color:#fff;-webkit-border-top-left-radius:5px;-webkit-border-top-right-radius:5px;-moz-border-radius-topleft:5px;-moz-border-radius-topright:5px;border-top-left-radius:5px;border-top-right-radius:5px;font-weight:200;text-transform:uppercase}
        #cal .header span{display:inline-block;line-height:34px}
        #cal .header .hook{width:9px;height:28px;position:absolute;bottom:60%;border-radius:10px;-moz-border-radius:10px;-webkit-border-radius:10px}
        .right.hook{right:15%}
        .left.hook{left:15%}
        /*month switch buttons*/
        #cal .header .button{width:24px;text-align:center;position:absolute}
        #cal .header .left.button{left:0;-webkit-border-top-left-radius:5px;-moz-border-radius-topleft:5px;border-top-left-radius:5px;}
        #cal .header .right.button{right:0;top:0;-webkit-border-top-right-radius:5px;-moz-border-radius-topright:5px;border-top-right-radius:5px}
        #cal .header .button:hover{cursor:pointer;}
        /*month label*/
        #cal .header .month-year{letter-spacing:1px;width:100%;text-align: center;}
        /*day headers---------------------*/
        .eformDayDisabled{background-color:#d3d3d3}
        #cal table{background:#fff;border-collapse:collapse}
        #cal td{color:#2b2b2b;width:50px;height:50px;line-height:30px;text-align:center;border:1px solid #e6e6e6;cursor:default;font-weight:200;}
        #cal #days td{height:26px;line-height:26px;text-transform:uppercase;font-size:12px;color:#9e9e9e;font-weight:200;}
        #cal td.footer{height:26px;line-height:26px;text-transform:uppercase;font-size:12px;color:#9e9e9e;font-weight:200;}
        #cal #days td:not(:last-child){border-right:1px solid #fff}
        #cal #cal-frame td.today{background:#ededed;color:#8c8c8c;box-shadow:1px 1px 0 #fff inset;-moz-box-shadow:1px 1px 0 #fff inset;-webkit-box-shadow:1px 1px 0 #fff inset}
        #cal #cal-frame td:not(.nil):hover{color:#fff;background:#a6a6a6;}
        #cal #cal-frame td span{font-size:12px;position:relative}
        #cal #cal-frame td span:first-child{bottom:5px}
        #cal #cal-frame td span:last-child{top:5px}
        #cal #cal-frame table.curr{float:left}
        #cal #cal-frame table.temp{position:absolute}
        /*>>>Calendar styles*/
    </style>
    <script type="text/javascript">
        function ReturnLast(){
            try{
                
                parent.ReturnLast();
            }catch(ex){
                console.log("EncryptedEmails:ReturnLast:"+ex);
            }
        }
        function closeCancelActiveWin() {
        }
        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }
        function OnCancelApply() {
            parent.closeActiveWin();
        }
        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }
        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");

            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }

        function SetPage(num) {
            window.location.href = "EncryptedEmails.aspx?p=" + num;
        }
        function NewMessage() {
            $("#CreateMessage").modal({ backdrop: 'static', keyboard: false });
            $("#CreateMessage input,#CreateMessage button").mouseover(function(){forceCloseCal();});
            $("#CreateMessage textarea").click(function(){forceCloseCal();});

            CheckUser($("#<%=txtTo.ClientID %>")[0]);
        }
        function alertM(msg) {
            $("#alertBody").html(msg);
            $("#alertModal").modal({ backdrop: 'static', keyboard: false });
        }
        function OnSendNow() {
            var to = $("#<%=txtTo.ClientID%>").val();
            var sub = $("#<%=txtSubject.ClientID%>").val();
            var bod = $("#<%=txtMessage.ClientID%>").val();
            var userType = $("#<%=hidUserType.ClientID%>").val();
            var pwd = $("#<%=txtPassword.ClientID%>").val();
            if (userType != "registered") {
                if ($("#passwordRow").is(":visible")){
                    if (pwd == "") {
                        alertM("<asp:Localize meta:resourcekey="str_pwdReq" runat="server">Password is required</asp:Localize>");
                        $("#CreateMessage").modal({ backdrop: 'static', keyboard: false });
                        return;
                    }
                }
            }
            if (to != "" && sub != "" && bod != "") {
               $("#<%=btnCreateNewMessage.ClientID%>")[0].click();
            } else {
                var missing = "<ul>";
                if(to == "") {
                    missing+="<li><asp:Localize meta:resourcekey="str_to" runat="server">To</asp:Localize></li>";
                }
                if(sub == "") {
                    missing+="<li><asp:Localize meta:resourcekey="str_sub" runat="server">Subject</asp:Localize></li>";
                }
                if(bod == "") {
                    missing+="<li><asp:Localize meta:resourcekey="str_msg" runat="server">Message</asp:Localize></li>";
                }
                missing += "</ul>";
                alertM("<asp:Localize meta:resourcekey="str_plsFilOutFlg" runat="server">Please fill out the following item(s):</asp:Localize>" + missing);

                $("#CreateMessage").modal({ backdrop: 'static', keyboard: false });
            }
        }
        function extendJquerySlim() {
            //define a barebones ajax function, because jquery slim doesn't include it
            $.extend({
                ajax: function (propsObj) {
                    var xhttp = new XMLHttpRequest();
                    xhttp.onreadystatechange = function () {
                        var XMLHttpRequestIsFinishedAndResponseIsReady = 4
                        var ok = 200;
                        var undefinedStatus = 0;
                        if (this.readyState == XMLHttpRequestIsFinishedAndResponseIsReady) {
                            if (this.status == ok) {
                                var jObj = this.responseText;
                                try {
                                    jObj = JSON.parse(this.responseText);
                                } catch (ex) { }
                                if (typeof propsObj["success"] != "undefined") {
                                    propsObj["success"](jObj, ok, xhttp);
                                }
                            } else if (this.status != undefinedStatus) {
                                if (typeof propsObj["error"] != "undefined") {
                                    propsObj["error"](this.responseText, this.status, xhttp);
                                }
                            }
                        }
                    };
                    var async = true;
                    if (typeof propsObj["async"] != "undefined") {
                        if (!isTrue(propsObj["async"])) async = false;
                    }
                    //         method            url              async
                    xhttp.open(propsObj["type"], propsObj["url"], async);
                    //process headers
                    for (var prop in propsObj["headers"]) {
                        if (propsObj["headers"].hasOwnProperty(prop)) xhttp.setRequestHeader(prop, propsObj["headers"][prop]);
                    }
                    if (typeof propsObj["dataType"] != "undefined") {
                        xhttp.setRequestHeader("Content-Type", propsObj["dataType"]);
                    }
                    if (typeof propsObj["data"] != "undefined") {
                        xhttp.send(propsObj["data"]);
                    } else {
                        xhttp.send();
                    }
                }
            });
        }
        function CheckUser(inpObjRef) {
            //checks if the user is registered or not
            if(inpObjRef.value==""){                
                $("#passwordRow").hide();
                return;
            }
            $.ajax({
                type: "POST",
                headers: {
                    "toemail": encodeURIComponent(inpObjRef.value)
                },
                url: "EncryptedEmails.aspx?ajx=1",
                success: function (data, status, request) {
                    $("#<%=hidUserType.ClientID%>").val(data);
                    if (data == "registered") {
                        $("#passwordRow").hide();
                    } else {
                        $("#passwordRow").show();
                    }
                },
                error: function (xhr, status, error) {
                    alertM("<asp:Localize meta:resourcekey="str_errLbl" runat="server">Error:</asp:Localize> " + error);
                }
            });
        }
        function LoadMessage(messageID) {
            //checks if the user is registered or not
            $.ajax({
                type: "POST",
                headers: {
                    "messageid": messageID,
                    "issent": !isInbox()
                },
                url: "EncryptedEmails.aspx?ajx=1",
                dataType:"application/json",
                success: function (data, status, request) {
                    $("#pDate").html(data.SentDate);
                    $("#pFrom").html(data.FromEmail);
                    $("#pTo").html(data.ToEmail);
                    $("#pSubject").html(data.Subject);
                    $("#pMessage").html(data.Message);
                    $("#ViewMessage").modal({ backdrop: 'static', keyboard: false });
                    $("#pExpires").html(data.ExpirationDate);
                    //mark the message as read
                    $("#newMail_" + messageID.replace(/\-/g,"")).remove();
                },
                error: function (xhr, status, error) {
                    alertM("<asp:Localize meta:resourcekey="str_errLbl" runat="server">Error:</asp:Localize> " + error);
                }
            });
        }
        function selectTab(num) {
            if(num==1){
                $("#page_1").addClass("gladtab_lg_active");
                $("#page_2").addClass("gladtab_lg_inactive");
            } else {
                $("#page_1").addClass("gladtab_lg_inactive");
                $("#page_2").addClass("gladtab_lg_active");
            }
        }
        var _selected = false;
        function toggleSelectAll(tblID) {
            _selected = !_selected;
            $("#" + tblID + " .chkDel").each(function () {
                $(this)[0].checked = _selected;
            });
            checkIfAnyChecked();
        }
        function checkIfAnyChecked() {
            $("#btnDelete").hide();
            $(".chkDel").each(function () {
                if ($(this)[0].checked) {
                    $("#btnDelete").show();
                    return;
                }
            });
        }
        function DeleteSelected() {
            var firstCheckboxValue = $('.chkDel:checked:first').val();
            if (firstCheckboxValue != null && firstCheckboxValue.length>5) {
                DeleteAllMessages(firstCheckboxValue);
            }
        }
        function DeleteAllMessages(messageID) {
            $.ajax({
                type: "POST",
                headers: {
                    "deletemessageid": messageID,
                    "issent": !isInbox(),
                },
                url: "EncryptedEmails.aspx?ajx=1",
                success: function (data, status, request) {
                    if (data == "success") {
                        console.log(messageID)
                        $(":checkbox[value=" + messageID + "]").closest("tr").remove();
                        var nextMessageID = $('.chkDel:checked:first').val();
                        if(nextMessageID!=null && nextMessageID!=""){
                            DeleteAllMessages(nextMessageID);
                        }
                    } else {
                        alertM("<asp:Localize meta:resourcekey="str_fldDltMsgLbl" runat="server">Failed to delete message:</asp:Localize> " + messageID);
                    }
                },
                error: function (xhr, status, error) {
                    alertM("<asp:Localize meta:resourcekey="str_errLbl" runat="server">Error:</asp:Localize> " + error);
                }
            });
        }
        function isInbox(){
            return  (location.href.indexOf("?p=2")==-1);
        }
        var oldOnload = window.onload;
        window.onload = function () {
            if (oldOnload) oldOnload();
            extendJquerySlim();
            if (isInbox()) {
                var msgid = "<%=_messageID%>";
                if(msgid != ""){
                    LoadMessage(msgid);
                }else{
                    selectTab(1);
                }
            } else {
                selectTab(2);
            }
            <asp:Literal ID="ltlServerScripts" runat="server" />
        }    
        function CheckIfFieldEmpty(txtObjRef, msgID){
            if(txtObjRef.value==""){
                $("#"+msgID).show();
            }else{
                $("#"+msgID).hide();
            }
        }
        function CheckEmail(txtObjRef, msgID){
            var val = txtObjRef.value;
            if(val==""){
                $("#"+msgID).show();
            }else{
                if(val.indexOf("@")>-1 && val.indexOf(".")>-1){
                    $("#"+msgID).hide();
                }else{
                    $("#"+msgID).show();
                }
            }
        }
        //==============================================================================================
        var calIsOpen = false;
        function forceCloseCal(){
            calIsOpen = false;
            gladCal.closeWithoutUpdating();
        }
        function toggleCal(){
            if(calIsOpen){
                forceCloseCal();
            }else{
                calIsOpen = true;
                var offset = $(".calendarIco ").offset();
                var topPadding = offset.top - 300;
                var leftPadding = offset.left + 40;
                var tomorrow = new Date();
                tomorrow.setDate(tomorrow.getDate() + 1);
                var minDate = tomorrow;
                var maxDate = new Date(new Date().setFullYear(new Date().getFullYear() + 1));
                gladCal.open('yyyy.MM.dd', leftPadding, topPadding, 1, fmtInpDate(minDate), fmtInpDate(maxDate), "<%=HidExpires.ClientID %>", 10000);
            }
        }
        function closeNewMessageModal(){
            if(calIsOpen){
                calIsOpen = false;
                gladCal.closeWithoutUpdating();
            }
            $('#CreateMessage').modal('toggle');
        }
        function formatDoubleDigitStr(i) {
            if (i < 10) {
                i = "0" + i;
            }
            return i;
        }
        function currentTimeStr() {
            //gets 23:59:59.000
            var today = new Date();
            var h = today.getHours();
            var m = today.getMinutes();
            var s = today.getSeconds();
            // add a zero in front of numbers<10
            m = formatDoubleDigitStr(m);
            s = formatDoubleDigitStr(s);
            return " " + h + ":" + m + ":" + s + ".000";
        }
        //calendar code<<<
        function fmtInpDate(dateObj) {
            //format=yyyy-MM-dd
            return dateObj.getFullYear() + '-' + (dateObj.getMonth() + 1) + '-' + dateObj.getDate();
        }
        function parseDate(str) {
            //format=MM.dd.yyyy
            var mdy = str.split('.');
            return new Date(mdy[0], mdy[1] - 1, mdy[2]);
        }
        function updateDate() {
            //override this
        }
        var gladCal = (function () {
            var wrap, label, calYear, calMonth, calDateFormat, firstDay, isIE11;
            isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
            //check global variables for calendar widget and set default localization values
            if (window.months === undefined) {
                window.months=["<asp:Localize runat="server" meta:resourcekey="str_caljan">January</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calfeb">February</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calmar">March</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calapr">April</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calmay">May</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caljun">June</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caljul">July</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calaug">August</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsep">September</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caloct">October</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calnov">November</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caldec">December</asp:Localize>"];
            }
            if (window.shortDays === undefined) {
                window.shortDays=["<asp:Localize runat="server" meta:resourcekey="str_calmon">MON</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caltue">TUE</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calwed">WED</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calthu">THU</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calfri">FRI</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsat">SAT</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsun">SUN</asp:Localize>"];
            }
            //first day of week combinations array
            var firstDayCombinations = [[0, 1, 2, 3, 4, 5, 6], [1, 2, 3, 4, 5, 6, 0], [2, 3, 4, 5, 6, 0, 1], [3, 4, 5, 6, 0, 1, 2], [4, 5, 6, 0, 1, 2, 3], [5, 6, 0, 1, 2, 3, 4], [6, 0, 1, 2, 3, 4, 5]];
            //DOM strings helper
            var DOMstrings = { divCal: "cal", divCalQ: "#cal", monthLabel: "label", btnPrev: "prev", btnNext: "next", sunLabel: "eformSun", monLabel: "eformMon", tueLabel: "eformTue", wedLabel: "eformWed", thuLabel: "eformThu", friLabel: "eformFri", satLabel: "eformSat", tdDay: ".eformDay" };
            //open function
            function open(dateFormat, x, y, firstDayOfWeek, minDate, maxDate, element, zindex) {
                //prevent to open more than one calendar
                if (document.getElementById('cal')) {
                    return false;
                }
                //init def props
                eFormMinimalDate = DateParse(minDate);
                eFormMaximalDate = DateParse(maxDate);
                //console.log("maxDate:")
                //console.log(eFormMaximalDate)
                eFormCalendarElement = element;
                firstDay = firstDayOfWeek;
                //set default first date of week
                if (firstDayOfWeek === undefined) {
                    firstDayOfWeek = 6;
                } else {
                    firstDayOfWeek -= 1;
                }
                //create html and push it into DOM
                var newHtml = '<div id="cal" style="top:' + y + 'px;left:' + x + 'px;z-index:' + zindex + ';"><div class="header topnavcolor"><span class="left button" id="prev">&lt;</span><span class="left hook"></span><span class="month-year" id="label">June 20&0</span><span class="right hook"></span><span class="right button" id="next">&gt;</span></div><table id="days"><tr><td id="eformSun">sun</td><td id="eformMon">mon</td><td id="eformTue">tue</td><td id="eformWed">wed</td><td id="eformThu">thu</td><td id="eformFri">fri</td><td id="eformSat">sat</td></tr></table><div id="cal-frame"><table class="curr"><tbody></tbody></table></div></div>';
                document.getElementsByTagName('body')[0].insertAdjacentHTML('beforeend', newHtml);
                calDateFormat = dateFormat;
                wrap = document.getElementById(DOMstrings.divCal);
                label = document.getElementById(DOMstrings.monthLabel);
                //register events
                document.getElementById(DOMstrings.btnPrev).addEventListener('click', function () { switchMonth(false); });
                document.getElementById(DOMstrings.btnNext).addEventListener('click', function () { switchMonth(true); });
                label.addEventListener('click', function () { switchMonth(null, new Date().getMonth(), new Date().getFullYear()); });
                //shorter day version labels
                var dayCombination = firstDayCombinations[firstDayOfWeek];
                document.getElementById(DOMstrings.sunLabel).textContent = window.shortDays[dayCombination[0]];
                document.getElementById(DOMstrings.monLabel).textContent = window.shortDays[dayCombination[1]];
                document.getElementById(DOMstrings.tueLabel).textContent = window.shortDays[dayCombination[2]];
                document.getElementById(DOMstrings.wedLabel).textContent = window.shortDays[dayCombination[3]];
                document.getElementById(DOMstrings.thuLabel).textContent = window.shortDays[dayCombination[4]];
                document.getElementById(DOMstrings.friLabel).textContent = window.shortDays[dayCombination[5]];
                document.getElementById(DOMstrings.satLabel).textContent = window.shortDays[dayCombination[6]];
                //fire initialization event trigger
                label.click();
            }
            //switches current month
            function switchMonth(next, month, year) {
                var curr = label.textContent.trim().split(' '), calendar, tempYear = parseInt(curr[1], 10);
                if (month === undefined) {
                    month = ((next) ? ((curr[0] === window.months[11]) ? 0 : months.indexOf(curr[0]) + 1) : ((curr[0] === window.months[0]) ? 11 : months.indexOf(curr[0]) - 1));
                }
                if (!year) {
                    if (next && month === 0) {
                        year = tempYear + 1;
                    } else if (!next && month === 11) {
                        year = tempYear - 1;
                    } else {
                        year = tempYear;
                    }
                }
                //set month and year for widget scope
                calMonth = month + 1;
                calYear = year;
                calendar = createCal(year, month);
                var curr = document.querySelector('.curr');
                curr.innerHTML = '';
                curr.appendChild(calendar.calendar());
                //disable days below minimal date
                if (eFormMinimalDate !== undefined) {
                    if (year < eFormMinimalDate.year || year <= eFormMinimalDate.year && month <= eFormMinimalDate.month - 1) {
                        var emptyCount = document.querySelector('.curr table').rows[0].querySelectorAll('td:empty').length;
                        var tdDisabled = document.querySelectorAll('.eformDay');
                        for (var i = 0; i < tdDisabled.length; ++i) {
                            if (i - emptyCount + 1 < eFormMinimalDate.day || month < eFormMinimalDate.month - 1 || year < eFormMinimalDate.year) {
                                tdDisabled[i].classList.add('eformDayDisabled');
                                tdDisabled[i].onclick = function () {
                                    return false;
                                }
                            }
                        }
                    }
                }
                //disable days above maximal date				
                if (eFormMaximalDate !== undefined) {
                    if (year > eFormMaximalDate.year || year >= eFormMaximalDate.year && month >= eFormMaximalDate.month - 1) {
                        var emptyCount = document.querySelector('.curr table').rows[0].querySelectorAll('td:empty').length;
                        var tdDisabled = document.querySelectorAll('.eformDay');
                        for (var i = 0; i < tdDisabled.length; ++i) {
                            if (i - emptyCount + 1 > eFormMaximalDate.day || month > eFormMaximalDate.month - 1 || year > eFormMaximalDate.year) {
                                tdDisabled[i].classList.add('eformDayDisabled');
                                tdDisabled[i].onclick = function () {
                                    return false;
                                }
                            }
                        }
                    }
                }
                label.textContent = calendar.label;
            }
            //main calendar function. Creates calendar itself and stores into cache
            function createCal(year, month) {
                var day = 1, i, j, haveDays = true,
                    startDay = new Date(year, month, day).getDay(),
                    daysInMonths = [31, (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
                    calendar = [];
                startDay -= firstDay;
                if (startDay < 0) {
                    startDay = 7 + startDay;
                }
                if (createCal.cache[year] && !isIE11) {
                    if (createCal.cache[year][month]) {
                        return createCal.cache[year][month];
                    }
                } else {
                    createCal.cache[year] = {};
                }
                i = 0;
                while (haveDays) {
                    calendar[i] = [];
                    for (j = 0; j < 7; j++) {
                        if (i === 0) {
                            if (j === startDay) {
                                calendar[i][j] = day++;
                                startDay++;
                            }
                        } else if (day <= daysInMonths[month]) {
                            calendar[i][j] = day++;
                        } else {
                            calendar[i][j] = '';
                            haveDays = false;
                        }
                        if (day > daysInMonths[month]) {
                            haveDays = false;
                        }
                    }
                    i++;
                }
                for (i = 0; i < calendar.length; i++) {
                    calendar[i] = '<tr><td class="eformDay" onclick="gladCal.dayClick(this)">' + calendar[i].join('</td><td class="eformDay" onclick="gladCal.dayClick(this)">') + '</td></tr>';
                }
                var customFooter = '<tr><td class="footer" onclick="gladCal.neverClick()" colspan="7"><asp:Localize meta:resourcekey="str_nvr" runat="server">NEVER</asp:Localize></td></tr>';
                var calendarInnerHtml = calendar.join('');
                calendar = document.createElement('table');
                calendar.className = 'curr';
                calendar.innerHTML = calendarInnerHtml + customFooter;
                var tdEmty = calendar.querySelectorAll('td:empty');
                for (var i = 0; i < tdEmty.length; ++i) {
                    tdEmty[i].classList.add('nil');
                }
                if (month === new Date().getMonth()) {
                    var calTd = calendar.querySelectorAll('td');
                    var calTdArray = Array.prototype.slice.call(calTd);
                    calTdArray.forEach(function (current, index, array) {
                        if (current.innerHTML === new Date().getDate().toString()) {
                            current.classList.add('today');
                        }
                    });
                }
                createCal.cache[year][month] = { calendar: function () { return calendar }, label: months[month] + ' ' + year };
                return createCal.cache[year][month];
            }
            createCal.cache = {};
            //day click event function => than close
            var dayClick = function (element) {
                if (element.innerHTML == "") {
                    return;
                }
                var dateResult = DateToString(new Date(calYear, calMonth - 1, parseInt(element.innerHTML)), calDateFormat);
                document.getElementById(eFormCalendarElement).value = dateResult;
                $("#divCalDisplay").html(dateResult.replace(/\./g,"/"));
                toggleCal();
            }
            var neverClick = function () {
                document.getElementById(eFormCalendarElement).value = "<asp:Localize meta:resourcekey="str_nvr" runat="server">NEVER</asp:Localize>";
                $("#divCalDisplay").html("<asp:Localize meta:resourcekey="str_nvr" runat="server">NEVER</asp:Localize>");
                toggleCal();
            }
            // join
            function joinObj(obj, seperator) {
                var out = [];
                for (k in obj) {
                    out.push(k);
                }
                return out.join(seperator);
            }
            //returns string in desired format
            function DateToString(inDate, formatString) {
                var dateObject = { M: inDate.getMonth() + 1, d: inDate.getDate(), D: inDate.getDate(), h: inDate.getHours(), m: inDate.getMinutes(), s: inDate.getSeconds(), y: inDate.getFullYear(), Y: inDate.getFullYear() };
                // Build Regex Dynamically based on the list above.
                // Should end up with something like this "/([Yy]+|M+|[Dd]+|h+|m+|s+)/g"
                var dateMatchRegex = joinObj(dateObject, "+|") + "+";
                var regEx = new RegExp(dateMatchRegex, "g");
                formatString = formatString.replace(regEx, function (formatToken) {
                    var datePartValue = dateObject[formatToken.slice(-1)];
                    var tokenLength = formatToken.length;
                    if (formatToken === 'MMMM') {
                        return window.months[dateObject.M - 1];
                    }
                    // A conflict exists between specifying 'd' for no zero pad -> expand to '10' and specifying yy for just two year digits '01' instead of '2001'.  One expands, the other contracts.
                    // so Constrict Years but Expand All Else
                    if (formatToken.indexOf('y') < 0 && formatToken.indexOf('Y') < 0) {
                        // Expand single digit format token 'd' to multi digit value '10' when needed
                        var tokenLength = Math.max(formatToken.length, datePartValue.toString().length);
                    }
                    var zeroPad;
                    try {
                        zeroPad = (datePartValue.toString().length < formatToken.length ? "0".repeat(tokenLength) : "");
                    } catch (ex) {//IE11 repeat catched
                        zeroPad = (datePartValue.toString().length < formatToken.length ? repeatStringNumTimes("0", tokenLength) : "");
                    }
                    return (zeroPad + datePartValue).slice(-tokenLength);
                });
                return formatString;
            }
            Date.prototype.ToString = function (formatStr) { return DateToString(this.toDateString(), formatStr); }
            //IE11 repeat alternative
            function repeatStringNumTimes(string, times) {
                var repeatedString = "";
                while (times > 0) {
                    repeatedString += string;
                    times--;
                }
                return repeatedString;
            }
            //close event function (fadeout)
            function close() {
                updateDate();
                fadeOutEffect(DOMstrings.divCalQ, remove);
            }
            function closeWithoutUpdating() {
                fadeOutEffect(DOMstrings.divCalQ, remove);
            }
            //remove calendar box
            var remove = function () {
                try {
                    document.getElementById(DOMstrings.divCal).remove();
                } catch (ex) {//ie11 fix
                    var child = document.getElementById(DOMstrings.divCal);
                    child.parentNode.removeChild(child);
                }
            }
            //parse date
            function DateParse(date) {
                var parsedDate, newDate;
                var currentDate = date;
                if (currentDate != null) {
                    splitedDate = currentDate.split('-');
                    newDate = { year: splitedDate[0], month: splitedDate[1], day: splitedDate[2] };
                }
                return newDate;
            }
            //function accesibility
            return { open: open, switchMonth: switchMonth, createCal: createCal, dayClick: dayClick, close: close, closeWithoutUpdating: closeWithoutUpdating, neverClick: neverClick };
        })();
        //plain javascript fadeout alternative
        function fadeOutEffect(t, e) { var a = document.querySelector(t); if (null != a) var c = setInterval(function () { a.style.opacity || (a.style.opacity = 1), 0 < a.style.opacity ? a.style.opacity -= .1 : (clearInterval(c), e()) }, 20) }
        /*MIT License. Copyright (c) 2018 Josef Brož. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
        The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
        //>>>calendar code

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocUnkErr" meta:resourcekey="str_unkErr" runat="server" Visible="false">Unknown Error</asp:Localize>
    <asp:Localize ID="LocNotRed" meta:resourcekey="str_notRed" runat="server" Visible="false">Not Read</asp:Localize>
    <asp:Localize ID="LocSntScs" meta:resourcekey="str_sntScs" runat="server" Visible="false">Sent successfully.</asp:Localize>
    <asp:Localize ID="LocErrFldSndMsg" meta:resourcekey="str_errFldSndMsg" runat="server" Visible="false">Error. Failed to send message.</asp:Localize>
    <asp:Localize ID="LocRegUsr" meta:resourcekey="str_regUsr" runat="server" Visible="false">Registered User</asp:Localize>
    <asp:Localize ID="LocExtUsr" meta:resourcekey="str_extUsr" runat="server" Visible="false">External User</asp:Localize>
    <asp:Localize ID="LocGstUsr" meta:resourcekey="str_gstUsr" runat="server" Visible="false">Guest User</asp:Localize>
    <asp:Localize ID="LocAdm" meta:resourcekey="str_adm" runat="server" Visible="false">Administrator</asp:Localize>
    <asp:Localize ID="LocExd" meta:resourcekey="str_exd" runat="server" Visible="false">Expired</asp:Localize>
    <asp:Localize ID="LocNvrLbl" meta:resourcekey="str_nvrLbl" runat="server" Visible="false">Never</asp:Localize>
    <asp:Localize ID="LocPrdSecMsg" meta:resourcekey="str_prdSecMsg" runat="server" Visible="false">{ProductName} Secure Message</asp:Localize>
    <asp:Localize ID="LocMptIbxMsg" meta:resourcekey="str_mptIbxMsg" runat="server" Visible="false">There are no emails in your inbox.</asp:Localize>
    <asp:Localize ID="LocEncMsgPwd" meta:resourcekey="str_encMsgPwd" runat="server" Visible="false">Encrypted Message Password</asp:Localize>
   <asp:Localize ID="LocNoEmaWerSen" meta:resourcekey="str_noEmaWerSen" Visible="false" runat="server">No emails were sent.</asp:Localize>
    <div style="background-color: transparent; border: 0px; padding-left: 0px; align-content: right; padding-right: 0px; box-shadow: 0px!important;margin-top: 20px;">
        <table style="border-collapse: collapse;" width="100%" cellspacing="0" cellpadding="0">
            <tbody><tr>

                <td style="width: 10px; border-bottom: 1px solid #cccccc;">&nbsp;</td>
                <td style="padding: 0px 0px 0px 10px; width: 100px;" align="left">
                    <table style="border-collapse: collapse;" cellspacing="0" cellpadding="0">
                        <tbody><tr>
                            
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="" id="page_1" onclick="SetPage(1);return false;" style="padding-left:20px;padding-right:20px;"><asp:Localize meta:resourcekey="str_inb" runat="server">Inbox </asp:Localize></div>
                            </td>
                            
                            <td style="padding-top: 10px;" valign="bottom">
                                <div class="" id="page_2" onclick="SetPage(2);return false;" style="padding-left:20px;padding-right:20px;"><asp:Localize meta:resourcekey="str_sen" runat="server">Sent </asp:Localize></div>
                            </td>
                            
                        </tr>
                    </tbody></table>

                </td>

                <td style="border-bottom: 1px solid #cccccc; padding-right: 10px;">
                    <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="ReturnLast();">×</div>
                </td>
            </tr>
        </tbody></table>

       <div class=" navbar navbar-default navbar-fixed-top" role="navigation" style="padding: 10px; box-shadow:0px 0px white!important;">
            <div class="navbar-left">
              
                <input id="btnDelete" type="button" value="Delete Selected" class="btn btn-primary gladbtn" onclick="DeleteSelected();" style="display:none;"  />
            </div>
            <div class="navbar-right">
                <asp:Localize ID="LocCrtNewEml" meta:resourcekey="str_crtNewEml" runat="server" Visible="false">Create a New Email</asp:Localize>
                <input type="button" value="<%=LocCrtNewEml.Text %>" class="btn btn-primary gladbtn" onclick="NewMessage();"/>
            </div>
            <div class="container-fluid" style="padding-right: 30px; border:0px!important;"></div>
        </div>

         <div class="wrapper" style="background-color:white; width:100%;padding:30px 20px 20px 20px;font-size: 16px;">
         
             <asp:Panel ID="pnlInbox" runat="server">
                <asp:Repeater ID="rptInbox" runat="server" >
                  <HeaderTemplate>
                    <table id="tblInbox" class ="table table-bordered table-striped">     
                      <thead>
                        <tr>
                            <th style="width:5%" class="text-center" onclick="toggleSelectAll('tblInbox')"><i class="gladinet-icons gladbtn" style="font-size:22px !important;">&#x164;</i></th>
                            <th class="nowrap" style="width:20%"><asp:Localize meta:resourcekey="str_frm" runat="server">From</asp:Localize></th>
                            <th style="width:55%"><asp:Localize meta:resourcekey="str_sbj" runat="server">Subject</asp:Localize></th>
                            <th class="nowrap" style="width:20%"><asp:Localize meta:resourcekey="str_sntDte" runat="server">Sent Date</asp:Localize></th>
                        </tr>
                      </thead>
                      <tbody>
                  </HeaderTemplate>
                    <ItemTemplate>   
                        <tr>
                            <td class="text-center"><input id="rptInboxRow_<%#(((RepeaterItem)Container).ItemIndex+1) %>" class="chkDel" type="checkbox" value="<%# ((user.EncryptedMessage)Container.DataItem).MessageID %>" onchange="checkIfAnyChecked()" /></td>
                            <td class="nowrap"><%# ((user.EncryptedMessage)Container.DataItem).FromEmail %></td>
                            <td class="clickable" onclick="LoadMessage('<%# ((user.EncryptedMessage)Container.DataItem).MessageID %>')"><%# ((user.EncryptedMessage)Container.DataItem).Subject %></td>
                            <td class="nowrap"><%# ((user.EncryptedMessage)Container.DataItem).SentDate %></td>
                        </tr>
                    </ItemTemplate>
                  <FooterTemplate>
                    </tbody>
                    </table>
                  </FooterTemplate>
                </asp:Repeater>  
             </asp:Panel>

             <asp:Panel ID="pnlSent" runat="server">
                <asp:Repeater ID="rptSent" runat="server" >
                  <HeaderTemplate>
                    <table id="tblSent" class="table table-bordered table-striped ">     
                      <thead>
                        <tr>
                            <th style="width:5%" class="text-center" onclick="toggleSelectAll('tblSent')"><i class="gladinet-icons gladbtn" style="font-size:22px !important;">&#x164;</i></th>
                            <th class="nowrap" style="width:20%">To</th>
                            <th style="width:55%"><asp:Localize meta:resourcekey="str_sub" runat="server">Subject</asp:Localize></th>
                            <th class="nowrap" style="width:20%"><asp:Localize meta:resourcekey="str_sntDte" runat="server">Sent Date</asp:Localize></th>
                            <th class="nowrap" style="width:20%"><asp:Localize meta:resourcekey="str_redDte" runat="server">Read Date</asp:Localize></th>
                            <th class="nowrap" style="width:20%"><asp:Localize meta:resourcekey="str_exp" runat="server">Expires</asp:Localize></th>
                        </tr>
                      </thead>
                      <tbody>
                  </HeaderTemplate>
                    <ItemTemplate>   
                        <t class="<%# ((user.EncryptedMessage)Container.DataItem).Message %>">
                            <td class="text-center"><input id="rptInboxRow_<%#(((RepeaterItem)Container).ItemIndex+1) %>" class="chkDel" type="checkbox" value="<%# ((user.EncryptedMessage)Container.DataItem).MessageID %>" onchange="checkIfAnyChecked()" /></td>
                            <td class="nowrap"><%# ((user.EncryptedMessage)Container.DataItem).ToEmail %></td>
                            <td class="clickable" onclick="LoadMessage('<%# ((user.EncryptedMessage)Container.DataItem).MessageID %>')"><%# ((user.EncryptedMessage)Container.DataItem).Subject %></td>
                            <td class="nowrap"><%# ((user.EncryptedMessage)Container.DataItem).SentDate %></td>
                            <td class="nowrap"><%# ((user.EncryptedMessage)Container.DataItem).ReadDate %></td>
                            <td class="nowrap"><%# ((user.EncryptedMessage)Container.DataItem).ExpirationDate %></td>
                        </tr>
                    </ItemTemplate>
                  <FooterTemplate>
                    </tbody>
                    </table>
                  </FooterTemplate>
                </asp:Repeater>    
             </asp:Panel>

             <asp:Literal ID="ltlError" runat="server" />
        </div>

    </div>
    
    <div id="CreateMessage" class="modal fade" role="dialog">
      <div class="modal-dialog" style="margin-left:5vw;">

      <!-- Modal content-->
        <div class="modal-content" style="width:90vw;">
          <div class="modal-header">
              <asp:Localize meta:resourcekey="str_newEncMsg" runat="server">New Encrypted Message</asp:Localize>
          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">

            <div style="margin-top:0px;margin-bottom:0px;width:40%;">
            <p><span style="color:red;font-weight:bold;" id="crfvtxtTo">* </span><asp:Localize meta:resourcekey="str_toLbl" runat="server">To:</asp:Localize></p>
            <p><asp:TextBox ID="txtTo" CssClass="form-control" runat="server" onblur="CheckUser(this)" onkeyup="CheckEmail(this, 'crfvtxtTo')" /><input type="hidden" id="hidUserType" value="" runat="server" /></p>
                
            </div>

            <p><asp:RequiredFieldValidator ID="rfvTxtSubject" runat="server" ControlToValidate="txtSubject" Text="* " Font-Bold="true" ForeColor="Red" Display="Dynamic" /><asp:Localize meta:resourcekey="str_subLbl" runat="server">Subject:</asp:Localize></p>
            <p><asp:TextBox ID="txtSubject" CssClass="form-control" runat="server" /></p>

            <div id="passwordRow" style="display:none;margin-top:0px;margin-bottom:0px;width:40%;">
                <p><span style="color:red;font-weight:bold;" id="crfvTxtPassword">* </asp:Localize><asp:Localize meta:resourcekey="str_pwdForAcsLbl" runat="server">Password for Access:</asp:Localize></p>
                <p><asp:TextBox TextMode="Password" ID="txtPassword" CssClass="form-control" runat="server" onkeyup="CheckIfFieldEmpty(this, 'crfvTxtPassword')" /></p>
                <p><asp:Checkbox id="chkSndPwd" runat="server" Text="Send Password (in a separate email)" meta:resourcekey="str_sndPwd" /></p> 
            </div>

            <p><span style="color:red;font-weight:bold;" id="crfvTxtMessage">* </span><asp:Localize meta:resourcekey="str_msgLbl" runat="server">Message:</asp:Localize></p>
            <p><asp:TextBox ID="txtMessage" CssClass="form-control" runat="server" TextMode="MultiLine" Rows="5" style="height:200px;border-width:1px !important;" onkeyup="CheckIfFieldEmpty(this,'crfvTxtMessage')" /></p>

            <table>
                <tr><td><asp:Localize meta:resourcekey="str_expDteLbl" runat="server">Expiration Date:</asp:Localize></td><td><div id="divCalDisplay"></div></td><td><span class="gladinet-icons gladbtn calendarIco hand" onclick="toggleCal()">&#x013E;</span></td></tr>
            </table>
            <input type="hidden" id="HidExpires" runat="server" />
            

          </div>

          <div class="modal-footer" style="font-size: 16px;padding-bottom:20px;">
              <asp:Button ID="btnCreateNewMessage" runat="server" Text="" style="display:none" OnClick="btnCreateNewMessage_Click"/>

              <button type="button" id="btnSendNow" class="btn btn-primary gladbtn" onclick="OnSendNow();return false;"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_sndNow" runat="server">Send Now</asp:Localize></span></button>
              <button type="button" id="btnCancel" class="btn btn-default" onclick="closeNewMessageModal()"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>

        </div>

    </div>
  </div>
    <div id="ViewMessage" class="modal fade" role="dialog">
      <div class="modal-dialog" style="margin-left:20vw;">

      <!-- Modal content-->
        <div class="modal-content" style="width:60vw;">
          <div class="modal-header">
              <asp:Localize meta:resourcekey="str_encMsg" runat="server">Encrypted Message</asp:Localize>
          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">
              
            <table class="table table-bordered">
                <tr><td class="text-right"><asp:Localize meta:resourcekey="str_dteLbl" runat="server">Date:</asp:Localize> </td><td id="pDate"></td></tr>
                <tr><td class="text-right"><asp:Localize meta:resourcekey="str_frmLbl" runat="server">From:</asp:Localize> </td><td id="pFrom"></td></tr>
                <tr><td class="text-right"><asp:Localize meta:resourcekey="str_toLbl" runat="server">To:</asp:Localize> </td><td id="pTo"></td></tr>
                <tr><td class="text-right"><asp:Localize meta:resourcekey="str_sbjLbl" runat="server">Subject:</asp:Localize> </td><td id="pSubject"></td></tr>
                <tr><td class="text-right"><asp:Localize meta:resourcekey="str_msgLbl" runat="server">Message:</asp:Localize> </td><td id="pMessage"></td></tr>
                <tr><td class="text-right"><asp:Localize meta:resourcekey="str_expLbl2" runat="server">Expires:</asp:Localize> </td><td id="pExpires"></td></tr>
            </table>

          </div>

          <div class="modal-footer" style="font-size: 16px;">
              <button type="button" id="btnClose" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></span></button>
          </div>

        </div>

    </div>
  </div>    

    <div id="alertModal" class="modal fade" role="dialog">
      <div class="modal-dialog" style="margin-left:30vw;">
      <!-- Modal content-->
        <div class="modal-content" style="width:40vw;">
          <div id="alertBody" class="modal-body" style="font-weight:400;font-size:18px;color:#565656;"></div>
          <div class="modal-footer" style="font-size: 16px;">
              <button type="button" id="btnAlertClose" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_ok" runat="server">OK</asp:Localize></span></button>
          </div>

        </div>

    </div>
  </div>    

</asp:Content>
