﻿<%@ Page Title="Share File or Folder" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true"
    CodeBehind="EditSharePage.aspx.cs" Inherits="GladinetPayFlow.EditSharePage" Culture="auto" meta:resourcekey="PageResource1"
    UICulture="auto" EnableViewState="true" MaintainScrollPositionOnPostback="true" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
    <style type="text/css">
        /*Calendar styles<<<*/
        #cal{margin:50px auto;font:14px;display:table;position:absolute}
        /*header bar---------------------*/
        #cal .header{cursor:default;height:34px;position:relative;color:#fff;-webkit-border-top-left-radius:5px;-webkit-border-top-right-radius:5px;-moz-border-radius-topleft:5px;-moz-border-radius-topright:5px;border-top-left-radius:5px;border-top-right-radius:5px;font-weight:200;text-transform:uppercase}
        #cal .header span{display:inline-block;line-height:34px}
        #cal .header .hook{width:9px;height:28px;position:absolute;bottom:60%;border-radius:10px;-moz-border-radius:10px;-webkit-border-radius:10px}
        .right.hook{right:15%}
        .left.hook{left:15%}
        /*month switch buttons*/
        #cal .header .button{width:24px;text-align:center;position:absolute}
        #cal .header .left.button{left:0;-webkit-border-top-left-radius:5px;-moz-border-radius-topleft:5px;border-top-left-radius:5px;}
        #cal .header .right.button{right:0;top:0;-webkit-border-top-right-radius:5px;-moz-border-radius-topright:5px;border-top-right-radius:5px}
        #cal .header .button:hover{cursor:pointer;}
        /*month label*/
        #cal .header .month-year{letter-spacing:1px;width:100%;text-align: center;}
        /*day headers---------------------*/
        .eformDayDisabled{background-color:#d3d3d3}
        #cal table{background:#fff;border-collapse:collapse}
        #cal td{color:#2b2b2b;width:55px;height:42px;line-height:30px;text-align:center;border:1px solid #e6e6e6;cursor:default;font-weight:200;}
        #cal #days td{height:26px;line-height:26px;text-transform:uppercase;font-size:12px;color:#9e9e9e;font-weight:200;}
        #cal td.footer{height:26px;line-height:26px;text-transform:uppercase;font-size:12px;color:#9e9e9e;font-weight:200;}
        #cal #days td:not(:last-child){border-right:1px solid #fff}
        #cal #cal-frame td.today{background:#ededed;color:#8c8c8c;box-shadow:1px 1px 0 #fff inset;-moz-box-shadow:1px 1px 0 #fff inset;-webkit-box-shadow:1px 1px 0 #fff inset}
        #cal #cal-frame td:not(.nil):hover{color:#fff;background:#a6a6a6;}
        #cal #cal-frame td span{font-size:12px;position:relative}
        #cal #cal-frame td span:first-child{bottom:5px}
        #cal #cal-frame td span:last-child{top:0px}
        #cal #cal-frame table.curr{float:left}
        #cal #cal-frame table.temp{position:absolute}
        /*>>>Calendar styles*/
        .resetBtn{margin-left:10px;width:100%;margin-top:20px;}
        .hiddenTxt{display:none;}
    </style>
    <script type="text/javascript">
        function extendJquery()
        {
            $.extend({
                ajax: function (propsObj) {
                    var xhttp = new XMLHttpRequest();
                    xhttp.onreadystatechange = function () {
                        var XMLHttpRequestIsFinishedAndResponseIsReady = 4
                        var ok = 200;
                        var undefinedStatus = 0;
                        if (this.readyState == XMLHttpRequestIsFinishedAndResponseIsReady) {
                            if (this.status == ok) {
                                var jObj = this.responseText;
                                try {
                                    jObj = JSON.parse(this.responseText);
                                } catch (ex) { }
                                if (typeof propsObj["success"] != "undefined") {
                                    propsObj["success"](jObj, ok, xhttp);
                                }
                            } else if (this.status != undefinedStatus) {
                                if (typeof propsObj["error"] != "undefined") {
                                    propsObj["error"](this.responseText, this.status, xhttp);
                                }
                            }
                        }
                    };
                    var async = true;
                    if (typeof propsObj["async"] != "undefined") {
                        if (!isTrue(propsObj["async"])) async = false;
                    }
                    //         method            url              async
                    xhttp.open(propsObj["type"], propsObj["url"], async);
                    //process headers
                    for (var prop in propsObj["headers"]) {
                        if (propsObj["headers"].hasOwnProperty(prop)) xhttp.setRequestHeader(prop, propsObj["headers"][prop]);
                    }
                    if (typeof propsObj["dataType"] != "undefined") {
                        xhttp.setRequestHeader("Content-Type", propsObj["dataType"]);
                    }
                    if (typeof propsObj["data"] != "undefined") {
                        xhttp.send(propsObj["data"]);
                    } else {
                        xhttp.send();
                    }
                }
            });
        }
        //calendar code<<<
        function fmtInpDate(dateObj) {
            //format=yyyy-MM-dd
            return dateObj.getFullYear() + '-' + (dateObj.getMonth() + 1) + '-' + dateObj.getDate();
        }
        function parseDate(str) {
            //format=MM.dd.yyyy
            var mdy = str.split('.');
            return new Date(mdy[0], mdy[1] - 1, mdy[2]);
        }
        function updateDate() {
            //override this
        }
        var gladCal = (function () {
            var wrap, label, calYear, calMonth, calDateFormat, firstDay, isIE11;
            isIE11 = !!window.MSInputMethodContext && !!document.documentMode;
            //check global variables for calendar widget and set default localization values
            if (window.months === undefined) {
                window.months=["<asp:Localize runat="server" meta:resourcekey="str_caljan">January</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calfeb">February</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calmar">March</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calapr">April</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calmay">May</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caljun">June</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caljul">July</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calaug">August</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsep">September</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caloct">October</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calnov">November</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caldec">December</asp:Localize>"];
            }
            if (window.shortDays === undefined) {
                window.shortDays=["<asp:Localize runat="server" meta:resourcekey="str_calmon">MON</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_caltue">TUE</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calwed">WED</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calthu">THU</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calfri">FRI</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsat">SAT</asp:Localize>","<asp:Localize runat="server" meta:resourcekey="str_calsun">SUN</asp:Localize>"];
            }
            //first day of week combinations array
            var firstDayCombinations = [[0, 1, 2, 3, 4, 5, 6], [1, 2, 3, 4, 5, 6, 0], [2, 3, 4, 5, 6, 0, 1], [3, 4, 5, 6, 0, 1, 2], [4, 5, 6, 0, 1, 2, 3], [5, 6, 0, 1, 2, 3, 4], [6, 0, 1, 2, 3, 4, 5]];
            //DOM strings helper
            var DOMstrings = { divCal: "cal", divCalQ: "#cal", monthLabel: "label", btnPrev: "prev", btnNext: "next", sunLabel: "eformSun", monLabel: "eformMon", tueLabel: "eformTue", wedLabel: "eformWed", thuLabel: "eformThu", friLabel: "eformFri", satLabel: "eformSat", tdDay: ".eformDay" };
            //open function
            function open(dateFormat, x, y, firstDayOfWeek, minDate, maxDate, element, zindex) {
                //prevent to open more than one calendar
                if (document.getElementById('cal')) {
                    return false;
                }
                //init def props
                eFormMinimalDate = DateParse(minDate);
                eFormMaximalDate = DateParse(maxDate);
                //console.log("maxDate:")
                //console.log(eFormMaximalDate)
                eFormCalendarElement = element;
                firstDay = firstDayOfWeek;
                //set default first date of week
                if (firstDayOfWeek === undefined) {
                    firstDayOfWeek = 6;
                } else {
                    firstDayOfWeek -= 1;
                }
                //create html and push it into DOM
                var newHtml = '<div id="cal" style="top:' + y + 'px;left:' + x + 'px;z-index:' + zindex + ';"><div class="header topnavcolor"><span class="left button" id="prev">&lt;</span><span class="left hook"></span><span class="month-year" id="label">June 20&0</span><span class="right hook"></span><span class="right button" id="next">&gt;</span></div><table id="days"><tr><td id="eformSun">sun</td><td id="eformMon">mon</td><td id="eformTue">tue</td><td id="eformWed">wed</td><td id="eformThu">thu</td><td id="eformFri">fri</td><td id="eformSat">sat</td></tr></table><div id="cal-frame"><table class="curr"><tbody></tbody></table></div></div>';
                document.getElementsByTagName('body')[0].insertAdjacentHTML('beforeend', newHtml);
                calDateFormat = dateFormat;
                wrap = document.getElementById(DOMstrings.divCal);
                label = document.getElementById(DOMstrings.monthLabel);
                //register events
                document.getElementById(DOMstrings.btnPrev).addEventListener('click', function () { switchMonth(false); });
                document.getElementById(DOMstrings.btnNext).addEventListener('click', function () { switchMonth(true); });
                label.addEventListener('click', function () { switchMonth(null, new Date().getMonth(), new Date().getFullYear()); });
                //shorter day version labels
                var dayCombination = firstDayCombinations[firstDayOfWeek];
                document.getElementById(DOMstrings.sunLabel).textContent = window.shortDays[dayCombination[0]];
                document.getElementById(DOMstrings.monLabel).textContent = window.shortDays[dayCombination[1]];
                document.getElementById(DOMstrings.tueLabel).textContent = window.shortDays[dayCombination[2]];
                document.getElementById(DOMstrings.wedLabel).textContent = window.shortDays[dayCombination[3]];
                document.getElementById(DOMstrings.thuLabel).textContent = window.shortDays[dayCombination[4]];
                document.getElementById(DOMstrings.friLabel).textContent = window.shortDays[dayCombination[5]];
                document.getElementById(DOMstrings.satLabel).textContent = window.shortDays[dayCombination[6]];
                //fire initialization event trigger
                label.click();
            }
            //switches current month
            function switchMonth(next, month, year) {
                var curr = label.textContent.trim().split(' '), calendar, tempYear = parseInt(curr[1], 10);
                if (month === undefined) {
                    month = ((next) ? ((curr[0] === window.months[11]) ? 0 : months.indexOf(curr[0]) + 1) : ((curr[0] === window.months[0]) ? 11 : months.indexOf(curr[0]) - 1));
                }
                if (!year) {
                    if (next && month === 0) {
                        year = tempYear + 1;
                    } else if (!next && month === 11) {
                        year = tempYear - 1;
                    } else {
                        year = tempYear;
                    }
                }
                //set month and year for widget scope
                calMonth = month + 1;
                calYear = year;
                calendar = createCal(year, month);
                var curr = document.querySelector('.curr');
                curr.innerHTML = '';
                curr.appendChild(calendar.calendar());
                //disable days below minimal date
                if (eFormMinimalDate !== undefined) {
                    if (year < eFormMinimalDate.year || year <= eFormMinimalDate.year && month <= eFormMinimalDate.month - 1) {
                        var emptyCount = document.querySelector('.curr table').rows[0].querySelectorAll('td:empty').length;
                        var tdDisabled = document.querySelectorAll('.eformDay');
                        for (var i = 0; i < tdDisabled.length; ++i) {
                            if (i - emptyCount + 1 < eFormMinimalDate.day || month < eFormMinimalDate.month - 1 || year < eFormMinimalDate.year) {
                                tdDisabled[i].classList.add('eformDayDisabled');
                                tdDisabled[i].onclick = function () {
                                    return false;
                                }
                            }
                        }
                    }
                }
                //disable days above maximum date				
                if (eFormMaximalDate !== undefined) {
                    if (year > eFormMaximalDate.year || year >= eFormMaximalDate.year && month >= eFormMaximalDate.month - 1) {
                        var emptyCount = document.querySelector('.curr table').rows[0].querySelectorAll('td:empty').length;
                        var tdDisabled = document.querySelectorAll('.eformDay');
                        for (var i = 0; i < tdDisabled.length; ++i) {
                            if (i - emptyCount + 1 > eFormMaximalDate.day || month > eFormMaximalDate.month - 1 || year > eFormMaximalDate.year) {
                                tdDisabled[i].classList.add('eformDayDisabled');
                                tdDisabled[i].onclick = function () {
                                    return false;
                                }
                            }
                        }
                    }
                }
                label.textContent = calendar.label;
            }
            //main calendar function. Creates calendar itself and stores into cache
            function createCal(year, month) {
                var day = 1, i, j, haveDays = true,
                    startDay = new Date(year, month, day).getDay(),
                    daysInMonths = [31, (((year % 4 == 0) && (year % 100 != 0)) || (year % 400 == 0)) ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31],
                    calendar = [];
                startDay -= firstDay;
                if (startDay < 0) {
                    startDay = 7 + startDay;
                }
                if (createCal.cache[year] && !isIE11) {
                    if (createCal.cache[year][month]) {
                        return createCal.cache[year][month];
                    }
                } else {
                    createCal.cache[year] = {};
                }
                i = 0;
                while (haveDays) {
                    calendar[i] = [];
                    for (j = 0; j < 7; j++) {
                        if (i === 0) {
                            if (j === startDay) {
                                calendar[i][j] = day++;
                                startDay++;
                            }
                        } else if (day <= daysInMonths[month]) {
                            calendar[i][j] = day++;
                        } else {
                            calendar[i][j] = '';
                            haveDays = false;
                        }
                        if (day > daysInMonths[month]) {
                            haveDays = false;
                        }
                    }
                    i++;
                }
                for (i = 0; i < calendar.length; i++) {
                    calendar[i] = '<tr><td class="eformDay" onclick="gladCal.dayClick(this)">' + calendar[i].join('</td><td class="eformDay" onclick="gladCal.dayClick(this)">') + '</td></tr>';
                }
                var timePicker = '<tr><td class="" colspan="7"><div id="timeRow"><div><%=LocHor.Text %></div><div><select id="selHour">';//Hour
                for (i = 0; i < 24; i++) {
                    timePicker += '<option value="' + twoDigitStr(i) + '">' + twoDigitStr(i) + '</option>';
                } 
                timePicker += '</select></div><div><%=LocMin.Text %></div><div><select id="selMin">';//Minutes
                for (i = 0; i <= 5; i++) {
                    var mins = i * 10;
                    timePicker += '<option value="' + twoDigitStr(mins) + '">' + twoDigitStr(mins) + '</option>';
                } 
                timePicker += '</select></div><div id="selBtn" class="btn btn-primary gladbtn gladbtn" onclick="gladCal.selDateAndTime()"><%=LocSel.Text %></div></div>';//SELECT

                var customFooter = timePicker + '<tr><td class="footer" onclick="gladCal.neverClick()" colspan="7"><asp:Localize meta:resourcekey="str_nvr" runat="server">NEVER</asp:Localize></td></tr>';
                var calendarInnerHtml = calendar.join('');
                calendar = document.createElement('table');
                calendar.className = 'curr';
                calendar.innerHTML = calendarInnerHtml + customFooter;
                var tdEmty = calendar.querySelectorAll('td:empty');
                for (var i = 0; i < tdEmty.length; ++i) {
                    tdEmty[i].classList.add('nil');
                }
                if (month === new Date().getMonth()) {
                    var calTd = calendar.querySelectorAll('td');
                    var calTdArray = Array.prototype.slice.call(calTd);
                    calTdArray.forEach(function (current, index, array) {
                        if (current.innerHTML === new Date().getDate().toString()) {
                            current.classList.add('today');
                        }
                    });
                }
                createCal.cache[year][month] = { calendar: function () { return calendar }, label: months[month] + ' ' + year };
                return createCal.cache[year][month];
            }
            createCal.cache = {};
            //day click event function => than close
            var dayClick = function (element) {
                if (element.innerHTML == "") {
                    return;
                }
                var dateResult = DateToString(new Date(calYear, calMonth - 1, parseInt(element.innerHTML)), calDateFormat);    
                $(".eformDay.topnavcolor").removeClass("topnavcolor");
                $(element).addClass("topnavcolor");  
                document.getElementById(eFormCalendarElement).value = dateResult;  
            }        
            var selDateAndTime = function () {    
                if ($(".eformDay.topnavcolor").length == 0) {        
                    $('#MsgBody').html("<%=LocPleSelDay.Text %>");//Please select a day.
                    $('#MsgWindowModal').modal({ backdrop: 'static', keyboard: false });
                    return;
                }                         
                var hour = parseInt(document.getElementById("selHour").value);
                var min = parseInt(document.getElementById("selMin").value);
                var arr = [];
                var val = document.getElementById(eFormCalendarElement).value;                
                if (val.indexOf(" ")>-1) {
                    val = val.split(" ")[0]; //example: 2022-06-10 07:10:00Z 
                }
                if (val.indexOf(".")>-1) {
                    arr = val.split("."); //example: 2022.12.01 
                } else if (val.indexOf("-")>-1){
                    arr = val.split("-"); //example: 2022-06-10 07:10:00Z
                }
                var year = parseInt(arr[0]);
                var month = parseInt(arr[1]);
                var day = parseInt(arr[2]);
                                                
                
                var selDate = new Date();
                var currDate = new Date();
                try {
                    selDate = new Date(year, month-1, day, hour, min);
                } catch (ex) {
                    selDate = new Date();
                }
                var diff = selDate - currDate;                     
                var totalDays = Math.floor(diff/(24*60*60*1000));   
                var totalHours = Math.floor(diff/(60*60*1000)) - (totalDays * 24);   
                var totalMinutes = Math.floor(diff / (60 * 1000));
                                                    
                console.log("current date: "+currDate);   
                console.log("selected date: "+selDate);                                                                
                console.log("total days to expiration: "+totalDays);  
                console.log("total hours to expiration: "+totalHours);  
                console.log("total minutes to expiration: "+totalMinutes);
                
                if (totalMinutes <= 0) {                             
                    $('#MsgBody').html("<%=LocPleSelTimInFut.Text %>");//Please select a time in the future.
                    $('#MsgWindowModal').modal({ backdrop: 'static', keyboard: false });
                    return;
                }

                updateDate(year, month, day, hour, min);
            } 
            var neverClick = function () {
                updateDate(2999,12,31,0,0);
            }
            // join
            function joinObj(obj, seperator) {
                var out = [];
                for (k in obj) {
                    out.push(k);
                }
                return out.join(seperator);
            }
            //returns string in desired format
            function DateToString(inDate, formatString) {
                var dateObject = { M: inDate.getMonth() + 1, d: inDate.getDate(), D: inDate.getDate(), h: inDate.getHours(), m: inDate.getMinutes(), s: inDate.getSeconds(), y: inDate.getFullYear(), Y: inDate.getFullYear() };
                // Build Regex Dynamically based on the list above.
                // Should end up with something like this "/([Yy]+|M+|[Dd]+|h+|m+|s+)/g"
                var dateMatchRegex = joinObj(dateObject, "+|") + "+";
                var regEx = new RegExp(dateMatchRegex, "g");
                formatString = formatString.replace(regEx, function (formatToken) {
                    var datePartValue = dateObject[formatToken.slice(-1)];
                    var tokenLength = formatToken.length;
                    if (formatToken === 'MMMM') {
                        return window.months[dateObject.M - 1];
                    }
                    // A conflict exists between specifying 'd' for no zero pad -> expand to '10' and specifying yy for just two year digits '01' instead of '2001'.  One expands, the other contracts.
                    // so Constrict Years but Expand All Else
                    if (formatToken.indexOf('y') < 0 && formatToken.indexOf('Y') < 0) {
                        // Expand single digit format token 'd' to multi digit value '10' when needed
                        var tokenLength = Math.max(formatToken.length, datePartValue.toString().length);
                    }
                    var zeroPad;
                    try {
                        zeroPad = (datePartValue.toString().length < formatToken.length ? "0".repeat(tokenLength) : "");
                    } catch (ex) {//IE11 repeat catched
                        zeroPad = (datePartValue.toString().length < formatToken.length ? repeatStringNumTimes("0", tokenLength) : "");
                    }
                    return (zeroPad + datePartValue).slice(-tokenLength);
                });
                return formatString;
            }
            Date.prototype.ToString = function (formatStr) { return DateToString(this.toDateString(), formatStr); }
            //IE11 repeat alternative
            function repeatStringNumTimes(string, times) {
                var repeatedString = "";
                while (times > 0) {
                    repeatedString += string;
                    times--;
                }
                return repeatedString;
            }
            //close event function (fadeout)
            function close() {
                updateDate();
                fadeOutEffect(DOMstrings.divCalQ, remove);
            }
            function closeWithoutUpdating() {
                fadeOutEffect(DOMstrings.divCalQ, remove);
            }
            //remove calendar box
            var remove = function () {
                try {
                    document.getElementById(DOMstrings.divCal).remove();
                } catch (ex) {//ie11 fix
                    var child = document.getElementById(DOMstrings.divCal);
                    child.parentNode.removeChild(child);
                }
            }
            //parse date
            function DateParse(date) {
                var parsedDate, newDate;
                var currentDate = date;
                if (currentDate != null) {
                    splitedDate = currentDate.split('-');
                    newDate = { year: splitedDate[0], month: splitedDate[1], day: splitedDate[2] };
                }
                return newDate;
            }
            //function accesibility
            return { open: open, switchMonth: switchMonth, createCal: createCal, dayClick: dayClick, close: close, closeWithoutUpdating: closeWithoutUpdating, neverClick: neverClick, selDateAndTime: selDateAndTime };
        })();
        //plain javascript fadeout alternative
        function fadeOutEffect(t, e) { var a = document.querySelector(t); if (null != a) var c = setInterval(function () { a.style.opacity || (a.style.opacity = 1), 0 < a.style.opacity ? a.style.opacity -= .1 : (clearInterval(c), e()) }, 20) }
        /*MIT License. Copyright (c) 2018 Josef Brož. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
        The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.*/
        //>>>calendar code
        </script>    
        <script type="text/javascript">
        var _calTopMargin = 80;
        var _oldOnload = window.onload;
        window.onload = function(){
            if(_oldOnload) _oldOnload();
            <% if (!"1".Equals(Request.QueryString["editmode"])) { %>
            setParentFrameTitle("<asp:Localize meta:resourcekey="str_shrNme" runat="server">Share Name:</asp:Localize> <%=LtlShareName.Text%>");
            <% } %>
            //fix for tooltips to work inside of popovers
            $('body').tooltip( {selector: '[data-toggle=tooltip]'} );
            //initialize tooltips
            $('[data-toggle="tooltip"]').tooltip();
            var recTabIsSelected = $("#<%=liTab0.ClientID%>").hasClass("gladtab_lg_active");
            var expDateTabIsSelected = $("#<%=liTab1.ClientID%>").hasClass("gladtab_lg_active");
            var reqLnkExpDateTabIsSelected = $("#<%=liTab5.ClientID%>").hasClass("gladtab_lg_active");
            var pubLnkExpDateTabIsSelected = ($("#pubLnkCtls").length==1);
            var shareNameEditorIsVisible = ($("#<%=TxtShareName.ClientID%>").length==1);
            if(expDateTabIsSelected || reqLnkExpDateTabIsSelected || pubLnkExpDateTabIsSelected){
                if(shareNameEditorIsVisible){
                    _calTopMargin = 90;
                }
            }
            if (recTabIsSelected) {
                $("#divEditShareNameRow").hide();
                $("#ShortTitle", parent.document).show();
            } else {
                if (shareNameEditorIsVisible) {
                    $("#divEditShareNameRow").show();
                    $("#ShortTitle", parent.document).hide();
                } else {   
                    $("#divEditShareNameRow").hide();
                    $("#ShortTitle", parent.document).show();
                }
            }
            if(expDateTabIsSelected){
                var hidDefShrDys = $("#<%=HidDefShrExp.ClientID%>").val();
                if(hidDefShrDys!=""){
                    var numberOfDaysToAdd = parseInt(hidDefShrDys);
                    var curDate = new Date();
                    curDate.setDate(curDate.getDate() + numberOfDaysToAdd);
                    $("#<%=HidExpires.ClientID%>").val(fmtInpDate(curDate)); //example:2022.06.18 16:21:48.000
                }
                else
                {
                    var minDate = new Date(Date.now());
                    //default maximum date is one year into the future
                    var maxDate = new Date(new Date().setFullYear(new Date().getFullYear() + 1));
                    var hidMaxShrDys = $("#<%=HidMaxShrExp.ClientID%>").val();
                    if (hidMaxShrDys != "" && parseInt(hidMaxShrDys) > 0) {
                        maxDate = new Date();
                        var numberOfDaysToAdd = parseInt(hidMaxShrDys);
                        maxDate.setDate(maxDate.getDate() + numberOfDaysToAdd);
                    }
                    var calLeftMargin = 20;
                    gladCal.open('yyyy.MM.dd', calLeftMargin, _calTopMargin, 1, fmtInpDate(minDate), fmtInpDate(maxDate), "<%=HidExpires.ClientID%>", 1000);
                }
            }
            if(reqLnkExpDateTabIsSelected){
                var calLeftMargin = 20;
                gladCal.open('yyyy.MM.dd', calLeftMargin, _calTopMargin, 1, fmtInpDate(minDate), fmtInpDate(maxDate), "<%=HidReqFilExpires.ClientID%>", 1000);
            }
            if(pubLnkExpDateTabIsSelected){
                togglePublicLink(document.getElementById("<%=ChkEblPubLnk.ClientID%>"));
            }
            $(".updatable input:checkbox,.updatable input:radio,.userInp").each(function () {
                $(this).after("<input type='hidden' id='oldval_" + $(this)[0].id + "' value='" + $(this)[0].checked + "' />");
            });
            $(".updatable input:checkbox,.updatable input:radio").each(function () {
                $(this).click(function () {
                    checkableValueChanged($(this)[0]);
                })
            });
            $(".userInp").each(function () {
                $(this).keyup(function (event) {
                    textValueChanged($(this)[0]);
                })
            });
            if ($(".rptRow").length == 0) {
                $("#TblRecipients").hide();
            }
            extendJquery();
        };
        <%//=======================================================================================================================================
          //======================================================================================================================================= %>
            function editShareACL(PkId, email) {
            $("#<%=HidEditPkId.ClientID%>").val(PkId);
            $("#<%=HidEditEmail.ClientID%>").val(email.toLowerCase().trim());
            $("#<%=BtnEdtUsr.ClientID%>")[0].click();
        }
        function sendShareEmail(PkId,email,perm) {
            $("#<%=HidSendEmailPkId.ClientID%>").val(PkId);
            $("#<%=HidSendEmailEmail.ClientID%>").val(email.toLowerCase().trim());
            if(perm=="<%=LocFilReq.Text%>"){
                $("#<%=BtnSendReqFileEmail.ClientID%>")[0].click();
            }else{
                $("#<%=HidEditPkId.ClientID%>").val(PkId);
                $("#<%=HidEditEmail.ClientID%>").val(email.toLowerCase().trim());
                $("#<%=BtnSendEmail.ClientID%>")[0].click();
            }
        }
        function deleteIt(pkid,email,perm) {
            if(perm=="<%=LocFilReq.Text%>"){
                deleteFileRequest(pkid,email);
            }
            else
            {
                deleteShareACL(email);
            }
        }
        function deleteShareACL(email) {
            $("#<%=HidDeletePkId.ClientID%>").val("");
            $("#<%=HidEditEmail.ClientID%>").val(email.toLowerCase().trim());
            $("#<%=HidDeleteEmail.ClientID%>").val(email.toLowerCase().trim());
            $("#<%=BtnDltUsr.ClientID%>")[0].click();
        }
        function deleteFileRequest(pkid,email) {
            $("#<%=HidDeletePkId.ClientID%>").val(pkid);
            $("#<%=HidEditEmail.ClientID%>").val("");
            $("#<%=HidDeleteEmail.ClientID%>").val(email.toLowerCase().trim());
            $("#<%=BtnDltUsr.ClientID%>")[0].click();
        }
        function OnSaveChanges() {
            $("#<%=BtnPostBack.ClientID%>")[0].click();
        }
        function OnCancelChanges() {
            $("#SaveBtnDiv1").hide();
        }
        function setParentFrameTitle(str){
            $("#ShortTitle", parent.document).html(str);
        }
        var _reqFilCalIsOpen = false;
        var _publicLinkCalIsOpen = false;
        function forceClosePubLnkCal(){
            _publicLinkCalIsOpen = false;
            gladCal.closeWithoutUpdating();
        }
        function forceCloseReqFilCal(){
            _reqFilCalIsOpen = false;
            gladCal.closeWithoutUpdating();
        }
        function twoDigitStr(num) {
            if (num < 10) {
                return "0" + num;
            }
            return num;
        }
        function getLocalizedText(numDays, numHours, numMins) {
            var template = "<%=LocDayHouMin.Text%>";//{$DYS} Day(s), {$HRS} Hour(s), {$MNS} Minute(s)
            return template.replace("{$DYS}",numDays).replace("{$HRS}",numHours).replace("{$MNS}",numMins);
        }
        function updateDate(yearInt, monthInt, dayInt, hourInt, minInt) {    
            var hidObjID = "<%=HidExpires.ClientID%>";
            if (_publicLinkCalIsOpen) {
                hidObjID = "<%=HidPubLnkExpires.ClientID%>";
            }else if (_reqFilCalIsOpen) {
                hidObjID = "<%=HidReqFilExpires.ClientID%>";
            }
            var selDate = new Date(yearInt, monthInt-1, dayInt, hourInt, minInt);   
            var currDate = new Date();
            var diff = selDate - currDate; 
            var numDays = Math.floor(diff/(24*60*60*1000));   
            var numHours = Math.floor(diff/(60*60*1000)) - (numDays * 24);   
            var numMins = Math.floor(diff/(60*1000)) - (numDays * 24 * 60) - (numHours * 60);  
            if (numDays >= 1850) {                                                                            
                $("#"+hidObjID+"_expiresDisplay").html("<asp:Localize ID="LocExpNvr" meta:resourcekey="str_expNvr" runat="server">Expires NEVER</asp:Localize>");
            } else {  
                $("#"+hidObjID+"_expiresDisplay").html(getLocalizedText(numDays, numHours, numMins));
            } 
            //convert selected date to the format for the database, which is UTC. Example: 2022-06-04 04:39:23Z 
            var selDateUtcStr = selDate.getUTCFullYear() + "-" + twoDigitStr(selDate.getUTCMonth() + 1) + "-" + twoDigitStr(selDate.getUTCDate()) + " " + twoDigitStr(selDate.getUTCHours()) + ":" + twoDigitStr(selDate.getUTCMinutes()) + ":00Z";
            if (_publicLinkCalIsOpen) {
                $("#<%=HidPubLnkExpires.ClientID%>").val(selDateUtcStr);
            } else if (_reqFilCalIsOpen) {
                $("#<%=HidReqFilExpires.ClientID%>").val(selDateUtcStr);
            } else {    
                $("#<%=HidExpires.ClientID%>").val(selDateUtcStr);
            }

            $("#SaveBtnDiv1").show();
            if(hidObjID.indexOf("ReqFil")>-1 || hidObjID.indexOf("PubLnk")>-1){
                forceClosePubLnkCal();
            }
        }
        function isTrue(strBool){
            if(strBool==null){
                return false;
            }
            if(strBool.toLowerCase()=="true"){
                return true;
            }else{
                return false;
            }
        }
        function checkableValueChanged(obj) {
            if (obj.checked != isTrue($("#oldval_" + obj.id).val())) {
                $("#SaveBtnDiv1").show();
            }
        }
        function textValueChanged(obj) {
            if (obj.value != $("#oldval_" + obj.id).val()) {
                $("#SaveBtnDiv1").show();
            }
        }
        function encodeVal(id){
            var obj = document.getElementById(id);
            if(obj && obj.value){
                obj.style.display = "none";
                if(obj.disabled){
                    obj.disabled = false;
                }
                obj.value = gEncodeUri(obj.value.toLowerCase().trim());
                console.log("===encoded", obj.value);
            }
        }
        function encodeAllEmails(){
            //encode all email values if present, before every postback, so special characters are not lost during transmission
            encodeVal("<%=HidSendEmailEmail.ClientID %>");
            encodeVal("<%=HidEditEmail.ClientID %>");
            encodeVal("<%=HidDeleteEmail.ClientID %>");
            encodeVal("<%=TxtReqEml.ClientID %>");
            encodeVal("<%=TxtNewRecipient.ClientID %>");
        }
        function checkIfUnsaved(tabIndex) {
            encodeAllEmails();

            var isNotRequestFileNorPublicLinkTab = (tabIndex < 5);
            if (isNotRequestFileNorPublicLinkTab && $("#ctl00_MainContent_liTab" + tabIndex).hasClass("tabDisabled")) {
                return false;
            }
            if ($("#SaveBtnDiv1").is(":visible")) {
                modalMessage("<asp:Localize meta:resourcekey="str_usdChgDtd" runat="server">Unsaved Changes Detected</asp:Localize>", "<asp:Localize meta:resourcekey="str_plsSavChg" runat="server">Please save your changes before continuing.</asp:Localize>");
                return false;
            }
            return true;
        }
        function checkIfUserExists() {
            var email = $("#<%=TxtNewRecipient.ClientID%>").val();
            if (email != "") {
                if(email.indexOf("[")==0 && email.indexOf("]")>1){
                    if(email=="[<%=LocAllTntAdm.Text%>]"){
                        email = "#tadmins@groups";
                    }else{
                        var tmpstr = email.replace("] ","]");
                        var parts = tmpstr.split("]");
                        if(parts.length==2){
                            email = parts[1]+"@groups";
                        }else{
                            email = email+"@groups";
                        }
                    }
                }
                $.ajax({
                    type: "GET",
                    url: "?tryemail=" + gEncodeUri(email),
                    success: function (data, status, request) {
                        if (data == "yes") {
                            document.getElementById('<%=ChkCreateGuestUserAccount.ClientID%>').checked = false;
                            $("#<%=BtnAddShr.ClientID%>")[0].click();
                        } else if (data == "banned") {
                            modalMessage("<asp:Localize ID="LocErr" meta:resourcekey="str_err" runat="server">Error</asp:Localize>", "<%=LocDomDisByAdm.Text %>"); //Sharing with this domain has been disabled by the administrator.
                        } else if (data == "bannednonad") {
                            modalMessage("<%=LocErr.Text %>", "<%=LocNonADDisByAdm.Text %>"); //Sharing with users from outside of the Active Directory has been disabled by the administrator.
                        } else {
                            modalCofirmation("<asp:Localize meta:resourcekey="str_cfr" runat="server">Confirm</asp:Localize>", "<asp:Localize meta:resourcekey="str_thsEmlIsNotRgd" runat="server">This email has not been registered.</asp:Localize>");
                        }
                    },
                    error: function (xhr, status, error) {
                        modalMessage("<asp:Localize meta:resourcekey="str_err" runat="server">Error</asp:Localize>", "<asp:Localize meta:resourcekey="str_cntVrfEml" runat="server">Cannot verify email address.</asp:Localize> " + error);
                    }
                });
            }
            return true;
        }    
        function modalCofirmation(title, message) {
            $('#CfmTitle').html(title);
            $('#CfmMsg').html(message);
            $('#CfmWindowModal').modal({ backdrop: 'static', keyboard: false });
        }
        function modalSaveCofirmation() {
            $('#CfmSaveChanges').modal({ backdrop: 'static', keyboard: false });
        }
        function modalMessage(title,message) {
            $('#MsgTitle').html(title);
            $('#MsgBody').html(message);
            $('#MsgWindowModal').modal({ backdrop: 'static', keyboard: false });
        }
        var _sawUserUnregisterWarning = false;
        function userUnregisterWarning() {
            try{
                if(!_sawUserCreationWarning){
                    if($("#<%=RdoRcpMstLgn.ClientID %>")[0].checked){
                        if(!$("#<%=RdoRcpMstLgn.ClientID %>")[0].disabled && $("#<%=RdoNoPrt.ClientID %>")[0].disabled){
                            _sawUserUnregisterWarning = true;
                            modalMessage("<%=LocIvlAct.Text.Replace("\"","&quot;") %>","<%=LocYouCntConRegAcc.Text.Replace("\"","&quot;") %>");
                        }
                    }
                }
            }catch(ex){}
        }
        var _sawUserCreationWarning = false;
        function userCreationWarning() {
            try{
                if(!_sawUserCreationWarning){
                    if("<%=_UserIsRegistered %>"=="false"){
                        if($("#<%=RdoRcpMstLgn.ClientID %>")[0].checked){
                            if(!$("#<%=RdoRcpMstLgn.ClientID %>")[0].disabled){
                                _sawUserCreationWarning = true;
                                modalMessage("<%=LocWrn.Text.Replace("\"","&quot;") %>","<%=LocGueUseWilBeCre.Text.Replace("\"","&quot;") %>");
                            }
                        }
                    }
                }
            }catch(ex){}
        }
        function stripEmail(obj){
            var val = obj.value;
            if(val.indexOf("(")>-1 && val.indexOf(")")>-1){
                var strInParRegExp = /\(([^)]+)\)/;
                var matches = strInParRegExp.exec(val);
                if(matches.length>0){
                    obj.value = matches[1];
                }
            }
        }
        function togglePublicLink(objRef){
            if(objRef.checked){
                $("#ChkPubLnkViwOly").prop("disabled", false);
                $("#pubLnkCtls").show();
                $(".TxtPubLnk").show();
                $("#pubLnkCpyBtn").show();
            }else{
                
                $("#ChkPubLnkViwOly").prop("disabled", true);
                $("#pubLnkCtls").hide();
                $(".TxtPubLnk").hide();
                $("#pubLnkCpyBtn").hide();
                forceClosePubLnkCal();
            }
        }
        function toggleReqFilCal(){
            if(_reqFilCalIsOpen){
                forceCloseReqFilCal();
            }else{
                _reqFilCalIsOpen = true;   
                var minDate = new Date(Date.now());
                //default maximum date is one year into the future
                var maxDate = new Date();
                maxDate.setDate(maxDate.getDate() + 9999);  
                var calLeftMargin = 180;
                gladCal.open('yyyy.MM.dd', calLeftMargin, _calTopMargin, 1, fmtInpDate(minDate), fmtInpDate(maxDate), "<%=HidReqFilExpires.ClientID%>", 1000);   
              
            }
        }
        function togglePublicLinkCal(){
            if(_publicLinkCalIsOpen){
                forceClosePubLnkCal();
            }else{
                _publicLinkCalIsOpen = true;   
                var minDate = new Date(Date.now());
                //default maximum date is one year into the future
                var maxDate = new Date(new Date().setFullYear(new Date().getFullYear() + 1));
                var hidPubLnkMaxExpDays = $("#<%=HidPubLnkMaxExpDays.ClientID%>").val();
                if (hidPubLnkMaxExpDays != "" && parseInt(hidPubLnkMaxExpDays) > 0) {
                    maxDate = new Date();
                    var numberOfDaysToAdd = parseInt(hidPubLnkMaxExpDays);
                    maxDate.setDate(maxDate.getDate() + numberOfDaysToAdd);  
                    var calLeftMargin = 220;
                    gladCal.open('yyyy.MM.dd', calLeftMargin, _calTopMargin, 1, fmtInpDate(minDate), fmtInpDate(maxDate), "<%=HidPubLnkExpires.ClientID%>", 1000);   
                }
            }
        }
        function copyRequestFileLink(){
            copyToClipboard($(".TxtReqFilLnk").val(),"reqFilCopiedStatus");
        }
        function copyLinkFromRecipients(url,idForStatus){
            copyToClipboard(url,idForStatus);
        }
        function copyPubLink(){
            copyToClipboard($(".TxtPubLnk").val(),"pubLnkCopiedStatus");
        }
        function copyToClipboard(text, dspId) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    displayCopyStatus(dspId, "<asp:Localize meta:resourcekey="str_copScs" runat="server">Copied successfully</asp:Localize>");
                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        displayCopyStatus(dspId, "Link copied to clipboard");
                    } catch (ex) {
                        displayCopyStatus(dspId, "Copy to clipboard failed. ", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }
        function displayCopyStatus(dspId,str){
            $("#"+dspId).text(str);
            setTimeout(function(){
                $("#"+dspId).text("");
            },3000);
        }
        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace(/\+/g, ':').replace(/'/g, '^');
            return s;
        }
        function goToCreateSharePage(){
            var uri = "/portal/AddSharePage.aspx?sd=1&src=browser&location=";
            uri += gEncodeUri("<%=LtlFullPath.Text%>");
            if (location.href.toLowerCase().indexOf("isfld=true")>-1) {
                uri += "&folder=true";
            } else {
                uri += "&folder=false";
            }
            $("#ShortTitle",parent).html("Share '<%=LtlShareName.Text%>'");
            location.href = uri;
        }
        function goToRequestFile(){
            var uri = gEncodeUri("<%=LtlFullPath.Text%>");
            if (location.href.toLowerCase().indexOf("isfld=true")>-1) {
                uri += "&folder=true";
            } else {
                uri += "&folder=false";
            }
            location.href="/portal/AddSharePage.aspx?l=2&src=browser&location="+uri;
        }
        function goToPublicLink(){
            var uri = gEncodeUri("<%=LtlFullPath.Text%>");
            if (location.href.toLowerCase().indexOf("isfld=true")>-1) {
                uri += "&folder=true";
            } else {
                uri += "&folder=false";
            }
            location.href="/portal/AddSharePage.aspx?l=1&src=browser&location="+uri;

        }
        function changeSendEmailButtonText(){
            setTimeout(function(){
                var isGuestUser = $("#<%=ChkCreateGuestUserAccount.ClientID%>")[0].checked;
                if(isGuestUser){
                    $(".sendEmailButton label").text($("#guestUserEmailMessage").text());
                }else{
                    $(".sendEmailButton label").text($("#externalUserEmailMessage").text());
                }
            },500);
        }
        function toggleCustomPassword(){
            setTimeout(function(){
                if($(".systemPasswordRow input")[0].checked){
                    $("#<%=TxtCstPwd.ClientID%>").val("");
                    $("#customPasswordRow").hide();
                }else{
                    $("#customPasswordRow").show();
                }
            },500);
        }
        function toggleSystemPassword(){
            if($("#<%=TxtCstPwd.ClientID%>").val().length>0){
                $(".systemPasswordRow input")[0].checked = false;
                $(".systemPasswordRow").hide();
            }else{
                $(".systemPasswordRow").show();
            }
        }
        function copyShareLink() {
            var e = document.getElementById("DivShareLink");
            copyToClipboard(e.innerHTML.trim());
            
        }   
        function copyToClipboard(text) {
            try {
                if (window.clipboardData && window.clipboardData.setData) {
                    // IE specific code path to prevent textarea being shown while dialog is visible.
                    clipboardData.setData("Text", text);
                    alert("Link copied to clipboard");

                } else if (document.queryCommandSupported && document.queryCommandSupported("copy")) {
                    var textarea = document.createElement("textarea");
                    textarea.textContent = text;
                    textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
                    document.body.appendChild(textarea);
                    textarea.select();
                    try {
                        document.execCommand("copy"); // Security exception may be thrown by some browsers.
                        alert("Link copied to clipboard");
                    } catch (ex) {
                        console.warn("Copy to clipboard failed.", ex);
                        return false;
                    } finally {
                        document.body.removeChild(textarea);
                    }
                }
            } catch (e) {

            }
        }  
        function resetPage() {
            var currUrl = location.href + "&rnd=" + Math.random();
            location.href = currUrl;
        }   
        var oold = window.onload;
        window.onload = function(){
            if(oold) oold();
            try{
                document.forms[0].addEventListener('submit', encodeAllEmails);
            }catch(ex){
                console.log(ex);
            }
        }
        
    </script>
    <style type="text/css">         
    #timeRow{display:flex;gap: 10px;align-items: center;margin-left: 10px;height:60px;margin-top:0px;}   
    #selHour{padding: 0 15px 0 15px;border:1px solid lightgray;}   
    #selMin{padding: 0 15px 0 15px;border:1px solid lightgray;}
    #selBtn {margin-top:5px;height:35px;border-radius:0px;padding-top:4px;}
    .eformDay.topnavcolor{color:#FFF !important;}
    main{padding:0px 30px 0px 10px;margin-top:0px;font-family:roboto,helvetica,arial,verdana,sans-serif;color:gray}
    nav{border-bottom:1px solid #ccc}
    header{padding-bottom:10px;padding-left:10px;}
    h1{font-size:24px}
    h2{margin-bottom:15px}
    ul.viewTabs{padding:0 0 0 10px;width:100%;margin-bottom:-1px}
    ul.viewTabs li{display:inline-block}
    ul.viewTabs li.gladtab_lg_active{width:auto;border-bottom:1px solid #FFF!important}
    ul.viewTabs li.gladtab_lg_inactive{width:auto}
    ul.viewTabs li.gladtab_lg_ends{border-bottom:none}
    section{width:100%;padding:20px 0}
    .fullWidth{width:99%;max-width:800px;margin-left:20px}
    .halfWidth{width:50%;max-width:380px;float:left}
    .sixtyPerWidth{width:60%;max-width:480px;float:left}
    .fortyPerWidth{width:40%;max-width:320px;float:left}
    aside{width:50%;max-width:400px;float:right;padding:20px 0 20px 20px}
    .rcpInpRow{margin-top:20px;width:550px}
    .TxtNewRecipient{width:calc(100% - 70px);float:left;display:block;font-size:18px}
    input::placeholder{color:#d5d5d5!important;opacity:1}
    input:placeholder-shown{color:#d5d5d5!important;opacity:1}
    .addRcpBtn{float:right;margin-top:5px;width:60px}
    .hand{cursor:pointer!important}
    .gladinet-icons.md-36{line-height:36px}
    .gladinet-icons.md-24{line-height:24px;padding-right:5px}
    .txtNts{width:100%;height:100px;border: 1px solid lightgray;padding:10px;}
    .TxtReqEmlNts{width:100%;height:50px;border: 1px solid lightgray;padding:10px;}
    .TxtReqFilLnk{width:100%;height:200px;border: 1px solid lightgray;padding:10px;}
    .TxtPubLnk{width:100%;height:200px;border: 1px solid lightgray;padding:10px;}
    .containerWithVerticalSeparator{width:100%;padding-right:20px;border-right:1px gray dotted}
    #SaveBtnDiv1{float:right;position:absolute;bottom:50px;right:50px;z-index:9999;background:transparent;display:none}
    .fabBtn{border-radius:50%;width:50px;height:50px;box-shadow:3px 3px 3px #ccc;align-content:center;padding-top:10px;padding-left:9px}
    .savebtn{cursor:pointer!important}
    .errMsg{color:red;font-size:18px;padding-top:30px;padding-left:20px;}
    .sucssMsg{font-size:18px;padding-top:30px}
    .shareName,.customPassword{width:350px}
    .titleIco{position:relative;top:-2px}
    #TblRecipients{width:100%;}
    #TblRecipients tr td{height:45px;}
    #TblRecipients .rptHeaderRow td{font-size:16px;padding-top:20px;}
    .tabDisabled{opacity:0.3;}
    .gladtab_lg_inactive.tabDisabled{cursor:default !important;}
    .gladtab_lg_inactive.tabDisabled:before{height:0;}
    .gladtab_lg_inactive.tabDisabled:hover:before {height: 0;}
    .gladtab_lg_inactive.tabDisabled a{cursor:default !important;}
    .gladtab_lg_inactive.tabDisabled a:hover{text-decoration:none;}
    .reqFilBtn{margin-left:10px;background-color:#FFF;border:none;padding-right:0px !important;}
    .pubLnkBtn{margin-left:10px;background-color:#FFF;border:none;padding-right:0px !important;}
    .copiedStatus{font-style:italic;}
    .copiedStatus2{display:inline-block;position:relative;top:0;font-style:italic;padding:0px;}
    .reqFilBtn,.pubLnkBtn{margin-left:5px;margin-right:5px;}
    .btn.btn-primary{border:1px solid lightgray;border-radius:5px;margin-top:20px;}
    .row{align-items:flex-end;clear:both;}
    .row label{font-size:15px !important;}
    #calIcoReqFilLnk{margin-bottom:15px;}
    .customPassword{width:100%;}
    .editLnk_Expired,.editLnk_FileRequest,.emlLnk_Expired{visibility:hidden !important;}
    .cpyLnk_na{display:none !important;}
    .anonymousExternal_FileRequest{visibility:hidden;}
    </style>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">        
    <asp:Localize meta:resourcekey="str_dldScs" runat="server" id="LocDldScs" Visible="false">Deleted Successfully</asp:Localize>
    <asp:Localize meta:resourcekey="str_grp" runat="server" id="LocGrp" Visible="false">Group</asp:Localize>
    <asp:Localize meta:resourcekey="str_allTntAdm" runat="server" id="LocAllTntAdm" Visible="false">All Tenant Administrators</asp:Localize>
    <asp:Localize meta:resourcekey="str_gstUsr" runat="server" id="LocGstUsr" Visible="false">Guest User</asp:Localize>
    <asp:Localize ID="LocCntLodShrStg" meta:resourcekey="str_cntLodShrStg" runat="server" Visible="False">Cannot load share settings.</asp:Localize>
    <asp:Localize ID="LocCldNotFndShr" meta:resourcekey="str_cldNotFndShr" runat="server" Visible="False">Could not find shares for the email provided.</asp:Localize>
    <asp:Localize ID="LocCntCvtIDVal" meta:resourcekey="str_cntCvtIDVal" runat="server" Visible="False">Cannot convert ID value.</asp:Localize>
    <asp:Localize ID="LocIvdEmlOrGrp" meta:resourcekey="str_ivdEmlOrGrp" runat="server" Visible="False">Invalid Email or Group.</asp:Localize>
    <asp:Localize ID="LocEmlIsReq" meta:resourcekey="str_emlIsReq" runat="server" Visible="False">An email is required.</asp:Localize>
    <asp:Localize ID="LocPwdCntBeEpt" meta:resourcekey="str_pwdCntBeEpt" runat="server" Visible="False">Password cannot be empty.</asp:Localize>
    <asp:Localize ID="LocPwdNotLngEgh" meta:resourcekey="str_pwdNotLngEgh" runat="server" Visible="False">Password is not long enough.</asp:Localize>
    <asp:Localize ID="LocPwdMstCtnUpr" meta:resourcekey="str_pwdMstCtnUpr" runat="server" Visible="False">Password must contain uppercase characters.</asp:Localize>
    <asp:Localize ID="LocPwdMstCtnLwr" meta:resourcekey="str_pwdMstCtnLwr" runat="server" Visible="False">Password must contain lowercase characters.</asp:Localize>
    <asp:Localize ID="LocPwdMstCtnNum" meta:resourcekey="str_pwdMstCtnNum" runat="server" Visible="False">Password must contain numbers.</asp:Localize>
    <asp:Localize ID="LocPwdMstCtnSbl" meta:resourcekey="str_pwdMstCtnSbl" runat="server" Visible="False">Password must contain symbols.</asp:Localize>
    <asp:Localize ID="LocFldTrgCrtGstUsr" meta:resourcekey="str_fldTrgCrtGstUsr" runat="server" Visible="False">Failed trying to create a new guest user.</asp:Localize>
    <asp:Localize ID="LocDomDisByAdm" meta:resourcekey="str_domDisByAdm" runat="server" Visible="False">Sharing with this domain has been disabled by the administrator.</asp:Localize>     
    <asp:Localize ID="LocNonADDisByAdm" meta:resourcekey="str_nonADDisByAdm" runat="server" Visible="False">Sharing with users from outside of the Active Directory has been disabled by the administrator.</asp:Localize>
    <asp:Localize ID="LocIvlEmlOrGrp" meta:resourcekey="str_ivlEmlOrGrp" runat="server" Visible="False">Invalid Email or Group.</asp:Localize>
    <asp:Localize ID="LocFldAddNewShr" meta:resourcekey="str_fldAddNewShr" runat="server" Visible="False">Failed to add the new share.</asp:Localize>
    <asp:Localize ID="LocSntEmlScs" meta:resourcekey="str_sntEmlScs" runat="server" Visible="False">Sent email successfully.</asp:Localize>
    <asp:Localize ID="LocFldSndEml" meta:resourcekey="str_fldSndEml" runat="server" Visible="False">Failed to send email</asp:Localize>
    <asp:Localize ID="LocChgExpStg" meta:resourcekey="str_chgExpStg" runat="server" Visible="False">Changed expiration settings</asp:Localize>
    <asp:Localize ID="LocChgPrmStg" meta:resourcekey="str_chgPrmStg" runat="server" Visible="False">Changed permissions settings</asp:Localize>
    <asp:Localize ID="LocChgAthStg" meta:resourcekey="str_chgAthStg" runat="server" Visible="False">Changed authentication settings</asp:Localize>
    <asp:Localize ID="LocChgNtfStg" meta:resourcekey="str_chgNtfStg" runat="server" Visible="False">Changed notification settings</asp:Localize>
    <asp:Localize ID="LocExpIn" meta:resourcekey="str_expIn" runat="server" Visible="False">Expires in $TIMELEFT</asp:Localize>
    <asp:Localize ID="LocNvrExp" meta:resourcekey="str_nvrExp" runat="server" Visible="False">Never Expires</asp:Localize>
    <asp:Localize ID="LocExpInDysHrs" meta:resourcekey="str_expInDysHrs" runat="server" Visible="False">Expires in $DD$ Day(s) $HH$ Hour(s)</asp:Localize> 
    <asp:Localize ID="LocDayHouMin" meta:resourcekey="str_dayHouMin" runat="server" Visible="false">{$DYS} Day(s), {$HRS} Hour(s), {$MNS} Minute(s)</asp:Localize>
    <asp:Localize ID="LocNoShrFnd" meta:resourcekey="str_noShrFnd" runat="server" Visible="False">No shares were found.</asp:Localize>
    <asp:Localize ID="LocUsr" meta:resourcekey="str_usr" runat="server" Visible="False">User</asp:Localize>
    <asp:Localize ID="LocGst" meta:resourcekey="str_gst" runat="server" Visible="False">Guest</asp:Localize>
    <asp:Localize ID="LocExt" meta:resourcekey="str_ext" runat="server" Visible="False">External</asp:Localize>
    <asp:Localize ID="LocExd" meta:resourcekey="str_exd" runat="server" Visible="False">Expired</asp:Localize>
    <asp:Localize ID="LocNvr" meta:resourcekey="str_nvr" runat="server" Visible="False">Never</asp:Localize>
    <asp:Localize ID="LocPlsEtrVldEml" meta:resourcekey="str_plsEtrVldEml" runat="server" Visible="False">Please enter a valid email.</asp:Localize>
    <asp:Localize ID="LocSntScs" meta:resourcekey="str_sntScs" runat="server" Visible="False">Sent successfully.</asp:Localize>
    <asp:Localize ID="LocDys" meta:resourcekey="str_dys" runat="server" Visible="False">Day(s)</asp:Localize>
    <asp:Localize ID="LocHrs" meta:resourcekey="str_hrs" runat="server" Visible="False">Hour(s)</asp:Localize>
    <asp:Localize ID="LocMns" meta:resourcekey="str_mns" runat="server" Visible="False">Min(s)</asp:Localize>
    <asp:Localize ID="LocFilReq" meta:resourcekey="str_filReq" runat="server" Visible="False">File Request</asp:Localize>
    <asp:Localize ID="LocUkn" meta:resourcekey="str_ukn" runat="server" Visible="False">Unknown Email</asp:Localize>
    <asp:Localize ID="LocMsgToEml" meta:resourcekey="str_msgToEml" runat="server" Visible="False">Missing To email.</asp:Localize>
    <asp:Localize ID="LocIvlEml" meta:resourcekey="str_ivlEml" runat="server" Visible="False">Invalid email.</asp:Localize>
    <asp:Localize ID="LocIvlExpDte" meta:resourcekey="str_ivlExpDte" runat="server" Visible="False">Invalid expiration date.</asp:Localize>
    <asp:Localize ID="LocIvlAct" meta:resourcekey="str_ivlAct" runat="server" Visible="False">Invalid Action</asp:Localize>
    <asp:Localize ID="LocWrn" meta:resourcekey="str_wrn" runat="server" Visible="False">Warning</asp:Localize>
    <asp:Localize ID="LocYouCntConRegAcc" meta:resourcekey="str_youCntConRegAcc" runat="server" Visible="False">You cannot convert a registered account into an external user. To do so, you must delete the user from the management dashboard and then share your folder/files again without protection.</asp:Localize>
    <asp:Localize ID="LocGueUseWilBeCre" meta:resourcekey="str_gueUseWilBeCre" runat="server" Visible="False">A guest account will be created if you require the user to log in.</asp:Localize>   
    <asp:Localize runat="server" ID="LocPleSelTimInFut" meta:resourcekey="str_pleSelTimInFut" Visible="false">Please select a time in the future.</asp:Localize> 
    <asp:Localize runat="server" ID="LocPleSelDay" meta:resourcekey="str_pleSelDay" Visible="false">Please select a day.</asp:Localize>     
    <asp:Localize runat="server" ID="LocHor" meta:resourcekey="str_hor" Visible="false">Hour</asp:Localize>   
    <asp:Localize runat="server" ID="LocMin" meta:resourcekey="str_min" Visible="false">Minutes</asp:Localize>
    <asp:Localize runat="server" ID="LocSel" meta:resourcekey="str_sel" Visible="false">SELECT</asp:Localize>      
    <asp:Localize runat="server" ID="LocEve" meta:resourcekey="str_eve" Visible="false">Everyone</asp:Localize>
    <asp:Localize runat="server" ID="LocGueUseAreDis" meta:resourcekey="str_gueUseAreDis" Visible="false">Guest user creation is disabled.</asp:Localize>
    <asp:Localize runat="server" ID="LocShaWitThiUseHasBeeDis" meta:resourcekey="str_shaWitThiUseHasBeeDis" Visible="false">Sharing with this user has been disabled by the administrator.</asp:Localize>
    <asp:Localize id="LocShrLnk" meta:resourcekey="str_shrLnk" runat="server" Visible="false">Share Link</asp:Localize> 
    <div style="display:none;">
        <asp:Button ID="BtnPostBack" runat="server" OnClick="BtnPostBack_Click" /> 
        <input type="hidden" id="HidPostbackParam" runat="server" />
    </div>
    <main>
        <header>
                <div style="display:none;">
                    <asp:Localize meta:resourcekey="str_shr" runat="server">Share</asp:Localize> <i class="gladinet-icons md-24 md-dark hand titleIco"><asp:Literal ID="LtlShareNameIcon" runat="server" /></i>
                    <asp:PlaceHolder ID="PhShareNameView" runat="server">
                        <asp:Literal ID="LtlShareName" runat="server" />
                    </asp:PlaceHolder>
                </div>
                <asp:PlaceHolder ID="PhShareNameEdit" runat="server" Visible="false">
                    <div id="divEditShareNameRow" style="display:none;">
                        <div style="float:left;margin-top:7px;margin-right:10px;font-size:20px;font-weight:100;"><asp:Localize meta:resourcekey="str_shrNme" runat="server">Share Name:</asp:Localize></div> <asp:TextBox ID="TxtShareName" class="form-control shareName userInp" runat="server" />
                    </div>
                </asp:PlaceHolder>
            <asp:Panel ID="PnlPathView" runat="server" style="padding-top:10px;">
                <i><asp:Literal ID="LtlFullPath" runat="server" /> <asp:Literal ID="LtlShareUser" runat="server" /></i>
            </asp:Panel><asp:Literal ID="LtlAltFullPath" runat="server" Visible="false" />
        </header>
        <nav id="Nav" runat="server">
    <ul id="ViewTabs" class="viewTabs" runat="server">
<li id="liTab0" class="gladtab_lg_active" runat="server"><asp:LinkButton ID="LBTab0" runat="server" OnClientClick="return checkIfUnsaved('0')" OnClick="LBTab0_Click" Text="Recipient(s)" meta:resourcekey="str_rcp"></asp:LinkButton>

</li><li id="liTab1" class="gladtab_lg_inactive tabDisabled" runat="server"><asp:LinkButton ID="LBTab1" runat="server" OnClientClick="return checkIfUnsaved('1')" OnClick="LBTab1_Click" Text="Expiration" meta:resourcekey="str_exp"></asp:LinkButton>

</li><li id="liTab2" class="gladtab_lg_inactive tabDisabled" runat="server"><asp:LinkButton ID="LBTab2" runat="server" OnClientClick="return checkIfUnsaved('2')" OnClick="LBTab2_Click" Text="Permissions" meta:resourcekey="str_shrPrm"></asp:LinkButton>

</li><li id="liTab3" class="gladtab_lg_inactive tabDisabled" runat="server"><asp:LinkButton ID="LBTab3" runat="server" OnClientClick="return checkIfUnsaved('3')" OnClick="LBTab3_Click" Text="Authentication" meta:resourcekey="str_athReq"></asp:LinkButton>

</li><li id="liTab4" class="gladtab_lg_inactive tabDisabled" runat="server"><asp:LinkButton ID="LBTab4" runat="server" OnClientClick="return checkIfUnsaved('4')" OnClick="LBTab4_Click" Text="Notifications" meta:resourcekey="str_emlNtf"></asp:LinkButton>

</li><li id="liTab5" runat="server" style="vertical-align:middle;padding-left:10px;"><asp:LinkButton ID="LBTab5" runat="server" OnClientClick="return checkIfUnsaved('5')" OnClick="LBTab5_Click" 
    ToolTip="Request File" meta:resourcekey="str_reqFilBtn" CssClass="reqFilBtn gladinet-icons md-24 md-dark hand">&#x22;</asp:LinkButton>

</li><li id="liTab6" runat="server" style="vertical-align:middle;padding-left:10px;"><asp:LinkButton ID="LBTab6" runat="server" OnClientClick="return checkIfUnsaved('6')" OnClick="LBTab6_Click" 
    ToolTip="Public Link" meta:resourcekey="str_pubLnkBtn" CssClass="pubLnkBtn gladinet-icons md-24 md-dark hand">&gt;</asp:LinkButton>
</li>
    </ul>
        </nav>

    <div id="SaveBtnDiv1">
        <div style="background-color: #0288d1;" class="fabBtn savebtn" title="Save changes" onclick="modalSaveCofirmation();">
            <img src="/webui/images/save_white_32.png" alt="<asp:Localize meta:resourcekey="str_sav" runat="server">Save</asp:Localize>" />
        </div>
            <div style="height:5px"></div>
            <div style="background-color: #ffa000;" class="fabBtn savebtn" title="Discard changes" onclick="OnCancelChanges();">
            <img src="/webui/images/discard_white_32.png" alt="<asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize>" />
        </div>
    </div>
    <asp:Literal ID="LtlMsg" runat="server" />
    <asp:MultiView ID= "MultiView1" runat= "server" ActiveViewIndex="0">
       <asp:View ID= "ViewTab0" runat= "server">
           <section class="fullWidth">
               <div class="rcpInpRow">
                   <asp:TextBox ID="TxtNewRecipient" list="DLNewRecipients" runat="server" CssClass="form-control TxtNewRecipient" placeholder="user@example.com" autocomplete="off" oninput="stripEmail(this);"></asp:TextBox>
                   <div class="addRcpBtn hand" title="Add user">
                       <div onclick="checkIfUserExists()" class="gladinet-icons md-36 md-dark hand" style="background-color:#FFF;border:none;">&#x10B;</div></div>
                   <datalist id="DLNewRecipients">
                       <asp:Repeater ID="RptSuggestRecipients" runat="server">
                          <ItemTemplate>
                              <option value="<%# DataBinder.Eval(Container, "DataItem.Name")%>" />
                          </ItemTemplate>
                       </asp:Repeater>
                    </datalist>
               </div>
               <table id="TblRecipients" class="recipientsList">
                <tr class="rptHeaderRow">
                    <td colspan="2"><asp:Localize meta:resourcekey="str_rc" runat="server">Recipient</asp:Localize></td>
                    <td><asp:Localize meta:resourcekey="str_prm" runat="server">Permissions</asp:Localize></td>
                    <td><asp:Localize meta:resourcekey="str_exp" runat="server">Expiration</asp:Localize></td>
                    <td></td>
                    <td></td>
                </tr>
               <asp:Repeater ID="RptRecipients" runat="server">
                  <ItemTemplate>
                      <tr class="rptRow" id="rptRow_<%# Container.ItemIndex %>">
                          <td><i id="rpt_<%# Container.ItemIndex %>" class="gladinet-icons md-22 md-dark <%# DataBinder.Eval(Container, "DataItem.NameAndEmail").ToString().Replace(" ","").Replace("(","").Replace(")","").Replace("user@example.com","anonymous").Replace("1@1","anonymous")%>_<%# DataBinder.Eval(Container, "DataItem.Permissions").ToString().Replace(" ","")%>"/><%# DataBinder.Eval(Container, "DataItem.TypeIcon")%></i></td>
                          <td><span class="<%# DataBinder.Eval(Container, "DataItem.NameAndEmail").ToString().Replace(" ","").Replace("(","").Replace(")","").Replace("user@example.com","anonymous").Replace("1@1","anonymous")%>_<%# DataBinder.Eval(Container, "DataItem.Permissions").ToString().Replace(" ","")%>">
                              <%# DataBinder.Eval(Container, "DataItem.NameAndEmail")%></span></td>
                          <td><span class=""><%# DataBinder.Eval(Container, "DataItem.Permissions")%></span></td>
                          <td><span class=""><%# DataBinder.Eval(Container, "DataItem.Expires")%></span></td>
                          <td class="editLnk_<%# DataBinder.Eval(Container, "DataItem.Expired")%> editLnk_<%# DataBinder.Eval(Container, "DataItem.Permissions").ToString().Replace(" ","") %>"><i id="rpt_<%# Container.ItemIndex %>" class="gladinet-icons md-22 md-dark hand" onclick="editShareACL('<%# DataBinder.Eval(Container, "DataItem.PkId")%>',&quot;<%# DataBinder.Eval(Container, "DataItem.Email")%>&quot;)" title="<asp:Localize meta:resourcekey="str_edtUsrShr" runat="server">Edit User Share</asp:Localize>" />/</i></td>
                          <td><i id="rpt_<%# Container.ItemIndex %>" class="gladinet-icons md-22 md-dark hand emlLnk_<%# DataBinder.Eval(Container, "DataItem.Expired")%>" onclick="sendShareEmail('<%# DataBinder.Eval(Container, "DataItem.PkId")%>',&quot;<%# DataBinder.Eval(Container, "DataItem.Email")%>&quot;,'<%# DataBinder.Eval(Container, "DataItem.Permissions")%>')" title="<asp:Localize meta:resourcekey="str_sndShrNtfEml" runat="server">Send Share Notification Email</asp:Localize>" />E</i></td> 
                          <td><i id="rpt_<%# Container.ItemIndex %>" class="gladinet-icons md-22 md-dark hand" onclick="deleteIt('<%# DataBinder.Eval(Container, "DataItem.PkId")%>',&quot;<%# DataBinder.Eval(Container, "DataItem.Email")%>&quot;,'<%# DataBinder.Eval(Container, "DataItem.Permissions")%>')" title="<asp:Localize meta:resourcekey="str_dlt" runat="server">Delete</asp:Localize>" />n</i></td>
                          <td class="cpyLnk_<%# DataBinder.Eval(Container, "DataItem.Link")%>"><i id="rpt_<%# Container.ItemIndex %>" class="gladinet-icons md-22 md-dark hand" onclick="copyLinkFromRecipients('<%# DataBinder.Eval(Container, "DataItem.Link")%>','lnkSts_<%# DataBinder.Eval(Container, "DataItem.PkId")%>')" title="<asp:Localize meta:resourcekey="str_cpyLnk" runat="server">Get Link</asp:Localize>" />&#x3C;</i> <div id="lnkSts_<%# DataBinder.Eval(Container, "DataItem.PkId")%>" class="copiedStatus2"></div></td>
                      </tr>
                  </ItemTemplate>
               </asp:Repeater>
               </table>
           </section>
       </asp:View>
       <asp:View ID= "ViewTab1" runat= "server">
           <section style="padding-top:225px;padding-left:390px;">
                <input type="hidden" id="HidDefShrExp" runat="server" />
                <input type="hidden" id="HidMaxShrExp" runat="server" />     
               <span id="<%=HidExpires.ClientID%>_expiresDisplay" class="expiresDisplay" style="padding-left:20px;"><asp:Literal ID="LtlExpDsp" runat="server"></asp:Literal></span> 
               <input type="hidden" id="HidExpires" runat="server" /> 
           </section>
       </asp:View>
       <asp:View ID= "ViewTab2" runat= "server">
           <section class="fullWidth updatable">                     
                <div class="row">
                    <div class="col-12">
                         <asp:RadioButton ID="RdoPrmRedOly" runat="server" AutoPostBack="false" Text="View / Read-Only Access" meta:resourcekey="str_viwRdoAcs" GroupName="RdoPrm" Checked="true" />       
                    </div>
                </div>                  
                <div class="row">
                    <div class="col-12">
                         <asp:RadioButton ID="RdoPrmViwOly" runat="server" AutoPostBack="false" Text="View only (download will be disabled)" meta:resourcekey="str_viwOlyDwdDsb" GroupName="RdoPrm" />       
                    </div>
                </div>                  
                <div class="row">
                    <div class="col-12">
                         <asp:RadioButton ID="RdoPrmDwdOly" runat="server" AutoPostBack="false" Text="Download Only" meta:resourcekey="str_dwdOly" GroupName="RdoPrm"  />       
                    </div>
                </div>                  
                <div class="row">
                    <div class="col-12">
                         <asp:RadioButton ID="RdoPrmFulCtl" runat="server" AutoPostBack="false" Text="Edit / Full-Control Access (Recipient must have a registered account)" meta:resourcekey="str_edtFulCtl" GroupName="RdoPrm" />       
                    </div>
                </div>                  
                <div class="row" style="margin-top:10px;">
                    <div class="col-12">
                         <asp:CheckBox ID="ChkOnlShrFstFld" runat="server" Text="Only share files under the current folder" meta:resourcekey="str_olyShrFstFld" AutoPostBack="false"></asp:CheckBox>       
                    </div>
                </div>
           </section>
           <aside></aside>
       </asp:View>
       <asp:View ID= "ViewTab3" runat= "server">
           <div class="fullWidth">
               <section class="halfWidth">
                   <h2>
                       <asp:Localize meta:resourcekey="str_extUsr" runat="server">External Users</asp:Localize></h2>
                   <div class="containerWithVerticalSeparator updatable" style="padding-left: 20px;" onclick="userUnregisterWarning()">
                       <div class="row">
                           <div class="col-12">
                               <asp:RadioButton ID="RdoNoPrt" runat="server" AutoPostBack="false" Text="No protection" meta:resourcekey="str_noPrt" GroupName="RdoAuth" />
                           </div>
                       </div>
                       <div class="row" onclick="userUnregisterWarning()">
                           <div class="col-12">
                               <asp:RadioButton ID="RdoCtmPwdForAcs" runat="server" AutoPostBack="false" Text="Password for access" meta:resourcekey="str_pwdForAcs" GroupName="RdoAuth" />
                           </div>
                       </div>
                       <div class="row" style="margin-left: 20px" id="customPasswordRow" onclick="userUnregisterWarning()">
                           <div class="col-10">
                               <asp:TextBox ID="TxtCstPwd" class="form-control customPassword userInp" runat="server" TextMode="Password" data-lpignore="true" onchange="toggleSystemPassword()"  />
                           </div>
                       </div>
                       <div class="row" style="margin-left:20px;margin-top:10px;" onclick="userUnregisterWarning()">
                           <div class="col-12">
                               <asp:CheckBox ID="ChkSndPwdSep" runat="server" AutoPostBack="false" Text="Re-send password email on save" meta:resourcekey="str_sndShrPwdEml" />
                              
                           </div>
                       </div>
                       <div class="row" style="margin-left:20px;" onclick="userUnregisterWarning()">
                           <div class="col-12">
                               <asp:CheckBox ID="ChkOneTimPwd" runat="server" AutoPostBack="false" Text="One-time password" meta:resourcekey="str_oneTmePwd" />
                           </div>
                       </div>
                       <div class="row systemPasswordRow" style="margin-left:20px;" onclick="toggleCustomPassword();userUnregisterWarning()">
                           <div class="col-12">
                               <asp:CheckBox ID="ChkStmGenPwd" runat="server" AutoPostBack="false" Text="System generated password" meta:resourcekey="str_stmGndPwd" />
                           </div>
                       </div>
                       <div></div>
                   </div>
               </section>
               <aside>
                <h2><asp:Localize meta:resourcekey="str_regAct" runat="server">Registered Accounts</asp:Localize></h2>
                       <div class="row updatable" style="padding-left:20px;" onclick="userCreationWarning()">
                           <div class="col-12">
                                <asp:RadioButton ID="RdoRcpMstLgn" runat="server" AutoPostBack="false" Text="Recipient must log in to access" meta:resourcekey="str_rcpMstLgn" GroupName="RdoAuth" />
                            <div></div> 
               </aside>
           </div>
       </asp:View>
       <asp:View ID= "ViewTab4" runat= "server">
           <div class="fullWidth">
                <section style="display:flex;align-items:baseline;height: 50px;">
                    <h2 style="white-space:nowrap;padding-right:10px;"><asp:Localize meta:resourcekey="str_shaLin" runat="server">Share Link:</asp:Localize></h2>
                    <div id="DivShareLink" style="border-bottom:1px solid #cccccc;width:calc(100% - 27px);"><asp:Literal ID="LtlShareLink" runat="server" /></div>
                    <div style="width:27px;padding-left:10px;">
                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" title="<%=str_copystr.Text %>" onclick='copyShareLink()'>&#0192;</i>
                        <asp:Localize meta:resourcekey="str_copystr" ID='str_copystr' runat="server" Visible="False">Copy to clipboard</asp:Localize>
                    </div>
                </section>
               <section class="halfWidth">
                   <h2><asp:Localize meta:resourcekey="str_nts" runat="server">Notes (for the share notification)</asp:Localize></h2>
                   <div class="containerWithVerticalSeparator" style="margin-left:20px;width: calc(100% - 20px);">                     
                       <div class="row">
                            <label class="col-12 col-form-label"><asp:Localize meta:resourcekey="str_to" runat="server">To:</asp:Localize> <asp:Literal ID="LtlNtsRcp" runat="server" /></label>
                            <div class="col-12">
                                <asp:TextBox ID="TxtNts" runat="server" TextMode="MultiLine" Rows="3" CssClass="txtNts"></asp:TextBox>
                            </div>
                        </div>                     
                       <div class="row">
                            <div class="col-12">
                                <asp:Button ID="BtnSndEmlNow" CssClass="btn btn-primary gladbtn" runat="server" Text="Re-Send Share Email Now" meta:resourcekey="str_sndShrEmlNow" OnClick="BtnSndEmlNow_Click"/>
                            </div>
                        </div>
                   </div>
               </section>
               <aside class="halfWidth updatable">
                   <h2><asp:Localize meta:resourcekey="str_opt" runat="server">Options</asp:Localize></h2>                        
                   <div class="row" style="margin-left:10px;">
                        <div class="col-12">
                            <asp:CheckBox ID="ChkNfyAdmDwd" runat="server" AutoPostBack="false" Text="Notify me when a file is downloaded" meta:resourcekey="str_ntfDwd" />
                        </div>
                    </div>                 
                   <div class="row" style="margin-left:10px;">
                        <div class="col-12">
                            <asp:CheckBox ID="ChkNfyAdmUpd" runat="server" AutoPostBack="false" Text="Notify me when a file is uploaded" meta:resourcekey="str_ntfUpd" />
                        </div>
                    </div>                 
                   <div class="row" style="margin-left:10px;">
                        <div class="col-12">
                            <asp:CheckBox ID="ChkNfyUsrChg" runat="server" AutoPostBack="false" Text="Notify the user when a file/folder changes" meta:resourcekey="str_ntfUsr" />
                        </div>
                    </div>


                    <% if (LtlShareLink.Text.StartsWith("http")) { %>
                    <section id="qrcode2" class="updatable" style="margin-top:20px;margin-left:10px;">
                        <img src="editsharepage.aspx?qr=1&str=<%=LtlShareLink.Text %>" style="width:180px;height:180px;" title="<%=LocShrLnk.Text %> QR Code" alt="<%=LocShrLnk.Text %> QR Code" />
                    </section>  
                    <% } %>

               </aside>
           </div>
       </asp:View>
       <asp:View ID= "ViewTab5" runat= "server">
           <div class="fullWidth">
               <section class="sixtyPerWidth">
                   <div class="containerWithVerticalSeparator">
                        <h2><asp:Localize meta:resourcekey="str_reqFilToEml" runat="server">Request File Email</asp:Localize></h2>

                       <section class="updatable">
                        <div class="row" style="margin-top:-20px;">
                            <label for="<%=TxtReqEml.ClientID %>" class="col-3 col-form-label"><asp:Localize meta:resourcekey="str_senTo" runat="server">Send to:</asp:Localize></label>
                            <div class="col">
                                <asp:TextBox ID="TxtReqEml" runat="server" CssClass="form-control TxtReqEml" placeholder="user@example.com" data-lpignore="true" autocomplete="new-password"></asp:TextBox>
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-3 col-form-label"><asp:Localize meta:resourcekey="str_expn" runat="server">Expiration:</asp:Localize></label>
                            <div class="col">
                                <span id="calIcoReqFilLnk" class="gladinet-icons md-22 md-dark hand" onclick="toggleReqFilCal()">&#x13E;</span>
                                <span id="<%=HidReqFilExpires.ClientID%>_expiresDisplay" style="padding-left:20px;"><asp:Literal ID="LtlReqFilExpDsp" runat="server"></asp:Literal></span>
                                <input type="hidden" id="HidReqFilExpires" runat="server" />  
                                <input type="hidden" id="HidReqFilTick" runat="server" />  
                            </div>
                        </div>
                        <div class="row">
                            <label class="col-12 col-form-label"><asp:Localize meta:resourcekey="str_ntsForReq" runat="server">Notes (for the request file notification):</asp:Localize></label>
                            <div class="col-12">
                                <asp:TextBox ID="TxtReqEmlNts" runat="server" TextMode="MultiLine" Rows="3" CssClass="TxtReqEmlNts"></asp:TextBox>
                            </div>
                        </div>
                        <div class="row">
                            <label for="<%=TxtReqEml.ClientID %>" class="col-12 col-form-label"><asp:Localize meta:resourcekey="str_pwdForAcs" runat="server">Password for access</asp:Localize>:</label>
                            <div class="col-12">
                                <asp:TextBox ID="TxtReqFilPwd" class="userInp" runat="server" CssClass="form-control customPassword" TextMode="Password" data-lpignore="true" autocomplete="new-password" />
                            </div>
                        </div>
                        <div class="row" style="margin-top:20px;">
                            <div class="col-12">
                                <asp:CheckBox ID="ChkOlyShwUpdBox" runat="server" CssClass="" Text="Only show upload box on the Request File page." meta:resourcekey="str_olyShwUpdBox"></asp:CheckBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="ChkCltUprInf" runat="server" CssClass="" Text="Collect Uploader Information" meta:resourcekey="str_cltUpdInf"></asp:CheckBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="ChkGenerateUniqueFileNames" runat="server" CssClass="" Text="Generate Unique File Names" meta:resourcekey="str_chkGenerateUniqueFileNames"></asp:CheckBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:Button ID="BtnSndReq" CssClass="btn btn-primary gladbtn" runat="server" Text="Send Email Request" meta:resourcekey="str_sndEmlReq" OnClick="BtnSndReq_Click"/>
                            </div>
                        </div>
                        </section>
                   </div>
               </section>
               <aside class="fortyPerWidth updatable">
                   <h2 style="float:left;"><asp:Localize meta:resourcekey="str_reqFilLnk" runat="server">Request File Link</asp:Localize></h2>
                   <div class="gladinet-icons md-26 md-dark hand" style="margin-left:10px;float:left;margin-right:10px;" onclick="copyRequestFileLink()" title="<asp:Localize meta:resourcekey="str_cpyLnk" runat="server">Copy link to clipboard</asp:Localize>">&#x13F;</div><div id="reqFilCopiedStatus" class="copiedStatus"></div>
                   <asp:TextBox ID="TxtReqFilLnk" runat="server" TextMode="MultiLine" Rows="3" CssClass="TxtReqFilLnk" style="clear:both;background-color:#f5f5f5;color:#b2b2b2;" onfocus="this.blur();copyRequestFileLink();"></asp:TextBox>
                   <asp:Button ID="BtnGenNewFilReqLin" CssClass="btn btn-primary gladbtn" runat="server" Text="Generate New File Request Link" meta:resourcekey="str_genNewFilReqLin" OnClick="BtnGenFilReq_Click"/>
                </aside>
           </div>
       </asp:View>
       <asp:View ID= "ViewTab6" runat= "server">
           <div class="fullWidth">
               <section class="sixtyPerWidth">
                   <div class="containerWithVerticalSeparator">
                        <h2><asp:Localize meta:resourcekey="str_pubLnkOpt" runat="server">Public Link Options</asp:Localize></h2>
                        <div class="row" style="margin-left:10px;">
                            <div class="col-12">
                                <asp:CheckBox ID="ChkEblPubLnk" runat="server" CssClass="" Text="Enable Public Link" meta:resourcekey="str_eblPubLnk" AutoPostBack="true" OnCheckedChanged="ChkEblPubLnk_CheckedChanged"></asp:CheckBox>
                            </div>
                        </div>
                       <section id="pubLnkCtls" class="updatable" style="margin-top:-10px;margin-left:40px;">
                            <div class="row" runat="server" ID="divChkPubLnkViwOly">
                                <div class="col-12">
                                    <asp:CheckBox ID="ChkPubLnkViwOly" runat="server" CssClass="" Text="View Only" meta:resourcekey="str_viwOly"></asp:CheckBox>
                                </div>
                            </div>
                            <div class="row" style="display:none;">
                                <div class="col-12">
                                    <asp:CheckBox ID="ChkFrcDwd" runat="server" CssClass="" Text="Force Download" meta:resourcekey="str_frcDwd"></asp:CheckBox>
                                </div>
                            </div>
                            <div class="row">
                                <label class="col-3 col-form-label" style="margin-bottom:-5px;"><asp:Localize meta:resourcekey="str_expn" runat="server">Expiration:</asp:Localize></label>
                                <div class="col">
                                    <input type="hidden" id="HidMaxPubLnkExp" runat="server" />
                                    <span id="calIcoPubLnk" class="gladinet-icons md-22 md-dark hand" onclick="togglePublicLinkCal()">&#x13E;</span>
                                    <span id="<%=HidPubLnkExpires.ClientID%>_expiresDisplay" style="padding-left:10px;"><asp:Literal ID="LtlPubLnkExpDsp" runat="server"></asp:Literal></span>                            
                                    <input type="hidden" id="HidPubLnkExpires" runat="server" />   
                                    <input type="hidden" id="HidPubLnkMaxExpDays" runat="server" />  
                                </div>
                            </div>
                        </section> 
                       <% if (ChkEblPubLnk.Checked) { %>
                       <section id="qrcode" class="updatable" style="margin-top:-10px;margin-left:20px;">
                           <img src="editsharepage.aspx?qr=1&str=<%=TxtPubLnk.Text %>" style="width:180px;height:180px;" title="<%=LocPubLnk.Text %> QR Code" alt="<%=LocPubLnk.Text %> QR Code" />
                        </section>  
                       <% } %>
                   </div>
               </section>
               <aside class="fortyPerWidth updatable">
                   <h2 style="float:left;"><asp:Localize ID="LocPubLnk" meta:resourcekey="str_pubLnk" runat="server">Public Link</asp:Localize></h2>
                   <div id="pubLnkCpyBtn" class="gladinet-icons md-26 md-dark hand" style="margin-left:10px;float:left;margin-right:10px;" onclick="copyPubLink()" title="<asp:Localize meta:resourcekey="str_cpyLnk" runat="server">Copy link to clipboard</asp:Localize>">&#x13F;</div><div id="pubLnkCopiedStatus" class="copiedStatus"></div>
                   <asp:TextBox ID="TxtPubLnk" runat="server" TextMode="MultiLine" Rows="3" CssClass="TxtPubLnk" style="clear:both;background-color:#f5f5f5;color:#b2b2b2;" onfocus="this.blur();copyPubLink();"></asp:TextBox>
               </aside>
           </div>
       </asp:View>
       <asp:View ID= "ViewTab7" runat= "server">
           <div class="fullWidth">               
                <h3 class='errMsg center'><%=LocNoShrFnd.Text %></h3><!--No shares were found-->
                <div class="row" style="clear:both;margin-top:40px;">
                    <% 
                        string colClass = "col-4";
                        if (!pnlReqFilBtn.Visible && !divEnablePubLnk.Visible)
                        {
                            colClass = "col-12";
                        }
                        else if (!pnlReqFilBtn.Visible || !divEnablePubLnk.Visible)
                        {
                            colClass = "col-6";
                        }
                    %>
                    <div class="<%=colClass %> center">
                        <div onclick="goToCreateSharePage()">
                        <span class="gladinet-icons md-dark hand" style="font-size:50px;">&#x10B;</span>  
                        <div style="clear:both;margin-top:10px;"><asp:Localize meta:resourcekey="str_crtNewShr" runat="server">Create New Share</asp:Localize></div>
                        </div>
                    </div>
                    <asp:Panel ID="pnlReqFilBtn" class="col-4 center" runat= "server">
                        <div onclick="goToRequestFile()">
                        <span class="gladinet-icons md-dark hand" style="font-size:50px;">&#x22;</span>  
                        <div style="clear:both;margin-top:10px;"><asp:Localize meta:resourcekey="str_reqFil" runat="server">Request File(s)</asp:Localize></div>
                        </div>
                    </asp:Panel>
                    <div class="<%=colClass %> center" ID="divEnablePubLnk" runat="server">
                        <div onclick="goToPublicLink()">
                        <span class="gladinet-icons md-dark hand" style="font-size:50px;">&#x3E;</span>  
                        <asp:Localize ID="LocEblPlcLnk" meta:resourcekey="str_eblPlcLnk" runat="server" Visible="false">Enable Public Link</asp:Localize>
                        <asp:Localize ID="LocViwPlcLnk" meta:resourcekey="str_viwPlcLnk" runat="server" Visible="false">View Public Link</asp:Localize>
                        <div style="clear:both;margin-top:10px;"><asp:Literal ID="LtlPlcLnkLbl" runat="server" /></div>
                        </div>
                    </div>
                </div>
           </div>
       </asp:View>
    </asp:MultiView>

    </main>
    <div style="display:none;">
        <input type="hidden" id="HidDeleteEmail" runat="server" />
        <input type="hidden" id="HidDeletePkId" runat="server" />
        <asp:Button ID="BtnDltUsr" runat="server" OnClick="BtnDltUsr_Click" /> 
        <input type="hidden" id="HidEditPkId" runat="server" />
        <input type="hidden" id="HidEditEmail" runat="server" />
        <asp:Button ID="BtnEdtUsr" runat="server" OnClick="BtnEdtUsr_Click" /> 
        <input type="hidden" id="HidSendEmailPkId" runat="server" />
        <input type="hidden" id="HidSendEmailEmail" runat="server" />
        <asp:Button ID="BtnSendEmail" runat="server" OnClick="BtnSendEmail_Click" /> 
        <asp:Button ID="BtnSendReqFileEmail" runat="server" OnClick="BtnSendReqFileEmail_Click" /> 
    </div>
    <div id="CfmSaveChanges" class="modal fade" role="dialog">
        <div class="modal-dialog " style="width:750px; max-width:750px;height:230px;">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header" >
                    <h4 class="modal-title sectextcolor" style="font-size:20px;"><asp:Localize meta:resourcekey="str_areYouSur" runat="server">Are you sure?</asp:Localize></h4>
                </div>
                <div class="modal-body" style="height:180px;padding-top:30px;">
                    <div><asp:Localize meta:resourcekey="str_areYouSurDsc" runat="server">This action will invalidate the current share link and create a new one. Please re-send the share email from the Notifications tab.</asp:Localize></div>
                    <br />
                    <div style="text-align:right;">
                    <button type="button" class="btn gladbtn" data-dismiss="modal" onclick="OnSaveChanges();"><asp:Localize meta:resourcekey="str_proc" runat="server">Proceed</asp:Localize></button>
                    <button type="button" class="btn gladbtn" data-dismiss="modal"><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></button>
                </div>
                </div>
            </div>

        </div>
    </div>

    <div id="CfmWindowModal" class="modal fade" role="dialog">
        <div class="modal-dialog " style="width:750px; max-width:750px;height:230px;">
            <!-- Modal content-->
            <div class="modal-content">
                <div class="modal-header" >
                    <h4 class="modal-title sectextcolor" style="padding-bottom:20px;font-size:20px;" id="CfmTitle"></h4>
                </div>
                <div class="modal-body" style="height:230px;padding-top:30px;" id="CfmBody">
                    <div id="CfmMsg"></div>
                    <br />
                    <div onclick="changeSendEmailButtonText()">
                    <asp:CheckBox ID="ChkCreateGuestUserAccount" CssClass="guestOption" runat="server" AutoPostBack="false" Text="Create a Guest User Account" meta:resourcekey="str_crtGstUsr" /><br />
                    </div>
                    <div style="display:none;">
                         <div id="guestUserEmailMessage"><asp:Localize meta:resourcekey="str_sndWlcEml" runat="server">Send Welcome and Share Email Now</asp:Localize></div>
                         <div id="externalUserEmailMessage"><asp:Localize meta:resourcekey="str_sndShrEml" runat="server">Send Share Email Now</asp:Localize></div>
                    </div>
                    <asp:CheckBox ID="ChkSendWelcomeEmail" CssClass="guestOption sendEmailButton" runat="server" AutoPostBack="false" Checked="true" Text="Send Share Email Now" meta:resourcekey="str_sndShrEml" />
                    <br /><br />
                    <asp:Button ID="BtnAddShr" runat="server" CssClass="btn gladbtn" OnClick="BtnAddShr_Click" Text="Create Share" meta:resourcekey="str_crtShr"></asp:Button>
                    <button type="button" class="btn gladbtn" data-dismiss="modal" style=""><asp:Localize meta:resourcekey="str_cnl" runat="server">Cancel</asp:Localize></button>
                </div>
            </div>

        </div>
    </div>    
    <div id="MsgWindowModal" class="modal fade" role="dialog">         
        <div class="modal-dialog " style="width:400px;max-width:400px;height:150px;">
            <!-- Modal content-->
            <div class="modal-content">  
                <div class="modal-header" >
                    <h4 class="modal-title sectextcolor" style="padding-bottom:20px;font-size:20px;" id="MsgTitle"></h4>
                    <button type="button" class="close" data-dismiss="modal" style="">&times;</button>
                </div>
                <div class="modal-body" style="height:150px;padding-top:30px;" id="MsgBody"></div>
                <br /><br />
                <button type="button" class="btn gladbtn" data-dismiss="modal" style="">OK</button>
            </div>

        </div>
    </div>

</asp:Content>
