﻿<%@ Page Title="Gladinet Cloud - Access Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="EditAcl.aspx.cs" Inherits="GladinetPayFlow.EditAcl"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="css/css.css" type="text/css" />
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">


        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var activewin;

        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "EditAcl.aspx";
        }

        function OnCancelAddUser() {
            parent.closeCancelActiveWin();
        }


        function OnUserSelected(UserList) {
            var ng = document.getElementById("ctl00_MainContent_NewUsers");
            var btn = document.getElementById("ctl00_MainContent_AddNewUsers");

            ng.value = UserList;
            btn.click();
        }

        function DeleteUser(name, UserId) {
            var ng = document.getElementById("ctl00_MainContent_UserId");
            var btn = document.getElementById("ctl00_MainContent_DeleteUser");

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                ng.value = UserId;
                btn.click();
            }
        }

        function SetPerm(userid) {
            var read = document.getElementById("read_" + userid);
            var write = document.getElementById("write_" + userid);
            var del = document.getElementById("delete_" + userid);
            var edit = document.getElementById("edit_" + userid);
            var ng = document.getElementById("ctl00_MainContent_NewUsers");
            var btn = document.getElementById("ctl00_MainContent_SetUser");
            var ng1 = document.getElementById("ctl00_MainContent_UserId");

            ng1.value = userid;
            ng.value = read.checked + "," + write.checked + "," + del.checked + "," + edit.checked + ",false";

            btn.click();

        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">


  <table width="100%" style="margin: 0px; padding: 8px; height: 100%;" align="center"
        cellspacing="0" cellpadding="0">
   <tr> <td valign="top" class="checkout3" style="background-color: white;">

       <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
   
        <table width="96%" style="height: 90%; padding: 8px;" cellspacing="0" cellpadding="0" align=center>
            <tr style="height:48px;">
                <td width="32px">
                    <img width="32px" src="images/admin.png" />
                </td>
                <td align="left">
                    <h2 style="font-size: 14px; color: #d08000;">
                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server">Object Name:</asp:Localize>
                        <asp:Label ID="ObjectNameLabel" runat="server" meta:resourcekey="ObjectNameLabelResource1"></asp:Label></h2>
                </td>
                <td align="right">
                    <table>
                        <tr>
                            <td width="32px">
                                <img width="24px" src="images/adduser.png" />
                            </td>
                            <td>
                                <a href="javascript:;" onclick="parent.parent.OnSelectUserNoGroup();return false;" style="font-size: 12px;">
                                    <asp:Localize ID="Localize2" meta:resourcekey="asp_string8" runat="server">Add User</asp:Localize></a>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="3" style="padding-top: 3px ; vertical-align:top;">
                    <div id="grid-example">
                    </div>
                </td>
            </tr>
            <tr>
               <td>
                 &nbsp;
               </td>
            </tr>
        </table>
   </td></tr>
   </table>
 


    
    <asp:HiddenField ID="ObjectName" runat="server" />
    <asp:HiddenField ID="NewUsers" runat="server" />
    <asp:HiddenField ID="UserId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="AddNewUsers" runat="server" OnClick="AddNewUsers_Click" meta:resourcekey="AddNewUsersResource1" />
        <asp:Button ID="DeleteUser" runat="server" OnClick="DeleteUser_Click" meta:resourcekey="DeleteUserResource1" />
        <asp:Button ID="SetUser" runat="server" OnClick="SetUser_Click" meta:resourcekey="SetUserResource1" />
    </div>
    <script type="text/javascript">
  var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" >
        <ItemTemplate>
       <%#(Container.ItemIndex == 0)? "": "," %>     
       [
       '<%#(((RepeaterItem)Container).ItemIndex+1) %>','<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem, "UserName").ToString())%>', 
       '<%#DataBinder.Eval(Container.DataItem,"CanRead") %>',
       '<%#DataBinder.Eval(Container.DataItem,"CanWrite") %>',
       '<%#DataBinder.Eval(Container.DataItem,"CanEdit") %>',
       '<%#DataBinder.Eval(Container.DataItem,"CanDelete") %>',
       '<%#DataBinder.Eval(Container.DataItem,"CanSetPermission") %>',
       '<%#DataBinder.Eval(Container.DataItem,"UserId") %>',
       ]
        
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();


            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                  { name: 'index' },
                  { name: 'username' },
                  { name: 'read' },
                  { name: 'write' },
                  { name: 'edit' },
                  { name: 'delete' },
                  { name: 'setperm' },
                  { name: 'userid' }
              ],
                data: myData
            });



            var grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Access Control</asp:Localize>",
                border: true,
                columnLines: true,
                columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="asp_string2" runat="server">User Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'username',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + value + "</b>";
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="asp_string3" runat="server">View</asp:Localize>",
                      width: 50,
                      sortable: true,
                      dataIndex: 'read',
                      renderer: function (value, metaData, record, rowIndex) {
                          var d = record.data;

                          if (value == "True") {
                              return '<input type="checkbox" checked id="read_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          } else {
                              return '<input type="checkbox" id="read_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          }
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="asp_string4" runat="server">Add</asp:Localize>",
                      width: 50,
                      sortable: true,
                      dataIndex: 'write',
                      renderer: function (value, metaData, record, rowIndex) {
                          var d = record.data;
                          if (value == "True") {
                              return '<input type="checkbox" checked id="write_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          } else {
                              return '<input type="checkbox"  id="write_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          }
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="asp_string5" runat="server">Edit</asp:Localize>",
                      width: 50,
                      sortable: true,
                      dataIndex: 'edit',
                      renderer: function (value, metaData, record, rowIndex) {
                          var d = record.data;
                          if (value == "True") {
                              return '<input type="checkbox" checked id="edit_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          } else {
                              return '<input type="checkbox" id="edit_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          }
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="asp_string6" runat="server">Delete</asp:Localize>",
                      width: 50,
                      sortable: true,
                      dataIndex: 'delete',
                      renderer: function (value, metaData, record, rowIndex) {
                          var d = record.data;
                          if (value == "True") {
                              return '<input type="checkbox" checked id="delete_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          } else {
                              return '<input type="checkbox"  id="delete_' + d.userid + '" onclick="SetPerm(\'' + d.userid + '\')" />';
                          }
                      }
                  }, {
                      xtype: 'actioncolumn',
                      width: 30,
                      items:
                      [


                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="asp_string7" runat="server">Delete</asp:Localize>",
                              handler: function (grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  DeleteUser(d.username, d.userid);
                              }
                        ,
                              getClass: function (v, meta, rec) {

                              }
                          }
                 ]
                  }
        ],
                renderTo: 'grid-example'
            });

            Ext.EventManager.onWindowResize(grid.doLayout, grid);
        });
    </script>
</asp:Content>
