﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceTokenMgr.aspx.cs" Inherits="GladinetPayFlow.DeviceTokenMgr" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

    
    function closeCancelActiveWin()
    {
       activewin.close();
    }

    function closeActiveWin() {
        window.location =  "/management/DeviceTokenMgr.aspx";
    }
    function OnWipeDevice(id, name) {
        var ng = document.getElementById("ctl00_MainContent_DeviceId");
        var btn = document.getElementById("ctl00_MainContent_WipeDevice");

        if (confirm("Do you really want to revoke the token for the device (" + unescape(name) + ")?")) {
            Wait('wiping...');
            ng.value = id;
            btn.click();            
        }
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <nav class="navbar navbar-default" role="navigation">
      <div class="container-fluid">
           <p class="navbar-text" id="errmsgdiv">
                                            <b>
                                                <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
               </p>
               <p class="navbar-text" id="P1">
                   <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
               </p>
               
               <asp:Button ID="RefreshBtn"  runat="server" OnClick="RefreshBtn_Click" Text="Refresh" CssClass="btn btn-primary gladbtn navbar-btn navbar-right"
                                meta:resourcekey="RefreshBtnResource1"></asp:Button>

      </div>
    </nav>
                
                <table width="100%" align="center" style="margin-top: -18px;">
                    
                    <tr>
                        <td id="grid-example">
                            
                        </td>
                    </tr>
                    
                </table>
    
  <asp:HiddenField ID="DeviceId" runat="server" />
  <div style="display:none;">
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />

        </div>
  <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#DataBinder.Eval(Container.DataItem,"Token") %>',
           '<%#DataBinder.Eval(Container.DataItem,"ExpirationTime") %>',
           '<%#DataBinder.Eval(Container.DataItem,"ClientIp") %>',
           '<%#DataBinder.Eval(Container.DataItem,"DeviceType") %>',
           '<%#HttpUtility.HtmlEncode(DataBinder.Eval(Container.DataItem,"DeviceName")) %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'token' },
                  { name: 'exp' },
                  { name: 'ip' },
                  { name: 'type' },
                  { name: 'name' }
              ],
              data: myData
          });


          var grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              height:400,
              border:true,
              columnLines: true, 
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string1" runat="server">Device Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string2" runat="server">Device Type</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'type',
                      renderer: function (value, metaData, record, rowIndex) {
                          return  unescape(value);
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string3" runat="server">Expiration</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'exp',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_swstring3" runat="server">IP</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'ip',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      xtype: 'actioncolumn',
                      width: 40,
                      hideable: false,
                      items:
                      [
                          
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string7" runat="server">Revoke</asp:Localize>",
                        width: 30,
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            OnWipeDevice(d.token, d.name);
                        },
                        getClass: function (v, meta, rec) {
                        <%if(!m_CanDelete){ %>
                            return 'x-col-hdide';
                        <%} %>
                        }
                    }
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(grid.doLayout, grid);
      });
  </script>
    <asp:HiddenField ID="HiddenUserGuid" runat="server" />
</asp:Content>
