﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceTaskTrace.aspx.cs" Inherits="GladinetPayFlow.DeviceTaskTrace"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize meta:resourcekey="str_doYouReaWanToDel" runat="server">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }


        function DelSubTask(sindex) {
            
        }
        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

     

     
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

<asp:Localize runat="server" ID="LocFaiToLoa" meta:resourcekey="str_faiToLoa" Visible="false">Failed to load</asp:Localize>
    <nav class="navbar navbar-default" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " title="<%=STRDevList.Text %>" onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left"></span>  
                       <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server" 
                           Text="Return"></asp:Localize>
             </button>

                   <p class="navbar-text dark">
                        <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark" style="margin-right: 8px;">
                       <span class="fa fa-refresh" aria-hidden="true"></span>
                    
                       <asp:LinkButton ID="RefreshBtn"  runat="server" 
                           OnClick="LinkButton2_Click"  OnClientClick="Wait('one minute'); return true;">Refresh <asp:Label ID="DeviceName" Visible="False" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label></asp:LinkButton>
                   </div>
               </div>
           </nav>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent;
        margin-top: -18px;" cellspacing="0" cellpadding="0">
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
                <table width="100%" class="table-striped">
                    <tr style="display: none">
                        <td colspan="2"></td><td></td>
                    </tr>
                    <tr>
                        <td width="160px" style="font-size: 16px; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_tme">Time</asp:Localize></td>
                        <td style="font-size: 16px; font-weight: 100;"><asp:Localize runat="server" meta:resourcekey="str_trc">Trace</asp:Localize></td>
                      
                      
                    </tr>
                    <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
                        OnItemDataBound="OnUserItemBound">
                        <ItemTemplate>
                            <tr style="padding: 5px; border-bottom: 0px solid #f0f0f0; padding-top: 10px;" onmouseover="this.style.borderBottom='2px solid #008000';"
                                onmouseout="this.style.borderBottom='0px solid #00ff00';">
                                <td style="padding: 5px; ">
                                    <span  class="btn-success btnsmall"><%#DataBinder.Eval(Container.DataItem,"Time") %></span>
                                </td>
                                <td style="font-size: 12px; font-weight: 100;">
                                    <%#DataBinder.Eval(Container.DataItem,"Trace") %>
                                </td>
                              
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                    
                </table>
                
            </td>
        </tr>

    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <asp:HiddenField ID="HiddenTaskId" runat="server" />
    <asp:HiddenField ID="HiddenTaskType" runat="server" />
    <asp:HiddenField ID="HiddenSubId" runat="server" />
    <asp:HiddenField ID="HiddenPara" runat="server" />
    
    <div style="display: none;">
    
    </div>
    <script type="text/javascript">
        var grid;
        function AdjustGridTable() {
            

            var e = document.getElementById("grid-example");
            e.style.height = (document.documentElement.offsetHeight - 80) + "px";
        }

        Ext.onReady(function () {
            Ext.EventManager.onWindowResize(AdjustGridTable);
            AdjustGridTable();
        });

        function ResumeTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Resume");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();
        }

        function PauseTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Pause");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();

        }

        function StartTask(tid) {
            var b = document.getElementById("ctl00_MainContent_Start");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            Wait('One Minute');
            b.click();

            

        }


    </script>
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
</asp:Content>
