﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceSyncStatus.aspx.cs" Inherits="GladinetPayFlow.DeviceSyncStatus"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }


        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = "/management/AttachedFolders.aspx";
        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="js_string11" runat="server">Confirm detaching the folder (</asp:Localize>" + unescape(id) + ")?")) {

                Wait("<asp:Localize meta:resourcekey="js_string12" runat="server">Detaching...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        function OnAttachFolder() {
            window.location = "/management/AddAttachedFolder.aspx?id=<%=HiddenInstanceId.Value%>&name=<%=HiddenDeviceName.Value %>";
        }
        function OnDeviceList() {
            window.location = "DeviceAttachedFolders.aspx?id=<%=HiddenInstanceId.Value %>";
        }

        function RefreshList() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");
            Wait("Loading...");
            e.click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize ID="LocThiDev" meta:resourcekey="str_thiDev" Visible="false" runat="server">This Device</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToDet" meta:resourcekey="str_faiToDet" Visible="false">Failed to detach</asp:Localize>
<asp:Localize runat="server" ID="LocNoFilIsChe" meta:resourcekey="str_noFilIsChe" Visible="false">No filter is checked</asp:Localize>
    <nav class="navbar navbar-default" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left " title="<%=STRDevList.Text %>" onclick="OnDeviceList()"> 
                <span class="fa fa-menu-left"></span>  
                       <asp:Localize meta:resourcekey="str_devlist" ID="STRDevList" runat="server" 
                           Text="Return"></asp:Localize>
             </button>

                   <p class="navbar-text">
                        <asp:Label ID="UserCount" runat="server" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <div id="Div1" class="navbar-text">
                       <b>
                          <asp:Label ID="Label1" runat="server" Style="color: Red;" Text="(Beta, may have false alarm.)"></asp:Label></b>
                   </div>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;" onclick="RefreshList();">
                       <span class="fa fa-refresh" aria-hidden="true"></span>
                    
                       <asp:LinkButton ID="RefreshBtn" ForeColor="White" runat="server" 
                           OnClick="LinkButton2_Click" meta:resourcekey="RefreshBtnResource1"  >Refresh  <asp:Label ID="DeviceName" runat="server" Text="Label" meta:resourcekey="DeviceNameResource1"></asp:Label></asp:LinkButton>
                   </div>
                   <div class="navbar-right" style="padding-right: 20px; padding-top: 2px;">
                       <table align="center" >
                           <tr>
                               <td style="padding: 5px;" ><asp:CheckBox CssClass="form-control" ID="Skipped" runat="server" Text="Skipped Files" meta:resourcekey="str_skpFil"></asp:CheckBox></td>
                               <td style="padding: 5px;"><asp:CheckBox Checked="True" CssClass="form-control" ID="NeedsUpload" runat="server" Text="Needs Upload" meta:resourcekey="str_ndsUpd"></asp:CheckBox></td>
                               <td style="padding: 5px;"><asp:CheckBox Checked="True" CssClass="form-control" ID="NeedsDownload" runat="server" Text="Needs Download" meta:resourcekey="str_ndsDwd"></asp:CheckBox></td>
                               <td style="padding: 5px;"><asp:CheckBox CssClass="form-control" ID="PendingSync" runat="server" Text="Syncing" meta:resourcekey="str_snc"></asp:CheckBox></td>
                               <td style="padding: 5px;"><asp:DropDownList ID="RecordCount" runat="server" CssClass="browser-default custom-select secsubbordercolor"></asp:DropDownList> </td>
                           </tr>
                       </table>
                    </div>
                       
               </div>
           </nav>
    <table id="grid-table" width="95%" align="center" style="background-color: transparent;
        margin-top: -10px;" cellspacing="0" cellpadding="0">
        <tr>
            <td id="grid-example" valign="top" style="background-color: transparent; padding: 10px; padding-top: 30px;">
            </td>
        </tr>
    </table>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
    </div>
    
    <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    <asp:HiddenField ID="HiddenDeviceName" runat="server" />
    <asp:HiddenField ID="backtotarget" runat="server" />
    
     <script type="text/javascript">    
var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" enableviewstate="false" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"ItemUri").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"State").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LocalSize").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LocalTime").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"CloudSize").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"CloudTime").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"SyncStatusIcon").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"SyncStatusString").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"SyncStatusColor").ToString().Replace("'","%27")) %>'
         ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

      

    var grid;
      
       function AdjustGridTable () {
           
        var h = 400;
          
        try {

           
            h = document.body.offsetHeight-120;
           
              grid.setWidth(document.documentElement.clientWidth - 20);
              grid.setHeight(h);
              grid.doComponentLayout();

              var e = document.getElementById("grid-example");
              e.style.height = h + "px";


          } catch (err) {
          }


      }

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' },
                  { name: 'state' },
                  { name: 'localsize' },
                  { name: 'localtime' },
                  { name: 'cloudsize' },
                  { name: 'cloudtime' },
                  { name: 'sicon' },
                  { name: 'sstr' },
                  { name: 'scolor' }
              ],
              data: myData
          });


           grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              border: true,
              columnLines: true,
              minHeight: 208,              
              minButtonWidth: 28,
              viewConfig: {
                  emptyText: "all files have synced",
                  deferEmptyText: false
              },
          
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hide';
                      }
                  },
                  {
                      text: "State",                      
                      Width:68,
                      sortable: true,
                      dataIndex: 'state',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span class='fa "+record.data.sicon+"  ' "
                              + "title='"+record.data.sstr+"' "
                              + "style='color:"+record.data.scolor+"; font-size: 32px; cursor: pointer;'></span>";
                      }

                  },
                           
                  {
                      text: "File Path",
                      flex: 1,
                      minWidth:68,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  },
                  {
                      text: "Local Size",
                      width: 175,
                      sortable: true,
                      dataIndex: 'localsize',
                      align:'right',
                      renderer: function (value, metaData, record, rowIndex) {
                          return Ext.util.Format.fileSize(unescape(value));
                      }
                  }, {
                      text: "Local Update Time",
                      minWidth: 120,                      
                      width:200,
                      sortable: true,
                      dataIndex: 'localtime',
                      align:'right',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }
                  }, {
                      text: "Cloud Size",
                      Width: 180,                      
                      sortable: true,
                      align:'right',
                      dataIndex: 'cloudsize',
                      renderer: function (value, metaData, record, rowIndex) {
                          return Ext.util.Format.fileSize(unescape(value));
                      }
                  }, {
                      text: "Cloud Update Time",
                      minWidth: 175,
                      width:175,                      
                      sortable: true,
                      align:'right',
                      dataIndex: 'cloudtime'
                  }, {
                      xtype: 'actioncolumn',
                      width: 110,
                      hideable: false,
                      items:
                      [
                          {
                              icon: 'images/wipe.png', // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="str_wipe" runat="server">Wipe Device</asp:Localize>",
                              width: 30,
                              handler: function(grid, rowIndex, colIndex) {
                                 
                              },
                              getClass: function(v, meta, rec) {
                                 
                                return 'x-col-hdide';
                              }
                          },
                        {
                              icon: 'images/trash.png', // Use a URL in the icon config
                              tooltip: "Delete",
                              width: 30,
                              handler: function(grid, rowIndex, colIndex) {
                              },
                              getClass: function(v, meta, rec) {
                               return 'x-col-hdide';
                              }
                      }
                  ]
              }
                  ],
              renderTo: "grid-example"
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
      });
    </script>
    <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" 
        Visible="False" Text=" Days ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" 
        Visible="False" Text=" Hours ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" 
        Visible="False" Text=" Minutes ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" 
        Visible="False" Text="Less than 1 minute ago"></asp:Localize>
</asp:Content>
