﻿<%@ Page Title="Gladinet Cloud - Role" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceSnapshotBrowser.aspx.cs" Inherits="GladinetPayFlow.DeviceSnapshotBrowser"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
     <script type="text/javascript" src="/portal/webui_strings.aspx"></script>
    <script type="text/javascript" src="/portal/filebrowser.js"></script>
    <style type="text/css">
        .fileoutboxex {
            height: 100px;            
        }
        .toolnavbtn div{
            overflow-x:hidden;white-space:nowrap;
        }
           
    </style>
    <script type="text/javascript">
                var gCurrentSession = "<%=CurrentSession.Value%>"
        var gRootFolder = "<%=CurrentRoot.Value%>"
        var gSnapshotId = "<%=SnapshotId.Value%>"
        var gRandom = 0;
        var _skipDownload = false;
        function getThumbImageUrl(data) {
            return getThumbImageUrlEx(gCurrentFolder, data, 560);
        }

        var Base64 = {

            // private property
            _keyStr: "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",

            // public method for encoding
            encode: function (input) {
                var output = "";
                var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
                var i = 0;

                input = Base64._utf8_encode(input);

                while (i < input.length) {

                    chr1 = input.charCodeAt(i++);
                    chr2 = input.charCodeAt(i++);
                    chr3 = input.charCodeAt(i++);

                    enc1 = chr1 >> 2;
                    enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                    enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                    enc4 = chr3 & 63;

                    if (isNaN(chr2)) {
                        enc3 = enc4 = 64;
                    } else if (isNaN(chr3)) {
                        enc4 = 64;
                    }

                    output = output +
                this._keyStr.charAt(enc1) + this._keyStr.charAt(enc2) +
                this._keyStr.charAt(enc3) + this._keyStr.charAt(enc4);

                }

                return output;
            },

            // public method for decoding
            decode: function (input) {
                var output = "";
                var chr1, chr2, chr3;
                var enc1, enc2, enc3, enc4;
                var i = 0;

                input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");

                while (i < input.length) {

                    enc1 = this._keyStr.indexOf(input.charAt(i++));
                    enc2 = this._keyStr.indexOf(input.charAt(i++));
                    enc3 = this._keyStr.indexOf(input.charAt(i++));
                    enc4 = this._keyStr.indexOf(input.charAt(i++));

                    chr1 = (enc1 << 2) | (enc2 >> 4);
                    chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                    chr3 = ((enc3 & 3) << 6) | enc4;

                    output = output + String.fromCharCode(chr1);

                    if (enc3 != 64) {
                        output = output + String.fromCharCode(chr2);
                    }
                    if (enc4 != 64) {
                        output = output + String.fromCharCode(chr3);
                    }

                }

                output = Base64._utf8_decode(output);

                return output;

            },

            // private method for UTF-8 encoding
            _utf8_encode: function (string) {
                string = string.replace(/\r\n/g, "\n");
                var utftext = "";

                for (var n = 0; n < string.length; n++) {

                    var c = string.charCodeAt(n);

                    if (c < 128) {
                        utftext += String.fromCharCode(c);
                    }
                    else if ((c > 127) && (c < 2048)) {
                        utftext += String.fromCharCode((c >> 6) | 192);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }
                    else {
                        utftext += String.fromCharCode((c >> 12) | 224);
                        utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                        utftext += String.fromCharCode((c & 63) | 128);
                    }

                }

                return utftext;
            },

            // private method for UTF-8 decoding
            _utf8_decode: function (utftext) {
                var string = "";
                var i = 0;
                var c = c1 = c2 = 0;

                while (i < utftext.length) {

                    c = utftext.charCodeAt(i);

                    if (c < 128) {
                        string += String.fromCharCode(c);
                        i++;
                    }
                    else if ((c > 191) && (c < 224)) {
                        c2 = utftext.charCodeAt(i + 1);
                        string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                        i += 2;
                    }
                    else {
                        c2 = utftext.charCodeAt(i + 1);
                        c3 = utftext.charCodeAt(i + 2);
                        string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                        i += 3;
                    }

                }

                return string;
            }

        }

        function GoUp() {

            if (gCurrentFolder == gRootFolder) {

                return;
            }

            var li = gCurrentFolder.lastIndexOf('/');
            if (li < 0) {
                SetCurrentFolder("");
            } else {
                SetCurrentFolder(gCurrentFolder.substring(0, li));
            }
        }

        function OnDownloadError() {
            var e = document.getElementById("downloadframe");
            var err = "";
            try {

                if (e.contentWindow.location.toString().toLowerCase().indexOf("/storage/") != -1) {
                    err = e.contentWindow.document.body.innerHTML;
                    var ind = err.indexOf("$!$");
                    if (ind == -1)
                        err = "";
                    else {
                        err = err.substring(ind + 3);

                        ind = err.indexOf("$!$");
                        if (ind != -1) {
                            err = " : " + err.substring(0, ind);
                        } else {
                            err = "";
                        }
                    }
                    alert("Failed to download" + err);
                }

            } catch (ee) {

            }

        }

        function RestoreFolderPermission()
        {
            $('#RestoreFolderPermissionModal').modal({ backdrop: 'static', keyboard: false });
        }

        function OnRestoreFolderPermissionNow()
        {
            $('#RestoreFolderPermissionModal').modal('hide');
            RestoreItems("perm|" + gCurrentFolder);
        }
        function checkAll()
        {
            var checkIt = $("#chkAll").prop("checked");
            $("input[type=checkbox].chkItem").each(function () {
                $(this).prop("checked", checkIt);
            });
            OnSelChanged();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToAut" meta:resourcekey="str_faiToAut" Visible="false">Failed to authenticate</asp:Localize>
<asp:Localize runat="server" ID="LocMisPar" meta:resourcekey="str_misPar" Visible="false">missing parameter</asp:Localize>
<asp:Localize runat="server" ID="LocRfsCurFld" meta:resourcekey="str_rfsCurFld" Visible="false">Refresh Current Folder</asp:Localize>
<asp:Localize runat="server" ID="LocLstViw" meta:resourcekey="str_lstViw" Visible="false">List View</asp:Localize>
<asp:Localize runat="server" ID="LocIcoViw" meta:resourcekey="str_icoViw" Visible="false">Icon View</asp:Localize>
<asp:Localize runat="server" ID="LocGoUp" meta:resourcekey="str_goUp" Visible="false">Go to Parent Folder</asp:Localize>
    <%if (string.IsNullOrEmpty(ErrorMsg.Text)){ %>
   
        <div role="navigation" class="navbar navbar-default <% if (!IsChildUi){ %>meubardrop<% } %>" style="width: 100%; padding:5px; <% if (IsChildUi){ %>border-bottom:1px solid #eeeeee; box-shadow:0px 0px 0px white!important;<% } %> " >
        <div class="container-fluid trbordercolor" style="border-bottom: 0px solid #f0f0f0; padding-bottom: 10px;">
            <div class="navbar-left">
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px; display: none;" onclick="GoUp();" id="goupbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=LocGoUp.Text %>">&#0166;</i>

            </button>
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px; display:none;" onclick="OnIconView();" id="ivbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=LocIcoViw.Text %>">&#0164;</i>

            </button>
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;display: none;" id="lvbtn" onclick="OnListView();">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=LocLstViw.Text %>">&#0186;</i>

            </button>
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;" onclick="RefreshCurrentFolder();">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=LocRfsCurFld.Text %>">&#0181;</i>

            </button>
           
            <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;" onclick="DownloadCurrentFolder();" title="<%=str_downloadfolder.Text %>" id="downfbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=str_downloadfolder.Text %>">&#x14F;</i>
                <asp:Localize meta:resourcekey="str_downloadfolder" ID="str_downloadfolder" runat="server" Visible="False">Download current folder</asp:Localize>
            </button>
                
                <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px; display:none;" onclick="DownloadSelectedFiles();" title="<%=str_downloadfiles.Text %>" id="downfiles">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=str_downloadfiles.Text %>">&#x150;</i>
                    <asp:Localize meta:resourcekey="str_downloadfiles" ID="str_downloadfiles" runat="server" Visible="False">Download selected files</asp:Localize>
                
            </button>
           <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 5px;" onclick="RestoreCurrentFolder();" title="<%=str_restorefolder.Text %>" id="restorefbtn">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=str_restorefolder.Text %>">&#x151;</i>
                <asp:Localize meta:resourcekey="str_restorefolder" ID="str_restorefolder" runat="server" Visible="False">Restore current folder</asp:Localize>
            </button>
               <button type="button" class="btn navbar-btn navbar-left toolbtn" style="padding: 2px; margin-left: 1px; display:none;" onclick="RestoreSelectedFiles();" title="<%=str_restorefiles.Text %>" id="restorefiles">
                <i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<%=str_restorefiles.Text %>">&#x152;</i>                   
                    <asp:Localize meta:resourcekey="str_restorefiles" ID="str_restorefiles" runat="server" Visible="False">Restore selected files</asp:Localize>
                   </button>
                </div>
            
            <span class="badge badge-primary" style="font-size:18px;" id="CurrentPath"></span>
            
            <div class="navbar-right" >
                <button id="restoreperm" class="btn btn-primary gladbtn" onclick="RestoreFolderPermission();return false;"><asp:Localize runat="server" meta:resourcekey="str_rstPrm">Restore Permission</asp:Localize></button>
            </div>
        </div>
    </div>
    <div style="width: 100%; align-content: left; margin: 0;      
            padding: 20px; 
            background-color: white;     
            margin-top: 18px; -webkit-overflow-scrolling: touch; overflow: auto; padding-top: 0px;" align="left" id="maindiv">
        <div style="width: 100%; display: none;  " id="iconview_div">
            <div style="color: #868686; font-weight: 100; display: none;">
                <asp:Localize runat="server" meta:resourcekey="str_fld">Folders:</asp:Localize>
            </div>

            <div class="row" id="FolderList" style="overflow: auto;"></div>
            <div style="color: #868686; font-weight: 100; padding-top: 30px; display: none;">
                <asp:Localize runat="server" meta:resourcekey="str_fil">Files:</asp:Localize>
            </div>
            <div class="row mt-5" id="FileList" style="overflow: auto; padding-top: 30px; "></div>
        </div>
        <div style="width: 100%;padding-left:20px;padding-right:20px;" id="listview_div">
            <table style="width:100%;" border="0">
                <tr>
                    <td style="padding:0 40px 0 20px;">
                         <table width="100%" style="font-size: 12px; font-weight: 100; color: #808080;" border="0">
                            <tbody id="listview_headers">
                                <tr style="border-bottom:1px solid #f8f8f8;">
                                    
                    <td id="listview_chk" style="width:30px;padding-top7px;padding-left:7px;"><input type="checkbox" id="chkAll" onclick="checkAll()" /></td>
                    <td id="listview_name" style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;"><asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize>                </td>
                    <td id="listview_date" style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;width:128px;"><asp:Localize runat="server" meta:resourcekey="str_lstMdf">Last Modified</asp:Localize></td>
                    <td id="listview_size" style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;text-align:left;width:100px;"><asp:Localize runat="server" meta:resourcekey="str_sze">Size</asp:Localize></td>
                    <td id="listview_download" style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;text-align:left;width:100px;"><asp:Localize runat="server" meta:resourcekey="str_dwd">Download</asp:Localize></td>
                                </tr>
                            </tbody>
                        </table>
                    </td>
                </tr>
                
                <tr>
                    <td 
                
                        style="padding-top: 15px;"
                
                        >
                        <div style="background-color: white; overflow: auto; width: 100%;padding:20px;" id="listviewtd" 
                
                            
                
                            >
                        <table width="100%" style="font-size: 12px; font-weight: 100; color: #808080;" border="0">
                            <tbody id="listcontent">
                          
                                </tbody>
                        </table>
                            </div>
                    </td>
                </tr>
            </table>
        </div>
        <div class="modal fade" id="RestoreFolderPermissionModal" tabindex="-1" role="dialog" aria-labelledby="ModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="ModalLabel"><asp:Localize runat="server" meta:resourcekey="str_ResFolPer">Restore Folder Permission</asp:Localize></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body"><asp:Localize meta:resourcekey="str_allFolPerInsThiFolWilBeRes" runat="server">All folder permissions inside this folder will be restored to the snapshot. Continue?</asp:Localize></div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_Can">Cancel</asp:Localize></button>
          <button type="button" class="btn btn-primary gladbtn" onclick="OnRestoreFolderPermissionNow();return false;"><asp:Localize runat="server" meta:resourcekey="str_ResNow">Restore Now</asp:Localize></button>
          
        
      </div>
    </div>
  </div>
</div>
        
        <div style="display: none; width: 1px; height: 1px">
            <iframe id='downloadframe' style="display: none;" onload="OnDownloadError();"></iframe>
        </div>

    </div>
    <%}else { %>
        <span>
            <%=ErrorMsg.Text %>
        </span>
    <%} %>
    <div style="display:none;">
    <asp:HiddenField ID="DeviceId" runat="server" />         
    <asp:HiddenField ID="SnapshotId" runat="server" />         
    <asp:HiddenField ID="CurrentSession" runat="server" />    
        <asp:HiddenField ID="CurrentRoot" runat="server" />    
        <asp:Label ID="ErrorMsg" runat="server" Text="Label"></asp:Label>
    </div>
    
    <script type="text/javascript">
             function AddFile(node, fileList) {

            ++gRandom;
            var cid = gRandom;

            var fileoutbox = document.createElement("div");
            
            fileoutbox.className = "col-xs-6 col-sm-6 col-md-3 col-lg-1 fileoutboxex";
            
            var fileBox = document.createElement("div");
            fileBox.className = "filebox";
            fileoutbox.appendChild(fileBox);

            var filenode = document.createElement("div");
            
            filenode.className = "filenode  iconobj boxbordercolor";            
            filenode.title = node.Key + "\n" + node.LastModified + "\n" + FormatFileSize(node.Size) + "\n" + node.LastUpdateUserName;

            filenode.ondblclick = function () {
                if (gCurrentFolder == '')
                    parent.ShowPreviewPanel(node.Key);
                else
                    parent.ShowPreviewPanel(gCurrentFolder + "/" + node.Key);
            }
            var icodiv = document.createElement("div");
            icodiv.className = "icodiv";
            filenode.appendChild(icodiv);
            icodiv.id = cid + "_ico";

            var fiurl = getImageUrl(node);
            var imgi = document.createElement("img");
            imgi.src = fiurl;

            imgi.className = 'icoimg';
            icodiv.appendChild(imgi);

            var imgurl = getThumbImageUrl(node);

            if (imgurl && imgurl != '') {
                var imgd = document.createElement("img");
                imgd.src = imgurl;
                imgd.className = "thumbimg";
                imgd.id = cid + "_img";
                imgd.style.display = "none";

                imgd.onload = function () {

                    var e = document.getElementById(cid + "_img");
                    e.style.display = "";

                    if (e.src.indexOf('view.dn') == -1) {
                        e = document.getElementById(cid + "_tt");
                        e.style.display = "none";
                    }

                    var e = document.getElementById(cid + "_ico");
                    e.style.display = "none";
                }
                filenode.appendChild(imgd);
            }


            var titlediv = document.createElement("div");
            titlediv.className = "titlediv btniconcolor";
            titlediv.id = cid + "_tt";

            filenode.appendChild(titlediv);
            titlediv.innerHTML = "<span class='titletxt' style='vertical-align: middle; font-size:16px!important;'>" + GetShortString(node.Key, 26) + "</span>";

            fileBox.appendChild(filenode);
            fileList.appendChild(fileoutbox);

        }

        function AddFolder(node, folderList) {
            ++gRandom;

            var folderbox = document.createElement("div");

            folderbox.className = "col-xs-12 col-sm-12 col-md-3 col-lg-2 folderbox";

            var folderNode = document.createElement("div");

             
             folderNode.className = "folderNode iconobj";
             
             var iconBox = document.createElement("span");
             iconBox.className = "gladinet-icons md-dark hand center toolbtn folderIcon btniconcolor";
             iconBox.innerHTML = getFolderIcon(node);
             folderNode.appendChild(iconBox);

             var nameBox = document.createElement("span");
             nameBox.innerHTML = GetShortString(node.Key, 26);
             nameBox.className = "foldrNameBox";

             folderNode.appendChild(nameBox);


             folderbox.appendChild(folderNode);
             folderList.appendChild(folderbox);

             folderNode.onclick = function () {
                 if (gCurrentFolder == "")
                     SetCurrentFolder(node.Key);
                 else
                     SetCurrentFolder(gCurrentFolder + "/" + node.Key);
             }

         }

        function getFileIcon(node) {
            var name = node.Key.toLowerCase();
            
            if (-1 != name.indexOf(".pdf"))
                return "y";
            if (-1 != name.indexOf(".ppt") || -1 != name.indexOf(".pptx"))
                return "p";
            if (-1 != name.indexOf(".doc") || -1 != name.indexOf(".docx"))
                return "w";
            if (-1 != name.indexOf(".xls") || -1 != name.indexOf(".xlsx"))
                return "x";

            return "z";
        }
        

        function DownloadItem(rowID, isFolder) {
            var url = "";
            var alias = $("#" + rowID)[0].AliasLocation;
            if (isFolder) {
                url = "/management/DeviceSnapshotBrowser.aspx?c=df&f=" + gEncodeUri(alias) + "&s=" + gSnapshotId + "&t=<%=DeviceId.Value%>";
            } else url = "/management/DeviceSnapshotBrowser.aspx?c=d&f=" + gEncodeUri(alias) + "&s=" + gSnapshotId + "&t=<%=DeviceId.Value%>";
            $("#downloadframe").prop("src",url);
        }
        function AddListViewItem(node, itemList) {

            ++gRandom;
            var cid = gRandom;

            var filetr = document.createElement("tr");            
            filetr.style.height = "48px";
            filetr.style.borderBottom = "1px solid #d8d8d8";
            filetr.className = "filerow";
            filetr.id = "row_" + cid;
            filetr.AliasLocation = node.Key;
            if (gCurrentFolder != "") filetr.AliasLocation = gCurrentFolder + "/" + node.Key;
            
            var seltd = document.createElement("td");
            filetr.appendChild(seltd);
            seltd.style.width = "30px";
            seltd.style.paddingLeft = "6px";
            
            if (!node.IsFolder) {
                seltd.innerHTML = '<input  type="checkbox" onchange="OnSelChanged();" class="chkItem" name="tt_' + node.Key + '"  value="1">';
            }
            

            var icontd = document.createElement("td");
            filetr.appendChild(icontd);
            icontd.style.width = "45px";
            icontd.style.paddingLeft = "6px";
            if (node.IsFolder) {
                var iconBox = document.createElement("span");
                iconBox.className = "gladinet-icons md-dark hand center  btniconcolor";
                iconBox.innerHTML = getFolderIcon(node);
                icontd.appendChild(iconBox);
            } else {
                var iconBox = document.createElement("span");
                iconBox.className = "gladinet-icons md-dark hand center  btniconcolor";
                iconBox.innerHTML = getFileIcon(node);
                icontd.appendChild(iconBox);
            }
            var nametd = document.createElement("td");
            filetr.appendChild(nametd);
            //nametd.className = "toolnavbtn";
            
            
            var max = parseInt(window.innerWidth - 40 - 40 - 30 - 128 - 100 - 100 - 40) + "px"
            nametd.innerHTML = "<div style=\"max-width:" + max + "\" title=\""+node.Key.replace("\"","&quot;")+"\">" + node.Key + "</div>";
            var lmtd = document.createElement("td");
            lmtd.innerHTML = node.LastModified;
            filetr.appendChild(lmtd);
            lmtd.style.width = "128px";

            var sizetd = document.createElement("td");
            sizetd.innerHTML = (node.IsFolder) ? "" : FormatFileSize(node.Size);
            filetr.appendChild(sizetd);
            sizetd.style.width = "100px";
            
            var optionstd = document.createElement("td");
            optionstd.style.width = "100px";
            optionstd.innerHTML = '<span class="gladinet-icons md-dark hand center btniconcolor" onclick="DownloadItem(\'row_' + cid + '\',' + node.IsFolder + ')" title="' + ExplorerGrid_1006_Download.replace("\"","&quot;") + '">&#xC5;</span>&nbsp;&nbsp;'+
                                  '<span class="gladinet-icons md-dark hand center btniconcolor" onclick="RestoreItem(\'row_' + cid + '\',' + node.IsFolder + ')" title="' + "<asp:Localize runat="server" meta:resourcekey="str_rst">Restore</asp:Localize>" + '">&#x13B;</span>';

            if (!_skipDownload) filetr.appendChild(optionstd);
            
            if (node.IsFolder) {
                nametd.onclick = function () {
                    if (gCurrentFolder == "")
                        SetCurrentFolder(node.Key);
                    else
                        SetCurrentFolder(gCurrentFolder + "/" + node.Key);
                }
            } else {


                nametd.onclick = function () {
                    
                    if (gCurrentFolder == '')
                        parent.ShowPreviewPanel(node.Key);
                    else
                        parent.ShowPreviewPanel(gCurrentFolder + "/" + node.Key);
                }
                nametd.ondblclick = function () {
                    if (gCurrentFolder == '')
                        parent.ShowPreviewPanel(node.Key);
                    else
                        parent.ShowPreviewPanel(gCurrentFolder + "/" + node.Key);
                }
            }
            itemList.appendChild(filetr);

        }

        var first = false;
        function SetDirContent(x) {
            try {
            //reset the select all checkbox
                document.getElementById("chkAll").checked = false;
            } catch (ex) { }
            try {
                //sort the output
                var keysSorted = null;
                keysSorted = x.Contents.slice(0).sort(function (a, b) {
                    var x = a["Key"].toLowerCase();
                    var y = b["Key"].toLowerCase();
                    if (x < y) { return -1; }
                    if (x > y) { return 1; }
                    return 0;
                });
                x.Contents = keysSorted;
            } catch (ex) { }

             var folderList = document.getElementById("FolderList");
             folderList.innerHTML = "";
             var fileList = document.getElementById("FileList");
             fileList.innerHTML = "";
             var listviewlist = document.getElementById("listcontent");
             listviewlist.innerHTML = "";
             
             if (!first) {                 
                 first = true;
                 //if (x.Contents.length < 15)
                   //  OnIconView();
             }
             for (var i = 0; i < x.Contents.length; ++i) {
                 var node = x.Contents[i];

                 if (node.Key == "41ED6C26-D5F8-424F-A311-BB4FF88140E5")
                     continue;
                 if (node.Key == "43811DCD-8C5A-4EF9-B903-2EEA9CE88487")
                     continue;
                 if (node.Key == "$$settings")
                     continue;
                 if (node.IsFolder) {
                     AddFolder(node, folderList);
                 } else {
                     AddFile(node, fileList);
                 }
                 
             }

             for (var i = 0; i < x.Contents.length; ++i) {
                 var node = x.Contents[i];

                 if (node.Key == "41ED6C26-D5F8-424F-A311-BB4FF88140E5")
                     continue;
                 if (node.Key == "43811DCD-8C5A-4EF9-B903-2EEA9CE88487")
                     continue;
                 if (node.Key == "$$settings")
                     continue;
                 if (node.IsFolder) {
                     AddListViewItem(node, listviewlist);
                 } 
                 
             }
             
             for (var i = 0; i < x.Contents.length; ++i) {
                 var node = x.Contents[i];

                 if (node.Key == "41ED6C26-D5F8-424F-A311-BB4FF88140E5")
                     continue;
                 if (node.Key == "43811DCD-8C5A-4EF9-B903-2EEA9CE88487")
                     continue;
                 if (!node.IsFolder) {
                     AddListViewItem(node, listviewlist);
                 }

             }
         }

         function RefreshCurrentFolder() {
             SetCurrentFolder(gCurrentFolder);
         }

         function RestoreItems(v) {
             
             Ext.Ajax.request({
                 url: "/management/DeviceSnapshotBrowser.aspx?c=rl",
                 success: function (response) {
                     
                     if (response.responseText == "restore task scheduled")
                         window.location = "BackupTaskStatus.aspx?tid=<%=DeviceId.Value%><% if (IsChildUi){ %>&child=1<%}%>";
                 },
                 failure: function () {

                 },
                 scope: this,
                 method: 'POST',
                 headers: {
                     'x-glad-token':  '<%=CurrentSession.Value%>',
                     'x-glad-snapshotid': gSnapshotId,
                     'x-glad-targetid': '<%=DeviceId.Value%>',
                     'Content-Type': 'application/x-www-form-urlencoded'
                 },
                 params: {
                     list: Base64.encode(v)
                 }
             });
         }
        function RestoreItem(rowID, isFolder) {
            gConfirm('Confirm you want to restore this file/folder?', "", function (btn1) {

                if (btn1 != 'ok')
                    return;

                var alias = $("#" + rowID)[0].AliasLocation;
             
                RestoreItems(isFolder + "|" + alias);
            });
         }

         function RestoreCurrentFolder() {
             gConfirm('Confirm you want to restore current folder?', "", function (btn1) {

                 if (btn1 != 'ok')
                     return;
                 RestoreItems("true|" + gCurrentFolder);
             });
             
         }
         function RestoreSelectedFiles() {
             gConfirm('Confirm you want to restore selected files?', "", function (btn1) {

                 if (btn1 != 'ok')
                     return;
                 var files = document.getElementsByTagName("input");
                 var SelectedFileList = "";
                 for (var i = 0; i < files.length; ++i) {
                     if (files[i].type == "checkbox") {
                         if (files[i].checked && StringStartsWith(files[i].name, "tt_")) {
                             if (SelectedFileList != "")
                                 SelectedFileList += "\n";

                             if (gCurrentFolder == "")
                                 SelectedFileList += "false|" + files[i].name.substring(3) + "\n";
                             else
                                 SelectedFileList += "false|" + gCurrentFolder + "/" + files[i].name.substring(3) + "\n";
                         }

                     }
                 }
                 RestoreItems(SelectedFileList);
             });
         }

         function DownloadCurrentFolder() {
             var uri = url = "/management/DeviceSnapshotBrowser.aspx?c=df&f=" + gEncodeUri(gCurrentFolder) + "&s=" + gSnapshotId + "&t=<%=DeviceId.Value%>";
             
             var e = document.getElementById("downloadframe");
             e.src = uri;

         }
         function DownloadSelectedFiles() {
             var files = document.getElementsByTagName("input");
             var SelectedFileList = gCurrentFolder;
             if (SelectedFileList == "")
                 SelectedFileList = "/";
             for (var i = 0; i < files.length; ++i) {
                 if (files[i].type == "checkbox") {
                     if (files[i].checked && StringStartsWith(files[i].name,"tt_")) {
                         if (SelectedFileList != "")
                             SelectedFileList += "\n";
                         
                        
                         SelectedFileList += files[i].name.substring(3) + "\t" + "0" + "\t0";
                     }

                 }
             }

             
             


             Ext.Ajax.request({
                 url: "/management/DeviceSnapshotBrowser.aspx?c=ml",
                 success: function (response) {
                     if (response.responseText.indexOf("[*]") != -1) {
                         alert(response.responseText.substring(3));
                         return;
                     }
                     var uri = "/management/DeviceSnapshotBrowser.aspx?c=dm&f=" + response.responseText + "&s=" + gSnapshotId + "&t=<%=DeviceId.Value%>";  
                     var e = document.getElementById("downloadframe");
                     e.src = uri;
                 },
                 failure: function () {

                 },
                 scope: this,
                 method: 'POST',
                 headers: {
                     'x-glad-token':  '<%=CurrentSession.Value%>',
                     'x-glad-snapshotid': gSnapshotId,
                     'Content-Type': 'application/x-www-form-urlencoded'
                 },
                 params: {
                     list: Base64.encode(SelectedFileList)
                 }
             });
         }
         
         function StringStartsWith(s, s1){
             var index = s.indexOf(s1);
             if(index == 0)
                 return true;
             return false;
         }
         function OnSelChanged() {
             try{
                 
             
                 var e = document.getElementById("downfiles");
                 e.style.display = "none";

                 var e1 = document.getElementById("restorefiles");
                 e1.style.display = "none";
                 
                 var files = document.getElementsByTagName("input");

                 for (var i = 0; i < files.length; ++i) {
                     if (files[i].type == "checkbox") {
                         if (files[i].checked && StringStartsWith(files[i].name, "tt_")) {
                             e.style.display = "";
                             e1.style.display = "";
                             return;
                         }
                     
                     }
                 }
             } catch (ee) {

             }
         }

         function OnIconView() {
             
             var e = document.getElementById("iconview_div");
             e.style.display = "";

             e = document.getElementById("listview_div");
             e.style.display = "none";

              
             
             
             try{
                 e = document.getElementById("lvbtn");
                 e.style.display = "";

                 e = document.getElementById("ivbtn");
                 e.style.display = "none";
             } catch (e) {

             }

             AdjustSize();

         }
         function OnListView() {
             var e = document.getElementById("iconview_div");
             e.style.display = "none";

             e = document.getElementById("listview_div");
             e.style.display = "";

             try{
                 e = document.getElementById("lvbtn");
                 e.style.display = "none";

                 e = document.getElementById("ivbtn");
                 e.style.display = "";
             } catch (e) {

             }
             
         }
         function SetCurrentFolder(fo) {


             Ext.Ajax.defaultHeaders = {
                 'Content-Type': "application/xml; charset=utf-8"
             };

             var received = function (response) {


                 try {
                     HideLoading();
                 } catch (ee1) {

                 }

                 
                 x = Ext.decode(response.responseText); // TODO: can we use json reader?
                 if (x !== null && x !== undefined) {

                     if (x.Success) {
                         try {
                             
                             var eea = document.getElementById("CurrentPath");
                             var sp = fo.replace(gRootFolder, "");
                             eea.title = sp;
                             sp = GetShortString(sp, 64);
                             if(sp.indexOf("/") != 0)
                                 eea.innerHTML = "/" + sp;
                             else
                                 eea.innerHTML = sp;
                             
                         } catch (eeeee) {
                             alert(eeeee);
                         }
                         gCurrentFolder = fo;
                         SetDirContent(x);
                         var e = document.getElementById('goupbtn');
                         var f = document.getElementById('restoreperm');
                         if (fo == gRootFolder) {
                             e.style.display = "none";
                             f.style.display = "";
                         } else {
                             e.style.display = "";
                             f.style.display = "none";
                         }

                         try {
                             if (x.Items != null && x.Items != undefined && x.FolderSize != null && x.FolderSize != undefined) {
                                 var s = x.Items + ExplorerDetail_Status_Text + FormatFileSize(x.FolderSize);
                                 if (parent.SetStatusText) {
                                     parent.SetStatusText(s);

                                 }
                             }
                         } catch (ep11) {
                         }

                         try{
                             AdjustSize();
                         } catch (ep22) {

                         }
                     } else {
                         alert("Failed to list dir:" + x.Reason);
                     }
                 } else {
                     alert("Failed to list dir");
                 }




             };

             try {
                 ShowLoading();
             } catch (ee1) {

             }



             var altpath = encodeURIComponent(fo);
             Ext.Ajax.request({
                 url: '/management/DeviceSnapshotBrowser.aspx?c=l', // + 'newcdir', //todo refactor to a file
                 success: received,
                 scope: this,
                 failure: function () {

                     alert("Failed to send request");
                     HideLoading();

                 },
                 method: 'GET',
                 headers: {
                     'x-glad-altpath': altpath,
                     'x-glad-token': '<%=CurrentSession.Value%>', // todo: make sure it is good token
                     'x-glad-tzoffset': getTzOffset(),
                     'x-glad-langid': getLangId(),
                     'x-glad-snapshotid': gSnapshotId

                 }
             });

         }



        function AdjustSize() {
            var f = document.getElementById('maindiv');
            f.style.height = (document.documentElement.clientHeight - 105) + "px";
            var e = document.getElementById("listviewtd");
            e.style.height = (document.documentElement.clientHeight - 190) + "px";

            try {
                var x = document.getElementsByClassName("fileoutboxex");
                if (!x)
                    return;

                if (x.length == 0)
                    return;
                var hh = 0;

                for (var i = 0; i < x.length; ++i) {
                    var w = x[i].offsetWidth - 30;

                    var h = Math.floor(w * 198 / 240) - 20;
                    if (h < 110)
                        h = 110;
                    if (hh == 0)
                        hh = h;
                    else {
                        h = hh;
                    }
                    x[i].style.height = (h + 30) + "px";




                }


            } catch (e) {
                alert(e);
            }
        }


        Ext.onReady(function () {
            CreateFileMap();
            SetCurrentFolder(gRootFolder);

            AdjustSize();
          
            

        });

        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });

    </script>
</asp:Content>
