﻿<%@ Page Title="Gladinet Cloud - Search" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceLockMgr.aspx.cs" Inherits="GladinetPayFlow.DeviceLockMgr"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function OpenFile(file) {
            var f = document.getElementById('rightpanel');
            f.src = "File.aspx?f=" + gEncodeUri(unescape(file));

        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_counlock" runat="server">Unlock the file:</asp:Localize>(" + unescape(name) + ")?")) {
            Wait("<asp:Localize meta:resourcekey="str_unlocking" runat="server">Unlocking...</asp:Localize>");
            ng.value = name;
            btn.click();
            }
        }

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">wiping...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        
    function OnAgentAttachedFolders(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceAttachedFolders.aspx?f=c&id=" + id + "&name=" + name;
    }

    function OnAgentTasks(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToUnlFil" meta:resourcekey="str_faiToUnlFil" Visible="false">Failed to unlock file</asp:Localize>
<asp:Localize runat="server" ID="LocDevNotFou" meta:resourcekey="str_devNotFou" Visible="false">device not found</asp:Localize>
    <asp:Localize ID="LocSttDyn" meta:resourcekey="str_sttDyn" runat="server" Visible="false">Dynamic</asp:Localize>
    <asp:Localize ID="LocSttPrm" meta:resourcekey="str_sttPrm" runat="server" Visible="false">Permanent</asp:Localize>
    <asp:Localize ID="LocUkn" meta:resourcekey="str_ukn" runat="server" Visible="false">Unknown</asp:Localize>
    <asp:Localize ID="LocLkdFilFnd" meta:resourcekey="str_lkdFilFnd" runat="server" Visible="false">locked file(s) found</asp:Localize> 
   <div class="navbar navbar-default meubardrop" role="navigation">
      <div class="container-fluid">
          <p class="navbar-text">
              <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="badge"></asp:Label>
          </p>
          <p class="navbar-text">
                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
          </p>
          
                
                <div class="navbar-form navbar-right" >
                                        <asp:Button ID="Button1" runat="server" Text="Refresh" OnClick="Button1_Click"  CssClass="btn btn-primary gladbtn"
                                             meta:resourcekey="Button1Resource1" />
                     </div>
                
          
      </div>
    </div>
    <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: 13px" cellspacing="0" id="grid-table"
                    cellpadding="0">
                   
                    
                    <tr>
                        <td colspan="3" style="vertical-align: top;" id="result_div">
                        </td>
                    </tr>
                   
                </table>
    
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
    <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" 
            Visible="False" Text=" Days ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" 
            Visible="False" Text=" Hours ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" 
            Visible="False" Text=" Minutes ago"></asp:Localize>
    <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" 
            Visible="False" Text="Less than 1 minute ago"></asp:Localize>

    </div>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
        <asp:Button ID="WipeDevice" runat="server" OnClick="WipeDevice_Click" 
            meta:resourcekey="WipeDeviceResource1" />
        <asp:Button ID="DeleteDevice" runat="server" OnClick="DeleteDevice_Click" 
            meta:resourcekey="DeleteDeviceResource1" />
        <asp:HiddenField ID="HiddenInstanceId" runat="server" />
    </div>
    <script type="text/javascript">    
var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" enableviewstate="false" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"OwnerName").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"FilePath").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LockedUser").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LockedMachine").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LockTime").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LockId").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"LockType").ToString().Replace("'","%27")) %>'
         ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

        function OnChange(id) {
          
            var idc = document.getElementById("MainContent_InstanceId");
            var db = document.getElementById("MainContent_DenyBtn");
            var ab = document.getElementById("MainContent_AllowBtn");
            idc.value = id;

            var e = document.getElementById(id);
            if (e.checked) {
              
                ab.click();
            } else {
          
                db.click();
            }

        }

        var grid;
      
        function AdjustGridTable () {
           
            var h = 400;
          
            try {

                var myTable = Ext.get('grid-table');
           
                var tableY = myTable.getY();
           
                h = document.body.offsetHeight-tableY-60;
           
                var ee = document.getElementById('tinfo');
                ee.style.height = h + "px";

            } catch (err) {
            }
            grid.setWidth(document.documentElement.clientWidth - 2);
            grid.setHeight(h);
            grid.doComponentLayout();

            var e = document.getElementById("result_div");
            e.style.height = h + "px";

        }

        Ext.require([
            'Ext.grid.*',
            'Ext.data.*',
            'Ext.util.*',
            'Ext.state.*'
        ]);
        Ext.onReady(function () {

            Ext.QuickTips.init();

            var store = Ext.create('Ext.data.ArrayStore', {
                fields: [
                    { name: 'index' },
                    { name: 'owner' },
                    { name: 'filepath' },
                    { name: 'luser' },
                    { name: 'ldevice' },
                    { name: 'ltime' },
                    { name: 'lid' },
                    { name: 'ltype' }
                ],
                data: myData
            });


            grid = Ext.create('Ext.grid.Panel', {
                store: store,
                stripeRows: true,
                border: true,
                columnLines: true,
                minHeight: 208,              
                minButtonWidth: 28,
                viewConfig: {
                    emptyText: "<asp:Localize meta:resourcekey="str_nolock" runat="server">No Lock Found</asp:Localize>",
                    deferEmptyText: false
                },
          
                columns: [
                    {
                        text: '',
                        width: 50,
                        sortable: false,
                        hideable: false,
                        dataIndex: 'index',
                        getClass: function (v, meta, rec) {
                            return 'x-col-hide';
                        }
                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_fowner" runat="server">File Owner</asp:Localize>",                      
                        width:178,
                        sortable: true,
                        dataIndex: 'owner',
                        renderer: function (value, metaData, record, rowIndex) {
                            return unescape(value);
                        }

                    },
                    {
                        text: "<asp:Localize meta:resourcekey="str_fpath" runat="server">File Path</asp:Localize>",
                        flex: 1,
                        minWidth: 175,
                        sortable: true,
                        dataIndex: 'filepath',
                        renderer: function (value, metaData, record, rowIndex) {
                            return unescape(value);
                        }
                    }, {
                        text: "<asp:Localize meta:resourcekey="str_lfrom" runat="server">Locked From</asp:Localize>",
                        minWidth: 80,                        
                        width:175,
                        sortable: true,
                        dataIndex: 'ldevice'
                    }, {
                        text: "<asp:Localize meta:resourcekey="str_ltype" runat="server">Type</asp:Localize>",
                        minWidth: 80,                        
                        width:175,
                        sortable: true,
                        dataIndex: 'ltype'
                    }, {
                        text: "<asp:Localize meta:resourcekey="str_ltime" runat="server">Locked Time</asp:Localize>",
                        minWidth: 175,
                        width:175,
                        sortable: true,
                        dataIndex: 'ltime'
                    }, {
                        xtype: 'actioncolumn',
                        width: 110,
                        hideable: false,
                        items:
                        [
                            {
                                icon: '/portal/images/unlock.png', // Use a URL in the icon config
                                tooltip: "<asp:Localize meta:resourcekey="str_unlock" runat="server">Unlock</asp:Localize>",
                              width: 30,
                              handler: function(grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;
                                  OnWipeDevice(decodeHTML(d.lid), decodeHTML(d.filepath));
                              },
                              getClass: function(v, meta, rec) {
                                 
                           
                              }
                          }
                  ]
              }
                  ],
              renderTo: 'result_div'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
        });
        function decodeHTML(html) {
            var txt = document.createElement('textarea');
            txt.innerHTML = html;
            return txt.value;
        };
    </script>
</asp:Content>
