﻿<%@ Page Title="Client Management Console" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceInfo.aspx.cs" Inherits="GladinetPayFlow.DeviceInfo"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }

        function EditNoCacheList() {
            parent.parent.EditNoCacheListWithDomain('<%=SessionDomainId %>');

        }

        function OnDeviceList() {
            window.location = "/portal/SearchDevicesPage.aspx";
        }

        function OnGetSyncStatus(id, name) {
            
            parent.SetSubView( "/management/DeviceSyncScan.aspx?f=c&id=" + id + "&name=" + name,name);
            
        }

        function OnDeviceAttachedFolder()
        {
            parent.SetSubView("DeviceAttachedFolders.aspx?id=<%=InstanceId.Value%>",  "Attached Folders");
        }

        function OnDeviceTask() {
            parent.SetSubView("DeviceTasks.aspx?id=<%=InstanceId.Value%>",  "Tasks Manager");
        }

         function OpenSubTask(tid, t, ti) {
            parent.SetSubView("DeviceSubTasks.aspx?id=<%=InstanceId.Value%>&tid=" + tid + "&t=" + t,ti);
         }

        function UnlockFile(id, name) {
            var ng = document.getElementById("ctl00_MainContent_LockId");
            var btn = document.getElementById("ctl00_MainContent_UnlockBtn");

            if (confirm("<asp:Localize meta:resourcekey="str_counlock" runat="server">Unlock the file:</asp:Localize>(" + unescape(name) + ")?")) {
            Wait("<asp:Localize meta:resourcekey="str_unlocking" runat="server">Unlocking...</asp:Localize>");
            ng.value = id;
            btn.click();
            }
        }


        function DeleteSubTask(pidin, id)
        {
            var pid = document.getElementById("ctl00_MainContent_ParentTaskId");
            var sid = document.getElementById("ctl00_MainContent_SubTaskId");
            var btn = document.getElementById("ctl00_MainContent_DeleteSubTaskBtn");

            if (confirm(" Confirm delete this sync task?")) {
                Wait("...");
                pid.value = pidin;
                sid.value = id;
                btn.click();
        }
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize ID="LocFldLodInf" meta:resourcekey="str_fldLodInf" runat="server" Visible="false">Failed to load device info</asp:Localize>
    <asp:Localize id="LocUkwn" meta:resourcekey="str_ukwn" runat="server" Visible="false">unknown</asp:Localize>
    <asp:Localize id="LocSng" meta:resourcekey="str_sng" runat="server" Visible="false">Syncing</asp:Localize>
    <asp:Localize id="LocSncFld" meta:resourcekey="str_sncFld" runat="server" Visible="false">Sync Failed</asp:Localize>
    <asp:Localize id="LocSncd" meta:resourcekey="str_sncd" runat="server" Visible="false">Synced</asp:Localize>
    <asp:Localize id="LocFldRtvSncSts" meta:resourcekey="str_fldRtvSncSts" runat="server" Visible="false">Failed to retrieve sync status</asp:Localize>
    <asp:Localize id="LocSncTskPng" meta:resourcekey="str_sncTskPng" runat="server" Visible="false">Sync task pending</asp:Localize>
    <asp:Localize id="LocSncTskPsd" meta:resourcekey="str_sncTskPsd" runat="server" Visible="false">Sync task paused</asp:Localize>
    <asp:Localize id="LocFldLodUsrInf" meta:resourcekey="str_fldLodUsrInf" runat="server" Visible="false">Failed to load device info</asp:Localize>
    <asp:Localize id="LocCntLocOwnUsrInf" meta:resourcekey="str_cntLocOwnUsrInf" runat="server" Visible="false">Cannot locate owner's user info</asp:Localize>
    <asp:Localize id="LocFldEnmAtcFld" meta:resourcekey="str_fldEnmAtcFld" runat="server" Visible="false">failed to enumerate attached folders</asp:Localize>
    <asp:Localize id="LocFldLod" meta:resourcekey="str_fldLod" runat="server" Visible="false">Failed to load</asp:Localize>
    <asp:Localize id="LocFldLodTskLst" meta:resourcekey="str_fldLodTskLst" runat="server" Visible="false">Failed to load task list</asp:Localize>
    <asp:Localize id="LocFld" meta:resourcekey="str_fld" runat="server" Visible="false">Failed to load task list</asp:Localize>
    
    <asp:Localize id="LocTskNmeUpd" meta:resourcekey="str_tskNmeUpd" runat="server" Visible="false">UPLOAD</asp:Localize>
    <asp:Localize id="LocTskNmeDwd" meta:resourcekey="str_tskNmeDwd" runat="server" Visible="false">DOWNLOAD</asp:Localize>
    <asp:Localize id="LocTskNmeCrtDir" meta:resourcekey="str_tskNmeCrtDir" runat="server" Visible="false">Create Directory</asp:Localize>
    <asp:Localize id="LocTskNmeApyFilChg" meta:resourcekey="str_tskNmeApyFilChg" runat="server" Visible="false">Apply File Change</asp:Localize>
    <asp:Localize id="LocTskNmeUpdLc" meta:resourcekey="str_tskNmeUpdLc" runat="server" Visible="false">Upload</asp:Localize>
    <asp:Localize id="LocTskNmeDel" meta:resourcekey="str_tskNmeDel" runat="server" Visible="false">Delete</asp:Localize>
    
    <div class="wrapper" style="background-color: white; width: 100%; font-size: 16px;">

        <table width="98%" align="center">
            <%if (SessionMMCMode){ %>
            <tr style="display: none;">
                <td style="padding: 5px; padding-top: 30px;" colspan="2" align="right">

                    <button type="button" class="btn btn-default btn-lg" data-toggle="modal" data-target="#myModal">
                        <asp:Localize meta:resourcekey="str_startmmc" runat="server">Start Native Management Console</asp:Localize></button>





                </td>

            </tr>
            <%} %>
            <tr>
                <td style="padding-top: 20px; padding:10px;">
                    <div class="row ">
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
                            <div class="staticviewcard">

                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor" >
                                    <table width="100%">
                                        <tr>
                                            <td style="font-weight:400;text-align:center">
                                                <asp:Localize meta:resourcekey="str_devinfo" runat="server">Device Info</asp:Localize>
                                            </td>
                                            <td align="right"></td>
                                        </tr>
                                    </table>

                                </div>
                                <div class="panel-body" style="padding: 5px; height: 400px;">
                                    <table width="100%" class="table-striped">
                                        <tr>
                                            <td colspan="2">
                                                <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <%if (!SessionMMCMode)
                                        { %>
                                        <tr style="display: none;">
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_devicename" runat="server">Device Name</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="DeviceName" runat="server" meta:resourcekey="DeviceNameResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <%} %>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_owner" runat="server">Device Owner</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="DeviceOwner" runat="server" meta:resourcekey="DeviceOwnerResource1"></asp:Label>
                                            </td>
                                        </tr>
                                       
                                        <% if (SessionIsAdmin || SessionIsClusterAdmin || SessionIsDelegateClusterAdmin) { %>
                                        <tr>
                                            <td  style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_allowed" runat="server">Allowed</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:CheckBox ID="DeviceAllowed" runat="server" AutoPostBack="True" OnCheckedChanged="DeviceAllowed_CheckedChanged"
                                                    meta:resourcekey="DeviceAllowedResource1" />
                                            </td>
                                        </tr>
                                        <% } %>

                                         <tr>
                                            <td  style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_mondevice" runat="server">Monitor Device Connected Status</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:CheckBox ID="DeviceMonitor" runat="server" AutoPostBack="True" OnCheckedChanged="DeviceMonitor_CheckedChanged"
                                                    meta:resourcekey="DeviceAllowedResource1" />
                                            </td>
                                        </tr>
                                       
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_devicetype" runat="server">Device Type</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="DeviceType" runat="server" meta:resourcekey="DeviceTypeResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_ostype" runat="server">OS Type</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="OSType" runat="server" meta:resourcekey="OSTypeResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_clientver" runat="server">Client Device Version</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="ClientVer" runat="server" meta:resourcekey="ClientVerResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_lastlogin" runat="server">Last Logon Time</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="LastLoginTime" runat="server" meta:resourcekey="LastLoginTimeResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_syncstatus" runat="server">Sync Status</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="SyncStatus" runat="server" meta:resourcekey="SyncStatusResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_cachesize" runat="server">Cache Size</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="CacheFolderSize" runat="server" meta:resourcekey="LastReportTimeResource1"></asp:Label>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 5px;">

                                                <asp:Localize meta:resourcekey="str_lreport" runat="server">Last Reported Time</asp:Localize>
                                            </td>
                                            <td style="padding: 5px;">
                                                <asp:Label ID="LastReportTime" runat="server" meta:resourcekey="LastReportTimeResource1"></asp:Label>
                                            </td>
                                        </tr>



                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer" style="padding-bottom:10px;">
                            <div class="staticviewcard">
                                 <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor" >
                                    <table width="100%">
                                        <tr>
                                            <td style="font-weight:400;text-align:center">
                                                <asp:Localize meta:resourcekey="str_ts" runat="server" Visible="false">Tasks</asp:Localize>
                                                <asp:Localize meta:resourcekey="str_syncstatus" runat="server">Sync Status</asp:Localize>
                                                <div style="float:right">
                                                    <span class="fa fa-wrench sectextcolor" style="font-size:14px; cursor:pointer;" onclick="OnDeviceTask();" title="<asp:Localize meta:resourcekey="str_tskMgr" runat="server">Tasks Manager</asp:Localize>"></span>
                                                    <asp:LinkButton ID="LinkButton1" runat="server" OnClick="LinkButton1_Click">&nbsp;&nbsp;
                                                    <span class="fa fa-refresh sectextcolor" style="font-size:14px; cursor:pointer;"  title="<asp:Localize meta:resourcekey="str_rfh" runat="server">Refresh</asp:Localize>"></span>
                                                        </asp:LinkButton>
                                                </div>

                                            </td>
                                        </tr>
                                    </table>

                                </div>
                                <div class="panel-body" style="padding: 5px; height: 400px;">
                                    <%if (SyncItemRepeater.Items.Count == 0)  { %>
                                       
                                            <table width="100%">
                                                <tr>
                                                    <td style="padding:5px;padding-top:100px;">
                                                         <span class="fa fa-check" style="font-size:64px; color:#008000;"></span>
                                                    </td>
                                                    </tr><tr>

                                                    <td style="padding:5px; font-size:24px; color:#808080; align-content:center;">
                                                        <asp:Localize meta:resourcekey="str_nosynctask" runat="server">No sync task found.</asp:Localize>
                                                    </td>
                                                </tr>
                                            </table>
                                       
                                    <%}else { %>
                                    <table width="100%" class="table-striped">
                                         <asp:Repeater ID="SyncItemRepeater" runat="server" >
                                            <ItemTemplate>
                                                <tr onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';"  onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                                <td width="32px" style="padding:5px; padding-top:7px;" valign="middle">
                                                    <span class="fa fa-<%#DataBinder.Eval(Container.DataItem,"StatusIcon") %>" style="font-size:18px;color:<%#DataBinder.Eval(Container.DataItem,"StatusColor") %>;"></span>

                                                </td>
                                                <td style="padding:5px;font-size:18px;width:140px;"  align="left"><%#DataBinder.Eval(Container.DataItem,"TaskName") %></td>
                                                <td style="padding:5px;" align="left"><%#DataBinder.Eval(Container.DataItem,"TaskPara1") %></td>
                                                <td style="padding:5px; color:#800000;" nowrap="nowrap"><%#DataBinder.Eval(Container.DataItem,"LastError") %></td>
                                                <td style="padding:5px; width:32px;">
                                                    <div class="toolbtn" style="cursor:pointer;">
                                                         <span class='gladinet-icons md-24 md-dark hand center toolbtn'   onclick="DeleteSubTask('<%#DataBinder.Eval(Container.DataItem,"ParentTaskId") %>', '<%#DataBinder.Eval(Container.DataItem,"TaskId") %>');">n</span>
                                                    </div>

                                                </td>
                                            </tr>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </table>
                                    <%} %>
                                </div>
                            </div>
                        </div>
                        <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer">
                            <div class="staticviewcard">

                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor" >
                                    <table width="100%">
                                        <tr>
                                            <td style="font-weight:400;text-align:center">
                                                <asp:Localize meta:resourcekey="str_lockedfiles" runat="server">Locked Files</asp:Localize>
                                            </td>
                                            <td align="right"></td>
                                        </tr>
                                    </table>

                                </div>
                                <div class="panel-body" style="padding: 5px; height: 300px; overflow:auto;">
                                    <%if (LocksRepeater.Items.Count == 0)  { %>
                                        <div style="padding:30px; font-size:24px; color:#808080; align-content:center;">
                                            <table>
                                                <tr>
                                                    <td style="padding:5px;">
                                                        <i class="gladinet-icons md-32 md-dark hand center toolbtn">r</i>
                                                    </td>
                                                    <td style="padding:5px; font-size:24px; color:#808080; align-content:center;">
                                                        <asp:Localize meta:resourcekey="str_nolock" runat="server">No locked file found.</asp:Localize>
                                                    </td>
                                                </tr>
                                            </table>
                                            </div>
                                    <%}else { %>
                                     <table width="100%" class="table-striped">
                                    <asp:Repeater ID="LocksRepeater" runat="server" enableviewstate="false" >
                                        <ItemTemplate>         
                                            <tr onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';"  onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                                <td width="32px"><i class="gladinet-icons md-32 md-dark hand center toolbtn">r</i></td>
                                                <td style="padding:5px;font-size:18px;" align="left"><%#DataBinder.Eval(Container.DataItem,"FilePath") %></td>
                                                <td style="padding:5px;width:100px;"><%#DataBinder.Eval(Container.DataItem,"LockType") %></td>
                                                <td style="padding:5px;" nowrap="nowrap"><%#DataBinder.Eval(Container.DataItem,"LockTime") %></td>
                                                <td style="padding:5px; width:32px;">
                                                    <div class="toolbtn" style="cursor:pointer;">
                                                        <img src="/portal/images/unlock.png" width="32px" title="<%=str_unlock.Text %>" onclick='UnlockFile("<%#DataBinder.Eval(Container.DataItem,"LockId") %>","<%#DataBinder.Eval(Container.DataItem,"FilePath") %>");' class="toolbtn"/>

                                                    </div>

                                                </td>
                                            </tr>
                                        </ItemTemplate>         
                                    </asp:Repeater>
                                         </table>
                                    <%} %>
                                </div>
                            </div>
                        </div>
                         <div class="col-xs-12 col-sm-12 col-md-6 col-lg-6 text-center topbuffer">
                            <div class="staticviewcard">

                                <div style="padding: 10px; border-bottom: 1px solid #f0f0f0;" class="boxbordercolor secsubcolor" >
                                    <table width="100%">
                                        <tr>
                                            <td style="font-weight:400;text-align:center">
                                                <asp:Localize meta:resourcekey="str_attfolders" runat="server">Attached Folders</asp:Localize>
                                                 <div style="float:right">
                                                    <span class="fa fa-wrench sectextcolor" style="font-size:14px; cursor:pointer;" onclick="OnDeviceAttachedFolder();" title="<asp:Localize meta:resourcekey="str_attfolders" runat="server">Attached Folders</asp:Localize>"></span>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>

                                </div>
                                <div class="panel-body" style="padding: 5px; height: 300px; overflow:auto;">
                                     <%if (AttachedFolderRepeater.Items.Count == 0)  { %>
                                        <div style="padding:30px; font-size:24px; color:#808080; align-content:center;">
                                            <table>
                                                <tr>
                                                    <td style="padding:5px;">
                                                        <i class="gladinet-icons md-32 md-dark hand center toolbtn">`</i>
                                                    </td>
                                                    <td style="padding:5px; font-size:24px; color:#808080; align-content:center;">
                                                        <asp:Localize meta:resourcekey="str_noattfolders" runat="server">No attached folder found.</asp:Localize>
                                                    </td>
                                                </tr>
                                            </table>
                                            </div>
                                    <%}else { %>
                                     <table width="100%" class="table-striped">

                                    <asp:Repeater ID="AttachedFolderRepeater" runat="server" enableviewstate="false" >
                                        <ItemTemplate>         
                                            <tr onmouseover="this.style.borderBottom='1px solid #008000';this.style.borderTop='1px solid #008000';"  onmouseout="this.style.borderBottom='0px solid #008000';this.style.borderTop='0px solid #008000';">
                                                <td width="32px"><i class="gladinet-icons md-32 md-dark hand center toolbtn">`</i></td>
                                                <td style="padding:5px;font-size:18px;padding-left:5px;" align="left"><%#DataBinder.Eval(Container.DataItem,"CloudFolder") %></td>
                                                <td style="padding:5px;" align="left"><%#DataBinder.Eval(Container.DataItem,"LocalFolder").ToString().Replace("\\\\", "\\") %></td>
                                                <td style="padding:5px;width:100px;" nowrap="nowrap" align="left"><%#DataBinder.Eval(Container.DataItem,"Type") %></td>
                                                <td style="padding:5px; width:32px;">
                                                    <span class='gladinet-icons md-24 md-dark hand center toolbtn'  title="<asp:Localize runat="server" meta:resourcekey="str_shwNotSnc">Show items not synced</asp:Localize>" onclick='OnGetSyncStatus("<%=InstanceId.Value %>","<%#DataBinder.Eval(Container.DataItem,"CloudFolder") %>"); return false;'>&#xBF;</span>
                                                </td>
                                            </tr>
                                        </ItemTemplate>         
                                    </asp:Repeater>
                                         </table>
                                    <%} %>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div id="myModal" class="modal fade" role="dialog">
                        <div class="modal-dialog">

                            <!-- Modal content-->
                            <div class="modal-content">
                                <div class="modal-header">
                                                                        <h4 class="modal-title">
                                        <asp:Localize meta:resourcekey="str_startmmc" runat="server">Start Native Management Console</asp:Localize></h4>

                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <p>
                                        <h4><asp:Localize runat="server" meta:resourcekey="str_SerAge">Server Agent:</asp:Localize></h4>
                                        <asp:Localize meta:resourcekey="str_sahelp" runat="server"> 1. Open a command prompt and browse to the installation folder<br/>
                2. run the follow command line:<br/>
                gtaskmmc /server /runlocal<br/><br/></asp:Localize>
                                        <h4><asp:Localize runat="server" meta:resourcekey="str_WinCli">Windows Client:</asp:Localize></h4>
                                        <asp:Localize meta:resourcekey="str_winhelp" runat="server">1. Open a command prompt and browse to the installation folder<br/>
                2. run the follow command line:<br/>
                gtaskmmc  /runlocal</asp:Localize><br />
                                        <br />
                                    </p>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-default" data-dismiss="modal">
                                        <asp:Localize meta:resourcekey="str_closetext" runat="server">Close</asp:Localize></button>
                                </div>
                            </div>

                        </div>
                    </div>

                </td>
            </tr>
        </table>

    </div>
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Text=" Days ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Text=" Hours ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Text=" Minutes ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Text="Less than 1 minute ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_never" ID="StrNever" runat="server"
            Text="Never"></asp:Localize>
            <asp:Localize ID="LocSttDyn" meta:resourcekey="str_sttDyn" runat="server" Visible="false">Dynamic</asp:Localize>
    <asp:Localize ID="LocSttPrm" meta:resourcekey="str_sttPrm" runat="server" Visible="false">Permanent</asp:Localize>
    <asp:Localize ID="LocUkn" meta:resourcekey="str_ukn" runat="server" Visible="false">Unknown</asp:Localize>
        <asp:Localize meta:resourcekey="str_unlock" id="str_unlock" runat="server">Unlock</asp:Localize>
    <asp:Button ID="UnlockBtn" runat="server" Text="UnlockBtn" OnClick="UnlockBtn_Click" />
        <asp:HiddenField ID="LockId" runat="server" />
        <asp:HiddenField ID="ParentTaskId" runat="server" />
        <asp:HiddenField ID="SubTaskId" runat="server" />
        <asp:Button ID="DeleteSubTaskBtn" runat="server" Text="UnlockBtn" OnClick="DeleteSubTaskBtn_Click" />
    </div>

</asp:Content>
