﻿<%@ Page Title="Client Management Console" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceDig.aspx.cs" Inherits="GladinetPayFlow.DeviceDig"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }

        function EditNoCacheList() {
            parent.parent.EditNoCacheListWithDomain('<%=SessionDomainId %>');

        }

        function OnDeviceList() {
            window.location = "/portal/SearchDevicesPage.aspx";
        }

        function LoadTaskAudit(tid) {
            
            var b = document.getElementById("ctl00_MainContent_LoadTaskAudit");
            var t = document.getElementById("ctl00_MainContent_HiddenTaskId");

            t.value = tid;
            
            b.click();
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToDow" meta:resourcekey="str_faiToDow" Visible="false">Failed to download</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToSetTraLev" meta:resourcekey="str_faiToSetTraLev" Visible="false">Failed to set trace level</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaFaiTasLis" meta:resourcekey="str_faiToLoaFaiTasLis" Visible="false">Failed to load failed task list</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToGetSysInfForTheDev" meta:resourcekey="str_faiToGetSysInfForTheDev" Visible="false">Failed to get system info for the device</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDevInf" meta:resourcekey="str_faiToLoaDevInf" Visible="false">Failed to load device info</asp:Localize>
    <asp:Localize ID="LocSncStsTxtUnk" meta:resourcekey="str_sncStsTxtUnk" runat="server" Visible="false">Unknown</asp:Localize>
    <asp:Localize ID="LocSncStsTxtSng" meta:resourcekey="str_sncStsTxtSng" runat="server" Visible="false">Syncing</asp:Localize>
    <asp:Localize ID="LocSncStsTxtFld" meta:resourcekey="str_sncStsTxtFld" runat="server" Visible="false">Sync failed</asp:Localize>
    <asp:Localize ID="LocSncStsTxtScd" meta:resourcekey="str_sncStsTxtScd" runat="server" Visible="false">Synced</asp:Localize>
    <asp:Localize ID="LocSncStsTxtFldRtvSts" meta:resourcekey="str_sncStsTxtFldRtvSts" runat="server" Visible="false">Failed to retrieve sync status</asp:Localize>
    <asp:Localize ID="LocSncStsTxtPnd" meta:resourcekey="str_sncStsTxtPnd" runat="server" Visible="false">Sync task pending</asp:Localize>
    <asp:Localize ID="LocSncStsTxtPsd" meta:resourcekey="str_sncStsTxtPsd" runat="server" Visible="false">Sync task paused</asp:Localize>

    <div class="wrapper" style="background-color: white; width: 100%; font-size: 16px;">
        <asp:Label ID="ErrorMsg" runat="server" ForeColor="Red" meta:resourcekey="ErrorMsgResource1"></asp:Label>

        <table width="100%" class="table">
            <tr>
                <td colspan="2"></td>
            </tr>


            <tr>
                <td align="center" style="padding: 20px; ">
                    <asp:Panel ID="DebugPanel" runat="server">
                        <table class="table-striped" style="font-size: 18px; font-weight: 100;border: 1px solid #f0f0f0;">
                            <tr>
                                <td style="padding: 15px;">

                                    <asp:Localize meta:resourcekey="str_syncstatus" runat="server">Sync Status</asp:Localize>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:Label ID="SyncStatus" runat="server" meta:resourcekey="SyncStatusResource1"></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td width="500px" style="padding: 15px;">
                                    <asp:Localize meta:resourcekey="str_enbTrc" runat="server">Enable Tracing</asp:Localize>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:CheckBox ID="TraceEnabled" runat="server" AutoPostBack="True" OnCheckedChanged="TraceEnabled_CheckedChanged"
                                        meta:resourcekey="DeviceAllowedResource1" />
                                </td>
                            </tr>
                             <tr>
                                <td width="500px" style="padding: 15px;">
                                    <asp:Localize meta:resourcekey="str_stmAdtTrc" runat="server">System Audit Trace</asp:Localize>
                                </td>
                                <td style="padding: 15px;">
                                    <asp:LinkButton ID="GetSysAudit" runat="server" OnClick="GetSysAudit_Click" CssClass="btn btn-primary gladbtn">
                                        <span class="fa fa-download" style=" cursor: pointer;" title="<asp:Localize meta:resourcekey="str_dnl" runat="server">Download</asp:Localize>"></span>
                                    </asp:LinkButton>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2"></td>
                            </tr>
                            <tr>
                                <td colspan="2" style="padding: 15px;">
                                    <table width="100%">
                                        <tr>
                                            <td style="background-color: #f0ffff">
                                                <asp:Localize meta:resourcekey="str_ft" runat="server">Failed Tasks</asp:Localize>&nbsp;&nbsp;(<asp:Label ID="FailedTaskCounts" runat="server" Text="Label"></asp:Label>)
                                            </td>
                                        </tr>
                                        <tr>
                                            <td style="padding: 10px;">
                                                <table class="table" width="100%">
                                                    <asp:Repeater ID="TaskRepeater" runat="server" >
                                                    <ItemTemplate>
                                                        <tr>
                                                            <td id="tdTaskDesc<%# Container.ItemIndex + 1 %>">
                                                                 <%#DataBinder.Eval(Container.DataItem,"TaskDesc") %>
                                                            </td>
                                                            <td width="50px">
                                                                <script>
                                                                    var tskDsc = document.getElementById("tdTaskDesc<%# Container.ItemIndex + 1 %>");
                                                                    if(tskDsc){
                                                                        switch(tskDsc.innerText.toLowerCase().trim()){
                                                                            case "system check task":
                                                                                tskDsc.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmChkTask">System Check Task</asp:Localize>";
                                                                                break;
                                                                            case "system sync task":
                                                                                tskDsc.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmSnkTask">System Sync Task</asp:Localize>";
                                                                                break;
                                                                            case "system sync down task":
                                                                                tskDsc.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmSnkDwnTask">System Sync Down Task</asp:Localize>";
                                                                                break;
                                                                            case "system update task":
                                                                                tskDsc.innerText = "<asp:Localize runat="server" meta:resourcekey="str_stmUpdTask">System Update Task</asp:Localize>";
                                                                                break;
                                                                        }
                                                                    }
                                                                </script>
                                                                <span class="fa fa-eye-open" style="color: #565656; cursor: pointer;" title="<asp:Localize meta:resourcekey="str_morInf" runat="server">More Info</asp:Localize>" onclick='LoadTaskAudit("<%#DataBinder.Eval(Container.DataItem,"TaskId") %>");'></span>
                                                            </td>
                                                        </tr>
                                                    </ItemTemplate>
                                                </asp:Repeater>
                                                </table>
                                            </td>
                                        </tr>
                                        
                                    </table>
                                </td>
                                
                            </tr>
                           
                        </table>
                    </asp:Panel>
                    <asp:Panel ID="NoDebugPanel" runat="server">
                        <div style="padding: 40px; align-content: center; font-size: 24px; font-weight: 100; color: #565656"><asp:Localize meta:resourcekey="str_noRmtDbg" runat="server">This device doesn't support remote debugging. Please upgrade to latest version.</asp:Localize>
                        </div>
                    </asp:Panel>
                </td>
            </tr>





        </table>



    </div>
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Text=" Days ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Text=" Hours ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Text=" Minutes ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Text="Less than 1 minute ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_never" ID="StrNever" runat="server"
            Text="Never"></asp:Localize>
        <asp:HiddenField ID="HiddenTaskId" runat="server" />
         <asp:Button ID="LoadTaskAudit" runat="server" Text="Button" OnClick="LoadTaskAudit_Click" />
    </div>
   
</asp:Content>
