﻿<%@ Page Title="Client Management Console" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceDashboard.aspx.cs" Inherits="GladinetPayFlow.DeviceDashboard"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }

        .badgefont {
            font-size: 15px;
        }

      
        .err {
            color: red;
        }

            .smallbtn {
            padding-left: 3px !important;
            padding-right: 3px !important;
                font-weight: 100 !important;
        }

        .tspan{
            font-weight:100;
            color:#404040;

        }
    </style>
    <script type="text/javascript">

        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);



        function closeCancelActiveWin() {
        }

        function closeActiveWin() {
            window.location = "AddUserPage.aspx";
        }

        function OnCancelApply() {
            parent.closeActiveWin();
        }

        function dummy(e) {
            if (window.event) {
                window.event.cancelBubble = true;
            } else {
                e.stopPropagation();
            }

        }
        var lastexpand = "";
        function Toggle(name) {
            var d = document.getElementById(name);
            var i = document.getElementById(name + "icon");


            if (lastexpand != "" && name != lastexpand) {

                var ld = document.getElementById(lastexpand);
                var li = document.getElementById(lastexpand + "icon");
                ld.style.display = 'none';
                li.src = "images/expand.png";

                lastexpand = "";
            }

            if (d.style.display == 'none') {
                d.style.display = '';
                i.src = "images/collapse.gif";
                lastexpand = name;
            } else {
                d.style.display = 'none';
                i.src = "images/expand.png";
            }
        }

        function EditNoCacheList() {
            parent.parent.EditNoCacheListWithDomain('<%=SessionDomainId %>');

        }

        function OnDeviceList() {
            window.location = "/portal/SearchDevicesPage.aspx";
        }

         var MainViewUrl = 'DeviceInfo.aspx?id=<%=InstanceId.Value %>';
        var MainViewTitle = "<%=str_devinfo.Text%>";

        function OnClickMainView() {
            SetView(MainViewUrl, MainViewTitle);
        }

        function SetView(Url, t) {
            MainViewUrl = Url;
            MainViewTitle = t;
            try {
                Wait("One minute");
            } catch (e) {

            }

            var e = document.getElementById("main_body");
            e.src = Url;

            //there is no currentmainview on this page, just skip this for now
            //e = document.getElementById("currentmainview");
            //e.innerHTML = "&nbsp;>&nbsp;" + t;

            SetSubTitle("");
        }


        var SubViewUrl;
        var SubViewTitle;

        function SetSubTitle(t) {
            return;
            //there is no currentsubview on this page, just return for now
            var e = document.getElementById("currentsubview");
            if (t != "")
                e.innerHTML = "&nbsp;>&nbsp;" + t;
            else e.innerHTML = t;
        }

        function OnClickSubView() {
            SetSubView(SubViewUrl, SubViewTitle);
        }
        function SetSubView(Url, t) {
            SubViewUrl = Url;
            SubViewTitle = t;

            var e = document.getElementById("main_body");
            e.src = Url;

            SetSubTitle(t);
        }

        function ClearSubView() {
            SubViewUrl = "";
            SubViewTitle = "";
            SetSubTitle("");
        }

        function SmallWindowMode() {
            var x = document.getElementsByClassName("tspan");
            if (!x)
                return;
            for (var i = 0; i < x.length; ++i) {
                x[i].style.display = "none";
            }
        }

        function LargeWindowMode() {
            var x = document.getElementsByClassName("tspan");
            if (!x)
                return;
            for (var i = 0; i < x.length; ++i) {
                x[i].style.display = "";
            }

        }
        function OnPageLoaded() {
            try {
                closeWait();
            } catch (e) {

            }
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocTimOut" meta:resourcekey="str_timOut" Visible="false">Timed Out!</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDevInf" meta:resourcekey="str_faiToLoaDevInf" Visible="false">Failed to load device info</asp:Localize>
    <div style="background-color: white; width: 100%; font-size: 16px; padding: 0px;">
        <table width="100%" >
            <%if (SessionMMCMode && m_ShowHeader)
                { %>
            <tr>
                <td style="padding-bottom:5px; ">
                    <div class="navbar navbar-default topnavcolor" style="box-shadow: 0px 3px 3px #cccccc !important">
                        <table width="100%">
                            <tr>
                                <td style='padding-top: 2px; padding-left: 8px; height: 68px;'>
                                    <asp:Image ID="WebAppIcon" runat="server" Height="48px" meta:resourcekey="WebAppIconResource1" />
                                </td>
                                <td>
                                    <asp:Panel ID="DefaultLogo" runat="server" meta:resourcekey="DefaultLogoResource1">
                                        <img class="gladinetcloud" src="images/s.gif" />
                                    </asp:Panel>
                                    <asp:Panel ID="BrandedLogo" runat="server" meta:resourcekey="BrandedLogoResource1">
                                        <table>
                                            <tr>
                                                <td style="padding-left: 4px; overflow: hidden;" nowrap valign="middle">
                                                    <span style='font-family: "Lucida Grande" , "Lucida Sans Unicode" ,Verdana,Helvetica,Arial,sans-serif; font-size: 21px; color: white; font-weight: bold;'
                                                        id="PanelTitle">
                                                        <asp:Label ID="ProductLable" runat="server" Font-Size="20px" ForeColor="White" BackColor="Transparent"
                                                            meta:resourcekey="ProductLableResource1"></asp:Label>
                                                    </span>
                                                </td>
                                            </tr>
                                        </table>
                                    </asp:Panel>
                                </td>
                                <td style="padding-right: 10px;" align="right" valign="bottom">
                                    <h2 style="color: white;">
                                        <asp:Label ID="DeviceName" runat="server" Text=""></asp:Label> - <asp:Localize ID="Localize1" meta:resourcekey="str_clientmmc" runat="server">Client Management Console</asp:Localize></h2>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
            <%} %>
            <tr>
               
                <td align="left" style="padding:0px;  ">
                    <table style="border-collapse: collapse; width: 100%" cellpadding="0" cellspacing="0">
                        <tr>
                            <td style="width: 100px;">
                                <table>
                                    <tr>
                                        <td style="padding-top: 10px;" valign="bottom">
                                            <div class="gladtab_lg_active" id="page_1" onclick="SetPage(1);return false;" title="<%=str_devinfo.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">)</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_devinfo" ID="str_devinfo" runat="server">Device Info</asp:Localize></span>
                                            </div>
                                        </td>
                                         <% if (SessionIsAdmin && m_IsSvr){ %>
                                        <%if(m_ShowCIFS) { %>
                                        <td style="padding-top: 10px;" valign="bottom" id="page_2_1">
                                            <div class="gladtab_lg_inactive " id="page_2" onclick="SetPage(2);return false;" title="<%=str_shares.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">F</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_devshares" ID="str_shares" runat="server">CIFS Shares</asp:Localize></span>
                                            </div>
                                        </td>
                                        <%} %>
                                        <td style="padding-top: 10px;" valign="bottom">
                                            <div class="gladtab_lg_inactive" id="page_3" onclick="SetPage(3);return false;" title="<%=str_locallocks.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">r</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_locallocks" ID="str_locallocks" runat="server">Local File Lock</asp:Localize></span>
                                            </div>
                                        </td>
                                        <%} %>

                                        <td style="padding-top: 10px;" valign="bottom">
                                            <div class="gladtab_lg_inactive" id="page_4" onclick="SetPage(4);return false;" title="<%=str_afolder.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">`</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_devafolder" ID="str_afolder" runat="server">Attached Folders</asp:Localize></span>
                                            </div>
                                        </td>
                                                <% if (m_ShowOffline){ %>
                                        <td style="padding-top: 10px;" valign="bottom" id="page_5_1">
                                            <div class="gladtab_lg_inactive" id="page_5" onclick="SetPage(5);return false;" title="<%=str_off.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">o</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_devoff" ID="str_off" runat="server">Offline Folders</asp:Localize></span>
                                            </div>
                                        </td>
                                        <%} %>
                                        <td style="padding-top: 10px;" valign="bottom">
                                            <div class="gladtab_lg_inactive" id="page_6" onclick="SetPage(6);return false;" title="<%=str_locked.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">r</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_locked" ID="str_locked" runat="server">Locked Files</asp:Localize></span>
                                            </div>
                                        </td>
                                        <% if (!m_IsMac){ %>
                                        <td style="padding-top: 10px;" valign="bottom" id="page_7_1">
                                            <div class="gladtab_lg_inactive" id="page_7" onclick="SetPage(7);return false;" title="<%=str_checkedin.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px; padding-left:5px;margin-top:-3px;">P</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_pchecked" ID="str_checkedin" runat="server">Pending Checkins</asp:Localize></span>
                                            </div>
                                        </td>
                                        <%} %>
                                        <%if(m_ShowSettings) { %>
                                        <td style="padding-top: 10px;" valign="bottom" id="page_8_1" title="<%=str_settings.Text %>">
                                            <div class="gladtab_lg_inactive" id="page_8" onclick="SetPage(8);return false;">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px;margin-top:-3px;">g</i> <span class="tspan"><asp:Localize meta:resourcekey="str_settings" ID="str_settings" runat="server">Settings</asp:Localize></span>
                                            </div>
                                        </td>
                                        <%} %>
                                                                                <% if (m_BackupEnabled && !IsHostedFarm && !IsServo){ %>
                                        <td style="padding-top: 10px;" valign="bottom" id="page_11_1" title="<%=str_cloudbackup.Text %>">
                                            <div class="gladtab_lg_inactive" id="page_11" onclick="SetPage(11);return false;">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px;padding-left:5px; margin-top:-3px;">&#x10C;</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_cloudbackup" ID="str_cloudbackup" runat="server">Cloud Backup</asp:Localize></span>
                                            </div>
                                        </td>
                                        <%} %>

                                        
                                        <td style="padding-top: 10px;" valign="bottom" id="page_9_1">
                                            <div class="gladtab_lg_inactive" id="page_9" onclick="SetPage(9);return false;" title="<%=str_tasks.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px; padding-left:5px;margin-top:-3px;">=</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_tms" ID="str_tasks" runat="server">Task Manager</asp:Localize></span>
                                            </div>
                                        </td>
                                        <% if (!m_IsMac){ %>
                                        <td style="padding-top: 10px;" valign="bottom" id="page_10_1">
                                            <div class="gladtab_lg_inactive" id="page_10" onclick="SetPage(10);return false;" title="<%=str_dig.Text %>">
                                                <i class="gladinet-icons  md-dark hand center toolbtn" style="font-size:16px;padding-right:5px; padding-left:5px;margin-top:-3px;">J</i>
                                                <span class="tspan"><asp:Localize meta:resourcekey="str_dig" ID="str_dig" runat="server">Diagnostics</asp:Localize></span>

                                            </div>
                                        </td>
                                        <%} %>
                                         
                                        
                                        
                                    </tr>
                                </table>
                            </td>

                            <td style="border-bottom: 1px solid #cccccc;">
                                
                                <asp:Label ID="ErrorMsg" runat="server" Text="" CssClass="err"></asp:Label>
                            </td>
                            <td style="border-bottom: 1px solid #cccccc; ">
                                <%if (m_IsSvr && SessionIsAdmin)
                                    { %>
                                <button style="margin-top:10px; padding:3px!important; display:none;" type="button" class="btn btn-primary gladbtn sectextcolor" onclick="SetView('DeviceCIFSShares.aspx?id=<%=InstanceId.Value %>',&quot;<%=str_migcifs.Text %>&quot;);return false;">
                                    <asp:Localize meta:resourcekey="str_migcifs" ID="str_migcifs" runat="server">Migrate CIFS Shares</asp:Localize>

                                </button>
                                &nbsp;&nbsp;
                                <button style="margin-top:10px!important; padding:3px!important;" type="button" class="btn btn-primary gladbtn sectextcolor" onclick="SetView('AddUserWizard/QueryServerAgent.aspx?id=<%=InstanceId.Value %>&vdid=<%=SessionDomainId %>',&quot;<%=str_migcifs.Text %>&quot;);return false;">
                                    <asp:Localize meta:resourcekey="str_migusers" runat="server">Migrate Users</asp:Localize>

                                </button>
                                <%} %>
                            </td>
                            <td align="right" nowrap="nowrap" style="background-color: white; border-bottom: 1px solid #cccccc; padding-right: 10px;">
                                <table>
                                    <tr>
                                        <td id="pollres" style="padding-left: 10px;" align="left" valign="bottom"></td>
                                        <td id="ConnectTd" style="display: none; padding-left: 5px;" align="left" valign="bottom">(<asp:LinkButton ID="ConnectBtn" runat="server" OnClick="ConnectBtn_Click" OnClientClick="Wait('Connecting...');return true;"><asp:Localize meta:resourcekey="str_connect" runat="server">Connect</asp:Localize></asp:LinkButton>
                                            )
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td id="main_body_td" style="background-color: white; padding: 0px;padding-top:20px; overflow: hidden;">
                    <iframe width="100%" src="<%=m_InitPageUrl %>" frameborder="0" style="padding: 0px; margin: 0px; border: 0px solid blue;"
                        onload="OnPageLoaded();" border="0" id="main_body"></iframe>
                </td>
            </tr>
        </table>
    </div>
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
        <asp:HiddenField ID="BackupTeamFolderId" runat="server" />
        <asp:Localize meta:resourcekey="str_daysgao" ID="StrDaysAgo" runat="server" Text=" Days ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_hoursago" ID="StrHoursAgo" runat="server" Text=" Hours ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_minsago" ID="StrMinsAgo" runat="server" Text=" Minutes ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_lessmin" ID="StrLessMin" runat="server" Text="Less than 1 minute ago"></asp:Localize>
        <asp:Localize meta:resourcekey="str_never" ID="StrNever" runat="server" Text="Never"></asp:Localize>
        <asp:Localize meta:resourcekey="str_disc" ID="StrDisc" runat="server">Disconnected</asp:Localize>
        <asp:Localize meta:resourcekey="str_connect1" ID="StrConn" runat="server">Connected</asp:Localize>
    </div>
    <script type="text/javascript">

        function SetPage(p) {

            
            try {
                var elements = document.getElementsByClassName("gladtab_lg_active");
                if (elements && elements.length != 0) {
                    for (var i = 0; i < elements.length; ++i) {
                        elements[i].className = "gladtab_lg_inactive";
                    }
                }
            } catch (e) {

            }

           

            e = document.getElementById("page_" + p);
            e.className = "gladtab_lg_active";

            e = document.getElementById("main_body");

            try {
                Wait("One minute");
            } catch (e) {

            }
            
            if (p == 1) {

                e.src = "DeviceInfo.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 2) {
                e.src = "DeviceCIFSShares.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 3) {
                e.src = "DeviceLocalLockMgr.aspx?id=<%= InstanceId.Value %>";
            } else if (p == 4) {
               e.src = "DeviceAttachedFolders.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 5) {
                e.src = "DeviceOfflineFolders.aspx?id=<%=InstanceId.Value %>";
                
            } else if (p == 6) {
                e.src = "DeviceLockMgr.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 7) {
                e.src = "DeviceCheckouts.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 8) {
                 e.src = "/management/GroupPolicyClientSettings.aspx?vdid=<%=SessionDomainId%>&id=<%=InstanceId.Value%>";
                
            } else if (p == 9) {
                e.src = "DeviceTasks.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 10) {
                e.src = "DeviceDig.aspx?id=<%=InstanceId.Value %>";
            } else if (p == 11) {
                e.src = "BackupDeviceInfo.aspx?vdid=<%=SessionDomainId%>&id=<%=InstanceId.Value %>";
            } else {
                try {
                    closeWait();
                } catch (e) {

                }
               
            }
}

function stringStartsWith(s, p) {
    return (s.indexOf(p) == 0);
}
function AdjustSize() {
    var h = 0;
    if (document.documentElement.offsetWidth > 1250) {
        LargeWindowMode();
    } else {
        SmallWindowMode();
    }
            <%if (SessionMMCMode && m_ShowHeader)
        { %>
            h = 95;
            <%} %>


            var f = document.getElementById('main_body_td');
            f.style.height = (document.documentElement.clientHeight - 100 - h) + "px";

            f = document.getElementById('main_body');
            f.style.height = (document.documentElement.clientHeight - 90 - h) + "px";


        }

        function OnPollRes(m) {
            var e = document.getElementById("pollres");

            var b = 0;
            if (stringStartsWith(m, "bad^")) {
                e.innerHTML = "<%=StrDisc.Text%>";
                e.style.color = "red";
                e = document.getElementById("ConnectTd");
                e.style.display = '';

                var f1;

                try {
                    f1 = document.getElementById('page_2_1');
                    f1.style.display = 'none';

                } catch (e) {

                }

                f1 = document.getElementById('page_7_1');
                f1.style.display = 'none';

                f1 = document.getElementById('page_5_1');
                f1.style.display = 'none';
                f1 = document.getElementById('page_9_1');
                f1.style.display = 'none';
                f1 = document.getElementById('page_10_1');
                f1.style.display = 'none';

            } else {
                e.innerHTML = "<%=StrConn.Text%>";
                e.style.color = "green";

                var f1;

                try {
                    f1 = document.getElementById('page_2_1');
                    f1.style.display = '';
                } catch (e) {

                }
                f1 = document.getElementById('page_7_1');
                f1.style.display = '';

                f1 = document.getElementById('page_5_1');
                f1.style.display = '';
                f1 = document.getElementById('page_9_1');
                f1.style.display = '';
                f1 = document.getElementById('page_10_1');
                f1.style.display = '';
                try {
                    <%if (!m_IsSvr)
        { %>
                    var f = document.getElementById('page_2_1');
                    f.style.display = 'none';
                    <%} %>
                } catch (e) {

                }

                e = document.getElementById("ConnectTd");
                e.style.display = 'none';

                if (m != "good") {
                    try {
                        e = document.getElementById("main_body");
                        e.contentWindow.onTaskInfo(m);
                        b = 1;
                    } catch (e) {

                    }
                }

            }
            if (b == 0)
                setTimeout("Poll()", 120000);
            else
                setTimeout("Poll()", 10000);
        }

        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/DeviceDashboard.aspx?id=<%=InstanceId.Value %>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        Ext.onReady(function () {
            AdjustSize();

            try {
                <%if (!m_IsSvr)
        { %>
                var f = document.getElementById('page_2_1');
                f.style.display = 'none';
                <%} %>
            } catch (e) {

            }

            <%if (m_DeviceVer < 3){ %>
            var f1;

            try {
                f1 = document.getElementById('page_2_1');
                f1.style.display = 'none';
            } catch (e) {

            }

            f1 = document.getElementById('page_5_1');
            f1.style.display = 'none';
            f1 = document.getElementById('page_7_1');
            f1.style.display = 'none';
            f1 = document.getElementById('page_9_1');
            f1.style.display = 'none';
            f1 = document.getElementById('page_10_1');
            f1.style.display = 'none';

            <%} %>
            document.title = "Client Management Console";

            <%if (m_IsSvr){ %>
                function selectPage2Tab() {
                    var mb = document.getElementById("main_body");
                    var cifsPageIsLoadedByDefault = (mb.src.toLowerCase().indexOf("devicecifsshares.aspx") > -1);
                    if (cifsPageIsLoadedByDefault) {
                        try {
                            var elements = document.getElementsByClassName("gladtab_lg_active");
                            if (elements && elements.length != 0) {
                                for (var i = 0; i < elements.length; ++i) {
                                    elements[i].className = "gladtab_lg_inactive";
                                }
                            }
                        } catch (e) { }
                        var obj = document.getElementById("page_2");
                        obj.className = "gladtab_lg_active";
                    }
                }
                selectPage2Tab();
            <%} %>
        });
        setTimeout("Poll()", 2000);
        Ext.EventManager.onWindowResize(function () {
            AdjustSize();
        });

    </script>
</asp:Content>
