﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceAttachedFolders.aspx.cs" Inherits="GladinetPayFlow.DeviceAttachedFolders" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        .dark {
            color: #565656 !important;
        }
        .smallbtn {
            padding: 5px!important;
        }
        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("<asp:Localize runat="server" meta:resourcekey="str_dltMsg">Do you really want to delete</asp:Localize> (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

        function OpenHtmlWindowShort(id, title, Html, w, h) {

            activewin = new Ext.Window({
                id: id,
                title: title,
                width: w,
                height: maxh(h),
                plain: true,
                modal: true,
                constrain: true,
                maximizable: false,
                maximized: false,
                bodyPadding: 5,
                resizable: false,
                shadow: 'drop',
                iconCls: 'publish',
                bodyStyle: 'background:#dfe8f6;border:0px; ',
                shadowOffset: 10,
                html: Html,
                defaults: {
                    border: false
                }
            });
            activewin.show();

        }
        
        function OnStopSync(id, instanceid, name)
        {
            var ng = document.getElementById("ctl00_MainContent_FolderName");
            
            var btn = document.getElementById("ctl00_MainContent_StopSyncFolder");

            if (confirm("<asp:Localize runat="server" meta:resourcekey="str_stopSyncex">Do you want to stop two-way sync for folder </asp:Localize> (" + unescape(name) + ")?")) {
                Wait("Please wait");
                ng.value = name;
            
                btn.click();
            }

        }
          function OnDeleteAttachedFolder(id, name) {

              var ng = document.getElementById("ctl00_MainContent_FolderName");
              var btn = document.getElementById("ctl00_MainContent_DetachFolder");

              if (confirm("<asp:Localize runat="server" meta:resourcekey="str_dtcFldMsg">Do you want to detach the folder</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("Please wait");
                ng.value = name;
                btn.click();
            }
          }
          function OnDeleteLinkedFolder(id, name) {

              var ng = document.getElementById("ctl00_MainContent_FolderName");
              var btn = document.getElementById("ctl00_MainContent_DeleteLinkedFolder");

              if (confirm("<asp:Localize runat="server" meta:resourcekey="str_stopSyncex">Do you want to stop two-way sync for folder </asp:Localize> (" + unescape(name) + ")?")) {
                Wait("Please wait");
              ng.value = name;
              btn.click();
          }
          }

          function OnForceSyncAttachedFolder(id, name) {

              var ng = document.getElementById("ctl00_MainContent_FolderName");
              var btn = document.getElementById("ctl00_MainContent_SyncFolder");

              if (confirm("<asp:Localize runat="server" meta:resourcekey="str_sncFldMsg">Do you want to force sync the folder</asp:Localize> (" + unescape(name) + ")?")) {
                  Wait("Please wait");
                  ng.value = name;
                  btn.click();
              }
          }

        function OnGetSyncStatus(id, name) {
            
            parent.SetSubView( "/management/DeviceSyncScan.aspx?f=c&id=" + id + "&name=" + name,name);
            
        }

        function OnExcludedFolderList() {
            
            parent.SetSubView("/management/ExcludedFolderList.aspx?f=c&id=<%=ViewInstanceId%>&name=aa", "<asp:Localize meta:resourcekey="str_edtExcFldLst" runat="server">Edit Excluded Folder List</asp:Localize>") ;
            
        }

        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  "/management/AttachedFolders.aspx";
        }


        function OnWipeDevice(id, name) {
            

            
        }

        function OnAttachFolder() {        
            
            parent.SetSubView("AttachLocalFolder.aspx?id=<%=ViewInstanceId%>", "<%=LocAch.Text %>" );

        }

        function OnRefresh() {        
            var btn = document.getElementById("ctl00_MainContent_RefreshBtn");
            Wait("Please wait");
            btn.click();


        }
    function OnDeviceList() {
        window.location = "<%=PageReturnUrl %>";
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToVerFol" meta:resourcekey="str_faiToVerFol" Visible="false">failed to verify folder</asp:Localize>
<asp:Localize runat="server" ID="LocFolWitTheSamNamAlrExi" meta:resourcekey="str_folWitTheSamNamAlrExi" Visible="false">folder with the same name already exists.</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToAttFol" meta:resourcekey="str_faiToAttFol" Visible="false">Failed to attach folder</asp:Localize>
<asp:Localize runat="server" ID="LocMisPas" meta:resourcekey="str_misPas" Visible="false">Missing password</asp:Localize>
<asp:Localize runat="server" ID="LocMisUseNam" meta:resourcekey="str_misUseNam" Visible="false">Missing user name</asp:Localize>
<asp:Localize runat="server" ID="LocMisShaLoc" meta:resourcekey="str_misShaLoc" Visible="false">Missing share location</asp:Localize>
<asp:Localize runat="server" ID="LocMisNam" meta:resourcekey="str_misNam" Visible="false">Missing name</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToDetFol" meta:resourcekey="str_faiToDetFol" Visible="false">Failed to detach folder</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaTeaFolLis" meta:resourcekey="str_faiToLoaTeaFolLis" Visible="false">Failed to load team folder list</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToStoSyn" meta:resourcekey="str_faiToStoSyn" Visible="false">Failed to stop sync</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToForSynAttFol" meta:resourcekey="str_faiToForSynAttFol" Visible="false">Failed to force sync attached folder</asp:Localize>
<asp:Localize runat="server" ID="LocCanNotLocOwnUseInf" meta:resourcekey="str_canNotLocOwnUseInf" Visible="false">Can not locate owner user info</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToLoaDevInf" meta:resourcekey="str_faiToLoaDevInf" Visible="false">Failed to load device info</asp:Localize>
<asp:Localize runat="server" ID="LocAtcLnkFldFnd" meta:resourcekey="str_atcLnkFldFnd" Visible="false">Attached/Linked Folder(s) Found</asp:Localize>
<asp:Localize runat="server" ID="LocFldFrcSncAtcFld" meta:resourcekey="str_fldFrcSncAtcFld" Visible="false">Failed to force sync attached folder:</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToDtcFol" meta:resourcekey="str_faiToDtcFol" Visible="false">Failed to deattach folder</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToStpSnc" meta:resourcekey="str_faiToStpSnc" Visible="false">Failed to stop sync:</asp:Localize>
<asp:Localize runat="server" ID="LocShrNmeCntCtnChr" meta:resourcekey="str_shrNmeCntCtnChr" Visible="false">Share name can not contain following characters: : & # ' / \\ + | @ "</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToVrfFld" meta:resourcekey="str_faiToVrfFld" Visible="false">Failed to verify folder</asp:Localize>

        <div class="navbar navbar-default meubardrop" role="navigation">
               <div class="container-fluid">
                   
                   <button type="button" class="btn btn-default navbar-btn navbar-left "  onclick="OnDeviceList()" style="display: none;"> 
                <span class="fa fa-menu-left" style="color:#565656;"></span> <asp:Localize meta:resourcekey="str_devdash" runat="server">Device Dashboard</asp:Localize>
             </button>

                   <p class="navbar-text">
                        <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1"></asp:Label>
                            <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota"
                                meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                          <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <table>
                       <tr>
                           <td>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark smallbtn" onclick="OnRefresh();" title="<asp:Localize meta:resourcekey="str_rfs" runat="server">Refresh</asp:Localize>">
                       
                     <i class="gladinet-icons md-24 md-dark hand center toolbtn " style="display: inline-block; margin-top: 0px;" >&#0181;</i>
                   </div>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark smallbtn " onclick="OnExcludedFolderList();" title="<asp:Localize meta:resourcekey="str_edtEcdFldLst" runat="server">Edit Excluded Folder List</asp:Localize>">
                     
                     <i class="gladinet-icons md-24 md-dark hand center toolbtn " style="display: inline-block; margin-top: 0px;" >X</i>
                   </div>
                   <%if (m_DeviceVer >= 3 && m_AllowAttach){ %>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right dark smallbtn" onclick="OnAttachFolder();" title="<%=LocAch.Text %>">
                       
                       <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 15px; margin-top: 2px; cursor: pointer; display: inline-block; position: absolute;" >
                                                                            </span>

                                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;" >`</i>
                     
                   </div>
                               <div class="btn btn-primary gladbtn navbar-btn navbar-right dark smallbtn" data-toggle="modal" data-target="#AttachCIFSModal" title="<%=str_attachcifs.Text %>">

                                <span class="fa fa-plus sectextcolor" aria-hidden="true" style="font-size: 14px; margin-left: 15px; margin-top: 2px; cursor: pointer; display: inline-block; position: absolute; width: 9px;"></span>

                                <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: 0px;">a</i>

                            </div>
                   <%} %>
                               <asp:Localize meta:resourcekey="str_attachcifs" ID="str_attachcifs" runat="server" Visible="false">Attach CIFS Share</asp:Localize>
                               </td>
                       </tr>
                       </table>
               </div>
           </div>
           

   <table id="grid-table" width="100%" align="center" style="background-color: white; padding: 2px; margin-top: 18px;" cellspacing="0"
        cellpadding="0">
        <tr>
            <td colspan="3" id="grid-example" valign="top">
            </td>
        </tr>
    </table>
    <div class="modal fade" id="AttachCIFSModal" tabindex="-1" role="dialog" aria-labelledby="modalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <table width="100%"><tr>
                    <td style="padding: 5px; font-size: 14px;">
                            <asp:Localize meta:resourcekey="str_name" runat="server">Name</asp:Localize>
                        </td>
                        </tr><tr>
                        <td style="padding: 5px;">
                            <asp:TextBox ID="CIFSName" runat="server" CssClass="form-control" ></asp:TextBox>
                        </td>
                            </tr><tr>
                        <td style="padding: 5px; font-size: 14px;">
                            <asp:Localize meta:resourcekey="str_cifslocation" runat="server">CIFS Share Location (\\host\share\folder)</asp:Localize>
                        </td>
                                </tr><tr>
                        <td style="padding: 5px;">
                            <asp:TextBox ID="CIFSNameLoc" runat="server" CssClass="form-control" ></asp:TextBox>
                        </td>
                         </tr><tr>
                        <td style="padding: 5px; font-size: 14px;">
                            <asp:Localize meta:resourcekey="str_username" runat="server">User Name</asp:Localize>
                        </td>
                                </tr><tr>
                        <td style="padding: 5px;">
                            <asp:TextBox ID="CIFSUser" runat="server" CssClass="form-control" ></asp:TextBox>
                        </td>
                                    </tr><tr>
                        <td style="padding: 5px; font-size: 14px;">
                            <asp:Localize meta:resourcekey="str_password" runat="server">Password</asp:Localize>
                        </td>
                                </tr><tr>
                        <td style="padding: 5px;">
                            <asp:TextBox ID="CIFSPwd" TextMode="Password" runat="server" CssClass="form-control" ></asp:TextBox>
                        </td>

                        </tr></table>
                </div>
                <div class="modal-footer">
                    <asp:LinkButton ID="AttachCifs" runat="server" OnClick="AttachCifs_Click" CausesValidation="false" OnClientClick="Wait('...'); return true;"><%=str_attachcifs.Text %></asp:LinkButton>
                    <button type="button" class="btn btn-secondary" data-dismiss="modal"><asp:Localize runat="server" meta:resourcekey="str_Can">Cancel</asp:Localize></button>
                </div>
            </div>
        </div>
    </div>
  <asp:HiddenField ID="DeviceId" runat="server" />
    
  <asp:HiddenField ID="FolderName" runat="server" />
  <div id="confirmTeamFolder" class="modal fade" role="dialog">
  <div class="modal-dialog">

    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
          <h4 class="modal-title"><asp:Localize runat="server" meta:resourcekey="str_DelTeaFol">Deleting Team Folder</asp:Localize></h4>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        
      </div>
      <div class="modal-body">
        <p style="font-weight: 100; color: #404040;">
            <asp:Localize meta:resourcekey="str_dchMsg" runat="server">The attached folder is currently published as a team folder, detaching the folder will also delete the team folder. Do you want to continue?</asp:Localize>
            </p>
      </div>
      <div class="modal-footer">
        <asp:Button ID="Button1" runat="server" Text="Yes" meta:resourcekey="str_yes" class="btn btn-primary gladbtn"  OnClientClick="OnDetachNow();return true;" OnClick="Button1_Click" /> <button type="button" class="btn btn-default" data-dismiss="modal"><asp:Localize meta:resourcekey="str_no" runat="server">No</asp:Localize></button>
      </div>
    </div>

  </div>
</div>

  <div style="display:none;">
      
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />
          <asp:LinkButton ID="RefreshBtn"  runat="server" OnClick="LinkButton2_Click" OnClientClick="Wait('one minute'); return true;"><asp:Localize meta:resourcekey="str_rfs" runat="server">Refresh</asp:Localize> </asp:LinkButton>

        <asp:Button ID="DetachFolder" runat="server" onclick="DetachFolder_Click"  />
      <asp:Button ID="DeleteLinkedFolder" runat="server" onclick="DeleteLinkedFolder_Click"  />
      <asp:Button ID="StopSyncFolder" runat="server" onclick="StopSyncFolder_Click"  />
      <asp:Button ID="SyncFolder" runat="server" onclick="SyncFolder_Click"  />
        <asp:LinkButton ID="AttachBtn"  runat="server" OnClick="Attach_Click" OnClientClick="Wait('one minute'); return true;"><asp:Localize ID="LocAch" meta:resourcekey="str_ach" runat="server">Attach</asp:Localize></asp:LinkButton>
        </div>


  <script type="text/javascript">
      function OnDetachNow() {
          $('#confirmTeamFolder').modal('hide');
          Wait('one minute');
      }


  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           "<%#DataBinder.Eval(Container.DataItem,"CloudFolder") %>",
           "<%#DataBinder.Eval(Container.DataItem,"LocalFolder") %>",
           "<%#DataBinder.Eval(Container.DataItem,"Type") %>"
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">
      var grid;
      function AdjustGridTable() {
          isMobileBrowserOrNarrow();
          var h = 400;

          try {

              var myTable = Ext.get('grid-table');
              var tableY = myTable.getY();

              //var mySetting = Ext.get('farm-setting');
              var settingH = 0; // mySetting.getHeight();

              h = document.body.offsetHeight - tableY - 8 - settingH;
              //var ee = document.getElementById('tinfo');
              //ee.style.height = h + "px";
              if (h < 108) {
                  h = 108;
              }

          } catch (err) {
          }
          //alert(h);
          //alert(tableY);
          //alert(document.body.offsetHeight);
          grid.setWidth(document.documentElement.clientWidth - 4);
          grid.setHeight(h);
          grid.doComponentLayout();
      }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' },
                  { name: 'loc' },
                  { name: 'type' }
              ],
              data: myData
          });



          grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              columnLines: false,
       
              border: true,
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="str_name" runat="server">Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-size:14px; font-weight:100; color:#404040'>" + unescape(value) + "</span>";
                      }

                  },{
                      text: "<asp:Localize meta:resourcekey="str_loc" runat="server">Local Folder</asp:Localize>",
                      
                      flex: 1,
                      sortable: true,
                      dataIndex: 'loc',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='font-size:14px; font-weight:100; color:#404040'>" + unescape(value) + "</span>";
                      }

                      },{
                          text: "<asp:Localize meta:resourcekey="str_type" runat="server">Type</asp:Localize>",
                          width: 180,    
                          sortable: true,
                          dataIndex: 'type',
                          renderer: function (value, metaData, record, rowIndex) {
                              if(value == "ATTACHED_FOLDER")
                                  return "<span style='font-size:14px; font-weight:100; color:#404040'><asp:Localize meta:resourcekey="str_attach" runat="server">Attached</asp:Localize></span>";
                                  if(value == "ATTACHED_REMOTE_SHARE")
                                      return "<span style='font-size:14px; font-weight:100; color:#404040'><asp:Localize meta:resourcekey="str_attacheds" runat="server">Attached CIFS Share</asp:Localize></span>";
                                      if(value == "PROXIED_FOLDER")
                                          return "<span style='font-size:14px; font-weight:100; color:#404040'><asp:Localize meta:resourcekey="str_proxied" runat="server">Proxied</asp:Localize></span>";
                                  return "<span style='font-size:14px; font-weight:100; color:#404040'><asp:Localize meta:resourcekey="str_linked" runat="server">Linked</asp:Localize></span>";
                                  
                          }

                      },{
                        width:160,
                      dataIndex: 'loc',
                      renderer: function (value, metaData, record, rowIndex) {
                          var ctrls = "";
                          var d = record.data;
                          var typ = d.type;
                          <%if(m_DeviceVer >= 3){ %>
                          
                          ctrls += "<span class='gladinet-icons md-24 md-dark hand center toolbtn'   title=\"<asp:Localize runat="server" meta:resourcekey="str_frcSnc">Force Sync</asp:Localize>\" onclick='OnForceSyncAttachedFolder(\"" +d.id +"\",\"" +d.name +"\"); return false;'>&#xB5;</span>&nbsp;&nbsp;";
                          ctrls += "<span class='gladinet-icons md-24 md-dark hand center toolbtn'  title=\"<asp:Localize runat="server" meta:resourcekey="str_shwNotSnc">Show items not synced</asp:Localize>\" onclick='OnGetSyncStatus(\"<%=ViewInstanceId %>\",\"" +d.name +"\"); return false;'>&#xBF;</span>&nbsp;&nbsp;";
                          if(typ == "ATTACHED_FOLDER" || typ == "ATTACHED_REMOTE_SHARE"){
                              ctrls += "<span class='gladinet-icons md-24 md-dark hand center toolbtn'  title=\"<asp:Localize runat="server" meta:resourcekey="str_stopSync">Stop Sync</asp:Localize>\" onclick='OnStopSync(\"" +d.id +"\",\"<%=ViewInstanceId %>\",\"" +d.name +"\"); return false;'>&#xD2;</span>&nbsp;&nbsp;";
                              ctrls += "<span class='gladinet-icons md-24 md-dark hand center toolbtn'   title=\"<asp:Localize runat="server" meta:resourcekey="str_del">Delete</asp:Localize>\" onclick='OnDeleteAttachedFolder(\"" +d.id +"\",\"" +d.name +"\"); return false;'>n</span>&nbsp;&nbsp;";
                          }else if(typ == "LINKED_FOLDR"){
                              ctrls += "<span class='gladinet-icons md-24 md-dark hand center toolbtn'   title=\"<asp:Localize runat="server" meta:resourcekey="str_stopSync">Stop Sync</asp:Localize>\" onclick='OnDeleteAttachedFolder(\"" +d.id +"\",\"" +d.name +"\"); return false;'>&#xD2;</span>&nbsp;&nbsp;";
                          }
                           <%} %>
                          
                          return ctrls;
                      }

                  }
        ],
              renderTo: 'grid-example'
          });

          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
          <% if (DelTeamFolder){ %>
          $('#confirmTeamFolder').modal({ backdrop: 'static', keyboard: false });
          <% }%>
});
  </script>
    
    
    <asp:HiddenField ID="backtotarget" runat="server" />

</asp:Content>
