﻿<%@ Page Title="Gladinet Cloud - User Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterDeviceMgrPage.aspx.cs" Inherits="GladinetPayFlow.ClusterDeviceMgrPage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">

    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        </style>
    <script type="text/javascript">
        function getScrollXY() {
            var scrOfX = 0, scrOfY = 0;
            if (typeof (window.pageYOffset) == 'number') {
                //Netscape compliant
                scrOfY = window.pageYOffset;
                scrOfX = window.pageXOffset;
            } else if (document.body && (document.body.scrollLeft || document.body.scrollTop)) {
                //DOM compliant
                scrOfY = document.body.scrollTop;
                scrOfX = document.body.scrollLeft;
            } else if (document.documentElement && (document.documentElement.scrollLeft || document.documentElement.scrollTop)) {
                //IE6 standards compliant mode
                scrOfY = document.documentElement.scrollTop;
                scrOfX = document.documentElement.scrollLeft;
            }
            //return [scrOfX, scrOfY];
            return scrOfY;
        }



       
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);
        //parent.setActivePanel("UserMgr");

        function onDelUser(id, name) {
            var h = "/management/GuestUserMgrPage.aspx?op=delete&id=" + id;

            if (confirm("Do you really want to delete (" + unescape(name) + ")?")) {
                Wait('Deleting');
                window.location = h;
            }

        }

    
        function closeCancelActiveWin()
        {
            activewin.close();
        }

        function closeActiveWin() {
            window.location =  "/management/UserDeviceMgrPage.aspx";
        }
        function OnWipeDevice(id, name) {
            var ng = document.getElementById("ctl00_MainContent_DeviceId");
            var btn = document.getElementById("ctl00_MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="js_string10" runat="server">Do you really want to wipe the device (</asp:Localize>" + unescape(name) + ")?")) {
            Wait("<asp:Localize meta:resourcekey="js_string11" runat="server">Wiping...</asp:Localize>");
            ng.value = id;
            btn.click();            
        }
    }

    function OnAttachFolders(id, name) {
        window.location = "/management/AttachedFolders.aspx?f=c&id="+id+"&name="+name;
    }
    function OnAgentTasks(id, name) {
        window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
    }
   
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
           <nav class="navbar navbar-default" role="navigation">
               <div class="container-fluid">
                   <p class="navbar-text">
                       <asp:Label ID="UserCount" runat="server" Text="0 User" meta:resourcekey="UserCountResource1" CssClass="badge"></asp:Label>
                       <asp:Label ID="GuestQuota" runat="server" Visible="False" Text="0 available guest user quota" meta:resourcekey="GuestQuotaResource1"></asp:Label>
                   </p>
                   <div id="errmsgdiv" class="navbar-text">
                       <b>
                           <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
                   </div>
                   <div  class="btn btn-primary gladbtn navbar-btn navbar-right" style="margin-right: 8px;" title="<%=RefreshBtn.Text %>">
                       <i class="gladinet-icons md-32 md-dark hand" style="display:table-cell;" onclick="__doPostBack('LinkButton2', '');">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px;display:none;"><asp:LinkButton ID="RefreshBtn" ForeColor="#565656" runat="server" OnClick="RefreshBtn_Click" meta:resourcekey="RefreshBtnResource1">Refresh</asp:LinkButton></div>
                   </div>
               </div>
           </nav>
       
       
    <table id="grid-table" width="100%" align="center" style="background-color: white; padding: 2px; margin-top: 18px;" cellspacing="0"
        cellpadding="0">
        <tr>
            <td colspan="3" id="grid-example" valign="top">
            </td>
        </tr>
    </table>
    
  <asp:HiddenField ID="DeviceId" runat="server" />
  <div style="display:none;">
    <asp:Button ID="WipeDevice" runat="server" 
        onclick="WipeDevice_Click" meta:resourcekey="WipeDeviceResource1" />

        </div>
  <script type="text/javascript">

  var myData = [
 <asp:Repeater ID="UsersRepeater" runat="server" OnItemCommand="UsersRepeater_ItemCommand"
        OnItemDataBound="OnUserItemBound">
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>     
         ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',        
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"InstanceName").ToString().Replace("'","%27")) %>',
           '<%#DataBinder.Eval(Container.DataItem,"InstanceId") %>',
           '<%#DataBinder.Eval(Container.DataItem,"Type") %>',
           '<%#DataBinder.Eval(Container.DataItem,"CommandInterface") %>',
           '<%#DataBinder.Eval(Container.DataItem,"SyncStatus") %>',
           '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"UserName").ToString().Replace("'","%27")) %>'
           ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
  <script type="text/javascript">
        var grid;
        function AdjustGridTable() {
            isMobileBrowserOrNarrow();
            var h = 400;

            try {

                var myTable = Ext.get('grid-table');
                var tableY = myTable.getY();

                //var mySetting = Ext.get('farm-setting');
                var settingH = 0; // mySetting.getHeight();

                h = document.body.offsetHeight - tableY - 8 - settingH;
                //var ee = document.getElementById('tinfo');
                //ee.style.height = h + "px";
                if (h < 108) {
                    h = 108;
                }

            } catch (err) {
            }
            //alert(h);
            //alert(tableY);
            //alert(document.body.offsetHeight);
            grid.setWidth(document.documentElement.clientWidth - 4);
            grid.setHeight(h);
            grid.doComponentLayout();
        }
      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'name' },
                  { name: 'id' },
                  { name: 'type' },
                  { name: 'ver' },
                  { name: 'sync' },
                  { name: 'user' }
              ],
              data: myData
          });



          grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              
              border:true,
              columnLines: true,
              minHeight: 108,
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hdide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string1" runat="server">Device Name</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<b>" + unescape(value) + "</b>";
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="js_string2" runat="server">User</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'user',
                      renderer: function (value, metaData, record, rowIndex) {
                          return  unescape(value) ;
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string3" runat="server">Device Type</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'type',
                      renderer: function (value, metaData, record, rowIndex) {
                          return  unescape(value);
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string4" runat="server">Command Interface Version</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'ver',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      text: "<asp:Localize meta:resourcekey="js_string5" runat="server">Status</asp:Localize>",
                      flex: 1,
                      sortable: true,
                      dataIndex: 'sync',
                      renderer: function (value, metaData, record, rowIndex) {
                          return unescape(value);
                      }

                  }, {
                      xtype: 'actioncolumn',
                      width: 80,
                      hideable: false,
                      items:
                      [
                          {
                              icon: '/portal/images/attachfolder.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string6" runat="server">Attached Folders</asp:Localize>",
                              width: 30,
                              handler: function (grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  OnAttachFolders( d.id,d.name);
                              },
                              getClass: function (v, meta, rec) {
                                  return 'x-col-hdide';
                              }
                          },
                          {
                              icon: '/portal/images/tasks.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string7" runat="server">Task Manager</asp:Localize>",
                              width: 30,
                              handler: function (grid, rowIndex, colIndex) {
                                  var rec = grid.getStore().getAt(rowIndex);
                                  var d = rec.data;

                                  OnAgentTasks(d.id, d.name);                            
                              },
                              getClass: function (v, meta, rec) {
                           
                              }
                          },
                          {
                              icon: 'images/trash.png',  // Use a URL in the icon config
                              tooltip: "<asp:Localize meta:resourcekey="js_string8" runat="server">Wipe Device</asp:Localize>",
                        width: 30,
                        handler: function (grid, rowIndex, colIndex) {
                            var rec = grid.getStore().getAt(rowIndex);
                            var d = rec.data;

                            OnWipeDevice(d.id, d.name);
                        },
                        getClass: function (v, meta, rec) {

                        }
                    }
                 ]
            }
        ],
              renderTo: 'grid-example'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
          Ext.EventManager.onWindowResize(AdjustGridTable);
          AdjustGridTable();
      });
  </script>
    <asp:HiddenField ID="HiddenUserGuid" runat="server" />
</asp:Content>
