﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterAdmin.aspx.cs" Inherits="GladinetPayFlow.ClusterAdmin" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .style1
        {
            width: 388px;
        }
        
        .style2
        {
            min-width: 16px;
            text-align: center;
        }
        
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .style3
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
            width: 121px;
        }
        
        .rolemgrtab
        {
	        background-image: url(/portal/images/guest.png);
	        background-repeat: no-repeat;
        }
        
       
    </style>
</asp:Content>

<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<div id="tabs"  ></div>
<script type="text/javascript">
    
    

    

    Ext.require([
    'Ext.tab.*'
    ]);
    var tabs;
    Ext.onReady(function () {



        tabs = Ext.createWidget('tabpanel', {
            renderTo:  'tabs',
            resizeTabs: true,
            enableTabScroll: true,
            width: '100%',
    
            plain:true,
            height: document.documentElement.clientHeight ,
            defaults: {
                autoScroll: true,
                bodyPadding: 10
            }
        });

        <%if(m_ShowTeamMgr){ %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string1" runat="server">Tenants Manager</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml ("TeamsMgrPage.aspx"),
            closable: false
        });
        <%} %>

        <% if (SessionIsClusterAdmin)
           { %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string2" runat="server">Cluster Admin</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("EditUserInfo.aspx?cluster=1"),
            closable: false
        });
        <% } %>


        <%if(m_ShowResellerMgr){ %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string3" runat="server">Resellers Manager</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("ResllersMgrPage.aspx"),
            closable: false
        });
        <%} %>
        <%if(m_ShowLicense){ %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string4" runat="server">License Manager</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("PackageLicense.aspx?g=1"),
            closable: false
        });
        <%} %>

        <%if(SessionIsClusterAdmin){ %>
        
        
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string7" runat="server">Cluster Branding</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("BrandingMgrPage.aspx?mode=cluster"),
            closable: false
        });

        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string6" runat="server">Email Service</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("SMTPCfg.aspx"),
            closable: false
        });
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string20" runat="server">Cluster Server Farm</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("ClusterFarm.aspx"),
            closable: false
        });

        <%} %>

        <% if (m_ShowClusterInfo)
           { %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string21" runat="server">Cluster Info</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("ClusterInfo.aspx"),
            closable: false
        });
        <% } %>

        <% if (m_ShowClusterReports)
           { %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string22" runat="server">Reports</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("ClusterReports.aspx"),
            closable: false
        });
        <% } %>

        <% if (SessionIsClusterAdmin)
           { %>
        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string23" runat="server">Cluster Settings</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("ClusterSettingsPage.aspx"),
            closable: false
        });

        tabs.add({
            title: "<asp:Localize meta:resourcekey="js_string24" runat="server">Languages</asp:Localize>",
            iconCls: 'tabs',
            html: getiFrameHtml("localize/Default.aspx"),
            closable: false
        });
        <% } %>
        

        tabs.setActiveTab(0);
    });

  Ext.EventManager.onWindowResize(function () {
  
            tabs.setHeight(document.documentElement.clientHeight);
            tabs.doComponentLayout();
           // alert("window resize: "+document.documentElement.clientHeight);

        });

</script>
    
</asp:Content>
