﻿<%@ Page Title="Gladinet Cloud - Publish Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BrowseLocalTreePage.aspx.cs" Inherits="GladinetPayFlow.BrowseLocalTreePage" culture="auto" meta:resourcekey="PageResource1" uiculture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        </style>
    <script type="text/javascript">

        function Toggle(name) {
            var d = document.getElementById(name);
            if (d.style.display == 'none')
                d.style.display = 'block';
            else
                d.style.display = 'none';
        }

        function TogglePubUser() {
            var d = document.getElementById("pubusers");
            var t = document.getElementById("pubusersc");
            if (d.style.display == 'none') {
                d.style.display = 'block';
                t.style.height = "300px";
            } else {
                t.style.height = "10px";
                d.style.display = 'none';
            }
        }
        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 8000);

        var SelItem = null;
        var cursel = "";

        function onfolderselect(obj, key) {
            obj.style.backgroundColor = "#CBE1FC";
            if (SelItem) {
                SelItem.select = 0;
                SelItem.style.backgroundColor = "WHITE";
            }
            obj.select = 1;
            SelItem = obj;
            cursel = key;
            
        }

        function onfolderdblclick(obj, key) {
            var uri = "BrowseLocalTreePage.aspx?path=";
            
            uri += key;
            uri += "&id=" + XSSDecode("<%=XSSUrlEncode(InstanceId.Value) %>");
            Wait("Please wait ...");
            window.location = uri;
        }

        function onfolderout(obj) {

            if (obj.select == 1)
                obj.style.backgroundColor = "#CBE1FC";
            else
                obj.style.backgroundColor = "WHITE";
        }

        function OnNewFolder(parent) {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'block';
            d.style.left = (document.body.offsetWidth - 450) / 2 + "px";

            d = document.getElementById("MainContent_CurrentParentFolder");

            d.value = parent;

        }

        function OnCancelNewFolder() {
            var d = document.getElementById("NewFolderCtrl");

            d.style.display = 'none';
            d.style.left = (document.body.offsetWidth - 600) / 2 + "px";
        }

        function onOk() {
            if (cursel == "") {
                alert("<asp:Localize meta:resourcekey="js_string1" runat="server">no folder is selected</asp:Localize>");
                return;
            }
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder(cursel);
            else
                parent.parent.SetSelectedFolder(cursel);
        }

        function onRoot() {
            if (parent.SetSelectedFolder)
                parent.SetSelectedFolder("");
            else
                parent.parent.SetSelectedFolder("");
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div id="errmsgdiv">
        <b>
            <asp:Label ID="Label1" runat="server" Style="color: Red;" 
            meta:resourcekey="Label1Resource1"></asp:Label></b>
    </div>
    <div id="NewFolderCtrl" style="top: 0px; left: 0px; position: absolute; display: none;">
        <div style="height: 30px;">
            <asp:HiddenField ID="CurrentParentFolder" runat="server" />
        </div>
        <table width="450" align="center" border="0" cellspacing="0" cellpadding="0" class="checkout3" style="background-color: white;">
            <tr>
                <td width="55" height="45" background="images/d-left-top-big-1.png">
                    <img width='32' height='32' src="images/adduser.png" style="margin-left: 15px; margin-top: 10px;" />
                </td>
                <td background="images/d-top-middle-1.png" style="color: White; font-size: 14px; padding-left: 0px;
                    padding-top: 5px;" align="left">
                    <asp:Localize meta:resourcekey="asp_string1" runat="server">Create New Folder</asp:Localize>
                </td>
                <td width="30" background="images/d-right-top-1.png">
                    &nbsp;
                </td>
            </tr>
        </table>
        <table width="450" align="center" border="0" cellspacing="0" cellpadding="0">
            <tr>
                <td background="images/left-middle.jpg">
                    &nbsp;
                </td>
                <td>
                    <table width="100%" height="100%" align="center" style="background-color: WHITE;
                        padding: 10px;">
                        <tr>
                            <td class="InputLabel">
                                <asp:Localize meta:resourcekey="asp_string2" runat="server">New Folder Name</asp:Localize>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <asp:TextBox ID="NewFolderName" runat="server" Width="95%" class="InputText" 
                                    meta:resourcekey="NewFolderNameResource1"></asp:TextBox>
                                <div style="color: #D00000">
                                    <asp:RequiredFieldValidator runat="server" ID="reqName" ControlToValidate="NewFolderName"
                                        ErrorMessage="Folder name is required!" Display="Dynamic" 
                                        CssClass="errmsg" meta:resourcekey="reqNameResource1" />
                                </div>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="2">
                                <table width="100%" align="center">
                                    <tr>
                                        <td align="left">
                                        </td>
                                        <td align="right" colspan="2" style="border-top: 0px solid #d0d0d0; padding-top: 15px;">
                                            <asp:Button ID="CreateButtonNow" runat="server" Text="Apply Change" Font-Size="12px"
                                                Height="26px" OnClick="CreateButtonNow_Click" Width="90px" 
                                                meta:resourcekey="CreateButtonNowResource1" />&nbsp;&nbsp;&nbsp;&nbsp;
                                            <asp:Button ID="CancelChange" runat="server" Text="Cancel" Font-Size="12px" Height="26px"
                                                OnClientClick="OnCancelNewFolder()" Width="90px" 
                                                meta:resourcekey="CancelChangeResource1" />
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                    </table>
                </td>
                <td background="images/right-middle.jpg">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td width="30" height="30" background="images/bottom-left.jpg">
                    &nbsp;
                </td>
                <td background="images/bottom-middle.png">
                    &nbsp;
                </td>
                <td width="30" height="30" background="images/bootom-right.jpg">
                    &nbsp;
                </td>
            </tr>
            <tr>
                <td height="40px">
                    &nbsp;
                </td>
            </tr>
        </table>
    </div>
    <table width="100%" height="100%" align="center" cellpadding="0" cellspacing="0"
        style="background-color: WHITE;" class="checkout3">
        <tr style="background-color: white;">
           <% if (!string.IsNullOrEmpty(CurParent) && CurParent.Length > 1)
              {%>
            <td width="120px" height="30px" style="border-bottom: 1px solid #d0d0d0;">
                <table>
                    <tr>
                        <td width="18px">
                            <img height="16px" src="images/up32.png" />
                        </td>
                        <td>

                            <a href="javascript:;" style="font-size: 12px;" onclick="onfolderdblclick(this, Ext.util.Format.htmlDecode('<%:PrevParent%>'));return false;">
                                <asp:Localize meta:resourcekey="asp_string3" runat="server">Parent Folder</asp:Localize></a>
           
                        </td>
                    </tr>
                </table>
            </td>
                                 <%} %>
            <td align="left" style="border-bottom: 1px solid #d0d0d0; padding:5px">
                <table>
                    <tr>
                        
                        <td>
                        <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
                          { %>
                        <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" 
                        CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
                        <%} %>
                        </td>
                    </tr>
                </table>
         
            </td>
        </tr>
        <tr class="tree_container">
            <td colspan="2" height="300px" valign="top" style="border-bottom:1px solid #d0d0d0;"> 
               
                <%if (!EmptyFolder)
                  { %>
                <div style="height: 334px; overflow: auto;">
                    <asp:Repeater ID="FolderList" runat="server">
                        <ItemTemplate>
                            <table width="95%" onmousedown="return false;" onselectstart="return false;" style="cursor: hand;
                                mozuserselect: none;" cellspacing="0" cellpadding="2px" onmouseover="this.style.backgroundColor='#f0f0f0';"
                                onmouseout="onfolderout(this)" onclick='onfolderselect(this, &#039;<%# DataBinder.Eval(Container.DataItem, "OrigKey") %>&#039;)'
                                
                                ondblclick='onfolderdblclick(this, &#039;<%# DataBinder.Eval(Container.DataItem, "OrigKey") %>&#039;)'>
                                <tr style="padding-top: 5px;">
                                    <td  width="30px" style="background-color: White;">
                                        <img src="Images/Folder.jpg" width="24px" />
                                    </td>
                                    <td style="font-size: 12px; padding-left: 10px;">
                                        <%#DataBinder.Eval(Container.DataItem, "Key")%>
                                    </td>
                                </tr>
                                
                            </table>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
                <%}
                  else
                  {%>
                  <div class='idea_flex'><asp:Localize meta:resourcekey="asp_string4" runat="server">Folder is empty. You can navigate up a level to select a folder . You can also create a new folder here.</asp:Localize></div>
                <%}%>
             
            </td>
        </tr>
        <tr>
        <td colspan=2  style="padding:5px;padding-top:10px;">
        <table width=100%>
        <tr>
        <td class='idea_flex' style="padding-right:10px; vertical-align: middle;" align=left>
            <asp:Localize meta:resourcekey="asp_string5" runat="server">Double click to browse into</asp:Localize><br /><asp:Localize meta:resourcekey="asp_string6" runat="server">Click to select</asp:Localize>
        </td>
        <td align=right>
  
    <asp:Button ID="OkBtn" Font-Size=12pt ForeColor="#009000" Width=128px runat="server" 
                Text="Ok" style="padding:2px;"   onclientclick="onOk();return false;" 
                CausesValidation=False meta:resourcekey="OkBtnResource1" />
    
            <asp:Button ID="CancelBTn" Font-Size=12pt ForeColor="#009000" Width=128px 
                runat="server" Text="Cancel" style="padding:2px;" 
                onclick="CancelBTn_Click"  CausesValidation=False 
                meta:resourcekey="CancelBTnResource1"/>
                <br />
        
        </td>
        </tr>
        </table>
        
        </td>
        </tr>
    </table>
    <asp:HiddenField ID="InstanceId" runat="server" />
</asp:Content>
