﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master" AutoEventWireup="true" CodeBehind="BrandingIOS.aspx.cs"
    Inherits="GladinetPayFlow.BrandingIOS" Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
  td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }        
         #brandc
         {
             background-image: url('images/branding.jpg');
             background-repeat: no-repeat;
             background-position: right bottom;
             border-style: solid;
             border-width: 1px;
             border-color: #cccccc;
         }
        .main
        {
            position: relative;
            min-height: 100%;
            padding: 0px;
        }
        .wrapper
        {
            padding: 0px;
            padding-bottom: 68px;
        }
        .footer, .push
        {
            height: 68px; /* .push must be the same height as .footer */
        }
        
        .footer
        {
            position: absolute;
            width: 100%;
            bottom: 0;
            left: 0;
        }
        
        *
        {
            margin: 0px;
            padding: 0px;
        }
        
        
      
    </style>
    <style type="text/css">
        .pricetable
        {
            border: 1px solid #cccccc;
        }
        
        .plain9BlackOnNone
        {
            border-bottom: 1px solid #cccccc;
            border-right: 1px solid #cccccc;
        }
        .offer_flex
        {
            background: #FFFFE0 url('images/giftbox.png') no-repeat 8px center;
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            color: #000000;
            height: 54px;
            line-height: 18px;
            padding: 2px;
            padding-left: 16px;
            width: 868px;
            vertical-align: middle;
            text-align: center;
            margin: auto;
            margin-bottom: 16px;
        }
        
        .offertitle
        {
            line-height: 24px;
        }
        .offertext
        {
            line-height: 20px;
        }
        
        .offer_flex1
        {
            border: 1px solid #E6DB55;
            border-radius: 4px 4px 4px 4px;
            margin: auto;
        }
    </style>
    <script type="text/javascript">


    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <div id="errmsgdiv" class="meubardrop" style="height:64px;">
        <b>
            <asp:Label ID="ErrorMessage" runat="server" Style="color: Red;" meta:resourcekey="ErrorMessageResource1"></asp:Label></b>
    </div>
    
    <table id="advinfo" width="100%"  class="" align="center" style="padding: 2px; margin-bottom: 100px; margin-top:20px;" cellspacing="0">
        <tr>
            <td style="padding: 10px;font-size:20px; font-weight:100; color:#404040;" valign="top" align="center">
                <div class="alert ">
                    <strong><asp:Localize meta:resourcekey="str_new" runat="server">New!</asp:Localize> </strong><asp:Localize meta:resourcekey="str_canSclBrdTsk" runat="server">You can schedule a branding task from your</asp:Localize> 
                                                            <%if(IsServo) { %>
                    <a href="https://my.triofox.com/management/partnerloginpage.aspx" target="_blank" ><asp:Localize meta:resourcekey="str_myTriAcc" runat="server">My Triofox account</asp:Localize></a>
                    <% } else {%>

                    <a href="https://access.centrestack.com/management/partnerloginpage.aspx" target="_blank" style="color: orange;"><asp:Localize meta:resourcekey="str_ptrAct" runat="server">partner account</asp:Localize></a>
                                                            <% } %>
                    <asp:Localize meta:resourcekey="str_wilBrdAdrCltAtm" runat="server">, we will brand the iOS Client automatically.</asp:Localize>
</div>
            </td>
        </tr>
        <tr>
            <td style="background-color: white; position: relative; padding:8px; border:1px; vertical-align: top; display: none;" >
                 <pre style="background-color: white; border: 0px;">
<asp:Localize meta:resourcekey="str_iosItr" runat="server">Branding of the iOS client can be done by following these steps.

First, download the zip file from here (<a href="/portal/gcebranding/transform_ios.zip">transform_ios.zip</a>) and extract it.                 

System Requirements:
   Mac OS X 10.11, 10.10 or 10.9 (Required)
   XCode
   iOS Developer Account
   iTunes Connect Account

The zip file contains:
  inputdir_appstore - The input branding directory. You will need to update the files in this folder for your own branding.
  gladinetcloud7_6_35855_1.ipa - The iOS package for the current release which will be transformed into your own branding
  transform_appstore.sh - The shell script that will transform the package into your own branding
  readme.txt - A help file which contains these instructions

How to brand your iOS Application
1. First, you will need to have iOS developer account with Apple. 
   If you plan to release your application to Apple App Store, you will need a normal developer account. 
   If you plan to release the iOS application for enterprise deployment, you will need an enterprise account.

2. You need a Mac OSX 10.11/10.10/10.9/ machine with XCode installed. XCode is a free download from the iOS Developer website.
   The current iOS application was built with XCode 6.4. It is recommended that you download XCode 6.4 from iOS developer download 
   portal instead of XCode 7. 

3. From XCode, you can connect to your iOS developer account, download the certificate, and create the mobile 
   provisioning profile. If you don't already have a distribution certificate, follow Apple's instructions to create one using the 
   same Mac machine.
   Assuming that your main app ID is com.acme.cloudfile:
      3.1 In the App ID section you need to create 4 app IDs:
         com.acme.cloudfile
         com.acme.cloudfile.docprovider
         com.acme.cloudfile.docproviderFileProvider
         com.acme.cloudfile.actionext
    
      3.2 Create an app group:
         group.com.acme.cloudfile
    
    3.3 Assign the group to each App ID. Enable Application Group capability for each App ID and assign the group.

    3.4 Create a distribution mobile profile 
        Each application ID needs a mobile provisioning profile. You will create 4 provisioning profiles and download them to the 
        input_dir:
           actionext.mobileprovision
           docprovider.mobileprovision
           fileprovider.mobileprovision
           main.mobileprovision

Summary: 
    After steps 1,2, and 3 you will have the certificate ready on your Mac OSX machine (in the keychain). 
    You will also have the mobile provisioning file ready and downloaded. The mobile provisioning file 
    needs to be placed in the inputdir so it can feed into the transform script.

4. There is an inputdir_appstore that contains the information to rebrand the iOS application for Apple AppStore deployment.
   You will need to prepare the inputdir following these examples. 
      4.1 Change the parameters in the common.sh to match your iOS product.
           ACCESSPOINT: This is your CentreStack server's external DNS name, make sure the HTTPS is ready before you try the iOS 
                        application because by default it connects via HTTPS
	         PRODUCTNAME: The product name
	         PRODUCTNAMENOS: The product name without any spaces, all in one word.
	         BUNDLEID: The bundle ID. It needs to match the application ID that you created in the iOS developer program
	         PACKAGEID: Same as above
	         IOSPACKAGEID: Same as above
	         FULLIOSID: The team prefix followed by a dot and the BUNDLEID.
	         CERTIFICATENAME: Your certificate to sign the iOS Application.
	         IOSTEAMID: The team ID in the iOS developer account
	         IOSGROUPID: The group ID used by all the app IDs. 
	 
    4.2 Various bitmap files. Replace the bitmap files making sure that you have the same resolution as the samples.
        4.2.1 Bitmap files directly inside the inputdir folder (or inputdir_appstore folder).
        4.2.2 Images.xcassets. There are two sub folders under this folder: 
                 AppIcon.appiconset - These are the app icons
		             LaunchImage.launchimage - These are the splash screens
    
    4.3 All 4 mobile provisioning files
  
5. The IPA file. The IPA file is the original iOS application package. 

6. transform_appstore.sh
   bash -x transform_appstore.sh inputdir_appstore gladinetcloud7_6_35855_1.ipa

   The generated package is output.ipa
   
You can open a Mac Terminal and run the script inside of it.  
 
How it works:
  The transform_appstore.sh will open up the original iOS package in the ipa file, take the bitmap files and input parameters
  from the inputdir folder and replace those in the ipa file.
  
  In the end, it will reassemble the IPA file back into one package and sign it with your own certificate. 
  The resigned package becomes your own branded package, with the access point hard-coded to your own access point.

NOTE:
   You might need to upload the transformed package multiple times to the App Store for beta testing and artwork adjustments. 
   Furthermore, since Apple doesn't allow duplicate version numbers, whenever you update the artwork and need to re-upload
   the package, you will need to add the following two lines to the transform_appstore.sh. You will need to update the version 
   string as well. Example: 6.332, 6.333, etc.

$PLISTBUDDY -c "Set :CFBundleShortVersionString '6.331.01'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleVersion '6.331'" "$PLIST_FILE"

For example, here is a section of the transform_appstore.sh after the package was updated to version 6.331

$PLISTBUDDY -c "Set :CFBundleIdentifier '$IOSPACKAGEID'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleName '$PRODUCTNAMENOS'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleDisplayName '$PRODUCTNAME'" "$PLIST_FILE"

$PLISTBUDDY -c "Set :CFBundleShortVersionString '6.331.01'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CFBundleVersion '6.331'" "$PLIST_FILE"

$PLISTBUDDY -c "Set :CSAccessPoint 'https://$ACCESSPOINT/namespace/n.svc/'" "$PLIST_FILE"
$PLISTBUDDY -c "Set :CSCopyright '$COPYRIGHTSTR'" "$PLIST_FILE"

TROUBLESHOOTING:
    In some systems, the bash shell will only accept UNIX-style text files (with a Line-Feed at the end, e.g. \n). The current 
    shell scripts, such as common.sh and transform_blah.sh are formatted as Mac text files and may have Carriage Returns e.g. \r 
    at the end of the lines. If this is the case, use could use perl or some other tool to transform the scripts to UNIX-style 
    text line endings.</asp:Localize></pre>
            </td>
        </tr>
    </table>

    <asp:HiddenField ID="BrandingObjectId" runat="server" />
    <asp:HiddenField ID="BrandingCluster" runat="server" />
</asp:Content>
