﻿<%@ Page Title="Gladinet Cloud Cluster" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BrandingGeneral.aspx.cs" Inherits="GladinetPayFlow.BrandingGeneral"
    Culture="auto" meta:resourcekey="PageResource2" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        
        .wrapper
        {
            padding: 0px;
            padding-bottom: 0px;            
        }
        
        td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
       
        
        .badgefont {
            font-size: 15px;
            
        }
    </style>
    <script type="text/javascript" src="/portal/jscolor.js"></script>
    <script type="text/javascript">
        function ConfirmReset() {
            gConfirm("<asp:Localize runat="server" meta:resourcekey="str_cfmRstMsg">Confirm reset. All existing branding settings will be lost.</asp:Localize>", "", function(btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_Button1");
                    Wait("<asp:Localize runat="server" ID="LocApyChg" meta:resourcekey="str_apyChg">Applying Changes</asp:Localize>");
                    e.click();
                }
            });
        }
        
        var _jsColorPickerIsVisible = false;
        function setColor(picker) {
            var e = document.getElementById("<%=CustomColor.ClientID%>");
            _jsColorPickerIsVisible = true;
            e.value = "#" + picker.toString();
        }
        function toggleJsColorPicker() {
            var e = document.getElementById("<%=CustomColor.ClientID%>");
            if(_jsColorPickerIsVisible){
                e.jscolor.hide();
                _jsColorPickerIsVisible = false;
            }else{
                e.jscolor.show();
                _jsColorPickerIsVisible = true;
            }
        } 
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocCtzUrlCntCtn" meta:resourcekey="str_ctzUrlCntCtn" Visible="false">Customized URL cannot contain: / \</asp:Localize>
    <div style="width: 100%; padding:5px; <% if (IsServo){ %>border-bottom:1px solid #cccccc;<% } %> " <% if (!IsServo){ %>class="meubardrop"<% } %>  >
            
            <table width="100%">
                <tr>
                    <td></td>
                    <td align="right">
                         <% if (m_CanEdit){ %>
        
                        <div class="navbar-right" style="display:flex;flex-direction:row-reverse;">    
                        <asp:Button ID="EditBtn" runat="server" 
                            CausesValidation="False" 
                            CssClass="btn btn-primary gladbtn  navbar-btn navbar-right btndlg" 
                            Text="Edit" onclick="EditBtn_Click" meta:resourcekey="EditBtnResource1"></asp:Button> 
                        <div style="display:flex;flex-direction:row;">   
                        <asp:Button ID="ApplyBtn" runat="server" Visible="false"
                            CausesValidation="False" OnClick="OnContinueClick" OnClientClick="Wait('Apply Change')"
                            CssClass="btn btn-primary gladbtn  btndlg" meta:resourcekey="LinkButton3Resource1" 
                            Text="Apply" Width="108"></asp:Button> 
                        <asp:Button ID="CancelBtn" runat="server" Visible="False"
                            CausesValidation="False" OnClientClick="Wait('Please wait')"
                            CssClass="btn   btndlg" 
                            Text="Cancel" onclick="CancelBtn_Click" Width="108" meta:resourcekey="CancelBtnResource1"></asp:Button>    
          
                        </div>      
                            
                        <asp:Button ID="ResetButton" runat="server" 
                            CausesValidation="False" OnClientClick="ConfirmReset();return false;"
                            CssClass="btn btn-primary gladbtn navbar-btn navbar-right btndlg" 
                            Text="Reset All"  meta:resourcekey="ResetBtnResource1"></asp:Button>   
                            </div>
            
                                                 
                 <%
                    EditBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                    CancelBtn.OnClientClick = String.Format("Wait('{0}')", LocPlsWat.Text);
                    ApplyBtn.OnClientClick = String.Format("Wait('{0}')", LocApyChg.Text);
                 }%>
            
                    </td>
                </tr>
            </table>
                
            </div>
    <div class="wrapper" style="background-color: white;margin-top: 20px;font-size: 16px;overflow:auto" id="rowcontainer">
        
        <div>
            <%if (!string.IsNullOrEmpty(ErrorMsg.Text))
              { %>
    
            <asp:Label ID="ErrorMsg" runat="server" CssClass="errmsg" meta:resourcekey="ErrorMsgResource1"></asp:Label>
            <%} %>
        </div>
        <asp:Panel ID="BrandingPanel" runat="server" meta:resourcekey="BrandingPanelResource1">
            <table width="100%" class="table" align="center" style="padding: 12px; font-size: 14px; font-weight: 100; color: #565656; " cellspacing="0">
                <%if (string.Compare(BrandingCluster.Value, "true") != 0 && !IsValidRSession)
                  {%>
                <tr>
                    <td colspan="2" valign="top" height="60px" style="border-bottom: 1px dashed #d0d0d0; padding: 10px;
                        border-top: 0px solid #C0C0C0;" >
                        <table width="100%">
                            <tr>
                                <td width="260px">
                                    
                                        <asp:Localize ID="Localize1" meta:resourcekey="asp_string1" runat="server" Text="Customized URL for your business"></asp:Localize>
                                </td>
                                <td width="60px">
                                    <asp:Label ID="DnsPrefix" runat="server" Text="http(s)://" meta:resourcekey="DnsPrefixResource2"></asp:Label>
                                </td><td nowrap="nowrap" width="20px">
                                    <asp:TextBox ID="DnsSubDomain" runat="server" Width="200px" CssClass="form-control" Visible="False"
                                        meta:resourcekey="DnsSubDomainResource1"></asp:TextBox>     
                                        <asp:Label ID="LDnsSubDomain" runat="server" meta:resourcekey="str_notbranded" CssClass="badge"
                                        ></asp:Label>
                                        </td><td >
                                    <asp:Label ID="DnsDomain" runat="server" Text=".gladinet.com/portal" meta:resourcekey="DnsDomainResource1"></asp:Label>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="4">
                                    <p class="text-muted">
                                    <asp:Localize ID="Localize2" meta:resourcekey="str_curl1" runat="server" Text="This is the URL that when you use to access"></asp:Localize> <%=m_ProductName %>,
                                    <asp:Localize ID="Localize3" meta:resourcekey="str_curl2" runat="server" Text="the following branding settings will apply."></asp:Localize>
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <%}%>
                <tr >
                    <td width="420px" style="padding: 10px;" valign="middle">
                        
                            <asp:Localize ID="Localize4" meta:resourcekey="asp_string3" runat="server" Text="Product Name:"></asp:Localize><br />
                        <p class="text-muted">
                            <asp:Localize ID="Localize5" meta:resourcekey="asp_string4" runat="server" Text="What you want to call the product."></asp:Localize></p>
                    </td>
                    <td style="padding-right: 10px;">
                        <asp:TextBox ID="ProductName" runat="server" Text="Gladinet Cloud" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="ProductNameResource1"></asp:TextBox>
                            
                            <asp:Label ID="LProductName" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"
                                        ></asp:Label>
                            
                    </td>
                </tr>
                <tr>
                    <td style="padding: 10px;" valign="middle">
                        <asp:Localize ID="Localize6" meta:resourcekey="asp_string5" runat="server" Text="Web-UI Theme (takes effect when you log in next time):"></asp:Localize>                        <br />
                        <asp:CheckBox ID="DisableThemeChange" runat="server" Text="Don't allow the user to change the theme"
                            meta:resourcekey="DisableThemeChangeResource1" />

                    </td>
                    <td nowrap="nowrap" style="padding-right: 10px;">
                        <asp:DropDownList ID="ThemeList" runat="server" meta:resourcekey="ThemeListResource1" CssClass="browser-default custom-select secsubbordercolor" Visible="False">
                            <asp:ListItem Value="blue" meta:resourcekey="ListItemResource1" Text="Blue"></asp:ListItem>
                            <asp:ListItem Value="mtblue" meta:resourcekey="ListItemResource5" Text="Sky Blue"></asp:ListItem>
                            <asp:ListItem Value="mtgreen" meta:resourcekey="ListItemResource6" Text="Lime Green"></asp:ListItem>
                            <asp:ListItem Value="mtorange" meta:resourcekey="ListItemResource7" Text="Orange"></asp:ListItem>
                            <asp:ListItem Value="mtred" meta:resourcekey="ListItemResource8" Text="Red"></asp:ListItem>
                            <asp:ListItem Value="mtmauve" meta:resourcekey="ListItemResource9" Text="Mauve"></asp:ListItem>
                            <asp:ListItem Value="mtsteel" meta:resourcekey="ListItemResource10" Text="Steel Blue"></asp:ListItem>
                            <asp:ListItem Value="mtolive" meta:resourcekey="ListItemResource11" Text="Olive Green"></asp:ListItem>
                            <asp:ListItem Value="mtteal" meta:resourcekey="ListItemResource12" Text="Teal Green"></asp:ListItem>
                            <asp:ListItem Value="mtpink" meta:resourcekey="ListItemResource13" Text="Pink"></asp:ListItem>
                            <asp:ListItem Value="gray" meta:resourcekey="ListItemResourceGray" Text="Gray"></asp:ListItem>
                            <asp:ListItem Value="classic" meta:resourcekey="ListItemResource3" Text="Classic"></asp:ListItem>
                            <asp:ListItem Value="custom"  Text="Customized" meta:resourcekey="str_ctz"></asp:ListItem>
                        </asp:DropDownList>
                         <asp:Label ID="LThemeList" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                            
                    </td>
                </tr>
                <%if (!IsServo) { %>
                <tr>
                        <td style="padding-top: 20px;">
                            <asp:Localize runat="server" meta:resourcekey="str_ctrWidDefLng">Tenant Default Language:</asp:Localize>
                            <asp:Localize ID="LocNoDft" meta:resourcekey="str_noDft" runat="server" Visible="false">No default</asp:Localize>
                        </td>
                        <td>
                            <asp:DropDownList ID="LanguageSelect" runat="server" AutoPostBack="false" Width="200px" CssClass="browser-default custom-select secsubbordercolor">
                            </asp:DropDownList>
                            <asp:Label ID="LLanguageSelect" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                        </td>
                </tr>
                <% } %>
                <tr >
                    <td width="420px" style="padding: 10px;" valign="middle">
                        <asp:Localize meta:resourcekey="str_custcolor" runat="server"> Customized Theme Color</asp:Localize>
                            
                    </td>
                    <td style="padding-right: 10px;">
                        <%if(!ColorPanel.Visible) { %>
                        <table width="200px">
                            <tr>
                                <td>
                                    <asp:TextBox ID="CustomColor" runat="server" Text="#00b294" Width="100%" CssClass="form-control jscolor {valueElement:'<%=CustomColor.ClientID %>',closable:true,closeText:'Done', onFineChange:'setColor(this)'}" Visible="False"
                                        ></asp:TextBox>
                                    
                                </td>
                                <td width="32px">
                                    <button class="btn btn-primary gladbtn" style="display: inline-block; padding: 0px; background-color: transparent!important;" onclick="toggleJsColorPicker();return false;"><span class="fa fa-pencil" style="background-color: transparent!important;"></span></button>
                                </td>
                            </tr>
                        </table>
                        
                        
                        <% } %>
                        <asp:Panel ID="ColorPanel" runat="server">
                            <div style="width: 32px; width: 32px; background-color:<%=CustomColor.Text%>">&nbsp;</div>
                        </asp:Panel>
                           
                            
                    </td>
                </tr>
                <tr>
                    <td style="padding: 10px;" valign="middle">
                        
                            <asp:Localize ID="Localize7" meta:resourcekey="asp_string6" runat="server" Text="'Contact Us' URL"></asp:Localize>
                        
                        <div style="display: none">
                            <asp:Button ID="Button1" runat="server" Text="Button" onclick="ResetButton_Click"/>
                            
                        </div>
                        <p class="text-muted"> <asp:Localize ID="Localize8" meta:resourcekey="asp_string7" runat="server" Text="The URL of your contact us page"></asp:Localize></p>
                    </td>
                    <td style="padding-right: 10px;">
                        <asp:TextBox ID="AboutUsUrl" runat="server" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="AboutUsUrlResource1"></asp:TextBox>
                        <asp:Label ID="LAboutUsUrl" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"
                                        ></asp:Label>
                    </td>
                </tr>
                <%if (SessionIsInstalledApp)
                  {%>
                <tr style="display:none;" >
                    <td style="padding: 10px; valign="middle" >
                        
                            <asp:Localize ID="Localize9" meta:resourcekey="asp_string8" runat="server" Text="'Feedback' Email"></asp:Localize>
                        
                        <p class="text-muted"><asp:Localize ID="Localize10" meta:resourcekey="asp_string9" runat="server" Text="The Email account that will receive user's feedback"></asp:Localize></p>
                    </td>
                    <td style="padding-right: 10px;">
                        <asp:TextBox ID="FeedbackEmail" runat="server" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="FeedbackEmailResource1"></asp:TextBox>
                            <asp:Label ID="LFeedbackEmail" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                    </td>
                </tr>
                
                <tr>
                    <td style="padding: 10px;" valign="middle">
                        
                            <asp:Localize ID="Localize11" meta:resourcekey="asp_string10" runat="server" Text="'Home Page' URL"></asp:Localize>
                        
                        <p class="text-muted"><asp:Localize ID="Localize12" meta:resourcekey="asp_string11" runat="server" Text="The URL of your 'Home' page"></asp:Localize></p>
                    </td>
                    <td style="padding-right: 10px;">
                        <asp:TextBox ID="HomePage" runat="server" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="HomePageResource1"></asp:TextBox>
                            <asp:Label ID="LHomePage" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td  style="padding: 10px;" valign="middle">
                        
                            <asp:Localize ID="Localize13" meta:resourcekey="asp_string12" runat="server" Text="'Term of Use' URL"></asp:Localize>
                        
                        <p class="text-muted"><asp:Localize ID="Localize14" meta:resourcekey="asp_string13" runat="server" Text="The URL of your 'Term of Use' page"></asp:Localize></p>
                    </td>
                    <td style="padding-right: 10px;">
                        <asp:TextBox ID="Term" runat="server" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="TermResource1"></asp:TextBox>
                             <asp:Label ID="LTerm" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                    </td>
                </tr>
                
                <tr>
                    <td  style="padding: 10px;" valign="middle">
                        
                            <asp:Localize ID="Localize15" meta:resourcekey="asp_string14" runat="server" Text="'Privacy Policy' URL"></asp:Localize>
                        <p class="text-muted"><asp:Localize ID="Localize16" meta:resourcekey="asp_string15" runat="server" Text="The URL of your 'Privacy Policy' page"></asp:Localize></p>
                    </td>
                    <td style="padding-right: 10px;">
                        <asp:TextBox ID="PrivacyLink" runat="server" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="PrivacyLinkResource1"></asp:TextBox>
                            <asp:Label ID="LPrivacyLink" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                    </td>
                </tr>
                
                <tr>
                    <td  style="padding: 10px;" valign="middle">
                        
                            <asp:Localize ID="Localize17" meta:resourcekey="asp_string16" runat="server" Text="'Copyright' Statement"></asp:Localize>
                        <p class="text-muted" style="display:none;"><asp:Localize ID="Localize18" meta:resourcekey="asp_string17" runat="server" Text="The URL of your 'Copyright' statement"></asp:Localize></p>
                    </td>
                    <td  style="padding-right: 10px;">
                        <asp:TextBox ID="Copyright" runat="server" Width="100%" CssClass="form-control" Visible="False"
                            meta:resourcekey="CopyrightResource1"></asp:TextBox>
                            <asp:Label ID="LCopyright" runat="server" meta:resourcekey="str_notbranded"  CssClass="badge"></asp:Label>
                    </td>
                </tr>
                <%} %>
            </table>
        </asp:Panel>
        
    </div>
    <div id="ModalAlert" class="modal fade" role="dialog">
      <div class="modal-dialog">

      <!-- Modal content-->
        <div class="modal-content">
          <div class="modal-header">

          </div>
          <div class="modal-body" style="font-weight: 100; color: #565656;">                             
            <p id="modalBody"><asp:Localize runat="server" ID="LocPleAllFewMinMsg" meta:resourcekey="str_pleAllFewMinMsg" Visible="false">Please allow a few minutes for the changes to take effect.</asp:Localize><asp:Localize runat="server" ID="LocRstIISMsg" meta:resourcekey="str_rstIISMsg" Visible="false">&nbsp;If you need the changes to be immediate, please reset your IIS web server.</asp:Localize></p>
          </div>

          <div class="modal-footer" style="font-size: 16px;">
            <button type="button" id="btnOK" class="btn btn-default" data-dismiss="modal"><span style="font-size: 16px; font-weight: 200;"><asp:Localize meta:resourcekey="str_ok" runat="server">OK</asp:Localize></span></button>
          </div>
        </div>

    </div>
  </div>
    <asp:Localize ID="Not_Branded" meta:resourcekey="str_notbranded" runat="server" Visible="False">Not Branded</asp:Localize>
    <asp:HiddenField ID="BrandingObjectId" runat="server" />
    <asp:HiddenField ID="BrandingCluster" runat="server" />
    <asp:HiddenField ID="BrandingMode" runat="server" />
    <asp:Localize runat="server" ID="LocPlsWat" meta:resourcekey="str_plsWat" Visible="false">Apply Change</asp:Localize>
      <script type="text/javascript">

            function adjust(){
                var e = document.getElementById("rowcontainer");
                e.style.height = (document.documentElement.offsetHeight -92)+"px";
                
            }

            Ext.onReady(function () {
                adjust();      
                try{
                    document.getElementById("<%=CustomColor.ClientID%>").style.backgroundColor = "<%=CustomColor.Text%>";
                }catch(ex){
                }
                var msg = $("#modalBody").html();
                if(msg.length>1){
                    $('#ModalAlert').modal({ backdrop: 'static', keyboard: false });
                }  

            });

        </script>
</asp:Content>
