﻿<%@ Page Title="Gladinet Cloud - Search" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BadDevicesPage.aspx.cs" Inherits="GladinetPayFlow.BadDevicesPage"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
        .titlecol
        {
            background-color: #f0f0f0;
            font-size: 14px;
        }
        
        .dark {
            color: #565656 !important;
        }
        
    </style>
    <script type="text/javascript">




        function ClearErrorMsg() {

            var d = document.getElementById("errmsgdiv");
            if (d) {
                d.style.display = 'none';
            }
        }
        setTimeout("ClearErrorMsg()", 30000);



        var ActiveWin;
        var MainWnd;
        function closeActiveWin() {


            window.location = window.location;

        }

        function closeCancelActiveWin() {
            ActiveWin.close();
        }

        function gEncodeUri(str) {
            var s = encodeURI(str).replace(/&/g, '%26').replace(/#/g, '|').replace('+', ':');
            while (true) {
                var i = s.indexOf('+');
                if (i == -1)
                    break;
                s = s.replace('+', ':');
            }

            return s;

        }

        function OpenFile(file) {
            var f = document.getElementById('rightpanel');
            f.src = "File.aspx?f=" + gEncodeUri(unescape(file));

        }

        function OnWipeDevice(id, name) {
            var ng = document.getElementById("MainContent_DeviceId");
            var btn = document.getElementById("MainContent_WipeDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_wipe" runat="server">Do you really want to wipe the device (</asp:Localize>" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_wiping" runat="server">wiping...</asp:Localize>");
            ng.value = id;
            btn.click();
        }
        }

        function OnDeleteDevice(id, name) {
            var ng = document.getElementById("MainContent_DeviceId");
            var btn = document.getElementById("MainContent_DeleteDevice");

            if (confirm("<asp:Localize meta:resourcekey="str_deldev" runat="server">Do you really want to delete the device entry</asp:Localize> (" + unescape(name) + ")?")) {
                Wait("<asp:Localize meta:resourcekey="str_delentry" runat="server">wiping...</asp:Localize>");
                ng.value = id;
                btn.click();
            }
        }

        
    function OnAgentAttachedFolders(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceAttachedFolders.aspx?f=c&id=" + id + "&name=" + name;
    }

    function OnAgentTasks(id, name) {
        Wait("Please wait");
        window.location = "/management/DeviceTasks.aspx?f=c&id=" + id + "&name=" + name;
    }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false">not found</asp:Localize>
   <nav class="navbar navbar-default" role="navigation">
      <div class="container-fluid">
          <p class="navbar-text">
              <asp:Label ID="ResultCount" runat="server" meta:resourcekey="ResultCountResource1" CssClass="badge"></asp:Label>
          </p>
          <p class="navbar-text">
           <asp:LinkButton ID="exportcsv" runat="server" ForeColor="Green" Visible="False" OnClick="exportcsv_Click"
                                ><asp:Localize ID="Localize1" meta:resourcekey="str_csv" runat="server">Download as CSV file</asp:Localize></asp:LinkButton>
          </p>
          <p class="navbar-text">
                <b>
                                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
          </p>
          
                
          
      </div>
    </nav>
    <table width="100%" style="padding: 2px; background-color: white; margin: 0px; margin-top: -13px" cellspacing="0" id="grid-table"
                    cellpadding="0">
                   
                    
                    <tr>
                        <td colspan="3" style="vertical-align: top;" id="result_div">
                        </td>
                    </tr>
        
                   
                </table>
    
    <div style="display: none;">
        <asp:HiddenField ID="InstanceId" runat="server" />
        <asp:Button ID="DeleteDevice" runat="server" Text="Delete" OnClick="DeleteDevice_Click" />
    </div>
    <asp:HiddenField ID="DeviceId" runat="server" />
    <div style="display: none;">
    </div>
    <script type="text/javascript">    
var myData = [
 <asp:Repeater ID="PubsRepeater" runat="server" enableviewstate="false" >
        <ItemTemplate>         
        <%#(Container.ItemIndex == 0)? "": "," %>      ['<%#(((RepeaterItem)Container).ItemIndex+1) %>',
        '<%#DataBinder.Eval(Container.DataItem, "UserId")%>', 
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"UserEmail").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"DeviceType").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"HostName").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"OsVer").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"ClientVer").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"InstanceId").ToString().Replace("'","%27")) %>',
        '<%#Server.HtmlEncode(DataBinder.Eval(Container.DataItem,"Status").ToString().Replace("'","%27")) %>',
        '<%#DataBinder.Eval(Container.DataItem,"LastLogin").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"LastReport").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"SyncStatus").ToString().Replace("'","%27") %>',
        '<%#DataBinder.Eval(Container.DataItem,"LiveDevice").ToString().Replace("'","%27") %>'
         ] 
        </ItemTemplate>
    </asp:Repeater>      
    ];
    </script>
    <script type="text/javascript">

      function OnChange(id) {
          
          var idc = document.getElementById("MainContent_InstanceId");
          var db = document.getElementById("MainContent_DenyBtn");
          var ab = document.getElementById("MainContent_AllowBtn");
          idc.value = id;

          var e = document.getElementById(id);
          if (e.checked) {
              
              ab.click();
          } else {
          
              db.click();
          }

      }
      function DeleteDevice(id) {
          var idc = document.getElementById("ctl00_MainContent_InstanceId");
          var ab = document.getElementById("ctl00_MainContent_DeleteDevice");
          idc.value = id;
          gConfirm("Confirm delete the device?", "", function(btn1) {

              if (btn1 != 'ok')
                  return;
              Wait("Deleting");
              ab.click();
          });
          
      }
        function MgrDevice(id) {
            window.location = "DeviceDashboard.aspx?id=" + id;
        }

    var grid;
      
       function AdjustGridTable () {
           
        var h = 400;
          
        try {

            var myTable = Ext.get('grid-table');
           
            var tableY = myTable.getY();
           
            h = document.body.offsetHeight-tableY-60;
           
              var ee = document.getElementById('tinfo');
              ee.style.height = h + "px";

          } catch (err) {
          }
              grid.setWidth(document.documentElement.clientWidth - 2);
              grid.setHeight(h);
              grid.doComponentLayout();

          var e = document.getElementById("result_div");
          e.style.height = h + "px";

      }

      Ext.require([
          'Ext.grid.*',
          'Ext.data.*',
          'Ext.util.*',
          'Ext.state.*'
      ]);
      Ext.onReady(function () {

          Ext.QuickTips.init();

          var store = Ext.create('Ext.data.ArrayStore', {
              fields: [
                  { name: 'index' },
                  { name: 'userid' },
                  { name: 'email' },
                  { name: 'type' },
                  { name: 'name' },
                  { name: 'os' },
                  { name: 'clientver' },
                  { name: 'id' },
                  { name: 'status' },
                  { name: 'lastlogin' },
                  { name: 'lastreport' },
                  { name: 'syncstatus' },
                  { name: 'livedevice' }
              ],
              data: myData
          });


           grid = Ext.create('Ext.grid.Panel', {
              store: store,
              stripeRows: true,
              border: false,
              columnLines: false,
              minHeight: 208,              
              minButtonWidth: 28,
              viewConfig: {
                  emptyText: "<asp:Localize meta:resourcekey="str_empty" runat="server">Please specify a search pattern to see search result</asp:Localize>",
                  deferEmptyText: false
              },
          
              columns: [
                  {
                      text: '',
                      width: 50,
                      sortable: false,
                      hideable: false,
                      dataIndex: 'index',
                      getClass: function (v, meta, rec) {
                          return 'x-col-hide';
                      }
                  },
                  {
                      text: "<asp:Localize meta:resourcekey="str_email" runat="server">Email</asp:Localize>",
                      sortable: true,
                      minWidth: 108,
                      flex:9,
                      dataIndex: 'email',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" + unescape(value) + "</span>";
                      }

                  },

                  {
                      text: "<asp:Localize meta:resourcekey="str_type" runat="server">Type</asp:Localize>",
                      flex: 1,
                      minWidth:68,
                      sortable: true,
                      dataIndex: 'type',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" +unescape(value);
                      }

                  },
                  {
                      text: "<asp:Localize meta:resourcekey="str_name1" runat="server">Name</asp:Localize>",
                      width: 175,
                      sortable: true,
                      dataIndex: 'name',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" +unescape(value)+ "</span>";
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="str_os" runat="server">OS</asp:Localize>",
                      minWidth: 120,                      
                      width:200,
                      sortable: true,
                      dataIndex: 'os',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" +unescape(value)+ "</span>";
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="str_ver" runat="server">Version</asp:Localize>",
                      minWidth: 80,
                      flex:1,
                      sortable: true,
                      dataIndex: 'clientver',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" +unescape(value)+ "</span>";
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="str_lastlogin" runat="server">Last Login</asp:Localize>",
                      minWidth: 175,
                      width:175,
                      sortable: true,
                      dataIndex: 'lastlogin',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" +unescape(value)+ "</span>";
                      }
                  }, {
                      text: "<asp:Localize meta:resourcekey="str_lastr" runat="server">Last Report</asp:Localize>",
                      minWidth: 175,
                      width:175,
                      sortable: true,
                      dataIndex: 'lastreport',
                      renderer: function (value, metaData, record, rowIndex) {
                          return "<span style='color:#404040; font-weight:100;'>" +unescape(value)+ "</span>";
                      }
                  }, {
                      text: "Status",
                      minWidth: 64,
                      width:100,
                      align: 'center',
                      sortable: true,
                      dataIndex: 'syncstatus',
                      renderer: function(value, metaData, record, rowIndex) {
                          if (value == "0")
                              return '<span class="fa fa-question-sign" title="unknown" style="color:#008000"></span>';
                        if (value == "6")
                              return '<span class="fa fa-pause " style="color:#808000" title="Sync task paused"></span>';

                        if (value == "5")
                              return '<span class="fa fa-calendar " style="color:#008080" title="Sync task pending"></span>';

                        if (value == "4")
                              return '<span class="fa fa-exclamation-sign " style="color:#800000" title="Failed to retrieve sync status"></span>';

                        if (value == "2")
                              return '<span class="fa fa-exclamation-sign " style="color:#800000" title="Sync Failed"></span>';

                        if (value == "1")
                              return '<span class="fa fa-refresh " style="color:#004080" title="Syncing"></span>';
                          if (value == "3")
                              return '<span class="fa fa-check" style="color:#008000" title="Synced"></span>';

                      }
                      }, {
                         
                          minWidth: 62,
                          width: 62,
                          sortable: true,
                          dataIndex: 'lastreport',
                          renderer: function (value, metaData, record, rowIndex) {
                              var d = record.data;
                              return "<a href='#' onclick='MgrDevice(\""+d.id+"\");return false'><span style='color:#404040; font-weight:100;' class='fa fa-wrench'></span></a>&nbsp;<a href='#' onclick='DeleteDevice(\""+d.id+"\");return false'><span style='color:#404040; font-weight:100;' class='glyphicon glyphicon-trash'></span></a>";
                          }
                      }
                  ],
              renderTo: 'result_div'
          });

          //Ext.EventManager.onWindowResize(grid.doLayout, grid);
           AdjustGridTable ();
             
             Ext.EventManager.onWindowResize(AdjustGridTable);     
      });
    </script>
</asp:Content>
