﻿<%@ Page Title="Device Info" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="DeviceBackupDashboard.aspx.cs" Inherits="GladinetPayFlow.DeviceBackupDashboard"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" EnableViewState="False" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
       
           
    </style>
    <script type="text/javascript">
        function parentOpenThirdMenu(icoCode, title, url) {
            if (parent) {
                if (parent.OpenThirdMenu) {
                    parent.OpenThirdMenu(icoCode, title, url);
                    return;
                } else {
                    location.href = url;
                }
            }
            console.log("parent.OpenThirdMenu does not exist in parent");
        }

        function OnEditBackupSet(sid, sn) {
            parentOpenThirdMenu("c", "Scheduling", "/management/BackupMgr/UI/DeviceBackupSetCfg.aspx?child=1&id=<%=DeviceId.Value%>&sid=" + sid);

        }
        function OnBackupSetRun(sid, sn) {
            parentOpenThirdMenu("=", sn, "/management/BackupMgr/UI/DeviceBackupSetTaskRun.aspx?child=1&id=<%=DeviceId.Value%>&sid=" + sid);

        }
        function OnViewBackupSetSnapshots(sid, sn) {
            parentOpenThirdMenu("&#x150;", sn, "/management/BackupMgr/UI/DeviceBackupSnapshots.aspx?child=1&id=<%=DeviceId.Value%>&sid=" + sid);

        }

        function OnEditTargetFolder(sid, sn) {
            parentOpenThirdMenu("&#x118;", "Target Folders", "/management/BackupMgr/UI/DeviceBackupSetTargetFolders.aspx?child=1&id=<%=DeviceId.Value%>&sid=" + sid);

        }

        function OnAddBackupSet() {

            OpenChildWnd("Add New Backup Set", "/management/BackupMgr/UI/AddDeviceBackupSet.aspx?child=1&id=<%=DeviceId.Value%>")
        }
        function ReturnLast() {

            parentOnSecondMenuClick();
        }


        function adjust() {

            var f = document.getElementById('childwnd');
            f.style.height = (document.documentElement.clientHeight - 20) + "px";
        }

        function OnDeleteBackupSet(sid, sname) {
            gConfirm('Confirm you want to delete backup set: "' + sname + '"?', "", function (btn1) {

                if (btn1 != 'ok')
                    return;

                var hsid = document.getElementById("ctl00_MainContent_SetId");
                var btn = document.getElementById("ctl00_MainContent_BtnDeleteBackupSet");

                hsid.value = sid;

                Wait('Applying');
                btn.click();
            });
        }

        function OnStartNow(sid) {
            var hsid = document.getElementById("ctl00_MainContent_SetId");
            var btn = document.getElementById("ctl00_MainContent_StartNowBtn");

            hsid.value = sid;

            Wait('Applying');
            btn.click();
        }

        function OnPause(sid) {
            var hsid = document.getElementById("ctl00_MainContent_SetId");
            var btn = document.getElementById("ctl00_MainContent_PauseBtn");

            hsid.value = sid;

            Wait('Applying');
            btn.click();
        }

        function OnResume(sid) {
            var hsid = document.getElementById("ctl00_MainContent_SetId");
            var btn = document.getElementById("ctl00_MainContent_ResumeBtn");

            hsid.value = sid;

            Wait('Applying');
            btn.click();
        }
        function OnRefresh() {
            var e = document.getElementById("ctl00_MainContent_RefreshBtn");


            Wait("...");
            e.click();

        }

        function OnFiles() {

            parentOpenThirdMenu("&#x104;", "Files", "/management/BackupMgr/UI/DeviceBackupFilesBrowser.aspx?child=1&vdid=<%=SessionDomainId%>&tid=<%=DeviceId.Value%>");
        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">

<asp:Localize ID="LocFaiToCreNewSna" meta:resourcekey="str_faiToCreNewSna" Visible="false" runat="server">Failed to create new snapshot</asp:Localize>
<asp:Localize ID="LocFaiToResBacSet" meta:resourcekey="str_faiToResBacSet" Visible="false" runat="server">Failed to resume backup set</asp:Localize>
<asp:Localize ID="LocFaiToPauBacSet" meta:resourcekey="str_faiToPauBacSet" Visible="false" runat="server">Failed to pause backup set</asp:Localize>
<asp:Localize ID="LocFaiToSta" meta:resourcekey="str_faiToSta" Visible="false" runat="server">Failed to start</asp:Localize>
<asp:Localize ID="LocFaiToDelBacSet" meta:resourcekey="str_faiToDelBacSet" Visible="false" runat="server">Failed to delete backup set</asp:Localize>
<asp:Localize ID="LocMisPar" meta:resourcekey="str_misPar" runat="server" Visible="False">Missing parameter</asp:Localize>
    <div id="defaultcontent">
        <div style="width: 100%; padding: 5px; <% if (IsChildUi){ %>border-bottom: 1px solid #eeeeee; <% } %>" <% if (!IsChildUi)
            { %>class="meubardrop"
            <% } %>>
            <table width="100%">
                <tr>
                    <td style="padding: 10px;">
                        <div style="display: inline-block; padding-right: 10px; cursor: pointer;" onclick="OnRefresh();return false;" class="toolnavbtn">
                            <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right: 2px;" title="Refresh">&#xB5;</i>
                            <span style="font-weight: 100; font-size: 16px; color: #404040;"><asp:Localize meta:resourcekey="str_refresh" runat="server">Refresh</asp:Localize></span>
                        </div>
                        <div style="display: none; padding-right: 10px; cursor: pointer;" onclick="OnAddBackupSet();return false;" class="toolnavbtn">
                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" title="New Backup Set">&#xc9;</i>
                            <span style="font-weight: 100; font-size: 16px; color: #404040;"><asp:Localize meta:resourcekey="str_newBacSet" runat="server">New Backup Set</asp:Localize></span>
                        </div>
                        <div style="display: none; padding-right: 10px; cursor: pointer;" onclick="OnFiles();return false;" class="toolnavbtn">
                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" title="Files">&#xAB;</i>
                            <span style="font-weight: 100; font-size: 16px; color: #404040;"><asp:Localize meta:resourcekey="str_files" runat="server">Files</asp:Localize></span>
                        </div>
                    </td>
                    <td style="padding-left: 10px;" align="center"></td>
                    <td>
                        <asp:Label ID="ErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                    </td>
                    <td style="font-size: 16px; color: #565656; font-weight: 100; display:none; padding: 10px; padding-left: 14px;" align="right">
                        <asp:Label ID="BackupSetCounLable" runat="server" Text=""></asp:Label>
                    </td>

                </tr>


            </table>
            <div id="pollres" style="position: absolute; right: 10px; bottom: 10px"></div>
        </div>
        <div style="width: 100%">
            <asp:Repeater ID="SetsRepeater" runat="server">
                <ItemTemplate>
                    <div style="border-bottom-width: 1px; border-bottom-style: solid; border-color: #f0f0f0; font-weight: 100; padding: 10px;" class="filerow">
                        <table width="100%">

                            <tr style="display:none;">
                                <td colspan="2">
                                    <div class="toolnavbtn" onclick='OnEditBackupSet("<%#DataBinder.Eval(Container.DataItem, "SetId")%>","<%#DataBinder.Eval(Container.DataItem, "SetName")%>");return false;' style="display: inline-block;">
                                        <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;">&#x139;</i>
                                        <span style="padding-left: 10px; font-size: 16px; color: #565656; font-weight:400;"><%#DataBinder.Eval(Container.DataItem, "SetName")%></span>
                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="padding: 10px; padding-bottom: 3px;">
                                    <table>
                                        <td style="font-size: 16px; color: #202020;"><asp:Localize meta:resourcekey="str_bacSch" runat="server">Backup Schedule:</asp:Localize></td>
                                        <td style="color: #808080!important; font-size: 16px;font-weight: 200!important;">
                                            <%#DataBinder.Eval(Container.DataItem, "DisplayBackupSchedule")%>
                                        </td>
                                        <td style="padding-left: 10px; font-size: 10px;">
                                            <a style="padding-right: 10px;" href="javascript:;" onclick='OnStartNow("<%#DataBinder.Eval(Container.DataItem, "SetId")%>");return false;'><asp:Localize meta:resourcekey="str_staNow" runat="server">Start Now</asp:Localize></a>
                                            <a style="padding-right: 10px; display: none;" href="javascript:;" data-toggle="modal" data-target="#NewSnapshotModal"><asp:Localize meta:resourcekey="str_takASna" runat="server">Take a Snapshot</asp:Localize></a>

                                            <a style="padding-right: 10px; <%#DataBinder.Eval(Container.DataItem, "PauseBtnDisplay")%>" href="javascript:;" onclick='OnPause("<%#DataBinder.Eval(Container.DataItem, "SetId")%>");return false;'>Pause</a>
                                            <a style="padding-right: 10px; <%#DataBinder.Eval(Container.DataItem, "ResumeBtnDisplay")%>" href="javascript:;" onclick='OnResume("<%#DataBinder.Eval(Container.DataItem, "SetId")%>");return false;'>Resume</a>


                                        </td>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="padding: 10px; padding-top: 0px;">

                                    <a data-toggle="collapse" style="font-style: italic; font-size: 10px;" href="#LastBackup-<%#DataBinder.Eval(Container.DataItem, "SetId")%>" role="button" aria-expanded="false"><asp:Localize meta:resourcekey="str_lasBac" runat="server">Last Backup</asp:Localize></a>


                                    <div class="collapse" id="LastBackup-<%#DataBinder.Eval(Container.DataItem, "SetId")%>">
                                        <div>
                                            <span style="font-size: 10px; font-weight: 100; color: #565656;"><asp:Localize meta:resourcekey="str_lasBacTim" runat="server">Last Backup Time:</asp:Localize></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #202020; padding-right: 15px;"><%#DataBinder.Eval(Container.DataItem, "DisplayLastStartTime")%></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #565656;"><asp:Localize meta:resourcekey="str_duration" runat="server">Duration</asp:Localize></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #202020; padding-right: 5px;"><asp:Localize meta:resourcekey="str_10Sec" runat="server">10 seconds</asp:Localize></span>
                                        </div>
                                        <div>
                                            <span style="font-size: 10px; font-weight: 100; color: #565656;"><asp:Localize meta:resourcekey="str_totFil" runat="server">Total Files</asp:Localize></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #202020; padding-right: 15px;"><%#DataBinder.Eval(Container.DataItem, "FileCount")%></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #565656;"><asp:Localize meta:resourcekey="str_bacSiz" runat="server">Backup Size</asp:Localize></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #202020; padding-right: 15px;"><%#DataBinder.Eval(Container.DataItem, "DisplayTotalSize")%></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #565656;"><asp:Localize meta:resourcekey="str_deleted" runat="server">Deleted</asp:Localize></span>
                                            <span style="font-size: 10px; font-weight: 100; color: #202020; padding-right: 15px;"><%#DataBinder.Eval(Container.DataItem, "FileCount")%></span>
                                        </div>

                                    </div>
                                </td>
                            </tr>
                            <tr>
                                <td colspan="2" style="padding: 10px;">
                                    <span onclick='OnViewBackupSetSnapshots("<%#DataBinder.Eval(Container.DataItem, "SetId")%>","<%#DataBinder.Eval(Container.DataItem, "SetName")%>");return false;' class="toolnavbtn iconviewitemcolor hand" style="padding: 3px;">
                                        <i class="gladinet-icons md-16 iconviewitemcolor hand center">&#x150;</i>
                                        <span style="padding-left: 1px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_snapshots" runat="server">Snapshots</asp:Localize></span>
                                    </span>
                                    <span style="padding-left: 10px;">&nbsp;</span>
                                    <span onclick='OnBackupSetRun("<%#DataBinder.Eval(Container.DataItem, "SetId")%>","<%#DataBinder.Eval(Container.DataItem, "SetName")%>");return false;' class="toolnavbtn iconviewitemcolor hand" style="padding: 3px;">
                                        <i class="gladinet-icons md-16 iconviewitemcolor hand center">=</i>
                                        <span style="padding-left: 1px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_bacRun" runat="server">Backup Run</asp:Localize></span>
                                    </span>
                                    <span style="padding-left: 10px;">&nbsp;</span>

                                    <span onclick='OnEditBackupSet("<%#DataBinder.Eval(Container.DataItem, "SetId")%>","<%#DataBinder.Eval(Container.DataItem, "SetName")%>");return false;' class="toolnavbtn iconviewitemcolor hand" style="padding: 3px;">
                                        <i class="gladinet-icons md-16 iconviewitemcolor hand center">c</i>
                                        <span style="padding-left: 1px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_edit" runat="server">Edit</asp:Localize></span>
                                    </span>
                                    <span style="padding-left: 10px;">&nbsp;</span>

                                    <span onclick='OnEditTargetFolder("<%#DataBinder.Eval(Container.DataItem, "SetId")%>","<%#DataBinder.Eval(Container.DataItem, "SetName")%>");return false;' class="toolnavbtn iconviewitemcolor hand" style="padding: 3px;">
                                        <i class="gladinet-icons md-16 iconviewitemcolor hand center">&#x118;</i>
                                        <span style="padding-left: 1px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_tarFol" runat="server">Target Folders</asp:Localize></span>
                                    </span>


                                    <span onclick='OnDeleteBackupSet("<%#DataBinder.Eval(Container.DataItem, "SetId")%>","<%#DataBinder.Eval(Container.DataItem, "SetName")%>");return false;' class="toolnavbtn iconviewitemcolor hand" style="padding: 3px; <%#DataBinder.Eval(Container.DataItem, "DeleteBtnDisplay")%>">
                                        <i class="gladinet-icons md-16 iconviewitemcolor hand center">n</i>
                                        <span style="padding-left: 1px; color: #565656; font-weight: 100;"><asp:Localize meta:resourcekey="str_delete" runat="server">Delete</asp:Localize></span>
                                    </span>

                                </td>
                            </tr>
                        </table>

                    </div>
                </ItemTemplate>
            </asp:Repeater>
        </div>
    </div>
    <div id="NewSnapshotModal" class="modal fade" role="dialog">

        <div class="modal-dialog">
            <!-- Modal content-->
            <div class="modal-content" style="width: 600px;">
                <div class="modal-header">


                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <div class="modal-body">
                    <table>
                        <tr>
                            <td align="left" valign="middle" style="padding: 10px;" class="glabel2">
                                <asp:Localize runat="server" meta:resourcekey="str_shtNme">Snapshot Name</asp:Localize>
                            </td>
                            <td align="right" valign="middle" style="padding: 10px; width: 100px;">

                                <asp:TextBox ID="SnapshotName" runat="server" CssClass="form-control" Width="300px"></asp:TextBox>

                            </td>

                        </tr>
                        <tr>
                            <td colspan="2">
                                <table>
                                    <tr>
                                        <td>
                                            <asp:CheckBox ID="FullSnapshot" runat="server" />
                                        </td>
                                        <td><asp:Localize meta:resourcekey="str_fulSna" runat="server">Full snapshot</asp:Localize></td>
                                    </tr>
                                </table>

                            </td>
                        </tr>
                    </table>
                </div>
                <div class="modal-footer">
                    <asp:Button ID="AddNewSnapShot" runat="server" meta:resourcekey="str_tkeSht" Text="Take a snapshot" CssClass="btn btn-default sectextcolor"
                        OnClick="AddNewSnapShot_Click" OnClientClick="Wait('Uploading');" />

                    <button type="button" class="btn btn-default" data-dismiss="modal">
                        Cancel</button>
                </div>
            </div>
        </div>
    </div>
    <div id="childwnd" style="width: 100%; display: none;">
        <div width="100%" style="background-color: white; border: 0px; padding-bottom: 0px; align-content: right; border-bottom: 1px solid #f0f0f0;">
            <table width="100%" style="border-collapse: collapse;" cellpadding="0" cellspacing="0">
                <tr>
                    <td>
                        <table>
                            <tr>
                                <td style="padding: 5px; font-size: 18px; cursor: pointer; font-weight: 100;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();">
                                    <asp:Localize runat="server" meta:resourcekey="str_shts">Snapshots</asp:Localize></td>

                                <td style="padding: 5px; font-size: 18px;" class="sectextcolor ">></td>
                                <td align="left" style="padding: 5px; border-bottom: 0px solid #cccccc; padding-right: 10px; height: 48px; font-size: 18px; font-weight: 100;" id="child_title"></td>

                            </tr>
                        </table>
                    </td>

                    <td style="border-bottom: 0px solid #cccccc; padding-right: 10px;">
                        <div style="float: right; font-size: 32px; font-weight: 100; cursor: pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                    </td>
                </tr>
            </table>
        </div>


        <iframe width="100%" src="/portal/WaitWin.htm" frameborder="0" style="margin-top: 5px;"
            border="0" height="100%" id="child_body"></iframe>
    </div>
    <div id="ShortWindowModal" class="modal fade" role="dialog">
        <div class="modal-dialog " style="max-width: 650px!important; width: 650px!important; padding: 0px!important;">

            <!-- Modal content-->
            <div class="modal-content" style="padding: 0px!important;">
                <div class="modal-header">
                    <h4 class="modal-title" style="color: #808080;" id="ShortTitle"></h4>
                    <button type="button" class="close" onclick="CloseChildWnd();">&times;</button>

                </div>
                <div class="modal-body" style="height: 600px; padding-top: 0px; padding: 0px!important;" id="ShortBody">
                    <iframe id='ShortWindow' width="100%" style="padding: 0px;" src="/portal/WaitWin.htm"
                        frameborder="0" border="0" height="100%"></iframe>
                </div>
            </div>

        </div>
    </div>
    <div style="display: none">
        <asp:HiddenField ID="DeviceId" runat="server" />
        <asp:HiddenField ID="SetId" runat="server" />
        <asp:LinkButton ID="RefreshBtn" runat="server" OnClick="RefreshBtn_Click">Refresh btn</asp:LinkButton>
        <asp:Button ID="BtnDeleteBackupSet" runat="server" Text="DeleteBackupSet" OnClick="BtnDeleteBackupSet_Click" />
        <asp:Localize meta:resourcekey="str_disc" ID="StrDisc" runat="server">Disconnected</asp:Localize>
        <asp:Localize meta:resourcekey="str_connect1" ID="StrConn" runat="server">Connected</asp:Localize>
        <asp:LinkButton ID="StartNowBtn" runat="server" Font-Size="Smaller" OnClick="StartNowBtn_Click">Start Now</asp:LinkButton>
        <asp:LinkButton ID="NewSnapShotBtn" runat="server" Font-Size="Smaller" OnClick="NewSnapShotBtn_Click">Take a Snapshot</asp:LinkButton>
        <asp:LinkButton ID="PauseBtn" runat="server" Font-Size="Smaller" OnClick="PauseBtn_Click">Pause</asp:LinkButton>
        <asp:LinkButton ID="ResumeBtn" runat="server" Font-Size="Smaller" OnClick="ResumeBtn_Click">Resume</asp:LinkButton>
    </div>

    <script type="text/javascript">

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        function OnPollRes(m) {

            try {
                var e = document.getElementById("pollres");

                var b = 0;
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = "<%=StrDisc.Text%>";
                    e.style.color = "red";
                } else {
                    e.innerHTML = "<%=StrConn.Text%>";
                    e.style.color = "green";
                }
            } catch (eee) {

            }
            setTimeout("Poll()", 60000);
        }
        function Poll() {


            try {
                Ext.Ajax.request({
                    url: 'DeviceBackupDashboard.aspx?id=<%=DeviceId.Value %>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        setTimeout("Poll()", 1000);



        function CloseChildWnd() {
            try {
                e = document.getElementById("ShortWindow");
                e.src = "/portal/WaitWin.htm";

                $('#ShortWindowModal').modal('hide');

            } catch (e) {

            }


        }

        function closeActiveWin() {
            Wait("...");
            window.location = window.location;
        }

        function OpenChildWnd(t, s) {

            var e = document.getElementById("ShortTitle");
            e.innerHTML = t;
            e = document.getElementById("ShortBody");
            if (document.documentElement.clientHeight < 750)
                e.style.height = "400px"
            else
                e.style.height = "500px"

            e = document.getElementById("ShortWindow");
            e.src = s;
            $('#ShortWindowModal').modal({ backdrop: 'static', keyboard: false });

        }
        function closeCancelActiveWin() {
            CloseChildWnd();
        }


        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            var s = 0 + size;
            if (isNaN(s))
                return "0";
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        adjust();
    </script>
</asp:Content>
