﻿<%@ Page Title="Backup Tasks" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupTask.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupTask"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>

    <style type="text/css">
        td {
            font-size: 15px;
            font-weight: 100;
        }

        b {
            font-weight: 500;
        }




        .titlecol {
            background-color: #f0f0f0;
            font-size: 14px;
        }

        .style1 {
            width: 153px;
        }

        .newusericon {
            background-image: url(images/upgradeuser.png);
        }

        .active {
            background-color: #565656;
        }

        li {
            background-color: transparent;
        }

        #rowcontainer {
            background-color:white;
        }
    </style>
    <script type="text/javascript">



        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("id=") == -1)
                window.location.href = window.location.href + "?id=" + (new Date()).toString();
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
   <div 
        <%if (IsChildUi) { %>
        style="width:100%;border-bottom:1px solid #eeeeee"
        <%}else { %>
        class=" meubardrop"
        <%} %>
        >
    <table width="100%">
        <tr>
              
            <td>
                <asp:Localize ID="LocPse" runat="server" meta:resourcekey="str_pse" Visible="false">Pause</asp:Localize>
                <asp:Localize ID="LocRsm" runat="server" meta:resourcekey="str_rsm" Visible="false">Resume</asp:Localize>
                <asp:Localize ID="LocStrNow" runat="server" meta:resourcekey="str_strNow" Visible="false">Start Now</asp:Localize>
                <asp:LinkButton ID="PauseBtn" runat="server" OnClick="PauseBtn_Click" CssClass="btn sectextcolor"><i class="gladinet-icons hand" title="<%=LocRsm.Text %>">&#x0155;</i></asp:LinkButton>
                <asp:LinkButton ID="ResumeBtn" runat="server" OnClick="ResumeBtn_Click"  CssClass="btn sectextcolor"><i class="gladinet-icons hand" title="<%=LocPse.Text %>">&#x0174;</i></asp:LinkButton>
                <asp:LinkButton ID="StartNowBtn" runat="server" OnClick="StartNowBtn_Click"  CssClass="btn sectextcolor"><i class="gladinet-icons hand" title="<%=LocStrNow.Text %>">&#x0158;</i></asp:LinkButton>
            </td>
            <td>
                 <div id="errmsgdiv" class="navbar-text">
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
                </td>
            
            <td align="right" style="height:48px;width:48px">
            <div class="btn btn-primary gladbtn" style="margin-right: 8px; display: table;" title="<%=LinkButton2.Text %>">
                <i class="gladinet-icons md-32 hand" onclick="OnRefresh();return false;" style="display: table-cell;">µ</i>
                <div style="display: table-cell; vertical-align: top; padding-left: 5px; display: none;">
                    <asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" meta:resourcekey="str_rfh" OnClientClick="OnRefresh();return false;" ForeColor="#565656"></asp:LinkButton></div>
            </div>
            </td>
             <%if (IsServo){ %>
                <td style="padding-right:10px; width:80px;">
                    <button class="btn newBtn" onclick='window.location="servo/ServoBackupSummary.aspx"; return false;' style="font-size:32px;">
                        <i class="gladinet-icons md-32 hand"  style="display: table-cell;">&#xFB;</i>
                        </button>
                </td>
                <%} %>
        </tr>
    </table>
        </div>
    <div style="width: 100%; overflow: auto; margin-top:20px; align-content:center;" id="rowcontainer">
        <table width="100%" >
            <tr>
                <td align="center" style="padding-top:60px;">
        <div class="row " style="width: 100%;max-width:1000px; align-content: center; margin: 0; margin-top: 20px; padding-bottom: 10px;" align="center">
            
            
            <div class="gridobject col-12" style="padding-bottom: 10px;">
                <div >
                    <div style="width: 100%; height: 300px;">
                    <table width="100%" >
                         <tr id="loading" >
                            <td align="center" style="padding-top:80px; border:0px solid red;" colspan="2">
                                <asp:Localize runat="server" meta:resourcekey="str_lng">loading...</asp:Localize>
                            </td>
                        </tr>
                        <tr id="pendingtr" style="display:none;">
                            <td align="center" style="padding-top:80px; border:0px solid red;" colspan="2">
                                <table >
                                    <tr>
                                        <td align="center">
                                            <span class=" fa fa-clock-o gladdropdownlink" style="font-size:64px!important; background-color:white!important;  " id="StatusIcon"></span>
                                        </td>
                                    </tr>
                                                                        <tr>
                                        <td  align="center"  style="padding-top:20px;font-size:14px!important;" >
                                            <asp:Localize runat="server" meta:resourcekey="str_nxtRnT">Next Runtime</asp:Localize>
                                        </td>
                                    </tr>

                                    <tr>
                                        <td id="ProcessStatus" align="center" class="gladdropdownlink" style="font-size:16px!important;" >
                                            
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                            <tr id="progresstr" style="display:none;">
                            <td colspan="2" style="padding: 5px; padding-left: 15px; padding-top: 20px; font-size: 18px; font-weight: 400; color: #404040; ">
                                <table width="100%">
                                    <tr>
                                        <td class="gladdropdownlink" style="padding:5px;font-size: 16px!important; font-weight: 400; " id="targetname">
                                            <asp:Localize runat="server" meta:resourcekey="str_bckUp">Backup</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="padding:5px;">
                                            <div class="progress" style="width:100%;">
                                                                <div class="progress-bar  bg-success" role="progressbar" aria-valuenow="40" id="iTaskProgress"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:0%">

                                                                  </div>
                                                                </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_ttlTsk">Total Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;" class="sectextcolor" id="iTotalTask">
                                            <asp:Label ID="TotalTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_pndTsk">Pending Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;" class="sectextcolor" id="iPendingTask">
                                            <asp:Label ID="PendingTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_fldTsk">Failed Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;" class="sectextcolor" id="iFailedTask">
                                            <asp:Label ID="FailedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_spdTsk">Skipped Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 0px solid #f0f0f0;" class="sectextcolor" id="iSkippedTask">
                                            <asp:Label ID="SkippedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                   
                                    
                                </table>
                            </td>
                            
                        </tr>
                         <tr>
                <td colspan="2" style="height:20px; color:red;" id="PollRes" align="center"></td>
            </tr>
                        </table>
                        </div>

                <div  style="width: 100%; height: 300px; overflow:auto;">
                    <div  style=" padding:10px; border-radius:3px;display:none;" id="rundiv">

                    
                                                                <table width="100%">
                                                <tbody id="Running" >

                                                </tbody>
                                            </table>
                        </div>

                    </div>
                    
                </div>
            </div>
            
        </div>
                </td>
            </tr>
        </table>

        <div style="display: none;">
            <span id="sectextcolor" class="sectextcolor"></span>
            <span id="lighttextcolor" class="lighttextcolor"></span>
        </div>
    </div>
    <asp:Localize ID="LocFilUpd" runat="server" meta:resourcekey="str_filUpd" Visible="false">Files Uploaded</asp:Localize>
    <asp:Localize ID="LocTme" runat="server" meta:resourcekey="str_tme" Visible="false">Time</asp:Localize>
    <asp:Localize ID="LocFil" runat="server" meta:resourcekey="str_fil" Visible="false">Files</asp:Localize>
    <script type="text/javascript">

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }

        function FormatFileSize(size) {
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        function AddRunningTask(res) {
            try {
                var e = document.getElementById("Running");
                e.innerHTML = "";

                var count = Math.floor((res.length - 9) / 4);
                for (var i = 0; i < count; ++i) {
                    var etr = document.createElement("tr");
                    etr.style.fontSize = "12px";
                    etr.style.borderBottom = "1px solid #f0f0f0";
                    var ttd = document.createElement("td");
                    ttd.innerHTML = res[9 + i * 4];
                    etr.appendChild(ttd);
                    ttd.style.width = "100px";
                    ttd.className = "sectextcolor";

                    var ntd = document.createElement("td");
                    ntd.innerHTML = GetShortString(res[9 + i * 4 + 1], 60);
                    etr.appendChild(ntd);


                    var ptd = document.createElement("td");
                    ptd.align = "right";
                    ptd.fontSize = "10px";
                    ptd.className = "sectextcolor";
                    if (res[8 + i * 4 + 2] != 0) {
                        ptd.innerHTML = FormatFileSize(res[9 + i * 4 + 3]) + "/" + FormatFileSize(res[9 + i * 4 + 2]);
                    }
                    etr.appendChild(ptd);

                    e.appendChild(etr);
                }
            } catch (eee) {
                var e = document.getElementById("Running");
                e.innerHTML = eee.message;
            }
        }

        function OnPollRes(m) {
            try {


                document.getElementById("loading").style.display = "none";
                var e = document.getElementById("PollRes");
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = m.substring(4);
                    setTimeout("Poll()", 3000);
                    document.getElementById("rundiv").style.display = "none";
                    return;
                }
               
                e.innerHTML = "&nbsp;";
                

                
                var res = m.split("|");
                if (res.length == 1 ) {
                    e = document.getElementById("pendingtr");
                    e.style.display = "";

                    e = document.getElementById("ProcessStatus");
                    e.innerHTML =  m;

                    e = document.getElementById("progresstr");
                    e.style.display = "none";

                    var e = document.getElementById("Running");
                    e.innerHTML = "";
                    document.getElementById("rundiv").style.display = "none";
                    setTimeout("Poll()", 3000);
                    return;

                }

                if( res[2] == -1){
                    e = document.getElementById("pendingtr");
                    e.style.display = "";

                    e = document.getElementById("ProcessStatus");
                    e.innerHTML =  "";

                    e = document.getElementById("progresstr");
                    e.style.display = "none";

                    var e = document.getElementById("Running");
                    e.innerHTML = "";
                    document.getElementById("rundiv").style.display = "none";
                    setTimeout("Poll()", 3000);
                    return;
                }

                e = document.getElementById("pendingtr");
                e.style.display = "none";
                e = document.getElementById("progresstr");
                e.style.display = "";

                e = document.getElementById("targetname");
                e.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_bckUp">Backup</asp:Localize>: " + res[1];

                

                e = document.getElementById("iTotalTask");
                e.innerHTML = res[2];
                

                e = document.getElementById("iPendingTask");
                e.innerHTML = res[3];

                e = document.getElementById("iFailedTask");
                e.innerHTML = res[4];
                e = document.getElementById("iSkippedTask");
                e.innerHTML = res[5];
                
                e = document.getElementById("iTaskProgress");
                e.style.width = res[6] + "%";

                if (res.length >= 9) {
                    document.getElementById("rundiv").style.display = "";
                    AddRunningTask(res);
                } else {
                    var e = document.getElementById("Running");
                    e.innerHTML = "";
                    document.getElementById("rundiv").style.display = "none";
                }
                
            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }
        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/BackupMgr/UI/ClusterBackupTask.aspx?vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        document.getElementById("rundiv").style.display = "none";
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }
        
        function adjust() {
            setTimeout("Poll()", 2000);
        }
        document.addEventListener("DOMContentLoaded", function () {
            adjust();
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });
    </script>
</asp:Content>
