﻿<%@ Page Title="Backup Settings" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupSettings.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupSettings"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">  
    </style>
    <script type="text/javascript">





        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("id=") == -1)
                window.location.href = window.location.href + "?id=" + (new Date()).toString();
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }
        function SetPage(n) {

            var e = document.getElementById("page_1");
            e.className = "nav-link";
            e = document.getElementById("page_1_div");
            e.style.display = "none";

            e = document.getElementById("page_2");
            e.className = "nav-link";
            e = document.getElementById("page_2_div");
            e.style.display = "none";

            e = document.getElementById("page_3");
            e.className = "nav-link";
            e = document.getElementById("page_3_div");
            e.style.display = "none";

            e = document.getElementById("page_4");
            e.className = "nav-link";
            e = document.getElementById("page_4_div");
            e.style.display = "none";

            e = document.getElementById("page_5");
            e.className = "nav-link";
            e = document.getElementById("page_5_div");
            e.style.display = "none";


            e = document.getElementById("page_" + n);
            e.className = "nav-link active";

            e = document.getElementById("page_" + n + "_div");
            e.style.display = "";
        }
    </script>

    <script type="text/javascript">

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocEvrDay" meta:resourcekey="str_evrDay" Visible="false">Every Day</asp:Localize>
    <asp:Localize runat="server" ID="LocEvrWek" meta:resourcekey="str_evrWek" Visible="false">Every Week</asp:Localize>
    <asp:Localize runat="server" ID="LocEvrMth" meta:resourcekey="str_evrMth" Visible="false">Every Month</asp:Localize>
    <asp:Localize runat="server" ID="LocCty" meta:resourcekey="str_cty" Visible="false">Continuously</asp:Localize>
    <asp:Localize runat="server" ID="LocStd" meta:resourcekey="str_std" Visible="false">Saturday</asp:Localize>
    <asp:Localize runat="server" ID="LocSnd" meta:resourcekey="str_snd" Visible="false">Sunday</asp:Localize>
    <asp:Localize runat="server" ID="LocMnd" meta:resourcekey="str_mnd" Visible="false">Monday</asp:Localize>
    <asp:Localize runat="server" ID="LocTsd" meta:resourcekey="str_tsd" Visible="false">Tuesday</asp:Localize>
    <asp:Localize runat="server" ID="LocWnd" meta:resourcekey="str_wnd" Visible="false">Wednesday</asp:Localize>
    <asp:Localize runat="server" ID="LocTrd" meta:resourcekey="str_trd" Visible="false">Thursday</asp:Localize>
    <asp:Localize runat="server" ID="LocFrd" meta:resourcekey="str_frd" Visible="false">Friday</asp:Localize>
    <asp:Localize runat="server" ID="LocMts" meta:resourcekey="str_mts" Visible="false">Minutes</asp:Localize>
    <asp:Localize runat="server" ID="LocHrs" meta:resourcekey="str_hrs" Visible="false">Hours</asp:Localize>





    <div class="c-subheader" style="margin-left:10px;">

        <div class="row" style="border-bottom:1px solid #f0f0f0;">
            <div class="col-12 col-md-9">
                <ul class="nav nav-tabs" id="myTab" style="margin-top: 15px;">
                    <li class="bkpLi nav-item">
                        <a class="nav-link active" href="#" id="page_1" onclick="SetPage(1);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_bkpScd">Backup Schedule</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_4" onclick="SetPage(4);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_flt">Filters</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_2" onclick="SetPage(2);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_bdwCtl">Bandwidth Control</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_5" onclick="SetPage(5);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_retPlc">Retention Policy</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_3" onclick="SetPage(3);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_otrStg">Other Settings</asp:Localize></a>
                    </li>
                </ul>


            </div>
            <div class="col-12 col-md-3 bkpRgtSdeNavExp" style="padding-top:25px;padding-right:25px;">
                <div style="margin-right:15px;">
                <asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" meta:resourcekey="str_rfh" Visible="false"></asp:LinkButton>
                <a class="" href="javascript:;" onclick="OnRefresh();" title="<%=LinkButton2.Text %>"><i class="gladinet-icons hand" style="font-size: 28px;">µ</i></a>
                </div>
            </div>
        </div>

    </div>




<div class="c-body" style="clear:both;">
    <main class="c-main" style="clear: both;">
<div class="container-fluid">
    <div class="fade-in">


        <div id="pageContainerCard" class="card" style="margin-bottom:30px; box-shadow:none!important; overflow:auto; height:300px;" >

            <%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
            <div id="container errmsgdiv">
                <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
            </div>
            <%} %>


            <div class="card-body">
                <div class="justify-content-between">

                    <div id="page_1_div" class="container">
                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl">
                                <asp:Localize runat="server" meta:resourcekey="str_tpe">Type</asp:Localize></label>
                            </div>
                            <div class="col-9">
                                <asp:DropDownList ID="ScheduleType" runat="server" OnSelectedIndexChanged="ScheduleType_SelectedIndexChanged" AutoPostBack="true" CssClass="form-control newDrpDwn"></asp:DropDownList>
                            </div>
                        </div>

                        <% if (WeeklyPanel.Visible) { %>
                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_on">On</asp:Localize></label>
                                
                            </div>
                            <div class="col-9">
                                <asp:DropDownList ID="WeekDayList" runat="server" CssClass="form-control newDrpDwn" onchange="ShowSavePanel();"></asp:DropDownList>
                            </div>
                        </div>
                        <% } %>

                        <% if (MonthlyPanel.Visible) { %>
                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_on">On</asp:Localize></label>
                                
                            </div>
                            <div class="col-9">
                                <asp:DropDownList ID="MonthDayList" runat="server" CssClass="form-control newDrpDwn" onchange="ShowSavePanel();">
                                    <asp:ListItem Value="0" meta:resourcekey="str_1stDay">1st day</asp:ListItem>
                                    <asp:ListItem Value="1" meta:resourcekey="str_2ndDay">2nd day</asp:ListItem>
                                    <asp:ListItem Value="2" meta:resourcekey="str_3rdDay">3rd day</asp:ListItem>
                                    <asp:ListItem Value="3" meta:resourcekey="str_4thDay">4th day</asp:ListItem>
                                    <asp:ListItem Value="4" meta:resourcekey="str_5thDay">5th day</asp:ListItem>
                                    <asp:ListItem Value="5" meta:resourcekey="str_6thDay">6th day</asp:ListItem>
                                    <asp:ListItem Value="6" meta:resourcekey="str_7thDay">7th day</asp:ListItem>
                                    <asp:ListItem Value="7" meta:resourcekey="str_8thDay">8th day</asp:ListItem>
                                    <asp:ListItem Value="8" meta:resourcekey="str_9thDay">9th day</asp:ListItem>
                                    <asp:ListItem Value="9" meta:resourcekey="str_10thDay">10th day</asp:ListItem>
                                    <asp:ListItem Value="10" meta:resourcekey="str_11thDay">11th day</asp:ListItem>
                                    <asp:ListItem Value="11" meta:resourcekey="str_12thDay">12th day</asp:ListItem>
                                    <asp:ListItem Value="12" meta:resourcekey="str_13thDay">13th day</asp:ListItem>
                                    <asp:ListItem Value="13" meta:resourcekey="str_14thDay">14th day</asp:ListItem>
                                    <asp:ListItem Value="14" meta:resourcekey="str_15thDay">15th day</asp:ListItem>
                                    <asp:ListItem Value="15" meta:resourcekey="str_16thDay">16th day</asp:ListItem>
                                    <asp:ListItem Value="16" meta:resourcekey="str_17thDay">17th day</asp:ListItem>
                                    <asp:ListItem Value="17" meta:resourcekey="str_18thDay">18th day</asp:ListItem>
                                    <asp:ListItem Value="18" meta:resourcekey="str_19thDay">19th day</asp:ListItem>
                                    <asp:ListItem Value="19" meta:resourcekey="str_20thDay">20th day</asp:ListItem>
                                    <asp:ListItem Value="20" meta:resourcekey="str_21thDay">21th day</asp:ListItem>
                                    <asp:ListItem Value="21" meta:resourcekey="str_22thDay">22th day</asp:ListItem>
                                    <asp:ListItem Value="22" meta:resourcekey="str_23thDay">23th day</asp:ListItem>
                                    <asp:ListItem Value="23" meta:resourcekey="str_24thDay">24th day</asp:ListItem>
                                    <asp:ListItem Value="24" meta:resourcekey="str_25thDay">25th day</asp:ListItem>
                                    <asp:ListItem Value="25" meta:resourcekey="str_26thDay">26th day</asp:ListItem>
                                    <asp:ListItem Value="26" meta:resourcekey="str_27thDay">27th day</asp:ListItem>
                                    <asp:ListItem Value="27" meta:resourcekey="str_28thDay">28th day</asp:ListItem>
                                    <asp:ListItem Value="28" meta:resourcekey="str_29thDay">29th day</asp:ListItem>
                                    <asp:ListItem Value="29" meta:resourcekey="str_30thDay">30th day</asp:ListItem>
                                </asp:DropDownList>
                            </div>
                        </div>
                        <% } %>

                        <%if (!ConinuePanel.Visible) { %>
                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_strTme">Start Time</asp:Localize></label>
                                
                            </div>
                            <div class="col-9">
                                <asp:DropDownList ID="StartTimeList" runat="server" CssClass="form-control newDrpDwn" onchange="ShowSavePanel();">
                                    <asp:ListItem Value="0">00 AM</asp:ListItem>
                                    <asp:ListItem Value="1">01 AM</asp:ListItem>
                                    <asp:ListItem Value="2">02 AM</asp:ListItem>
                                    <asp:ListItem Value="3">03 AM</asp:ListItem>
                                    <asp:ListItem Value="4">04 AM</asp:ListItem>
                                    <asp:ListItem Value="5">05 AM</asp:ListItem>
                                    <asp:ListItem Value="6">06 AM</asp:ListItem>
                                    <asp:ListItem Value="7">07 AM</asp:ListItem>
                                    <asp:ListItem Value="8">08 AM</asp:ListItem>
                                    <asp:ListItem Value="9">09 AM</asp:ListItem>
                                    <asp:ListItem Value="10">10 AM</asp:ListItem>
                                    <asp:ListItem Value="11">11 AM</asp:ListItem>
                                    <asp:ListItem Value="12">12 PM</asp:ListItem>
                                    <asp:ListItem Value="13">01 PM</asp:ListItem>
                                    <asp:ListItem Value="14">02 PM</asp:ListItem>
                                    <asp:ListItem Value="15">03 PM</asp:ListItem>
                                    <asp:ListItem Value="16">04 PM</asp:ListItem>
                                    <asp:ListItem Value="17">05 PM</asp:ListItem>
                                    <asp:ListItem Value="18">06 PM</asp:ListItem>
                                    <asp:ListItem Value="19">07 PM</asp:ListItem>
                                    <asp:ListItem Value="20">08 PM</asp:ListItem>
                                    <asp:ListItem Value="21">09 PM</asp:ListItem>
                                    <asp:ListItem Value="22">10 PM</asp:ListItem>
                                    <asp:ListItem Value="23">11 PM</asp:ListItem>
                                </asp:DropDownList>
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-3">
                                
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_endTme">End Time</asp:Localize></label>
                                
                            </div>
                            <div class="col-9">
                                <asp:DropDownList ID="EndTimeList" runat="server" CssClass="form-control newDrpDwn" onchange="ShowSavePanel();">
                                    <asp:ListItem Value="0">00 AM</asp:ListItem>
                                    <asp:ListItem Value="1">01 AM</asp:ListItem>
                                    <asp:ListItem Value="2">02 AM</asp:ListItem>
                                    <asp:ListItem Value="3">03 AM</asp:ListItem>
                                    <asp:ListItem Value="4">04 AM</asp:ListItem>
                                    <asp:ListItem Value="5">05 AM</asp:ListItem>
                                    <asp:ListItem Value="6">06 AM</asp:ListItem>
                                    <asp:ListItem Value="7">07 AM</asp:ListItem>
                                    <asp:ListItem Value="8">08 AM</asp:ListItem>
                                    <asp:ListItem Value="9">09 AM</asp:ListItem>
                                    <asp:ListItem Value="10">10 AM</asp:ListItem>
                                    <asp:ListItem Value="11">11 AM</asp:ListItem>
                                    <asp:ListItem Value="12">12 PM</asp:ListItem>
                                    <asp:ListItem Value="13">01 PM</asp:ListItem>
                                    <asp:ListItem Value="14">02 PM</asp:ListItem>
                                    <asp:ListItem Value="15">03 PM</asp:ListItem>
                                    <asp:ListItem Value="16">04 PM</asp:ListItem>
                                    <asp:ListItem Value="17">05 PM</asp:ListItem>
                                    <asp:ListItem Value="18">06 PM</asp:ListItem>
                                    <asp:ListItem Value="19">07 PM</asp:ListItem>
                                    <asp:ListItem Value="20">08 PM</asp:ListItem>
                                    <asp:ListItem Value="21">09 PM</asp:ListItem>
                                    <asp:ListItem Value="22">10 PM</asp:ListItem>
                                    <asp:ListItem Value="23">11 PM</asp:ListItem>
                                </asp:DropDownList>
                            </div>

                        </div>
                        <%} else { %>

                        <div class="row">
                            <div class="col-6">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_ivl">Interval</asp:Localize></label>
                                
                            </div>
                            <div class="col-4">
                                <asp:TextBox ID="BackupInterval" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();">10</asp:TextBox>
                            </div>
                            <div class="col-4">
                                <asp:DropDownList ID="TimeTypeList" runat="server" CssClass="form-control newDrpDwn" Width="80px" onchange="ShowSavePanel();"></asp:DropDownList>
                            </div>
                        </div>
                        <%} %>
                    </div>


                    <div id="page_2_div" class="container" style="display:none;">
                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_dtmLmt">Day-time Limit</asp:Localize></label>
                            </div>
                            <div class="col-3">
                                <asp:TextBox ID="DayTimeLimit" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();">0</asp:TextBox>
                            </div>
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_Kby">KB/Second</asp:Localize></label>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_ntmLmt">Night-time  Limit</asp:Localize></label>
                            </div>
                            <div class="col-3">
                                <asp:TextBox ID="NightTimeLimit" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();">0</asp:TextBox>
                            </div>
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_Kby">KB/Second</asp:Localize></label>
                            </div>
                        </div>

                    </div>

                    
                    <div id="page_3_div" class="container" style="display:none;">
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="NoDevCloudBackup" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=NoDevCloudBackup.ClientID %>">
                                    <asp:Localize runat="server" meta:resourcekey="str_dntBkpDvcDtaRte">Do not backup device data to remote cloud backup server</asp:Localize>
                                </label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="RecordEmptyTaskRun" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=RecordEmptyTaskRun.ClientID %>">
                                    <asp:Localize runat="server" meta:resourcekey="str_recEmtTsk">Record empty backup task run</asp:Localize>
                                </label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="SendBackupEmail" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=SendBackupEmail.ClientID %>">
                                    <asp:Localize runat="server" meta:resourcekey="str_sndStsEml">Send backup status email notification</asp:Localize>
                                </label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-3">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_eml">Emails</asp:Localize></label>
                            </div>
                            <div class="col-9">
                                <asp:TextBox ID="BackupNotifyEmails" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" Width="300"></asp:TextBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="AllowDeviceBackup" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=AllowDeviceBackup.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_allowBackupDevices">Enable back up for devices</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="AllowBackupNewTeamFolders" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=AllowBackupNewTeamFolders.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_allowBackupNewTeamFolders">Enable back up for new team folders</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox CssClass="labelex" ID="BackupAllDevices" runat="server" Text="" />
                                <label class="bkpFrmLbl" for="<%=BackupAllDevices.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_bkpAllDvcWthPfl">Back up all devices with below profile</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:DropDownList ID="DeviceProfileList" Width="300px" CssClass="form-control newDrpDwn" runat="server"></asp:DropDownList>
                            </div>
                        </div>
                    </div>
                    
                    
                    <div id="page_5_div" class="container" style="display:none;">
                        <div class="row">
                            <div class="col-6">
                                <label class="bkpFrmLbl"><asp:Localize runat="server" meta:resourcekey="str_kepNSht">Keep last N snapshots (0 - unlimited)</asp:Localize></label>
                                
                            </div>
                            <div class="col-3">
                                <asp:TextBox ID="BackupSnapshotCount" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" Width="300" Text="0"></asp:TextBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <label class="bkpFrmLbl" style="line-height:20px;"><asp:Localize runat="server" meta:resourcekey="str_kepShtNDys">Keep snapshot for at least N days (0 - controlled by other policies, otherwise override above policy)</asp:Localize></label>
                                
                            </div>
                            <div class="col-3">
                                <asp:TextBox ID="BackupSnapshotDays" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" Width="300" Text="0"></asp:TextBox>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-6">
                                <label class="bkpFrmLbl" style="line-height:20px;"><asp:Localize runat="server" meta:resourcekey="str_genBkpNDys">Generate full backup snapshot every N days (0 - never)</asp:Localize></label>
                                
                            </div>
                            <div class="col-3">
                                <asp:TextBox ID="FullBackupDays" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" Width="300" Text="0"></asp:TextBox>
                            </div>
                        </div>

                    </div>
                    
                    <div id="page_4_div" class="container" style="display:none;">
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="AllowBackupExes" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=AllowBackupExes.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_alwExe">Allow executable files (.exe)</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                 <asp:CheckBox ID="AllowBackupIso" runat="server" onchange="ShowSavePanel();" />
                                 <label class="bkpFrmLbl" for="<%=AllowBackupIso.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_alwIso">Allow ISO files (.iso)</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                 <asp:CheckBox ID="AllowBackupBackup" runat="server" onchange="ShowSavePanel();" />
                                 <label class="bkpFrmLbl" for="<%=AllowBackupBackup.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_alwBkpFil">Allow backup files(.bck, .bkf,.rbf, .tib)</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                 <asp:CheckBox ID="AllowBackupVM" runat="server" onchange="ShowSavePanel();" />
                                 <label class="bkpFrmLbl" for="<%=AllowBackupVM.ClientID %>" style="line-height:20px;"><asp:Localize runat="server" meta:resourcekey="str_alwVms">Allow VMs (.hdd, .hds, .pvm, .pvs, .vdi, .vfd, .vhd, .vmc, .vmdk, .vmem, .vmsd, .vmsn, .vmss, .vmtm, .vmwarevm, .vmx, .vmxf, .vsv, .nvram, .vud, .xva)</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="AllowBackupAppFolder" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=AllowBackupAppFolder.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_alwAppFld">Allow application folders</asp:Localize></label>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <asp:CheckBox ID="AllowBackupAppData" runat="server" onchange="ShowSavePanel();" />
                                <label class="bkpFrmLbl" for="<%=AllowBackupAppData.ClientID %>"><asp:Localize runat="server" meta:resourcekey="str_alwAppDtaFld">Allow application data folders</asp:Localize></label>
                            </div>
                        </div>

                    </div>



        <div style="display: none;">

            <asp:Button ID="ApplyBtn" runat="server" Text="Button" OnClick="ApplyBtn_Click" />

            <asp:Panel ID="DailyPanel" runat="server"></asp:Panel>
            <asp:Panel ID="WeeklyPanel" runat="server"></asp:Panel>
            <asp:Panel ID="MonthlyPanel" runat="server"></asp:Panel>
            <asp:Panel ID="ConinuePanel" runat="server"></asp:Panel>
        </div>

                </div>




            </div>



        </div>
    </div>
</div>
</main>
</div>



    <script type="text/javascript">


        function onEditProfile(id) {
            var e = document.getElementById("ctl00_MainContent_EditProfile");
            var t = document.getElementById("ctl00_MainContent_PorfileId");
            t.value = id;
            Wait("...");
            e.click();

        }


        $(document).ready(function () {
        <%if (m_NeedSave)
        {%>
            ShowSavePanel();
        <%}%>
        });

        function adjust() {
            var e = document.getElementById("pageContainerCard");

            e.style.height = (document.documentElement.offsetHeight - 90) + "px";

            
        }
        document.addEventListener("DOMContentLoaded", function () {
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });

    </script>
</asp:Content>
