﻿<%@ Page Title="Restore Team Folder" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupRestoreTeamFolder.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupRestoreTeamFolder"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script type="text/javascript">
        function OnLocalRestore(f) {
            
            window.location = "/portal/RestoreFolder.aspx?f="+f+"&vdid=<%=CurrentTeantId.Value%>&edittenant=1";
        }

        function OnCloudRestore(sid) {
            
            var b = document.getElementById("ctl00_MainContent_GetSnapShotBtn");
            var s = document.getElementById("ctl00_MainContent_TeamFolderId");
            
            s.value = sid;
            
            b.click();
            
        }
        function BrowseSnapshot(n, sid)
        {
            
            parent.OpenChildWnd(n, "/management/BackupMgr/UI/BackupSnapshotBrowser.aspx?tid=<%=TeamFolderId.Value%>&sid=" + sid)
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFldEblBkp" meta:resourcekey="str_fldEblBkp" Visible="false">Failed to enable backup</asp:Localize>
<asp:Localize runat="server" ID="LocFldLodSht" meta:resourcekey="str_fldLodSht" Visible="false">Failed to load snapshots</asp:Localize>
<asp:Localize runat="server" ID="LocDysAgo" meta:resourcekey="str_dysAgo" Visible="false">days ago</asp:Localize>
<asp:Localize runat="server" ID="LocScsAgo" meta:resourcekey="str_scsAgo" Visible="false">less than 1 minute ago</asp:Localize>
<asp:Localize runat="server" ID="LocHrsAgo" meta:resourcekey="str_hrsAgo" Visible="false">hours ago</asp:Localize>
<asp:Localize runat="server" ID="LocMnsAgo" meta:resourcekey="str_mnsAgo" Visible="false">minutes ago</asp:Localize>
<asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
<asp:Localize runat="server" ID="LocCrt" meta:resourcekey="str_crt" Visible="false">Current</asp:Localize>




<div class="c-body">

<main class="c-main">
<div class="container-fluid">
<div class="fade-in">

<div id="pageContainerCard" 
>

<div >
<div class="justify-content-between">


    <table width="100%">
        <tr>
            <td>
                <asp:Label ID="ErrorMsg" runat="server" Font-Size="20px" ForeColor="red"></asp:Label>
            </td>
        </tr>
        <tr>
            <td align="center">
            <%if(!SnapShotPanel.Visible) { %>
            <%if (TenantPanel.Visible){ %>
                <table style="width:100%; margin-top:100px; max-width:1000px;">
                    <tr>
                        <td style="padding:10px;font-size:16px; color:#565656; font-weight:100;">
                            <asp:Localize runat="server" meta:resourcekey="str_fstSltTnt">First select a tenant (who owns a backed-up team folder)</asp:Localize>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <asp:DropDownList ID="TenantList" runat="server" CssClass="form-control newDrpDwn"></asp:DropDownList>
                        </td>
                    </tr>
                </table>
            <%}else { %>
                <div style="max-height:500px; overflow:auto;margin-top:100px; max-width:1000px;">
                <table style="width:100%;" >
            <tr>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;" width="32px"></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px; font-size:14px;"><asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;font-size:14px; " colspan="2" align="center"></td>
            </tr>
            <asp:Repeater ID="TeamFolderRepeater" runat="server" >
                <ItemTemplate> 
                    <tr class=" filerow" onclick='OnCloudRestore("<%# DataBinder.Eval(Container.DataItem, "ShareUid") %>"); return false;' style=" <%# DataBinder.Eval(Container.DataItem, "CloudRestoreDisplay")%>">
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;" width="32px">
                   
                </td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px; font-size:18px; font-weight:100; color:#565656;">
                    <%# DataBinder.Eval(Container.DataItem, "ShareName")%>
                </td>
                        <td style="border-bottom:1px solid #f0f0f0; padding:3px; width:80px; display:none;" nowrap>
                    <button class="btn newBtn"  onclick='OnLocalRestore("<%# DataBinder.Eval(Container.DataItem, "DirLocation") %>"); return false;' style=" <%# DataBinder.Eval(Container.DataItem, "LocalRestoreDisplay")%>"><asp:Localize runat="server" meta:resourcekey="str_lcl">Local</asp:Localize></button>
                    
                </td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;width:80px" nowrap>
                    
                    <button class="btn newBtn" onclick='OnCloudRestore("<%# DataBinder.Eval(Container.DataItem, "ShareUid") %>"); return false;' style=" <%# DataBinder.Eval(Container.DataItem, "CloudRestoreDisplay")%>"><i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="Restore">&#x13B;</i></button>
                </td>
                        </tr>
                </ItemTemplate> 
            </asp:Repeater>
        </table>
                    </div>
            <%} %>
            <%}else { %>
                <table style="width:100%;">
                      <tr style=" border-bottom: 0px solid red; font-weight: 100;">
                    
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0; color: #565656; font-size: 14px;
                        border-top: 0px solid #d0d0d0;">
                        <asp:Localize runat="server" meta:resourcekey="str_shtNme">Snapshot Name</asp:Localize>
                    </td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;">
                        <asp:Localize runat="server" meta:resourcekey="str_stgUsg">Storage Usage</asp:Localize>
                    </td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;">
                        <asp:Localize runat="server" meta:resourcekey="str_crtTme">Creation Time</asp:Localize>
                    </td>
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;">
                        <asp:Localize runat="server" meta:resourcekey="str_crtBy">Created by</asp:Localize>
                    </td>
                   
                    
                </tr>
                
               
                <asp:Repeater ID="VersionRepeat" runat="server">
                    <ItemTemplate>
                        <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px; font-weight: 100; background-color:white" class="filerow" onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                          
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "StorageDisplayName")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "CreateTimeDisplay")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "UpdateDisplayName")%>
                            </td>
                           
                          <td style="border-bottom:1px solid #f0f0f0; padding:3px;width:80px" nowrap>
                    
                    <button class="btn newBtn" onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'><i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="<asp:Localize runat="server" meta:resourcekey="str_rst">Restore</asp:Localize>">&#x13B;</i></button>
                </td>
                            
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
                </table>
            <%} %>  
            <table style="width:100%; ">
                    <tr>
                        <td style="padding-top:20px;" align="center">
                             <%if (TenantPanel.Visible){ %>
                            <asp:LinkButton ID="ShowTeamfolders" runat="server" CssClass="btn newBtn" OnClick="ShowTeamfolders_Click" meta:resourcekey="str_ctn">Continue</asp:LinkButton>
                            <%}else { %>
                            <button class="btn newSecBtn" onclick="OnBack();return false;"><asp:Localize runat="server" meta:resourcekey="str_bck">Back</asp:Localize></button>                            
                            <%} %>
                            <button class="btn newSecBtn" onclick="OnCancel();return false;"><asp:Localize runat="server" meta:resourcekey="str_cnl">Cancel</asp:Localize></button>
                        </td>
                    </tr>
                </table>
                    
            </td>
        </tr>
    </table>
    
    <div style="display:none">
        <asp:HiddenField ID="CurrentTeantId" runat="server" />
        <asp:HiddenField ID="TeamFolderId" runat="server" />
        <asp:Panel ID="TenantPanel" runat="server"></asp:Panel>
        <asp:Panel ID="SnapShotPanel" Visible="false" runat="server"></asp:Panel>
        <asp:LinkButton ID="GetSnapShotBtn" runat="server" OnClick="GetSnapShotBtn_Click">GetSnapShot</asp:LinkButton>
        <asp:LinkButton ID="ShowBtn" runat="server" OnClick="BacktoTeamFolder_Click">GetTeamFolders</asp:LinkButton>
    </div>
    





</div>
</div>    

</div>
</div>
</div>
</main>
<footer class="c-footer">
</footer>
	
	
</div>









    <script type="text/javascript">

        function OnCancel()
        {
            <% if (IsChildUi) {
            //If the page is loaded in the main frame body
            %>
            parent.OnDashboard();
            <% } else { 
            //If the page is loaded within a modal popup         
            %>
            parent.CloseChildWnd();
            <% } %>
            
        }
    
        function OnBack() {
            <%if(!SnapShotPanel.Visible) { %>
            window.location = "ClusterBackupRestoreTeamFolder.aspx";
            <%}else { %>
            var e = document.getElementById("ctl00_MainContent_ShowBtn");
            Wait('...');
            e.click();
            <%} %>
        }

        function adjust() {
            //for backwards compatibility with WebAppPanel.master
        }
        document.addEventListener("DOMContentLoaded", function () {
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });
    </script>
</asp:Content>
