﻿<%@ Page Title="Restore Device" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupRestoreDevice.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupRestoreDevice"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>

    
    <script type="text/javascript">
            function OnLocalRestore(f, did) {
            
            window.location = "/portal/RestoreFolder.aspx?f="+f+"&vdid="+did+"&edittenant=1";
        }

        function OnCloudRestore(sid) {
            
            var b = document.getElementById("ctl00_MainContent_GetSnapShotBtn");
            var s = document.getElementById("ctl00_MainContent_InstanceId");
            
            s.value = sid;
            
            b.click();
            
        }
        function BrowseSnapshot(n, sid)
        {
            parent.OpenChildWnd(n, "/management/BackupMgr/UI/MgrDeviceSnapshotBrowser.aspx?did=<%=InstanceId.Value%>&tid=<%=TeamFolderId.Value%>&sid=" + sid)
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false">not found</asp:Localize>
<asp:Localize runat="server" ID="LocCrt" meta:resourcekey="str_crt" Visible="false">Current</asp:Localize>
<asp:Localize runat="server" ID="LocDysAgo" meta:resourcekey="str_dysAgo" Visible="false">days ago</asp:Localize>
<asp:Localize runat="server" ID="LocScsAgo" meta:resourcekey="str_scsAgo" Visible="false">less than 1 minute ago</asp:Localize>
<asp:Localize runat="server" ID="LocHrsAgo" meta:resourcekey="str_hrsAgo" Visible="false">hours ago</asp:Localize>
<asp:Localize runat="server" ID="LocMnsAgo" meta:resourcekey="str_mnsAgo" Visible="false">minutes ago</asp:Localize>




<div class="c-body" style="margin-top:20px;">

<main class="c-main">
<div class="container-fluid">
<div class="fade-in">


<div id="pageContainerCard" 
<% if (IsChildUi) {
//If the page is loaded in the main frame body, add a shaded border to the page. If loaded within a modal popup, skip the border
%>
 class="card"
<% } %>
>

<div class="card-body">
<div class="justify-content-between">



    <table width="100%">
        <tr>
            <td align="center">
                <asp:Label ID="ErrorMsg" runat="server" Font-Size="20px" ForeColor="red"></asp:Label>
            </td>
        </tr>
        <tr>
            <td align="center" style="">
                <%if (!SnapShotPanel.Visible){ %>
                    <%if (TenantPanel.Visible){ %>
                        <table style="width:100%; max-width:1200px;">
                            <tr>
                                <td style="padding:10px;font-size:20px; color:#565656; font-weight:100; padding-bottom:20px;">
                                    <asp:Localize runat="server" meta:resourcekey="str_srcDvcRst">Search for a device you want to restore</asp:Localize>
                                </td>
                            </tr>
                            <tr>
                                <td align="center">
                                    <table width="100%">
                                        <tr>
                                            <td style="padding: 10px; font-size:18px; color:#404040; font-weight:100;" width="80px" nowrap="nowrap">
                                                <asp:Localize runat="server" meta:resourcekey="str_srcBy">Search by:</asp:Localize></td>
                                            <td style="padding:10px; ">
                                                <asp:DropDownList ID="Field" runat="server" AutoPostBack="True" OnSelectedIndexChanged="Field_SelectedIndexChanged" CssClass="form-control newDrpDwn"
                                                    >
                                                </asp:DropDownList>
                                            </td>
                                            </tr>
                                            <tr>
                                                <td style="padding:10px; font-size:18px; color:#404040; font-weight:100;" width="80px" nowrap="nowrap"><asp:Localize runat="server" meta:resourcekey="str_srcFor">Search for:</asp:Localize></td>
                                            <td style="padding:10px; ">
                                                <asp:TextBox ID="FileName" runat="server"
                                                    CssClass="form-control newTxtBx"></asp:TextBox>
                                                <asp:DropDownList ID="ActionName" runat="server" CssClass="form-control newDrpDwn">
                                                </asp:DropDownList>
                                        
                                                <asp:DropDownList ID="StatusList" runat="server" CssClass="form-control newDrpDwn">
                                                </asp:DropDownList>
                                            </td>
                                    
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                        </table>
                    <%}else { %>
                        <div style="max-height:320px; overflow:auto;">
                        <table style="width:100%; max-width:1200px;" >
                    <tr style="border-bottom:1px solid #808080;">
                
                        <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;"><asp:Localize runat="server" meta:resourcekey="str_owr">Owner</asp:Localize></td>
                        <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;"><asp:Localize runat="server" meta:resourcekey="str_hstNme">Host Name</asp:Localize></td>
                        <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;" colspan="2" align="center"><asp:Localize runat="server" meta:resourcekey="str_rstFrm">Restore From</asp:Localize></td>
                
                    </tr>
                             <tr><td style="height:8px">&nbsp;</td></tr>
                    <asp:Repeater ID="DevicesRepeater" runat="server" enableviewstate="false" >
                                                    <ItemTemplate>         
                                                        <tr style="border-bottom:1px solid #f0f0f0;" class="filerow">
                                                  
                                                            <td style="padding:5px;color:#565656;font-size:16px!important; font-weight:100;"><%# DataBinder.Eval(Container.DataItem,"UserEmail") %></td>
                                                            <td style="padding:5px;color:#565656;font-size:16px!important; font-weight:100;"><%# DataBinder.Eval(Container.DataItem,"HostName") %></td>
                                <td style="padding:5px;color:#565656;font-size:16px!important; font-weight:100; " nowrap>
                            <button class="btn newBtn"  onclick='OnLocalRestore("<%# DataBinder.Eval(Container.DataItem, "LocalBackupLocation") %>", "<%# DataBinder.Eval(Container.DataItem, "DomainId") %>"); return false;' style=""><asp:Localize runat="server" meta:resourcekey="str_lcl">Local</asp:Localize></button>
                    
                        </td>
                        <td style=" padding:3px;width:80px" nowrap>
                    
                            <button class="btn newBtn" onclick='OnCloudRestore("<%# DataBinder.Eval(Container.DataItem, "InstanceId") %>"); return false;' style=" "><asp:Localize runat="server" meta:resourcekey="str_cld">Cloud</asp:Localize></button>
                        </td>
                                                        </tr>
                                                    </ItemTemplate>         
                                                     </asp:Repeater>
                                                                            

                </table>
                            </div>
                    <%} %>
                <%}else { %>
                <div style="height:420px;width:100%; overflow:auto;">
                    
                <table style="width:100%; max-width:1200px;" >
                    <tr>
                        <td colspan="4" style="padding:10px;padding-left:0px; font-size:20px; font-weight:100; color:#202020;">
                            <asp:Localize runat="server" meta:resourcekey="str_slcShtRstFilFrm">Please select a snapshot to restore files from:</asp:Localize>
                        </td>
                    </tr>
                  <tr style=" border-bottom: 1px solid #808080; font-weight: 100;">
                    
                    <td  style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;">
                        <asp:Localize runat="server" meta:resourcekey="str_shtNme">Snapshot Name</asp:Localize>
                    </td>
                    <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;">
                        <asp:Localize runat="server" meta:resourcekey="str_crtTme">Creation Time</asp:Localize>
                    </td>
                    <td  style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;">
                        <asp:Localize runat="server" meta:resourcekey="str_crtBy">Created by</asp:Localize>
                    </td>
                   
                    <td width="80px" style=" 
                        height:32px!important; overflow:hidden" >
                       
    
                        <asp:Localize meta:resourcekey="str_down" ID="str_down" runat="server" Visible="False">Download</asp:Localize>
                        <asp:Localize meta:resourcekey="str_del" id="str_del" Visible="False" runat="server">Delete</asp:Localize>
                        <asp:Localize meta:resourcekey="str_restore" id="str_restore" Visible="False" runat="server">Restore to this version</asp:Localize>
                        <asp:Localize meta:resourcekey="str_close" id="str_close" Visible="False" runat="server">Close</asp:Localize>
                        <asp:Localize meta:resourcekey="str_browse" id="str_browse" Visible="False" runat="server">Browse</asp:Localize>
                    </td>
                </tr>
                
               
                <asp:Repeater ID="VersionRepeat" runat="server">
                    <ItemTemplate>
                        <tr style="border-bottom: 1px solid #f0f0f0; padding: 5px 5px 5px 5px; font-weight: 100; background-color:white; cursor:pointer;" class="filerow" onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                          
                            <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;">
                                <%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>
                                
                            </td>
                            <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;">
                               <%#DataBinder.Eval(Container.DataItem, "CreateTimeDisplay")%>
                            </td>
                            <td style="padding:5px;color:#565656;font-size:18px!important; font-weight:300;">
                               <%#DataBinder.Eval(Container.DataItem, "UpdateDisplayName")%>
                            </td>
                           
                          
                            <td style="padding-right: 4px; padding:5px;color:#565656;font-size:16px!important; font-weight:100;" align="right" >
                                
                                <table>
                                    <tr>
                                        
                                         
                                        <td >
                                            <a href='#' onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                                                
                                                <i class="gladinet-icons  iconviewitemcolor hand center" title="<%=str_browse.Text %>" style="font-size:16px!important">&#xDB;</i>
                                                
                                                </a>
                                        </td>
                                         
                                        
                                    </tr>
                                </table>
                            
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
                    </table>
                    </div>
                <%} %>
                
            <table style="width:100%; max-width:1200px;">
                    <tr>
                        <td>
                          
                        </td>
                        <td style="padding:10px;padding-top:20px;" align="right">
                             <%if (TenantPanel.Visible){ %>
                            <asp:LinkButton ID="ShowTeamfolders" runat="server" CssClass="btn newBtn" OnClick="SearchDevice_Click" meta:resourcekey="str_srh">Search</asp:LinkButton>
                            <%}else { %>
                            <button class="btn newSecBtn" onclick="OnBack();return false;"><asp:Localize runat="server" meta:resourcekey="str_bck">Back</asp:Localize></button>
                            
                            <%} %>
                            <button class="btn newSecBtn" onclick="OnCancel();return false;" style="margin-left:10px;"><asp:Localize runat="server" meta:resourcekey="str_cnl">Cancel</asp:Localize></button>
                        </td>
                    </tr>
                </table>
                    
            </td>
        </tr>
    </table>
    <div style="display:none">
        <asp:HiddenField ID="InstanceId" runat="server" />
        <asp:Panel ID="TenantPanel" runat="server"></asp:Panel>
        <asp:Panel ID="SnapShotPanel" Visible="false" runat="server"></asp:Panel>
        <asp:LinkButton ID="GetSnapShotBtn" runat="server" OnClick="GetSnapShotBtn_Click">GetSnapShot</asp:LinkButton>
        <asp:HiddenField ID="TeamFolderId" runat="server" />         
        <asp:Localize meta:resourcekey="str_ddl_usrEml" ID="LocUsrEml"  Visible="false" runat="server">User Email</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_dvcTpe" ID="LocDvcTpe"  Visible="false" runat="server">Device Type</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_hstNme" ID="LocHstNme"  Visible="false" runat="server">Host Name</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_oprStm" ID="LocOprStm"  Visible="false" runat="server">Operating System</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_cntSfw" ID="LocCntSfw"  Visible="false" runat="server">Client Software Version</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sts" ID="LocSts"  Visible="false" runat="server">Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncSts" ID="LocSncSts"  Visible="false" runat="server">Sync Status</asp:Localize>

<asp:Localize meta:resourcekey="str_ddl_acd" ID="LocAcd"  Visible="false" runat="server">Accepted</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_rjd" ID="LocRjd"  Visible="false" runat="server">Rejected</asp:Localize>
                
<asp:Localize meta:resourcekey="str_ddl_snc" ID="LocSnc"  Visible="false" runat="server">Syncing</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fld" ID="LocFld"  Visible="false" runat="server">Failed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncCpd" ID="LocSncCpd"  Visible="false" runat="server">Sync Completed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fldRtvSts" ID="LocFldRtvSts"  Visible="false" runat="server">Failed to Retrieve Sync Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPnd" ID="LocSncTskPnd"  Visible="false" runat="server">Sync Task Pending</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPsd" ID="LocSncTskPsd"  Visible="false" runat="server">Sync Task Paused</asp:Localize>

<asp:Localize meta:resourcekey="str_dvcFnd" ID="LocDvcFnd"  Visible="false" runat="server">Device(s) found</asp:Localize>

    </div>
    




</div>
</div>    

</div>
</div>
</div>
</main>
<footer class="c-footer">
</footer>
	
	
</div>







    <script type="text/javascript">

        function OnCancel()
        {
            <% if (IsChildUi) {
            //If the page is loaded in the main frame body
            %>
            parent.OnDashboard();
            <% } else { 
            //If the page is loaded within a modal popup         
            %>
            parent.CloseChildWnd();
            <% } %>
        }
    
        function OnBack() {

            window.location = "ClusterBackupRestoreDevice.aspx";

        }

        function adjust() {
            //for backwards compatibility with WebAppPanel.master
        }
        document.addEventListener("DOMContentLoaded", function () {
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });
    </script>
</asp:Content>
