﻿<%@ Page Title="Backup Profile Manager" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupProfileMgr.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupProfileMgr"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script type="text/javascript">





        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("id=") == -1)
                window.location.href = window.location.href + "?id=" + (new Date()).toString();
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }

    </script>

    <script type="text/javascript">

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaPro" meta:resourcekey="str_faiToLoaPro" Visible="false">failed to load profile</asp:Localize>
    <asp:Localize runat="server" ID="LocPflNmeMsg" meta:resourcekey="str_pflNmeMsg" Visible="false">Profile name is missing</asp:Localize>
    <asp:Localize runat="server" ID="LocPflIdMsg" meta:resourcekey="str_pflIdMsg" Visible="false">Profile ID is missing</asp:Localize>
    <asp:Localize ID="LocEdt" runat="server" meta:resourcekey="str_edt" Visible="false">Edit</asp:Localize>
    <asp:Localize ID="LocDlt" runat="server" meta:resourcekey="str_dlt" Visible="false">Delete</asp:Localize>
    <div style="display: none;">
      <asp:LinkButton ID="LinkButton3" runat="server" Text="Refresh" meta:resourcekey="str_rfh" OnClientClick="OnRefresh();return false;" ForeColor="#565656"></asp:LinkButton>
    </div>
    <%if (!ProfilePanel.Visible) { %>
<div class="c-subheader">

    <div style="width:100%;margin-top:20px;">
        
        <div class="bkpActLnk " style="float: left; width: 400px; height: 40px;padding-left:20px; margin-right: 15px;">
             <asp:Localize ID="LocAddNewDvcBkpPfl" runat="server" meta:resourcekey="str_addNewDvcBkpPfl" Visible="false">Add a new Device Backup Profile</asp:Localize>
            <asp:LinkButton ID="LinkButton1" runat="server" CssClass="hand" OnClick="LinkButton1_Click" meta:resourcekey="str_add"><i class="gladinet-icons hand" title="<%=LocAddNewDvcBkpPfl.Text %>">&#x173;</i></asp:LinkButton>
        </div>
        <div class="bkpActLnk text-right" style="float: right; width: 200px; height: 40px; margin-right: 15px;">
            <a class="" href="javascript:;" onclick="OnRefresh();" title="<%=LinkButton3.Text %>"><i class="gladinet-icons hand" style="font-size: 28px;">µ</i></a>
        </div>
    </div>

</div>
<%} %>



<div class="c-body" style="clear:both;">
<main class="c-main">
<div class="container-fluid">
<div class="fade-in">


<div id="pageContainerCard" class="card" style="box-shadow:none!important;">

<%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
<div id="container errmsgdiv">
    <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
</div>
<%} %>

<div class="card-body">
<div class="justify-content-between">
    
    <div class="content">
    <%if (!ProfilePanel.Visible) { %>

    <div class="row" style="border-bottom:1px solid #f0f0f0;margin-bottom:10px;padding-bottom:5px;">
        <div class="col">
            <h2 class="bkpHClr">
                <asp:Localize runat="server" meta:resourcekey="str_dvcBkpPfl">Device Backup Profiles</asp:Localize></h2>
        </div>
    </div>
        <asp:Repeater ID="ProfileRepeater" runat="server" EnableViewState="false">
            <ItemTemplate>
                <div class="row">
                    <div class="col-6">
                        <p class="bkpP"><%# DataBinder.Eval(Container.DataItem,"DisplayName") %></p>
                    </div>
                    <div class="col-6" style="align-content:flex-end;">
                        <i class="gladinet-icons iconviewitemcolor hand center" style="font-size:22px !important;" title="<%=LocEdt.Text %>" onclick='onEditProfile("<%# DataBinder.Eval(Container.DataItem, "ProfileId")%>");return false;'>/</i>
                        <i class="gladinet-icons iconviewitemcolor hand center" style="margin-left:10px;font-size:22px !important; <%# DataBinder.Eval(Container.DataItem,"DelteStyle") %>" title="<%=LocDlt.Text %>" onclick='onDeleteProfile("<%# DataBinder.Eval(Container.DataItem, "ProfileId")%>");return false;'>n</i>
                    </div>
                </div>
            </ItemTemplate>
        </asp:Repeater>

    <%} else { %>
        <table style="width:100%">
            <tr>
                <td align="center">
                    <div style="width:100%; max-width:1000px; padding:20px;" class="viewcard">
                         <div class="row">
            <div class="col-3">
                <h2 class="bkpHClr" style="margin-bottom: 0px; white-space: nowrap;">
                    <asp:Localize runat="server" meta:resourcekey="str_pflNme">Profile Name:</asp:Localize></h2>
            </div>
            <div class="col-9">
                <asp:TextBox ID="ProfileName" runat="server" CssClass="form-control newTxtBx"></asp:TextBox>
            </div>
        </div>
                         
        <div style="margin-top:20px;">
           
            <table align="center">
                <tr>
                    <td width="200px" style="padding:5px;">
                        <asp:CheckBox ID="BackupDocument" runat="server" meta:resourcekey="str_dcsFld" Text="Documents Folder" />
                    </td>
                     <td width="200px" style="padding:5px;">
                        <asp:CheckBox ID="BackupPicture" runat="server" meta:resourcekey="str_pcsFld" Text="Pictures Folder" />
                    </td>
                </tr>
                <tr>
                    <td width="200px" style="padding:5px;">
                        <asp:CheckBox ID="BackupDesktop" runat="server" meta:resourcekey="str_dtpFld" Text="Desktop Folder" />
                    </td>
                     <td width="200px" style="padding:5px;">
                        <asp:CheckBox ID="BackupVideo" runat="server" meta:resourcekey="str_vdoFld" Text="Video Folder" />
                    </td>
                </tr>
                 <tr>
                    <td width="200px" style="padding:5px;">
                        <asp:CheckBox ID="BackupFav" runat="server" meta:resourcekey="str_favFld" Text="Favorites Folder" />
                    </td>
                     <td width="200px" style="padding:5px;">
                        <asp:CheckBox ID="BackupMusic" runat="server" meta:resourcekey="str_mscFld" Text="Music Folder" />
                    </td>
                </tr>

            </table>
        </div>
        
        
        <div class="row" style="margin-top:20px;">
            <div class="col-3">
                <p class="bkpP" style="padding-top:7px;"><asp:Localize runat="server" meta:resourcekey="str_fldToBkp">Folder to back up</asp:Localize>:</p>
            </div>
            <div class="col-6">
                <asp:TextBox ID="FolderName" runat="server" CssClass="form-control newTxtBx" meta:resourcekey="str_fldPth" placeholder="folder path"></asp:TextBox>
            </div>
            <div class="col-3">
                <button class="btn newBtn" onclick="AddBackupFolder(); return false;">
                    <asp:Localize runat="server" meta:resourcekey="str_add">Add</asp:Localize></button>
            </div>
        </div>

        <div id="bfolders">
            <asp:Repeater ID="BackupFoldersRepeater" runat="server" EnableViewState="false">
                <ItemTemplate>
                    <div class="row" style="margin-top:10px;">
                        <div class="col-3">                                
                        </div>
                        <div class="col-6">
                            <input type="checkbox" style="display:inline-block;float:left;margin-top:3px;" checked name="uu_<%# DataBinder.Eval(Container.DataItem,"Name") %>" id="id_<%# DataBinder.Eval(Container.DataItem,"Name") %>" />
                                         
                            <p class="bkpP" style="font-style:italic;display:inline-block;margin-left:10px;"><%# DataBinder.Eval(Container.DataItem,"Name") %></p>                                         
                        </div>
                    </div>
                </ItemTemplate>
            </asp:Repeater>
        </div>

        <div class="row bkpBtnRowRgt">
            <div style="width:100%;text-align:right;margin-top:20px;">
                <asp:Button ID="ApplyProfile" runat="server" meta:resourcekey="str_apy" Text="Apply" OnClick="ApplyProfile_Click" CssClass="btn newBtn" />
                <asp:Button ID="CancelApplyProfile" runat="server" style="margin-left:20px;" meta:resourcekey="str_cnl" Text="Cancel" OnClick="CancelApplyProfile_Click" CssClass="btn newSecBtn" />

            </div>
        </div>
                    </div>
                </td>
            </tr>
        </table>
       
    </div>
    <% } %>


        <div style="display: none;">
            <asp:Panel ID="ProfilePanel" runat="server" Visible="false"></asp:Panel>
            <asp:LinkButton ID="EditProfile" runat="server" OnClick="EditProfile_Click">EditProfile</asp:LinkButton>
            <asp:LinkButton ID="DeleteProfile" runat="server" OnClick="DeleteProfile_Click">EditProfile</asp:LinkButton>
            <asp:HiddenField ID="PorfileId" runat="server" />

        </div>


</div>
</div>
</div>



</div>
</div>
</main>
</div>





    <script type="text/javascript">


        function onEditProfile(id) {
            var e = document.getElementById("ctl00_MainContent_EditProfile");
            var t = document.getElementById("ctl00_MainContent_PorfileId");
            t.value = id;
            Wait("...");
            e.click();

        }
        function onDeleteProfile(id) {

            gConfirm('Confirm you want to delete the backup profile?', "", function (btn1) {

                if (btn1 != 'ok')
                    return false;
                var e = document.getElementById("ctl00_MainContent_DeleteProfile");
                var t = document.getElementById("ctl00_MainContent_PorfileId");
                t.value = id;
                Wait("...");
                e.click();
            });


        }

        

        function AddBackupFolder()
        {
            var e = document.getElementById("ctl00_MainContent_FolderName");
            if (!e || e == "") {
                alert("<asp:Localize runat="server" meta:resourcekey="str_pthIsMsg">Path to the backup folder is missing</asp:Localize>");
                return;
            }
            var fname = e.value;
            if (!fname || fname == "") {
                alert("<asp:Localize runat="server" meta:resourcekey="str_pthIsMsg">Path to the backup folder is missing</asp:Localize>");
                return;
            }

            var o = document.getElementById("id_"+fname);
            if (o)
                return;

            e = document.getElementById("bfolders");

            var div = document.createElement("div");
            div.style.marginTop = "10px";
            div.className = "row";

            var div1 = document.createElement("div");
            div1.className = "col-3";
            div.appendChild(div1);

            var div2 = document.createElement("div");
            div2.className = "col-6";

            var cb = document.createElement("input");
            cb.type = "checkbox";
            cb.name = "uu_" + fname;
            cb.id = "id_" + fname;
            cb.checked = "checked";
            cb.style.float = "left";
            cb.style.display = "inline-block";
            cb.style.marginTop = "3px";
            div2.appendChild(cb);

            var p = document.createElement("p");
            p.style.display = "inline-block";
            p.style.marginLeft = "10px";
            p.style.fontStyle = "italic";
            p.innerHTML = fname;
            div2.appendChild(p);

            div.appendChild(div2);

            e.appendChild(div);
        }
        
        function adjust() {
            //for backwards compatibility with WebAppPanel.master
        }
        document.addEventListener("DOMContentLoaded", function () {
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });
    </script>
</asp:Content>
