﻿<%@ Page Title="Cluster Backup Console" Language="C#" MasterPageFile="~/UIFrameWork/ManagementConsole.master"
    AutoEventWireup="true" CodeBehind="ClusterBackupConsole.aspx.cs" Inherits="GladinetPayFlow.ClusterBackupConsole"
    Culture="auto" UICulture="auto" EnableViewState="true" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <asp:Localize ID="LocDshbrd" meta:resourcekey="str_dshbrd" runat="server" Visible="false">Dashboard</asp:Localize>
    <asp:Localize ID="LocDvcBcp" meta:resourcekey="str_dvcBcp" runat="server" Visible="false">Device Backups</asp:Localize>
    <asp:Localize ID="LocBcpStg" meta:resourcekey="str_bcpStg" runat="server" Visible="false">Backup Settings</asp:Localize>
    <asp:Localize ID="LocDvcBcpPfl" meta:resourcekey="str_dvcBcpPfl" runat="server" Visible="false">Device Backup Profiles</asp:Localize>
    <asp:Localize ID="LocTemFldBcp" meta:resourcekey="str_temFldBcp" runat="server" Visible="false">Team Folder Backups</asp:Localize>
    <asp:Localize ID="LocAddTemFldBcp" meta:resourcekey="str_addTemFldBcp" runat="server" Visible="false">Add Team Folder Backup</asp:Localize>
    <asp:Localize ID="LocTskSts" meta:resourcekey="str_tskSts" runat="server" Visible="false">Task Status</asp:Localize>
    <asp:Localize ID="LocBcpLog" meta:resourcekey="str_bcpLog" runat="server" Visible="false">Backup Log</asp:Localize>
    <asp:Localize ID="LocBcpStr" meta:resourcekey="str_bcpStr" runat="server" Visible="false">Backup Storage</asp:Localize>
    <asp:Localize ID="LocRstTemFld" meta:resourcekey="str_rstTemFld" runat="server" Visible="false">Restore Team Folder</asp:Localize>
    <asp:Localize ID="LocAddDvcBcp" meta:resourcekey="str_addDvcBcp" runat="server" Visible="false">Add Device to Backup</asp:Localize>
    <asp:Localize ID="LocRstDvc" meta:resourcekey="str_rstDvc" runat="server" Visible="false">Restore Device</asp:Localize>
    <asp:Localize ID="LocBcpTskRunDtl" meta:resourcekey="str_bcpTskRunDtl" runat="server" Visible="false">Backup Task Run Detail</asp:Localize>
    <asp:Localize ID="LocStgUsgDts" meta:resourcekey="str_stgUsgDts" runat="server" Visible="false">Storage Usage Details</asp:Localize>
    <asp:Localize ID="LocStg" meta:resourcekey="str_stg" runat="server" Visible="false">Settings</asp:Localize>


    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script type="text/javascript">
        function SetMainMenu(i, t, u) {
            console.log("SetMainMenu was removed");
            SetBreadCrumAndOpenPage(t, u, 1);
        }
        function SetSecondBreadCrum(i, t, u) {
            console.log("SetSecondBreadCrum was removed!");
            SetBreadCrumAndOpenPage(t, u, 2);
        }
        function SetThirdBreadCrum(i, t, u) {
            console.log("SetThirdBreadCrum was removed!");
            SetBreadCrumAndOpenPage(t, u, 3);
        }

        function CloseChildWnd(){
            GoToPreviousBreadCrum();
        }
        function OnDashboard()
        {
            <%if (m_BackupEnabled){%>
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDashboard").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocDshbrd.Text%>", "/management/BackupMgr/UI/ClusterBackupSummary.aspx", 1);
            <%}%>
        }

        function OpenChildWnd(n,u)
        {
            OpenNextMenu("a", n, u);
        }

        function EnableBackup(){
            SetBreadCrumAndOpenPage("Enable Backup", "/management/BackupMgr/UI/EnableCloudBackup.aspx", 1);
        }
        function OpenDeviceBackMgr()
        {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDeviceBackMgr").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocDvcBcp.Text%>", "/management/BackupMgr/UI/ClusterBackupDevices.aspx?child=1", 1);
        }
        function OpenBackupSettings()
        {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkBackupSettings").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocBcpStg.Text%>", "/management/BackupMgr/UI/ClusterBackupSettings.aspx?child=1", 1);
        }
        function OpenDeviceProfile() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDeviceProfile").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocDvcBcpPfl.Text%>", "/management/BackupMgr/UI/ClusterBackupProfileMgr.aspx?child=1", 1);
        }
        function OnClusterMgr() {
            window.location = "/management/clustermgrconsole";
        }
        function OpenTeamFolderBackMgr() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkTeamFolderBackMgr").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocTemFldBcp.Text%>", "/management/BackupMgr/UI/ClusterBackupTeamFolders.aspx?child=1", 1);
        }
        function AddTeamFolder() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkTeamFolderBackMgr").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocAddTemFldBcp.Text%>", "/management/BackupMgr/UI/ClusterBackupAddTeamFolder.aspx?child=1", 2);
        }        
        function OpenBackupStatus() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDashboard").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocTskSts.Text%>", "/management/BackupMgr/UI/ClusterBackupTask.aspx?child=1", 2);
        }
        function OpenBackupLog() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDashboard").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocBcpLog.Text%>", "/management/BackupMgr/UI/ClusterBackupTaskLog.aspx?child=1", 2);
        }
        function OnConfigureStorage() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkBackupSettings").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocBcpStr.Text%>", "/management/BackupMgr/UI/CloudBackupStorageType.aspx?child=1", 2);
        }
        function RestoreTeamFolder() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkTeamFolderBackMgr").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocRstTemFld.Text%>", "/management/BackupMgr/UI/ClusterBackupRestoreTeamFolder.aspx?child=1", 2);
        }
        function AddDevice() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDeviceBackMgr").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocAddDvcBcp.Text%>", "/management/BackupMgr/UI/ClusterBackupAddDevice.aspx?child=1", 2);
        }
        function RestoreDevice() {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDeviceBackMgr").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocRstDvc.Text%>", "/management/BackupMgr/UI/ClusterBackupRestoreDevice.aspx?child=1", 2);
        }
        function LastDetail(fpid) {
            $(".c-sidebar-nav-link").removeClass("navSelected");
            $("#navLinkDashboard").addClass("navSelected");
            SetBreadCrumAndOpenPage("<%=LocBcpTskRunDtl.Text%>", "/management/BackupMgr/UI/ClusterBackupTaskDetail.aspx?vdid=<%=SessionDomainId%>&f=1&tid=" + fpid, 2);            
        }
        var _isOverUserMenu = false;

        var _languageDropDownHasFocus = false;
        var _themeDropDownHasFocus = false;
        function ChangingLanguage(boolVar) {
            _languageDropDownHasFocus = boolVar;
        }
        function ChangingTheme(boolVar) {
            _themeDropDownHasFocus = boolVar;
        }

        function TryCloseUserMenuNow() {
            if (!_isOverUserMenu && !_languageDropDownHasFocus && !_themeDropDownHasFocus) {
                if ($("#userMenu").is(":visible")) {
                    $("#userMenu").hide();
                    $("#managerMenuIcon").html("&#x0180;");
                }
            }
        }
        function IsOverUserMenu(boolVar) {
            _isOverUserMenu = boolVar;
            setTimeout(function () {
                TryCloseUserMenuNow();
            }, 2000);
        }
        function ToggleUserMenu() {
            if ($("#userMenu").is(":visible")) {
                ForceCloseUserMenu();
            } else {
                $("#userMenu").show();
                $("#managerMenuIcon").html("&#x017c;");

                $("#userMenuContainer .icoTxtBtnTxt").not(".withDots").each(function () {
                    if (contentCroppedOff($(this)[0])) {
                        //add 3 dots and a title if the content gets cut off
                        $(this).addClass("withDots");
                        $(this).prop("title", $(this).text());
                        $(this).after("<span class='userMenuDots'>...</span>");

                    }
                });

                IsOverUserMenu(false);
            }
        }
        function ForceCloseUserMenu() {
            _isOverUserMenu = false;
            $("#userMenu").hide();
            $("#managerMenuIcon").html("&#x0180;");
        }

        function OnClickMyFiles() {
            window.location = "/portal/files";
        }
        function UserMenuItem(url, title) {
            parent.SetBreadCrumAndOpenPage(title, url, 1);
        }
        function OnChangePwd() {
            OpenModalPopup('/portal/ChangePasswordPage.aspx', "");
        }
        function onLogout() {
            window.location = "/portal/loginpage.aspx";
        }
    </script>
</asp:Content>

<asp:Content ID="PageBranding" runat="server" ContentPlaceHolderID="LeftMenuTop">
</asp:Content>      

<asp:Content ID="UserMenuDivContent" runat="server" ContentPlaceHolderID="UserMenuDiv">
    <div id="userMenu" onmouseover="IsOverUserMenu(true)" onmouseout="IsOverUserMenu(false)">
        <div onclick="ToggleUserMenu();" style="background:rgba(255,255,255,0.05);width:100%;height:40px;"></div>
        <div id="userMenuContainer">
            <ul>
                <li>
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">9</i>
                    <div class="icoTxtBtnTxt" style="margin-top:-20px;"><asp:DropDownList ID="LanguageSelect" runat="server" AutoPostBack="True" Width="200px"  cssclass="form-control newDrpDwn" OnSelectedIndexChanged="LanguageSelect_SelectedIndexChanged" onfocus="ChangingLanguage(true)" onblur="ChangingLanguage(false)"></asp:DropDownList></div></li>
                <% if (!m_DisableThemeChange){ %>
                <li>
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">B</i>
                    <div class="icoTxtBtnTxt" style="margin-top:-20px;"><asp:DropDownList ID="ThemeList" runat="server" AutoPostBack="True" Width="200px" CssClass="form-control newDrpDwn" OnSelectedIndexChanged="ThemeListSelect_SelectedIndexChanged" onfocus="ChangingTheme(true)" onblur="ChangingTheme(false)"></asp:DropDownList></div></li>
                <% } %>


                <% if (!SessionIsAdUser) { %>
                <li onclick="OnChangePwd();">
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">r</i><div class="icoTxtBtnTxt"><asp:Localize meta:resourcekey="str_chgPwd" runat="server">Change Password</asp:Localize></div></li>
                <% } %>
                <li onclick="onLogout();">
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">*</i><div class="icoTxtBtnTxt"><asp:Localize meta:resourcekey="str_lgt" runat="server">Logout</asp:Localize> <%=AccountEmail %></div></li>
            </ul>
        </div>
    </div>
</asp:Content>

<asp:Content ID="MMCSwitches" runat="server" ContentPlaceHolderID="ToolBarRight">

    <asp:Localize runat="server" ID="LocFlwBrwLcl" meta:resourcekey="str_flwBrwLcl" Visible="false">Follow Browser Locale</asp:Localize>
    <asp:Localize runat="server" ID="LocEng" meta:resourcekey="str_eng" Visible="false">English</asp:Localize>
    <asp:Localize runat="server" ID="LocThmBlu" meta:resourcekey="str_thmBlu" Visible="false">Blue</asp:Localize>
    <asp:Localize runat="server" ID="LocThmSkyBlu" meta:resourcekey="str_thmSkyBlu" Visible="false">Sky Blue</asp:Localize>
    <asp:Localize runat="server" ID="LocThmStlBlu" meta:resourcekey="str_thmStlBlu" Visible="false">Steel Blue</asp:Localize>
    <asp:Localize runat="server" ID="LocThmLmeGrn" meta:resourcekey="str_thmLmeGrn" Visible="false">Lime Green</asp:Localize>
    <asp:Localize runat="server" ID="LocThmOlvGrn" meta:resourcekey="str_thmOlvGrn" Visible="false">Olive Green</asp:Localize>
    <asp:Localize runat="server" ID="LocThmTelGrn" meta:resourcekey="str_thmTelGrn" Visible="false">Teal Green</asp:Localize>
    <asp:Localize runat="server" ID="LocThmMve" meta:resourcekey="str_thmMve" Visible="false">Mauve</asp:Localize>
    <asp:Localize runat="server" ID="LocThmOrg" meta:resourcekey="str_thmOrg" Visible="false">Orange</asp:Localize>
    <asp:Localize runat="server" ID="LocThmPnk" meta:resourcekey="str_thmPnk" Visible="false">Pink</asp:Localize>
    <asp:Localize runat="server" ID="LocThmRed" meta:resourcekey="str_thmRed" Visible="false">Red</asp:Localize>
    <asp:Localize runat="server" ID="LocThmGry" meta:resourcekey="str_thmGry" Visible="false">Gray</asp:Localize>
    <asp:Localize runat="server" ID="LocThmCsc" meta:resourcekey="str_thmCsc" Visible="false">Classic</asp:Localize>
    <asp:Localize runat="server" ID="LocThmCst" meta:resourcekey="str_thmCst" Visible="false">Customized</asp:Localize>

    <div class="flexRow"> 
        <% if (SessionTrial) { %>
        <asp:Literal ID="DysLft" runat="server" meta:resourcekey="str_dysLft" Visible="false" Text="{NUMVAR} day(s) left."></asp:Literal>
        <div class="icoTxtBtnTxt hideIfNotXLg" style="margin-top:5px;"><asp:Localize meta:resourcekey="str_trlDysLft" runat="server">Trial day(s) left:</asp:Localize></div>
		
		<asp:Literal ID="LtlProgBarClass" runat="server" Text="progress-bar-success" Visible="False"></asp:Literal>
		<asp:Literal ID="LtlProgBarPercent" runat="server" Text="30" Visible="False"></asp:Literal>
        
        <div class="progress hideIfNotXLg" style="width:100px;margin-left:6px;margin-top:10px;height:5px;" title="<%=DysLft.Text %>">
          <div class="progress-bar <%=LtlProgBarClass.Text %>" role="progressbar" style="width:<%=LtlProgBarPercent.Text %>"></div>
        </div>
        <i class="icoTxtBtnIco gladinet-icons sectextcolor" title="<%=LBBuyNow.Text %>" style="font-size:20px;line-height:20px;margin-top:5px;margin-left:5px;">&#x107;</i>
		<asp:LinkButton ID="LBBuyNow" runat="server" OnClick="LBBuyNow_Click" meta:resourcekey="str_buyNow" style="margin-left:5px;margin-right:10px;margin-top:5px;">Buy Now!</asp:LinkButton>
        
        <% } %>

        <% if (SessionIsClusterAdmin) { %>
        <div class="flexRow icoTxtBtn" onclick="OnClusterMgr();" style="height:24px; margin-top:6px;margin-left:15px; display:none;">
            <i class="icoTxtBtnIco gladinet-icons sectextcolor" title="<%=LocCtrMgr.Text %>" style="font-size:24px;line-height:24px;">T</i>
            <div class="icoTxtBtnTxt"><asp:Localize ID="LocCtrMgr" meta:resourcekey="str_ctrMgr" runat="server">Cluster Manager</asp:Localize></div>
        </div>
        <% } %>
        <div class="flexRow icoTxtBtn" onclick="OnClickMyFiles();" style="height:24px; margin-left:15px; margin-top:6px; display:none;">
            <i class="icoTxtBtnIco gladinet-icons sectextcolor" title="Files" style="font-size:24px;line-height:24px;">Q</i>
            <div class="icoTxtBtnTxt"><asp:Localize ID="LocFls" meta:resourcekey="str_fls" runat="server">Files</asp:Localize></div>
        </div>
        <div class="flexRow trbordercolor" onclick="ToggleUserMenu();" style="margin-left:50px;height:30px; width:30px; margin-top:5px;margin-right:10px;">
            <i id="managerMenuIcon" class="icoTxtBtnIco gladinet-icons sectextcolor" title="<%=LocUsrMnu.Text %>" style="font-size:30px;">&#x180;</i>
            <div class="icoTxtBtnTxt" style="display:none;"><asp:Localize ID="LocUsrMnu" meta:resourcekey="str_usrMnu" runat="server">User Menu</asp:Localize></div>
        </div>
    </div>
</asp:Content>

<asp:Content ID="LeftMenuBar" runat="server" ContentPlaceHolderID="LeftMenuPanel">
    <%if(m_BackupEnabled){%>
    <li class="c-sidebar-nav-item"><a id="navLinkDashboard" class="c-sidebar-nav-link" href="javascript:;" onclick="OnDashboard();">
        <i class="gladinet-icons">s</i><div class="hideIfSmallScreen"><%=LocDshbrd.Text %></div></a></li>
    <li class="c-sidebar-nav-item"><a id="navLinkDeviceBackMgr" class="c-sidebar-nav-link" href="javascript:;" onclick="OpenDeviceBackMgr();">
        <i class="gladinet-icons">)</i><div class="hideIfSmallScreen"><%=LocDvcBcp.Text %></div></a></li>
    <%if(!IsServo) { %>
    <li class="c-sidebar-nav-item"><a id="navLinkTeamFolderBackMgr" class="c-sidebar-nav-link" href="javascript:;" onclick="OpenTeamFolderBackMgr();">
        <i class="gladinet-icons">+</i><div class="hideIfSmallScreen"><%=LocTemFldBcp.Text %></div></a></li>
    <%}%>
    <li class="c-sidebar-nav-item"><a id="navLinkDeviceProfile" class="c-sidebar-nav-link" href="javascript:;" onclick="OpenDeviceProfile();">
        <i class="gladinet-icons">o</i><div class="hideIfSmallScreen"><%=LocDvcBcpPfl.Text %></div></a></li>
    <li class="c-sidebar-nav-item"><a id="navLinkBackupSettings" class="c-sidebar-nav-link" href="javascript:;" onclick="OpenBackupSettings();">
        <i class="gladinet-icons">g</i><div class="hideIfSmallScreen"><%=LocStg.Text %></div></a></li>
    <%}%>
</asp:Content>

<asp:Content ID="PageTailJS" runat="server" ContentPlaceHolderID="LastBodyContent">
     <script type="text/javascript">
         if (top != self) top.location.replace(location);
         function contentCroppedOff(element) {
             return element.scrollHeight > element.clientHeight || element.scrollWidth > element.clientWidth;
         }
         <%if(!m_BackupEnabled){%>
         $("#sidebar1.c-sidebar-lg-show").removeClass("c-sidebar-lg-show");
         var el = document.getElementById("togglebtn");
         el.style.display="none";
         <%}%>
         document.addEventListener("DOMContentLoaded", function () {
             <asp:Literal ID="LtlClientScripts" runat="server" />
             });

    </script>
</asp:Content>