﻿<%@ Page Title="Team Folder Backups" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BackupTeamfolder.aspx.cs" Inherits="GladinetPayFlow.BackupTeamfolder"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script type="text/javascript">
        function ISetPage(n)
        {
            var e = document.getElementById("page_1");
            e.className = "nav-link";
            e = document.getElementById("page_1_div");
            e.style.display = "none";

            e = document.getElementById("page_2");
            e.className = "nav-link";
            e = document.getElementById("page_2_div");
            e.style.display = "none";

            e = document.getElementById("page_3");
            e.className = "nav-link";
            e = document.getElementById("page_3_div");
            e.style.display = "none";

            e = document.getElementById("page_4");
            e.className = "nav-link";
            e = document.getElementById("page_4_div");
            e.style.display = "none";

            e = document.getElementById("page_5");
            e.className = "nav-link";
            e = document.getElementById("page_5_div");
            if(n==5){
                try{
                    top.ShowLoader();
                }catch(ex){
                    console.log("ShowLoader call failed. Please ensure HideLoader exists on the top frame");
                }
                //reload iframe
                e.src = "/management/BackupSubtasks.aspx?child=1&vdid=<%=SessionDomainId%>&tid=<%=TeamFolderId.Value %>";
            }
            e.style.display = "none";

            e = document.getElementById("page_6");
            e.className = "nav-link";
            e = document.getElementById("page_6_div");
            e.style.display = "none";

            e = document.getElementById("page_"+n);
            e.className = "nav-link active";

            e = document.getElementById("page_"+n+"_div");

            e.style.display = "";
        }
        function SetPage(n) {
            ISetPage(n);
            
            if (n == 2)
                window.location = window.location;
            else if(n== 4){
                var btn = document.getElementById('ctl00_MainContent_RefreshChangeLog');
                btn.click();
            }
        }

        function OnSaveChanges() {
            Wait("Please wait...");
            var btn = document.getElementById('ctl00_MainContent_ApplyBtn');
            btn.click();

        }
        function ResizeIFrameHeight(ref) {
            try{
                top.HideLoader();
            }catch(ex){
                console.log("HideLoader call failed. Please ensure HideLoader exists on the top frame");
            }
            try {
                $(ref).contents().find("form").css({"overflow":"visible","height":"auto"});
                $(ref).contents().find(".main").css({"overflow":"visible","height":"auto"});
                $(ref).contents().find("#rowcontainer").css({"overflow":"visible","height":"auto"});
            } catch (ex) { }
            try {
                ref.style.height = 0;
                var minHeight = window.innerHeight;
                var contentHeight = $(ref).contents().find(".main")[0].offsetHeight;
                if (contentHeight < minHeight) {
                    contentHeight = minHeight;
                }
                contentHeight += 60;
                //console.log("iframe2 height: " + contentHeight)
                ref.style.height = contentHeight + 'px';
            } catch (ex) {
                console.log("ResizeIFrameHeight2: " + ex);
            }
            try {
                parent.ResizeIFrame();
            } catch (ex) {}
        }
        function ResizeIFrame() {
            ResizeIFrameHeight($("#page_5_div")[0]);
        }
        window.onresize = function () {
            ResizeIFrame();
        };
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocFldAplStg" meta:resourcekey="str_fldAplStg" Visible="false">Failed to apply settings</asp:Localize>
    <asp:Localize runat="server" ID="LocMsgPrt" meta:resourcekey="str_msgPrt" Visible="false">missing parameter</asp:Localize>
    <asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
    <asp:Localize runat="server" ID="LocDysAgo" meta:resourcekey="str_dysAgo" Visible="false">days ago</asp:Localize>
<asp:Localize runat="server" ID="LocScsAgo" meta:resourcekey="str_scsAgo" Visible="false">less than 1 minute ago</asp:Localize>
<asp:Localize runat="server" ID="LocHrsAgo" meta:resourcekey="str_hrsAgo" Visible="false">hours ago</asp:Localize>
<asp:Localize runat="server" ID="LocMnsAgo" meta:resourcekey="str_mnsAgo" Visible="false">minutes ago</asp:Localize>
    <asp:Localize runat="server" ID="LocFldLodLog" meta:resourcekey="str_fldLodLog" Visible="false">failed to load process log</asp:Localize>
<asp:Localize runat="server" ID="LocFldApyStg" meta:resourcekey="str_fldApyStg" Visible="false">failed to apply settings</asp:Localize>
<asp:Localize runat="server" ID="LocTskPnd" meta:resourcekey="str_tskPnd" Visible="false">Task Pending</asp:Localize>
<asp:Localize runat="server" ID="LocTskRng" meta:resourcekey="str_tskRng" Visible="false">Task Running</asp:Localize>
<asp:Localize runat="server" ID="LocTskPsd" meta:resourcekey="str_tskPsd" Visible="false">Task Paused</asp:Localize>
<asp:Localize runat="server" ID="LocTskFld" meta:resourcekey="str_tskFld" Visible="false">Task Failed</asp:Localize>
<asp:Localize runat="server" ID="LocTskCpt" meta:resourcekey="str_cpt" Visible="false">Completed</asp:Localize>
<asp:Localize runat="server" ID="LocFldRtvSncSts" meta:resourcekey="str_fldRtvSncSts" Visible="false">Failed to retrieve sync status</asp:Localize>
<asp:Localize runat="server" ID="LocWatBkpTskPrc" meta:resourcekey="str_watBkpTskPrc" Visible="false">Waiting for backup task processor</asp:Localize>
    <asp:Localize runat="server" ID="LocCrt" meta:resourcekey="str_crt" Visible="false">Current</asp:Localize>

    <asp:CheckBox ID="EnableBackup" runat="server" meta:resourcekey="str_eblBkp" Text="Enable backup" OnCheckedChanged="EnableBackup_CheckedChanged" AutoPostBack="true" Visible="false" />

    
    <%if (EnableBackup.Checked){ %>
    <div class="c-subheader">

        <div class="row" style="border-bottom:1px solid #f0f0f0;">
            <div class="col-12 col-md-9">
                <ul class="nav nav-tabs" id="myTab" style="margin:15px;">
                    <li class="bkpLi nav-item" style="display:none;">
                        <a class="nav-link " href="#" id="page_2" onclick="SetPage(2);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_shts">Snapshots</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link active" href="#" id="page_4" onclick="SetPage(4);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_bkpLog">Backup Log</asp:Localize></a>
                    </li>

                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_1" onclick="SetPage(1);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_bkpTskSts">Backup Task Status</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_5" onclick="SetPage(5);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_fldTsk">Failed Tasks</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item" style="display:none;">
                        <a class="nav-link" href="#" id="page_3" onclick="SetPage(3);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_tskSts">Task Status</asp:Localize></a>
                    </li>
                    <li class="bkpLi nav-item">
                        <a class="nav-link" href="#" id="page_6" onclick="SetPage(6);return false;">
                            <asp:Localize runat="server" meta:resourcekey="str_retPlc">Retention Policy</asp:Localize></a>
                    </li>
                </ul>
            </div>
            <div class="col-12 col-md-3 bkpRgtSdeNavExp" style="padding-top:25px;padding-right:25px;">
                <div style="margin-right:15px;">
                <asp:LinkButton ID="LinkButton2" runat="server" OnClick="StartSeeding_Click" meta:resourcekey="str_frcStrNow" title="Force Start Now" CssClass="btn btn-primary gladbtn"><i class="gladinet-icons hand" style="font-size: 28px;">&#x0158;</i></asp:LinkButton>
                <asp:LinkButton ID="StopBackup" style="padding-left:10px;" runat="server" OnClick="StopBackup_Click" title="Disable Backup"><i class="gladinet-icons hand" style="font-size: 28px;">&#x002a;</i></asp:LinkButton>
                

                </div>
            </div>
        </div>
        

    </div>


    <%}%>


    

<div class="c-body" style="clear:both; ">
<main class="c-main">
<div class="container-fluid">
<div class="fade-in" >



<div class="card" >
<%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
<div id="container errmsgdiv">
    <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
</div>
<%} %>
</div>

<div class="card-body">
<div class="justify-content-between">




    <div id="defaultcontent">
   
                <%if (EnableBackup.Checked){ %>
                <div  style="display:none;" id="page_2_div">


                    
                <%if (EnableBackup.Checked){ %>
                <%if (!DeviceView){ %>
                    <div style="text-align:left; margin-bottom:10px;">
                        <div style="display:inline-block; padding-right:18px; cursor:pointer;" data-toggle="modal" data-target="#myModal" class="toolnavbtn">
          <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;"  >&#x173;</i>
            <span style="font-weight:100; font-size:16px; color:#404040;"><%=AddNewVersion.Text %></span>
            
        </div>
        <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="OnRefresh();return false;" class="toolnavbtn">
            <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;" title="Refresh" >µ</i>
            <span style="font-weight:100; font-size:16px; color:#404040;"><%=RefreshBtn.Text %></span>
                
        </div>
                    
                    
                    </div>
                <%}%>
                <%}%>    
                    
                    



                    <table width="100%" align="center" cellspacing="0" cellpadding="0" style="background-color: transparent;clear:both;">
                       
                        <%if (VersionRepeat.Items.Count != 0){ %>
                         <tr>
                            <td colspan="2">
                                <div style="width:100%; overflow:auto; height:100px;" id="VersionDiv">
                                <asp:Repeater ID="VersionRepeat" runat="server">
                                    <ItemTemplate>
            <div class="card filerow" style="margin-bottom: 5px; box-shadow:none!important;border-top:1px solid #f0f0f0;border-top:1px solid #f0f0f0;">
                <div class="card-body">
                    <div class="justify-content-between">
                                            <table width="100%">
                                                <tr>
                                                    <td style="padding-left:10px;" align="left" valign="middle" colspan="3">
                                                        <div class="toolnavbtn" style="display:inline-block" onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                            <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;"  >&#x139;</i>
                                                                    <span class="bkpNobrk" style="padding-left:10px; font-size:18px!important;  color: #202020;"><%#DataBinder.Eval(Container.DataItem, "DisplayName")%></span>
                            </div>
                                                        
                                                    </td>
                                                    
                                                </tr>
                                                <tr>
                                                    <td colspan="3" style="padding: 10px; padding-bottom: 3px; font-size: 12px; color: #565656;">
                                                        <span>
                                                            <asp:Localize runat="server" meta:resourcekey="str_ctnTme">Creation Time:</asp:Localize></span><span style="padding-left: 3px; padding-right: 10px;"><%#DataBinder.Eval(Container.DataItem, "CreateTimeDisplay")%></span>
                                                        <span>
                                                            <asp:Localize runat="server" meta:resourcekey="str_stgUsg">Storage Usage:</asp:Localize></span><span style="padding-left: 3px; padding-right: 10px;"><%#DataBinder.Eval(Container.DataItem, "StorageDisplayName")%></span>
                                                        <span>
                                                            <asp:Localize runat="server" meta:resourcekey="str_fldCnt">Folder Count:</asp:Localize></span><span style="padding-left: 3px; padding-right: 10px;"><%#DataBinder.Eval(Container.DataItem, "DirCount")%></span>
                                                        <span>
                                                            <asp:Localize runat="server" meta:resourcekey="str_filCnt">File Count:</asp:Localize></span><span style="padding-left: 3px; padding-right: 10px;"><%#DataBinder.Eval(Container.DataItem, "FileCount")%></span>
                                                        <span>
                                                            <asp:Localize runat="server" meta:resourcekey="str_ctdBy">Created By:</asp:Localize></span><span style="padding-left: 3px; padding-right: 10px;"><%#DataBinder.Eval(Container.DataItem, "UpdateDisplayName")%></span>

                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="3" style="padding-top:10px; padding-left:10px;">
                                                         <div style="display:inline-block; cursor:pointer;" class="toolnavbtn"  onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:-3px; font-size:14px" >&#x00ab;</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; " ><%=str_browse.Text %></span>
                                                                </div>
                                                                <div style="display:inline-block;width:15px">&nbsp;</div>
                                                                <div style="display:inline-block;cursor:pointer;<%#(Container.ItemIndex == 0)? "display:none;": "" %>" class="toolnavbtn" onclick="DeleteSnapshot('<%#DataBinder.Eval(Container.DataItem, "SnapshotName").ToString().Replace("'","%27") %>','<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>');return false;" >
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:0px; font-size:14px" >n</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; "><%=str_del.Text %></span>
                                                                </div>
                       
                                                    </td>
                                                </tr>

                                            </table>

                                        </div>
                                    </div>
                                </div>
                                    </ItemTemplate>
                                </asp:Repeater>
                                    </div>
                            </td>
                            </tr>
                          <%}
                              else
                              { %>
                        <tr>
                            <td align="center" colspan="2">

                                
                            <div class="card" style="margin-bottom: 10px;">
                                <div class="card-body">
                                    <div class="justify-content-between">

                                        <div class="container errMsg text-center">
                                            <h2 class="bkpHClr">
                                                <asp:Localize runat="server" meta:resourcekey="str_noShtAvlMsg">There are no snapshots available before the initial data seeding. The initial data seeding will occur when the backup process runs next time.</asp:Localize></h2>
                                            
                                            <asp:LinkButton ID="ForceStart" runat="server" CssClass="btn newBtn" style="font-size: 16px!important" OnClick="StartSeeding_Click" meta:resourcekey="str_frcIntSedNow">Force Initial Seeding Now</asp:LinkButton>

                                        </div>

                                    </div>
                                </div>
                            </div>


                            </td>
                        </tr>
                        <%} %>
                    </table>

                    <div id="myModal" class="modal fade" role="dialog">
                        <asp:Localize meta:resourcekey="str_onfirmrestore" ID="str_onfirmrestore" runat="server" Visible="false">Do you want to restore this version to the head version?</asp:Localize>
                        <div class="modal-dialog">
                            <!-- Modal content-->
                            <div class="modal-content" style="width: 600px;">
                                <div class="modal-header">


                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                </div>
                                <div class="modal-body">
                                    <div class="content">
                                        <div class="row">
                                            <div class="col-12">
                                                <p class="bkpP"><asp:Localize runat="server" meta:resourcekey="str_shtNme">Snapshot Name</asp:Localize></p>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-12">
                                                <asp:TextBox ID="SnapshotName" runat="server" CssClass="form-control newTxtBx"></asp:TextBox>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <div class="modal-footer" style="margin-bottom:20px;padding-right:20px;">
                                    <asp:Button ID="AddNewVersion" runat="server" meta:resourcekey="str_tkeSht" Text="Take a snapshot" CssClass="btn newBtn"
                                        OnClick="AddNewVersion_Click" OnClientClick="Wait('Uploading');" />

                                    <button type="button" class="btn newSecBtn" data-dismiss="modal" style="margin-left:10px;">
                                        <%=str_close.Text %></button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="wrapper" style="background-color: white; display:none; " id="page_1_div">
                    <table width="100%" id="SummaryTable">
                        <tr>
                            <td align="center" style="padding-top:30px;">
                                <table style="width:100%;  display:;" border="0" id="SummaryPanel">
                                    <tr>
                                        <td colspan="2" align="center" height="90px" valign="top" id="displayicon">
                                            
                                            <i class="sectextcolor gladinet-icons" style="font-size:64px;"><%=MaterialIconToGladIcon(DipslayIconName.Value)%></i>

                                        </td>
                                    </tr>
                                    <tr>
                                                <td colspan="2" align="center">
                                                    <span style="padding:3px; font-size:18px;font-weight:100; color:#565656; " >
                                                        <span id="dspStsSpn"></span>
                                                        <script>
                                                            function printStatus(){
                                                                var dispSpan = document.getElementById("dspStsSpn");
                                                                var statusFromUserlib = "<asp:Literal ID="DisplayStatus" runat="server" Text=""></asp:Literal>";
                                                                switch(statusFromUserlib){
                                                                    case "Pending Initial Seeding":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_pndIntSdg">Pending Initial Seeding</asp:Localize>";
                                                                        break;
                                                                    case "Initial Seeding":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_intSdg">Initial Seeding</asp:Localize>";
                                                                        break;
                                                                    case "Scan Files for Initial Seeding":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_scnFilIntSdg">Scan Files for Initial Seeding</asp:Localize>";
                                                                        break;
                                                                    case "Initial Seeding Completed Successfully":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_intSdgCptScs">Initial Seeding Completed Successfully</asp:Localize>";
                                                                        break;
                                                                    case "Scan for File Changes":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_scnFilChg">Scan for File Changes</asp:Localize>";
                                                                        break;
                                                                    case "Last Backup Completed Successfully":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_lstBkpCptScs">Last Backup Completed Successfully</asp:Localize>";
                                                                        break;
                                                                    case "Backing Up":
                                                                        dispSpan.innerHTML = "<asp:Localize runat="server" meta:resourcekey="str_bknp">Backing Up</asp:Localize>";
                                                                        break;
                                                                    default:
                                                                        dispSpan.innerHTML = statusFromUserlib;
                                                                        break;
                                                                }
                                                            }
                                                            printStatus();
                                                        </script>
                                                    </span>
                                                </td>
                                            </tr>
                                     <tr>
                                                <td colspan="2" style="padding-top:20px;" align="center">
                                                    <asp:LinkButton ID="LinkButton1" runat="server" CssClass="btn newBtn" OnClick="StartSeeding_Click" meta:resourcekey="str_frcStrNow">Force Start Now</asp:LinkButton>
                                                </td>
                                            </tr>
                                    <tr>
                                                <td colspan="2" height="20px;">&nbsp;</td>
                                            </tr>
                                            <tr style="display:none;">
                                                <td colspan="2" align="center">
                                                    <table>
                                                        <tr >
                                                <td style="color:#565656;font-weight:100;font-size:12px;" width="150px" nowrpa="nowrap">&nbsp;</td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor"></td>
                                            </tr>
                                            <tr>
                                                <td style="color:#565656;font-weight:100;font-size:12px; padding-top:10px;"  width="100px" nowrpa="nowrap"><asp:Localize runat="server" meta:resourcekey="str_lstStrTme">Last Start Time</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="starttime">
                                                    
                                                    <asp:Label ID="StartTime" runat="server" Text=""></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>                                                
                                                <td style="color:#565656;font-weight:100;font-size:12px;"><asp:Localize runat="server" meta:resourcekey="str_drn">Duration</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="duration">
                                                    
                                                    <asp:Label ID="Duration" runat="server" Text=""></asp:Label>
                                                    
                                                </td>
                                            </tr>
                                            <tr>                                                
                                                <td style="color:#565656;font-weight:100;font-size:12px;"><asp:Localize runat="server" meta:resourcekey="str_filCnt">File Count</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="filecount">                                                    
                                                    <asp:Label ID="FileCount" runat="server" Text=""></asp:Label>
                                                </td>
                                            </tr>
                                            <tr>                                                
                                                <td style="color:#565656;font-weight:100;font-size:12px;"><asp:Localize runat="server" meta:resourcekey="str_dtaSze">Data Size</asp:Localize></td>
                                                <td style="font-weight:100;font-size:14px;" align="left" class="sectextcolor" id="backupsize">                                                    
                                                    <asp:Label ID="DisplayBackupSize" runat="server" Text=""></asp:Label>
                                                </td>
                                            </tr>
                                                    </table>
                                                </td>
                                            </tr>

                                    
                                            
                                </table>
                                
                               
                            </td>
                        </tr>
                    </table>
                    <table width="100%" id="tablerunning" style="display:none;">
                        <tr>
                            <td align="center" style="padding-top:30px;">
                                 <div  style="width:100%;padding:5px; font-size:16px;  display:;" id="RunningPanel" >
                                <table width="100%">
                        <tr>
                            <td width="30%" style="padding-top:0px;" valign="top">
                                <table width="100%">
                                    <tr>
                                        <td colspan="2" style="font-weight:100; padding:10px; font-size:18px; color:#565656;" align="center">
                                            <asp:Localize runat="server" meta:resourcekey="str_smr">Summary</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr style="display:none;">
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;"><asp:Localize runat="server" meta:resourcekey="str_sts">Status</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;" class="sectextcolor" id="iTaskStatus">
                                            <asp:Label ID="TaskStatus" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_totTsk">Total Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iTotalTask">
                                            <asp:Label ID="TotalTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_pndTsk">Pending Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iPendingTask">
                                            <asp:Label ID="PendingTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_fldTsk">Failed Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iFailedTask">
                                            <asp:Label ID="FailedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_skpTsk">Skipped Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size:16px; color:#565656; font-weight:100;" class="sectextcolor" id="iSkippedTask">
                                            <asp:Label ID="SkippedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="padding:10px; padding-top:20px; display:none;" align="right">
                                            <table>
                                                            <tr>
                                                                <td id="tdr" style="display:none;">                                                                    
                                                                    <asp:Button ID="Resume" runat="server" meta:resourcekey="str_rsm" Text="Resume" CssClass="btn newBtn" OnClick="Resume_Click" />
                                                                </td>
                                                                <td id="tdp" style="display:none;">
                                                                    <asp:Button ID="Pause" runat="server" meta:resourcekey="str_pse" Text="Pause" CssClass="btn newBtn" OnClick="Pause_Click"  />
                                                                </td>

                                                                <td id="tds" style="display:none;">
                                                                    <asp:Button ID="Start" runat="server" meta:resourcekey="str_rst" Text="Restart" CssClass="btn newBtn" OnClick="Start_Click"  />
                                                                </td>
                                                            </tr>
                                                        </table>
                                        </td>
                                    </tr>
                                     <tr>
                <td colspan="2" style="height:20px; color:red;" id="PollRes" align="center">&nbsp;</td>
            </tr>
                                </table>
                            </td>
                            <td style="width:1px; border-left: 1px solid#f4f4f4 ;">&nbsp;</td>
                            <td valign="top" style="padding-top:0px; border-left:0px solid #f0f0f0;">
                                <table width="100%" style="font-size:16px!important;" >
                                    <tr>
                                        <td  colspan="2" style="font-weight:100; padding:10px; font-size:18px; color:#565656;" align="center">
                                            <asp:Localize runat="server" meta:resourcekey="str_prg">Progress</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" id="" style="padding:5px;" class="sectextcolor">

                                        </td>
                                    </tr>
                                    <tr >
                                        <td width="120px" style="padding:5px; font-size:16px; color:#565656; font-weight:100;"><asp:Localize runat="server" meta:resourcekey="str_ovl">Overall</asp:Localize></td>
                                        <td >
                                            <div class="progress" style="width:100%;">
                                                                <div class="progress-bar  <%#SyncProgressBarType.Value %>" role="progressbar" aria-valuenow="40" id="iTaskProgress"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%=SyncProgressPercent.Value %>%">

                                                                  </div>
                                                                </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:250px; overflow-y:auto;padding:5px;" valign="top">
                                            <table width="100%">
                                                <tbody id="Running">

                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>

                                    </table>
                            </td>
                        </tr>
                    </table>
                                </div>
                                </td>
                        </tr>
                    </table>
                </div>

                <div class="wrapper" style="background-color: white; display:none; " id="page_3_div">
                    
                </div>
                <iframe id="page_5_div" src="/management/BackupSubtasks.aspx?child=1&vdid=<%=SessionDomainId%>&tid=<%=TeamFolderId.Value %>" style="display:none;" onload="ResizeIFrameHeight(this);" class="bkpIfrm">

                </iframe>


                <div class="content" style="display: none;text-align:left;" id="page_6_div">
                    <div class="row">
                        <div class="col-4"><p class="bkpP" style="padding-top:10px;"><asp:Localize runat="server" meta:resourcekey="str_KeeLasNSna0Unl">Keep last N snapshots</asp:Localize></p></div>
                        <div class="col-2"><asp:TextBox ID="BackupSnapshotCount" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();"  onkeypress="ShowSavePanel();" Text="0"></asp:TextBox></div>
                        <div class="col-6"><p class="bkpP" style="padding-top:10px;"><asp:Localize runat="server" meta:resourcekey="str_KeeLasNSna0UnlHlp">(0 - unlimited)</asp:Localize></p></div>
                    </div>
                    <div class="row">
                        <div class="col-4"><p class="bkpP" style="padding-top:10px;"><asp:Localize runat="server" meta:resourcekey="str_KeeSnaForAtLeaNDay0ConByOthPolOthOveAboPol">Keep snapshot for at least N days</asp:Localize></p>
                            </div>
                        <div class="col-2"><asp:TextBox ID="BackupSnapshotDays" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();" onkeypress="ShowSavePanel();" Text="0"></asp:TextBox></div>
                        <div class="col-6"><p class="bkpP" style="padding-top:10px;"><asp:Localize runat="server" meta:resourcekey="str_KeeSnaForAtLeaNDay0ConByOthPolOthOveAboPolHlp">(0 - controlled by other policies, otherwise override above policy)</asp:Localize></p></div>
                    </div>
                    <div class="row">
                        <div class="col-4"><p class="bkpP" style="padding-top:10px;"><asp:Localize runat="server" meta:resourcekey="str_GenFulBacSnaEveNDay0Nev">Generate full backup snapshot every N days</asp:Localize></p>
                            </div>
                        <div class="col-2"><asp:TextBox ID="FullBackupDays" runat="server" CssClass="form-control newTxtBx" onchange="ShowSavePanel();"  onkeypress="ShowSavePanel();" Text="0"></asp:TextBox></div>
                        <div class="col-6"><p class="bkpP" style="padding-top:10px;"><asp:Localize runat="server" meta:resourcekey="str_GenFulBacSnaEveNDay0NevHlp">(0 - never)</asp:Localize></p></div>
                    </div>
                </div>




                <div class="wrapper" style="<%if (!DeviceView){ %>display:;<%}%>" id="page_4_div">
                     <table width="100%"  align="center"  cellspacing="0"  
                cellpadding="0" style="background-color: transparent;">
                    <%if (LogRepeater.Items.Count != 0){ %>
                         <tr style=" border-bottom: 0px solid red; font-weight: 100;">
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0; color: #565656; font-size: 14px; width:42px;
                        border-top: 0px solid #d0d0d0;">
                        
                    </td>
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0; color: #565656; font-size: 14px; 
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_TasNam">Task Name</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_StaTim">Start Time</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_Dur">Duration</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:80px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_FilCou">File Count</asp:Localize></td>
                    <td style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px;width:180px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_TotFilSiz">Total File Size</asp:Localize></td>
                    <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_DelFil">Deleted Files</asp:Localize></td>
                                                 <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_Pro">Processed</asp:Localize></td>
                                                 <td  style="padding: 5px; border: 0px; border-bottom: 0px solid #d0d0d0;color: #565656;font-size: 14px; width:100px;
                        border-top: 0px solid #d0d0d0;"><asp:Localize runat="server" meta:resourcekey="str_FaiCou">Failed Count</asp:Localize></td>

                             </tr>
                    <asp:Repeater ID="LogRepeater" runat="server">
                    <ItemTemplate>
                        <tr class="filerow" style=" border-bottom: 0px solid red; font-weight: 100; cursor:default!important;">
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                               
                                <i class="sectextcolor gladinet-icons" style="font-size:24px;"><%#MaterialIconToGladIcon(DataBinder.Eval(Container.DataItem, "DipslayIconName"))%></i>
                                
                            </td>
                             <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;" align="left">
                                <%#DataBinder.Eval(Container.DataItem, "LogName")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "DisplayStartTime")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "Duration")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "FileCount")%>
                                
                            </td>
                             <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "DisplayFileSize")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "DeleteFileCount")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#404040;">
                                <%#DataBinder.Eval(Container.DataItem, "ProcessedCount")%>/<%#DataBinder.Eval(Container.DataItem, "TotalTaskCount")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;font-size:16px; font-weight:100; color:#800000;">
                                <span runat="server" visible='<%#Convert.ToInt64(DataBinder.Eval(Container.DataItem, "FailedCount")) != 0%>'>
                                    <a
                                        href="##"
                                        onclick='onDetail("<%#DataBinder.Eval(Container.DataItem, "LogName")%>", "<%#DataBinder.Eval(Container.DataItem, "TaskProcessId")%>");'
                                        style="color:inherit !important;"
                                        >
                                        <%#DataBinder.Eval(Container.DataItem, "FailedCount")%>
                                    </a>
                                </span>
                                <span runat="server" visible='<%#Convert.ToInt64(DataBinder.Eval(Container.DataItem, "FailedCount")) == 0%>'>
                                    <%#DataBinder.Eval(Container.DataItem, "FailedCount")%>
                                </span>
                            </td>
                        </tr>
                    </ItemTemplate>
                    </asp:Repeater>
                    <%}else { %>
                    <tr>
                    <td align="center">

                <h2 class="bkpHClr bkpNoDtaMsg"><asp:Localize runat="server" meta:resourcekey="str_noProLogFou">No process logs were found.</asp:Localize></h2>
               

                    </td>
                </tr>
                    <%} %>
               

                <%}else { %>
                 <tr>
                    <td align="center">
                <div style="padding-top:60px;font-size:18px; font-weight:100;">
                    <p class="bkpP"><asp:Localize runat="server" meta:resourcekey="str_bkpNotEblTemFld">Backup is not enabled for the team folder.</asp:Localize></p>
                    <asp:LinkButton ID="StartBackup" runat="server" CssClass="btn newBtn" OnClick="StartBackup_Click" meta:resourcekey="str_eblBkp">Enable Backup</asp:LinkButton>

                </div>
             
                        </td>
                </tr>
           <%}%>
                 </table>
    </div>

        </div>




</div>
</div>
</div>



</div>
</div>
</main>
</div>








    <div id="childwnd" style="width:100%; display:none;">
    <div width="100%" style="background-color: white;  border: 0px; padding-bottom:0px; align-content: right; border-bottom: 1px solid #f0f0f0; " >
        <table width="100%" style="border-collapse:collapse;" cellpadding="0" cellspacing="0" >
            <tr>
                <td>
                    <table>
                        <tr>
                <td style="padding:5px; font-size:18px; cursor:pointer;font-weight:100;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();"><asp:Localize runat="server" meta:resourcekey="str_sht">Snapshots</asp:Localize></td>
                                
                <td  style="padding:5px; font-size:18px;" class="sectextcolor ">></td>
                <td align="left" style="padding:5px;border-bottom: 0px solid #cccccc;padding-right:10px; height:48px; font-size:18px; font-weight:100;" id="child_title" >
                </td>

                        </tr>
                    </table>
                </td>
                    
                <td style="border-bottom: 0px solid #cccccc;padding-right:10px;">
                    <div style="float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                </td>
                </tr>
            </table>
        </div>
   
   
<iframe src="/portal/WaitWin.htm" style="margin-top:5px;" id="child_body" class="bkpIfrm"></iframe>
        </div>
    <div style="display:none">
        <asp:LinkButton ID="RefreshBtn" style="padding-left:10px;" runat="server" OnClick="RefreshBtn_Click" Text="Refresh"></asp:LinkButton>
         <asp:Localize meta:resourcekey="str_down" ID="str_down" runat="server" Visible="False">Download</asp:Localize>
                                  <asp:Localize meta:resourcekey="str_del" ID="str_del" Visible="False" runat="server">Delete Snapshot</asp:Localize>
                                  <asp:Localize meta:resourcekey="str_restore" ID="str_restore" Visible="False" runat="server">Restore to this version</asp:Localize>
                                  <asp:Localize meta:resourcekey="str_close" ID="str_close" Visible="False" runat="server">Close</asp:Localize>
                                  <asp:Localize meta:resourcekey="str_browse" ID="str_browse" Visible="False" runat="server">Browse Folder</asp:Localize>
        <asp:Button ID="ApplyBtn" runat="server" Text="Button" OnClick="ApplyBtn_Click" />
    <asp:HiddenField ID="TeamFolderId" runat="server" />         
        <asp:HiddenField ID="SnapshotId" runat="server" />         
    <asp:HiddenField ID="DipslayIconColor" runat="server" />
    <asp:HiddenField ID="DipslayIconName" runat="server" />
     <asp:HiddenField ID="SyncProgressBarType" runat="server" />        
     <asp:HiddenField ID="SyncProgressPercent" runat="server" />
        <asp:LinkButton ID="DeleteSnapshot" runat="server" OnClick="DeleteSnapshot_Click">DeleteSnapshot</asp:LinkButton>
        <asp:LinkButton ID="RefreshChangeLog" runat="server" OnClick="RefreshChangeLog_Click">DeleteSnapshot</asp:LinkButton>
        </div>
    
    <script type="text/javascript">


        function CloseChildWnd() {
            var f = document.getElementById('defaultcontent');
            f.style.display = "";


            f = document.getElementById('child_body');
            f.src = "/portal/WaitWin.htm";

            f = document.getElementById('childwnd');
            f.style.display = "none";

        }
        function OpenChildWnd(t, s) {
            var f = document.getElementById('defaultcontent');
            f.style.display = "none";


            f = document.getElementById('child_body');
            f.src = s;

            f = document.getElementById('childwnd');
            f.style.display = "";

            f = document.getElementById('child_title');
            f.innerHTML = t;

        }

        function closeCancelActiveWin() {
            CloseChildWnd();
        }

        function BrowseSnapshot(n, sid)
        {
            parent.OpenNextMenu("&#x139;",n, "/management/BackupMgr/UI/BackupSnapshotBrowser.aspx?tid=<%=TeamFolderId.Value%><% if (IsChildUi) { %>&child=1<%}%>&sid="+sid)
        }

        function DeleteSnapshot(n,s)
        {

            gConfirm("<asp:Localize runat="server" meta:resourcekey="str_cfmDltSht">Do you want to delete snapshot</asp:Localize>: '" + n + "'?", "", function (btn1) {

                if (btn1 != 'ok')
                    return;
                var btn = document.getElementById('ctl00_MainContent_DeleteSnapshot');
                var sname = document.getElementById('ctl00_MainContent_SnapshotId');

                sname.value = s;

                Wait('Applying');
                btn.click();
            });
        }

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            var s = 0 + size;
            if (isNaN(s))
                return "0";

            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        function AddRunningTask(res)
        {
            try{
                var e = document.getElementById("Running");
                e.innerHTML = "";

                var count = Math.floor((res.length - 8) / 4);
                for (var i = 0; i < count; ++i) {
                    var etr = document.createElement("tr");
                    etr.style.fontSize = "16px";
                    etr.style.borderBottom = "1px solid #f0f0f0";
                    var ttd = document.createElement("td");
                    ttd.innerHTML = res[8 + i * 4];
                    etr.appendChild(ttd);
                    ttd.style.width = "60px";
                    ttd.className = "sectextcolor";
                    ttd.fontSize = "24px!important";
                    var ntd = document.createElement("td");
                    ntd.innerHTML = GetShortString(res[8 + i * 4 + 1], 20);
                    etr.appendChild(ntd);


                    var ptd = document.createElement("td");
                    ptd.align = "right";
                    ptd.fontSize = "16px!important";
                    ptd.className = "sectextcolor";
                    if (res[8 + i * 4 + 2] != 0) {
                        ptd.innerHTML = FormatFileSize(res[8 + i * 4 + 3]) + "/" + FormatFileSize(res[8 + i * 4 + 2]);
                    }
                    etr.appendChild(ptd);

                    e.appendChild(etr);
                }
            } catch (eee) {

            }
        }

        function onChangeTaskStatus(s)
        {

            try{
                var tdr = document.getElementById("tdr");
                var tdp = document.getElementById("tdp");
                var tds = document.getElementById("tds");

                if (s == "<%=LocTskPnd.Text%>") {
                    tdr.style.display = "none";
                    tdp.style.display = "";
                    tds.style.display = "none";
                }
                else if (s == "<%=LocTskRng.Text%>") {
                    tdr.style.display = "none";
                    tdp.style.display = "";
                    tds.style.display = "none";

                } else if (s == "<%=LocTskPsd.Text%>") {
                    tdr.style.display = "";
                    tdp.style.display = "none";
                    tds.style.display = "none";
                } else if (s == "<%=LocTskCpt.Text%>") {

                    tdr.style.display = "none";
                    tdp.style.display = "none";
                    tds.style.display = "none";
                } else {
                    tdr.style.display = "";
                    tdp.style.display = "none";
                    tds.style.display = "";
                }
            } catch (e) {

            }

            var res = s.split(";");
            if (res.length == 1) {
                setHtml('ctl00_MainContent_DisplayStatus', s);
                return;
            }

            setHtml('ctl00_MainContent_DisplayStatus', res[0]);
            var ss = '<span class="alert-' + res[1] + ' fa fa-' + res[2] + '" style="font-size:64px!important; background-color:white!important; "></span>';
            setHtml('displayicon', ss);

            setHtml('starttime', res[3]);
            setHtml('filecount', res[4]);
            setHtml('backupsize', res[5]);
            setHtml('duration', res[6]);

            function setHtml(eid, html) {
                var el = document.getElementById(eid);
                if (el) el.innerHTML = html;
                return el;
            }
        }

        function ShowRunning(s)
        {
            var r = document.getElementById("tablerunning");
            var m = document.getElementById("SummaryTable");
            if (s) {
                r.style.display = "";
                m.style.display = "none";
            } else {
                r.style.display = "none";
                m.style.display = "";

            }
        }



        function OnPollRes(m) {
            try {
                if (m == null || m == ""){
                    return;
                }
                var e = document.getElementById("PollRes")
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = m.substring(4);
                    ShowRunning(false);
                    setTimeout("Poll()", 3000);
                    return;
                }
                e.innerHTML = "&nbsp;";

                var res = m.split("|");

                e = document.getElementById("iTotalTask");
                e.innerHTML = res[0];
                if (res.length >= 8) {
                    e.innerHTML = res[7];
                    ShowRunning(true);
                } else {
                    ShowRunning(false);

                }


                onChangeTaskStatus(res[4]);
                e = document.getElementById("iPendingTask");
                if(res[1] != "-1")
                    e.innerHTML = res[1];
                else
                    e.innerHTML = "";

                e = document.getElementById("iFailedTask");
                if (res[2] != "-1")
                    e.innerHTML = res[2];
                else
                    e.innerHTML = "";

                e = document.getElementById("iSkippedTask");
                if (res[3] != "-1")
                    e.innerHTML = res[3];
                else
                    e.innerHTML = "";


                e = document.getElementById("iTaskStatus");
                e.innerHTML = res[4];

                e = document.getElementById("iTaskProgress");
                e.style.width = res[5]+"%";

                e = document.getElementById("ProcessStatus");
                if (e) {
                    if (res.length >= 7) {
                        e.innerHTML = res[6];
                    } else {
                        e.innerHTML = "";

                    }
                }

                if (res.length >= 9) {
                    AddRunningTask(res);
                } else {
                    var e = document.getElementById("Running");
                    if(e)
                        e.innerHTML = "";

                }


            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }
        function Poll() {
            try {
                Ext.Ajax.request({
                    url: '/management/BackupMgr/UI/BackupTeamFolder.aspx?tid=<%=TeamFolderId.Value %>&vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {
                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        function onDetail(tn, id) {
            parent.OpenNextMenu('=', 'Failed task - ' + tn, "/management/BackupSubtasks.aspx?vdid=<%=SessionDomainId%>&tid=" + "<%=TeamFolderId.Value%>" + "&lid=" + id);
        }

        var oldOnload = window.onload;
        window.onload = function() {

            adjust();
            if (oldOnload) try { oldOnload(); } catch(x) { };

            <%if(m_ShowSummary){%>
            SetPage(1);
            <%}%>

            <%if(m_ShowChangeLog){%>
            ISetPage(4);
            <%}%>

            setTimeout("Poll()", 2000);
        };

        function adjust() {
            var e = document.getElementById("VersionDiv");
            if (e) {
                e.style.height = (document.documentElement.offsetHeight - 150) + "px";
            }
        }

        document.addEventListener("DOMContentLoaded", function () {
            $(window).on('shown.bs.modal', function () {
                ResizeParentIFrameH();
            });
            $(window).on('hidden.bs.modal', function () {
                ResizeParentIFrameH();
            });
        });
    </script>
</asp:Content>
