﻿<%@ Page Title="Backup Task Status" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="BackupTaskStatus.aspx.cs" Inherits="GladinetPayFlow.BackupTaskStatus"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <style type="text/css">
       
           
    </style>
    <script type="text/javascript">
        
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
    <asp:Localize runat="server" ID="LocMsgPrt" meta:resourcekey="str_msgPrt" Visible="false">missing parameter</asp:Localize>
    <asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
<asp:Localize runat="server" ID="LocFldRtvSncSts" meta:resourcekey="str_fldRtvSncSts" Visible="false">Failed to retrieve sync status</asp:Localize>
<asp:Localize runat="server" ID="LocTskPnd" meta:resourcekey="str_tskPnd" Visible="false">Task Pending</asp:Localize>
<asp:Localize runat="server" ID="LocTskRng" meta:resourcekey="str_tskRng" Visible="false">Task Running</asp:Localize>
<asp:Localize runat="server" ID="LocTskPsd" meta:resourcekey="str_tskPsd" Visible="false">Task Paused</asp:Localize>
<asp:Localize runat="server" ID="LocTskFld" meta:resourcekey="str_tskFld" Visible="false">Task Failed</asp:Localize>
<asp:Localize runat="server" ID="LocTskCpt" meta:resourcekey="str_cpt" Visible="false">Completed</asp:Localize>
<asp:Localize runat="server" ID="LocTskUkn" meta:resourcekey="str_tskUkn" Visible="false">Unknown</asp:Localize>

    <div class="meubardrop " style="height:32px; width:100%; <% if (IsChildUi){ %>box-shadow: 0px 0px white!important; <% } %>">
        </div>
    <table width="100%" id="defaultcontent" style="margin-top:20px;">
       <tr>
           <td align="center">
               <asp:Label ID="ErrorMsg" runat="server" Text=""></asp:Label>
           </td>
           
       </tr>
        <tr>
            <td align="center" >

                <div style="background-color: white; max-width:810px; min-height:300px;">
                    <table width="100%" id="SummaryTable">
                        <tr>
                            <td align="center" style="padding-top:30px;">
                                <table style="width:100%; max-width:800px; display:;" border="0" id="SummaryPanel">
                                    <tr>
                                        <td align="center" style="font-size:18px; font-weight:100;color:#404040;padding-top:30px;" id="summarytd">
                                            <asp:Localize runat="server" meta:resourcekey="str_tskPnd">Task Pending</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center">
                                            <div id="closediv" style="display:none;">
                                            <button class="btn btn-primary gladbtn" onclick="parent.CloseChildWnd();return false;">
                                            <asp:Localize runat="server" meta:resourcekey="str_cls">Close</asp:Localize>
                                            </button>
                                                </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:20px; color:red;" id="PollRes" align="center">&nbsp;</td>
                                    </tr>
                                            
                                </table>
                                
                               
                            </td>
                        </tr>
                    </table>
                    <table width="100%" id="tablerunning" style="display:none;">
                        <tr>
                            <td align="center" style="padding-top:10px;">
                                 <div  style="width:100%;max-width: 800px; border:0px solid #c0c0c0; border-radius:5px;padding:5px; display:;" id="RunningPanel">
                                <table width="100%">
                        <tr>
                            <td width="40%" style="padding-top:0px;" valign="top">
                                <table width="100%">
                                    <tr>
                                        <td colspan="2" style="font-size:16px; padding-bottom:20px;font-size:18px; font-weight:100;color:#404040;" align="center">
                                            <asp:Localize runat="server" meta:resourcekey="str_smr">Summary</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_sts">Status</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;" class="sectextcolor" id="iTaskStatus">
                                            <asp:Label ID="TaskStatus" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_totTsk">Total Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;" class="sectextcolor" id="iTotalTask">
                                            <asp:Label ID="TotalTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_pndTsk">Pending Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;" class="sectextcolor" id="iPendingTask">
                                            <asp:Label ID="PendingTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_fldTsk">Failed Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;" class="sectextcolor" id="iFailedTask">
                                            <asp:Label ID="FailedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_skpTsk">Skipped Tasks</asp:Localize></td>
                                        <td style="padding: 5px; border-bottom: 1px solid #f0f0f0;font-size: 14px; font-weight: 100; color:#404040;" class="sectextcolor" id="iSkippedTask">
                                            <asp:Label ID="SkippedTask" runat="server" Text=""></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="padding:10px; padding-top:20px;" align="right">
                                            <table>
                                                            <tr>
                                                                <td id="tdr" style="display:none;">                                                                    
                                                                    <asp:Button ID="Resume" runat="server" Text="Resume" CssClass="btn btn-primary gladbtn" OnClick="Resume_Click" />
                                                                </td>
                                                                <td id="tdp" style="display:none;">
                                                                    <asp:Button ID="Pause" runat="server" Text="Pause" CssClass="btn btn-primary gladbtn" OnClick="Pause_Click"  />
                                                                </td>

                                                                <td id="tds" style="display:none;">
                                                                    <asp:Button ID="Start" runat="server" Text="ReStart" CssClass="btn btn-primary gladbtn" OnClick="Start_Click"  />
                                                                </td>
                                                            </tr>
                                                        </table>
                                        </td>
                                    </tr>
                                     <tr>
                
            </tr>
                                </table>
                            </td>
                            <td style="width:1px; border-left: 1px solid#f4f4f4 ;">&nbsp;</td>
                            <td valign="top" style="padding-bottom:20px; border-left:0px solid #f0f0f0;">
                                <table width="100%" >
                                    <tr>
                                        <td  colspan="2" style="font-size:18px; font-weight:100;color:#404040;" align="center">
                                            <asp:Localize runat="server" meta:resourcekey="str_prg">Progress</asp:Localize>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" id="ProcessStatus" style="padding:5px;" class="sectextcolor">

                                        </td>
                                    </tr>
                                    <tr>
                                        <td width="120px" style="padding:5px;"><asp:Localize runat="server" meta:resourcekey="str_ovl">Overall</asp:Localize></td>
                                        <td >
                                            <div class="progress" style="width:100%;">
                                                                <div class="progress-bar  <%#SyncProgressBarType.Value %>" role="progressbar" aria-valuenow="40" id="iTaskProgress"
                                                                    aria-valuemin="0" aria-valuemax="100" style="width:<%=SyncProgressPercent.Value %>%">

                                                                  </div>
                                                                </div>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="2" style="height:250px; overflow-y:auto;padding:5px;" valign="top">
                                            <table width="100%">
                                                <tbody id="Running">

                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>

                                    </table>
                            </td>
                        </tr>
                    </table>
                                </div>
                                </td>
                        </tr>
                    </table>
                </div>
                <div  style="background-color: white; display:none; max-width:810px; ">
                    <table style="width:100%">
                        <tr>
                            <td align="right">
                                <button class="btn btn-primary gladbtn" onclick="parent.CloseChildWnd();return false;">
                                    <asp:Localize runat="server" meta:resourcekey="str_cls">Close</asp:Localize>
                                </button>
                            </td>
                        </tr>
                    </table>
                </div>
            </td>
        </tr>

    </table>

    <div style="display:none">
    <asp:HiddenField ID="TeamFolderId" runat="server" />                   
    <asp:HiddenField ID="DipslayIconColor" runat="server" />
    <asp:HiddenField ID="DipslayIconName" runat="server" />
     <asp:HiddenField ID="SyncProgressBarType" runat="server" />        
     <asp:HiddenField ID="SyncProgressPercent" runat="server" />
        
        </div>
    
    <script type="text/javascript">


       

        function stringStartsWith(s, p) {
            return (s.indexOf(p) == 0);
        }
        function GetShortString(src, MaxLen) {
            if (src.length <= MaxLen)
                return src;
            src = src.replace('[BuiltInGroup]', '');
            if (src.length <= MaxLen)
                return src;
            var len = (MaxLen - 3) / 2;
            var p1 = src.substring(0, len);
            var p2 = src.substring(src.length - len);
            return p1 + "..." + p2;

        }

        function FormatFileSize(size) {
            if (size < 1024) { //pow(2,10)
                return size + " B";
            } else if (size < 1048576) { //pow(2,20)
                return (Math.round(((size * 10) / 1024)) / 10) + " KB";
            } else if (size < 1073741824) { //pow(2,30)
                return (Math.round(((size * 10) / 1048576)) / 10) + " MB";
            } else if (size < 1099511627776) { //pow(2,40)
                return (Math.round(((size * 100) / 1073741824)) / 100) + " GB";
            } else if (size < 1125899906842624) { //pow(2,50)
                return (Math.round(((size * 100) / 1099511627776)) / 100) + " TB";
            } else { //pow(2,60)
                return (Math.round(((size * 100) / 1125899906842624)) / 100) + " PB";
            }
        }
        function AddRunningTask(res)
        {
            try{
                var e = document.getElementById("Running");
                e.innerHTML = "";

                var count = Math.floor((res.length - 8) / 4);
                for (var i = 0; i < count; ++i) {
                    var etr = document.createElement("tr");
                    etr.style.fontSize = "14px";
                    etr.style.borderBottom = "1px solid #f0f0f0";
                    var ttd = document.createElement("td");
                    ttd.innerHTML = res[8 + i * 4];
                    etr.appendChild(ttd);
                    ttd.style.width = "60px";
                    ttd.className = "sectextcolor";

                    var ntd = document.createElement("td");
                    ntd.innerHTML = GetShortString(res[8 + i * 4 + 1], 20);
                    etr.appendChild(ntd);


                    var ptd = document.createElement("td");
                    ptd.align = "right";
                    ptd.fontSize = "14px";
                    ptd.className = "sectextcolor";
                    if (res[8 + i * 4 + 2] != 0) {
                        ptd.innerHTML = FormatFileSize(res[8 + i * 4 + 3]) + "/" + FormatFileSize(res[8 + i * 4 + 2]);
                    }
                    etr.appendChild(ptd);

                    e.appendChild(etr);
                }
            } catch (eee) {

            }
        }
        
        function onChangeTaskStatus(s)
        {
            var tdr = document.getElementById("tdr");
            var tdp = document.getElementById("tdp");
            var tds = document.getElementById("tds");
            var e = document.getElementById("closediv");

            
            e.style.display = "none";
            if (s == "<%=LocTskPnd.Text%>") {
                tdr.style.display = "none";
                tdp.style.display = "";
                tds.style.display = "none";
            }
            else if (s == "<%=LocTskRng.Text%>") {
                tdr.style.display = "none";
                tdp.style.display = "";
                tds.style.display = "none";
                
            } else if (s == "<%=LocTskPsd.Text%>") {
                tdr.style.display = "";
                tdp.style.display = "none";
                tds.style.display = "none";
            } else if (s == "<%=LocTskCpt.Text%>") {
                
                tdr.style.display = "none";
                tdp.style.display = "none";
                tds.style.display = "none";

                e.style.display = "";
            } else {
                tdr.style.display = "";
                tdp.style.display = "none";
                tds.style.display = "";
            }
        }

        function ShowRunning(s)
        {

            var r = document.getElementById("tablerunning");
            var m = document.getElementById("SummaryTable");
            if (s) {
                r.style.display = "";
                m.style.display = "none";
            } else {
                r.style.display = "none";
                m.style.display = "";

            }
        }
        function OnPollRes(m) {
            try{
                var e = document.getElementById("PollRes")
                if (stringStartsWith(m, "bad^")) {
                    e.innerHTML = m.substring(4);
                    ShowRunning(false);
                    setTimeout("Poll()", 3000);
                    return;
                }
                e.innerHTML = "&nbsp;";
                
                var res = m.split("|");
                
                e = document.getElementById("iTotalTask");
                e.innerHTML = res[0];
                if (res.length >= 8) {
                    e.innerHTML = res[7];
                    ShowRunning(true);
                } else {
                    if (res.length == 6) {
                        var e1 = document.getElementById("summarytd");
                        e1.innerHTML = res[4];
                        
                    }
                    ShowRunning(false);
                }

               

                e = document.getElementById("iPendingTask");
                e.innerHTML = res[1];
                
                e = document.getElementById("iFailedTask");
                e.innerHTML = res[2];
                e = document.getElementById("iSkippedTask");
                e.innerHTML = res[3];

                e = document.getElementById("iTaskStatus");
                e.innerHTML = res[4];

                e = document.getElementById("iTaskProgress");
                e.style.width = res[5]+"%";
                
                e = document.getElementById("iTaskStatus");
                if (res.length >= 7) {                    
                    e.innerHTML = res[6];
                } 

                if(res.length >= 9){
                    AddRunningTask(res);
                } else {
                    var e = document.getElementById("Running");
                    e.innerHTML = "";

                }

                onChangeTaskStatus(res[4]);
            } catch (ee) {

            }
            setTimeout("Poll()", 1000);
        }

        function Poll() {


            try {
                Ext.Ajax.request({
                    url: '/management/BackupMgr/UI/BackupTaskStatus.aspx?tid=<%=TeamFolderId.Value %>&vdid=<%=SessionDomainId%>&poll=1',
                    success: function (response) {

                        OnPollRes(response.responseText);
                    },
                    failure: function () {
                        OnPollRes('bad^unknown');
                    },
                    method: 'GET'
                });

            } catch (e) {
                alert(e);
            }


        }

        function AdjustSize() {


          
            
        }


        Ext.onReady(function () {
            
            AdjustSize();
            setTimeout("Poll()", 2000);
            

        });

        Ext.EventManager.onWindowResize(function () {
                       

            AdjustSize();
        });

    </script>
</asp:Content>
