﻿<%@ Page Title="Restore Team Folders" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantBackupRestoreTeamFolder.aspx.cs" Inherits="GladinetPayFlow.TenantBackupRestoreTeamFolder"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>
    <style type="text/css">       
    </style>
    <script type="text/javascript">
        function OnLocalRestore(f) {
            
            window.location = "/portal/RestoreFolder.aspx?f="+f+"&vdid=<%=CurrentTeantId.Value%>&edittenant=1";
        }

        function OnCloudRestore(sid) {
            
            var b = document.getElementById("ctl00_MainContent_GetSnapShotBtn");
            var s = document.getElementById("ctl00_MainContent_TeamFolderId");
            
            s.value = sid;
            
            b.click();
            
        }
        function BrowseSnapshot(n, sid)
        {
            parent.OpenChildWnd(n, "/management/BackupMgr/UI/BackupSnapshotBrowser.aspx?vdid=<%=SessionDomainId%><% if (IsChildUi){ %>&child=1<%}%>&tid=<%=TeamFolderId.Value%>&sid=" + sid)
        }

    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToLoaSna" meta:resourcekey="str_faiToLoaSna" Visible="false">Failed to load snapshots</asp:Localize>
<asp:Localize runat="server" ID="LocFaiToEnaBac" meta:resourcekey="str_faiToEnaBac" Visible="false">Failed to enable backup</asp:Localize>
    <asp:Localize runat="server" ID="LocBts" meta:resourcekey="str_bts" Visible="false">Bytes</asp:Localize>
    <asp:Localize runat="server" ID="LocCrt" meta:resourcekey="str_crt" Visible="false">Current</asp:Localize>
<asp:Localize runat="server" ID="LocDysAgo" meta:resourcekey="str_dysAgo" Visible="false">days ago</asp:Localize>
<asp:Localize runat="server" ID="LocScsAgo" meta:resourcekey="str_scsAgo" Visible="false">less than 1 minute ago</asp:Localize>
<asp:Localize runat="server" ID="LocHrsAgo" meta:resourcekey="str_hrsAgo" Visible="false">hours ago</asp:Localize>
<asp:Localize runat="server" ID="LocMnsAgo" meta:resourcekey="str_mnsAgo" Visible="false">minutes ago</asp:Localize>





<div class="c-body" style="clear:both;margin-top:20px;">
<main class="c-main">
<div class="container-fluid">
<div class="fade-in">



<div id="pageContainerCard" class="">


<%if (!string.IsNullOrEmpty(ErrorMsg.Text)) { %>
<div id="container errmsgdiv">
    <asp:Label ID="ErrorMsg" runat="server" CssClass="alert alert-warning alert-dismissible" meta:resourcekey="ErrorMsgResource1"></asp:Label>
</div>
<%} %>


<div class="card-body">
<div class="justify-content-between">




    <table width="100%">
    
        <tr>
            <td align="center" style="">
            <%if(!SnapShotPanel.Visible) { %>
           <%if (TeamFolderRepeater.Items.Count != 0){ %>
                <div style="max-height:500px; overflow:auto;">
                <table style="width:100%; " >
            <tr>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;" width="32px"></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;"><asp:Localize runat="server" meta:resourcekey="str_nme">Name</asp:Localize></td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;" colspan="2" align="center"></td>
            </tr>
            
            <asp:Repeater ID="TeamFolderRepeater" runat="server" >
                <ItemTemplate> 
                    <tr class=" filerow">
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;" width="32px">
                   
                </td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;">
                    <%# DataBinder.Eval(Container.DataItem, "ShareName")%>
                </td>
                <td style="border-bottom:1px solid #f0f0f0; padding:3px;width:50px">
                    
                    <a class="" onclick='OnCloudRestore("<%# DataBinder.Eval(Container.DataItem, "ShareUid") %>"); return false;' style=" <%# DataBinder.Eval(Container.DataItem, "CloudRestoreDisplay")%>"><i class="gladinet-icons md-32 md-dark hand" style="display: inline-block; margin-top: 8px;" title="Restore">&#x13B;</i></a>
                </td>
                        </tr>
                </ItemTemplate> 
            </asp:Repeater>
        </table>
                    </div>
                    <%}else { %>
                <div style="padding-top:60px;width:100%;">
                <table width="100%">
                    <tr>
                        <td align="center" style="">
                <asp:Localize runat="server" meta:resourcekey="str_noTemFldCfg">No Team Folders are configured for backup.</asp:Localize><br />
                
                        </td>
                    </tr>
                </table>

            </div>
                    <%}%>
            
            <%}else { %>
                <table style="width:100%; ">
                      <tr style=" border-bottom: 0px solid red; font-weight: 100;">
                    
                    <td  style="padding: 5px; border:none;">
                        <asp:Localize runat="server" meta:resourcekey="str_shtNme">Snapshot Name</asp:Localize>
                    </td>
                    <td style="padding: 5px; border:none;width:180px;">
                        <asp:Localize runat="server" meta:resourcekey="str_stgUsg">Storage Usage</asp:Localize>
                    </td>
                    <td style="padding: 5px; border:none;width:180px;">
                        <asp:Localize runat="server" meta:resourcekey="str_crtTme">Creation Time</asp:Localize>
                    </td>
                    <td  style="padding: 5px; border:none;width:180px;">
                        <asp:Localize runat="server" meta:resourcekey="str_crtBy">Created by</asp:Localize>
                    </td>
                   <td></td>
                    
                </tr>
                
               
                <asp:Repeater ID="VersionRepeat" runat="server">
                    <ItemTemplate>
                        <tr style="border-top: 1px solid #f0f0f0; padding: 5px 5px 5px 5px;" class="filerow" onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'>
                          
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                                <%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>
                                
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "StorageDisplayName")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "CreateTimeDisplay")%>
                            </td>
                            <td style="padding: 10px; border-bottom: 1px solid #f8f8f8;">
                               <%#DataBinder.Eval(Container.DataItem, "UpdateDisplayName")%>
                            </td>
                           
                          <td style="border-bottom:1px solid #f0f0f0; padding:3px;width:80px" nowrap>
                    
                    <button class="btn btn-primary" onclick='BrowseSnapshot("<%#DataBinder.Eval(Container.DataItem, "SnapshotName")%>","<%# DataBinder.Eval(Container.DataItem, "SnapshotId").ToString().Replace("'","%27") %>");return false;'><i class="gladinet-icons md-32 md-dark hand center " style="display: inline-block; margin-top: 8px;" title="Restore">&#x13B;</i></button>
                </td>
                            
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
                </table>
            <%} %>  
            <table style="width:100%; ">
                    <tr>
                        <td style="padding:10px;padding-top:20px;" align="right">
                             <%if (SnapShotPanel.Visible && BackBtnPanel.Visible){ %>
                            <button class="btn newBtn" onclick="OnBack();return false;"><asp:Localize runat="server" meta:resourcekey="str_bck">Back</asp:Localize></button>                            
                            <%} %>
                            <%if(!IsServo) { %>
                            <button class="btn newSecBtn" onclick="OnCancel();" style="margin-left:10px;"><asp:Localize runat="server" meta:resourcekey="str_cnl">Cancel</asp:Localize></button>
                            <%} %>
                        </td>
                    </tr>
                </table>
                    
            </td>
        </tr>
    </table>






</div>
</div>
</div>



</div>
</div>
</main>
</div>




    
    <div style="display:none">
        <asp:HiddenField ID="CurrentTeantId" runat="server" />
        <asp:HiddenField ID="TeamFolderId" runat="server" />
        <asp:Panel ID="BackBtnPanel" runat="server"></asp:Panel>
        <asp:Panel ID="SnapShotPanel" Visible="false" runat="server"></asp:Panel>
        <asp:LinkButton ID="GetSnapShotBtn" runat="server" OnClick="GetSnapShotBtn_Click" meta:resourcekey="str_getSht">Get SnapShot</asp:LinkButton>
    </div>
    

    <script type="text/javascript">

        function OnCancel()
        {
            <% if (IsChildUi) {
            //If the page is loaded in the main frame body
            %>
            parent.OpenTeamFolderBackMgr();
            <% } else { 
            //If the page is loaded within a modal popup         
            %>
            parent.CloseChildWnd();
            <% } %>
            
        }
    
        function OnBack() {

            window.location = "ClusterBackupRestoreTeamFolder.aspx";

        }


        function adjust() {

        }


    </script>
</asp:Content>
