﻿<%@ Page Title="Device Backups" Language="C#" MasterPageFile="~/WebAppPanel.master"
    AutoEventWireup="true" CodeBehind="TenantBackupDevices.aspx.cs" Inherits="GladinetPayFlow.TenantBackupDevices"
    Culture="auto" meta:resourcekey="PageResource1" UICulture="auto" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <script src="/management/bootstrap4/js/Chart.bundle.min.js"></script>

    <style type="text/css">
        
         td {
            font-size: 15px;
            
            font-weight: 100;
        }
        
        b {
            font-weight: 500;
        }
        
     
        

         .titlecol
         {
             background-color: #f0f0f0;
             font-size: 14px;
         }
        
        .style1
        {
            width: 153px;
        }
        
        .newusericon
        {
            background-image: url(images/upgradeuser.png);
        }
        
           .active {
           background-color: #565656;
       }
       
       li {
           background-color: transparent;
       }
    </style>
    <script type="text/javascript">

        function SelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = true;
                }
            }
        }

        function DeSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = false;
                }
            }
        }

        function ReSelectAll() {
            var Users = document.getElementsByTagName("input");

            for (var i = 0; i < Users.length; ++i) {
                if (Users[i].type == "checkbox") {
                    Users[i].checked = !Users[i].checked;
                }
            }
        }



        var activewin;
        function closeCancelActiveWin() {
            activewin.close();
        }

        function closeActiveWin() {
            window.location = window.location;
        }

        function OnCancelPub() {
            parent.closeActiveWin();
        }

        function OnRefresh() {
            var rowURL = window.location.href;
            var e = document.getElementById("ImgContainer");

            if (rowURL.indexOf("id=") == -1)
                window.location.href = window.location.href + "?id=" + (new Date()).toString();
            else
                window.location.href = window.location.href + "&id=" + (new Date()).toString();
        }
      
    </script>
</asp:Content>
<asp:Content ID="BodyContent" runat="server" ContentPlaceHolderID="MainContent">
<asp:Localize runat="server" ID="LocFaiToStaBacTheDev" meta:resourcekey="str_faiToStaBacTheDev" Visible="false">Failed to start backup the device</asp:Localize>
<asp:Localize runat="server" ID="LocNotFou" meta:resourcekey="str_notFou" Visible="false">not found</asp:Localize>
    <div style="width: 100%; overflow: auto;margin-top:3px;" id="defaultcontent" >
    <div class="meubardrop"  style="width:100%;<% if (IsChildUi){ %>box-shadow: 0px 0px white!important; border-bottom:1px solid #f0f0f0!important;<% } %>">
    <table width="100%">
        <tr>
            <td style="padding:20px; ">
                   <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="OnRefresh();return false;" class="toolnavbtn">
                             <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;" title="Refresh" >&#xB5;</i>
                             <span style="font-weight:100; font-size:16px; color:#404040;"><%=LinkButton2.Text %></span>
                         </div> 
                 <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="parent.AddDevice();return false;" class="toolnavbtn">
                             <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;"  >&#x173;</i>
                             <span style="font-weight:100; font-size:16px; color:#404040;"><asp:Localize runat="server" meta:resourcekey="str_addDvcBkp">Add device to backup</asp:Localize></span>
                         </div> 
                <div style="display:inline-block; padding-right:10px; cursor:pointer;" onclick="parent.DeviceSettings();return false;" class="toolnavbtn">
                             <i class="gladinet-icons md-24 md-dark hand center " style="display: inline-block; margin-top: -3px; padding-right:2px;"  >g</i>
                             <span style="font-weight:100; font-size:16px; color:#404040;"><asp:Localize meta:resourcekey="str_devBacSet" runat="server">Device backup settings</asp:Localize></span>
                         </div> 
        
            </td>
            <td>
                <div id="errmsgdiv" >
                <b>
                    <asp:Label ID="ErrorMsg" runat="server" Style="color: Red;" meta:resourcekey="ErrorMsgResource1"></asp:Label></b>
            </div>
            </td>
           
            <td  style="padding:10px; width:62px; display:none;" align="right">
                 <div  class="btn btn-primary gladbtn " style="margin-right: 8px;display:table;" title="<%=LinkButton2.Text %>">
                <i class="gladinet-icons md-32 md-dark hand" onclick="OnRefresh();return false;" style="display:table-cell;">µ</i>
                <div style="display:table-cell;vertical-align:top;padding-left:5px; display:none;"><asp:LinkButton ID="LinkButton2" runat="server" Text="Refresh" meta:resourcekey="str_rfh" OnClientClick="OnRefresh();return false;"  ForeColor="#565656"></asp:LinkButton></div>
            </div>
            </td>
        </tr>
    </table>
        </div>
      
     
    <div style="width:100%; overflow:auto; background-color:white;" id="rowcontainer">
        <%if (ListPanel.Visible){ %>
                <table width="100%">
            <tr>
                <td align="center" style="">
                    <%if (EmptyPanel.Visible) { %>
                    <div style="padding:10px; background-color:white; border-radius:3px;width:100%; max-width:800px;padding-top:100px; height:240px;  font-size:24px; color:#565656; font-weight:100;">
                        <asp:Localize runat="server" meta:resourcekey="str_noDvcCfg">No device is configured for backup yet.</asp:Localize>
                        <br />
                        <asp:LinkButton ID="LinkButton1" runat="server" OnClick="AddDeviceToBackup_Click" OnClientClick="parent.AddDevice();return false;" ><span style="font-size:16px!important"><asp:Localize runat="server" meta:resourcekey="str_AddDevToBac">Add Device to Backup</asp:Localize></span></asp:LinkButton>
                    </div>
                    <%}else { %>
                    <table style="width:100%; display:none;">
                        <tr>
                            <td><asp:Localize runat="server" meta:resourcekey="str_hstNme">Host Name</asp:Localize></td>
                            <td><asp:Localize runat="server" meta:resourcekey="str_owrEml" ID="str_ownEml">Owner Email</asp:Localize></td>
                            <td><asp:Localize runat="server" meta:resourcekey="str_os" ID="str_os">OS</asp:Localize></td>
                            <td><asp:Localize runat="server" meta:resourcekey="str_bkpPrf" ID="str_bkpPfl">Backup Profile</asp:Localize></td>
                            <td><asp:Localize runat="server" meta:resourcekey="str_strBkp">Start Backup</asp:Localize></td>
                            <td width="68px"></td>
                        </tr>
                        </table>
                        <asp:Repeater ID="TargetRepeater" runat="server" enableviewstate="false" >
                                            <ItemTemplate>         
                                                <div style="border-bottom:1px solid #f0f0f0; font-weight: 100; padding: 10px;padding-top:10px;" class="filerow">
                                                    <table width="100%">
                                                        
                                                         <tr>
                                                            <td colspan="2" style="padding-left:10px;">
                                                                <div class="toolnavbtn" onclick='onViewDevDetail("<%# DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%# DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'  style="display:inline-block;">
                                                                    <i class="gladinet-icons md-24 md-dark hand center toolbtn" style="display: inline-block; margin-top: -3px;" >&#x139;</i>
                                                                    <span style="padding-left:10px; font-size: 16px; color: #202020;"><%#DataBinder.Eval(Container.DataItem, "HostName")%></span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2" style="padding: 10px; padding-bottom: 3px; color: #808080; font-size: 10px; font-weight: 100;">
                                                                <span><%=str_ownEml.Text %></span>
                                                                <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"UserEmail") %></span>
                                                                <span style="width: 15px">&nbsp;</span>
                                                                
                                                                <span style="width: 10px">&nbsp;</span>
                                                                <span><%=str_os.Text %></span>
                                                                <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"OsVer") %></span>
                                                                <span style="width: 10px">&nbsp;</span>
                                                                <span><%=str_bkpPfl.Text %></span>
                                                                <span style="color:#202020; padding-left:3px;"><%# DataBinder.Eval(Container.DataItem,"ProfileDisplayName") %></span>

                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td colspan="2" style="padding: 10px; padding-bottom: 3px; color: #808080; font-size: 10px; font-weight: 100;">
                                                                <div style="display:inline-block; cursor:pointer;" class="toolnavbtn"  onclick='onViewDevDetail("<%# DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%# DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'>
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:-3px; font-size:12px" >&#xDB;</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; " ><asp:Localize meta:resourcekey="str_manage" runat="server">Manage</asp:Localize></span>
                                                                </div>
                                                                <div style="display:inline-block;width:15px">&nbsp;</div>
                                                                <div style="display:inline-block;cursor:pointer;" class="toolnavbtn" onclick='onStop("<%# DataBinder.Eval(Container.DataItem, "InstanceId")%>","<%# DataBinder.Eval(Container.DataItem, "HostName")%>");return false;'>
                                                                     <i class="gladinet-icons sectextcolor hand center" style="display: inline-block;margin-top:0px; font-size:10px" >&#xFB;</i>
                                                                        <span   style="font-size:10px; font-weight:100; color:#202020; "><asp:Localize meta:resourcekey="str_disBac" runat="server">Disable Backup</asp:Localize></span>
                                                                </div>
                                                            </td>
                                                        </tr>
                                                    </table>

                                                </div>
                                                
                                            </ItemTemplate>         
                                             </asp:Repeater>
                    
                    <%} %>
                </td>
            </tr>
            </table>
        <%}else { %>
        <table width="100%">
            <tr>
                <td align="center" style="padding-top:50px;">

                    <div style="padding:10px; background-color:white; width:100%; max-width:800px; border:1px solid #cccccc;border-radius:3px;">
                        <table style="width:100%; max-width:800px;">
                            <tr>
                                <td style="padding:5px;border-bottom:1px solid #f0f0f0; " align="right" colspan="2">
                                    <table>
                                        <tr>
                                            <td>
                                                <asp:Label ID="AddErrorMsg" runat="server" Text="" ForeColor="Red"></asp:Label>
                                            </td>
                                        </tr>
                                <tr>

                                    <td>
                                        <asp:DropDownList ID="Field" runat="server" AutoPostBack="True" OnSelectedIndexChanged="Field_SelectedIndexChanged" CssClass="browser-default custom-select secsubbordercolor"
                                            meta:resourcekey="FieldResource1">
                                        </asp:DropDownList>
                                    </td>
                                    <td style="padding-left: 3px; padding-right: 8px; padding-top:8px;">
                                        <asp:TextBox ID="FileName" Width="250px" runat="server" meta:resourcekey="FileNameResource1"
                                            CssClass="form-control dark"></asp:TextBox>
                                        </td><td>
                                        <asp:DropDownList ID="ActionName" runat="server" meta:resourcekey="ActionNameResource1" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                        </td><td>
                                        <asp:DropDownList ID="StatusList" runat="server" meta:resourcekey="ActionNameResource1" CssClass="browser-default custom-select secsubbordercolor">
                                        </asp:DropDownList>
                                    </td>
                                    <td width="80px">
                                        <asp:Button ID="Button1" runat="server" Text="Search" OnClick="Button1_Click" meta:resourcekey="Button1Resource1" CssClass="btn btn-primary gladbtn"
                                            />
                                    </td>
                                </tr>
                            </table>
                                </td>
                                
                            </tr>
                            <tr>
                                <td style="padding-top:20px; height:400px; overflow:auto;" valign="top" colspan="2">
                                    <table width="100%">
                                         <asp:Repeater ID="DevicesRepeater" runat="server" enableviewstate="false" >
                                            <ItemTemplate>         
                                                <tr style="border-bottom:1px solid #e0e0e0;">
                                                    <td style="padding:5px;">
                                                        <input type='checkbox' name='uu_<%# DataBinder.Eval(Container.DataItem,"InstanceId") %>' value='1' />
                                                    </td>
                                                    <td style="padding:5px;"><%# DataBinder.Eval(Container.DataItem,"UserEmail") %></td>
                                                    <td style="padding:5px;"><%# DataBinder.Eval(Container.DataItem,"HostName") %></td>
                                                    <td style="padding:5px;"><%# DataBinder.Eval(Container.DataItem,"OsVer") %></td>
                                                </tr>
                                            </ItemTemplate>         
                                             </asp:Repeater>
                                    </table>
                                </td>
                            </tr>
                                                    <tr>
                                <td style="padding-top:20px; overflow:auto;" valign="top" colspan="2" align="right">
                                    <table >
                                        <tr>
                                            <td style="padding:3px;"><asp:Localize runat="server" meta:resourcekey="str_UsiPro">Using Profile:</asp:Localize></td>
                                            <td style="padding:3px;">
                                                <asp:DropDownList ID="DeviceProfileList" Width="300px" CssClass="browser-default custom-select secsubbordercolor" runat="server"></asp:DropDownList></td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td style="padding:10px;" >
                                    <table width="100%">
                                        <tr>
                                            <td> <table>
                                    <tr>
                                        <td>
                                            <a href="#" onclick="SelectAll();return false;" style="padding-left: 10px; padding-right: 10px;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       color: #008000">
                                                <asp:Localize ID="Localize1" meta:resourcekey="asp_string5" runat="server" Text="Select All"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <a href="#" onclick="DeSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                <asp:Localize ID="Localize2" meta:resourcekey="asp_string6" runat="server" Text="Deselect All"></asp:Localize></a>
                                        </td>
                                        <td>
                                            <a href="#" onclick="ReSelectAll();return false;" style="padding-right: 10px; color: #008000">
                                                <asp:Localize ID="Localize3" meta:resourcekey="asp_string7" runat="server" Text="Undo Selection"></asp:Localize></a>
                                        </td>
                                    </tr>
                                </table></td>
                                        </tr>
                                    </table>
                                </td>
                                <td align="right">
                                    <asp:Button ID="AddDevices" runat="server" meta:resourcekey="str_add" Text="Add" OnClick="AddDevices_Click" cssclass="btn btn-primary gladbtn"/>
                                    <asp:Button ID="CancelAddDevices" runat="server" meta:resourcekey="str_can" Text="Cancel" OnClick="CancelAddDevices_Click" cssclass="btn btn-primary gladbtn"/>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
            </tr>
        </table>
        <%} %>
        </div>
          </div>

    <div id="childwnd" style=" padding:0px;  width:100%; display:none;">
   
   <div style="width:100%;"" id="childin" class="meubardrop">
   <table width="100%" style="border-collapse:collapse;" cellpadding="0" cellspacing="0" >
            <tr style="border-top:1px solid #dddddd;">
                

                 
                <td style="padding-bottom:3px;">
                    <table >
                        <tr>
                
                                
                <td style="padding:5px; font-size:18px; cursor:pointer;" class="sectextcolor toolnavbtn" onclick="CloseChildWnd();"><asp:Localize runat="server" meta:resourcekey="str_DevBac">Device Backups</asp:Localize></td>
                <td  style="padding:5px; font-size:18px;" class="sectextcolor ">></td>
                                <td align="left" style="padding:5px;border-bottom: 0px solid #cccccc;padding-left:10px; height:48px; font-size:18px;font-weight:100;color:#404040;" id="child_title" ></td>

                        </tr>
                    </table>
                </td>
                    
               <td style="border-bottom: 0px solid #cccccc;padding-right:10px;" align="right">
                    <div style="padding-left:10px; float:right; font-size:32px;  font-weight:100; cursor:pointer;" class="sectextcolor" onclick="CloseChildWnd();">&times;</div>
                </td>
                </tr>
            </table>
       </div>
    <iframe width="100%" src="/portal/WaitWin.htm" frameborder="0" style="margin-top:20px;" 
                    border="0"  id="child_body"></iframe>
        
        </div>
    <div style="display:none;">
         <asp:Button ID="StopBackup" runat="server" Text="StopBackup" OnClick="StopBackup_Click" />
        <asp:HiddenField ID="TargetId" runat="server" />
        <asp:Panel ID="ListPanel" runat="server" ></asp:Panel>
        <asp:Panel ID="EmptyPanel" runat="server" ></asp:Panel>
        <asp:HiddenField ID="DeviceTeamfolderId" runat="server" />

        <asp:Localize meta:resourcekey="str_ddl_usrEml" ID="LocUsrEml"  Visible="false" runat="server">User Email</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_dvcTpe" ID="LocDvcTpe"  Visible="false" runat="server">Device Type</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_hstNme" ID="LocHstNme"  Visible="false" runat="server">Host Name</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_oprStm" ID="LocOprStm"  Visible="false" runat="server">Operating System</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_cntSfw" ID="LocCntSfw"  Visible="false" runat="server">Client Software Version</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sts" ID="LocSts"  Visible="false" runat="server">Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncSts" ID="LocSncSts"  Visible="false" runat="server">Sync Status</asp:Localize>

<asp:Localize meta:resourcekey="str_ddl_acd" ID="LocAcd"  Visible="false" runat="server">Accepted</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_rjd" ID="LocRjd"  Visible="false" runat="server">Rejected</asp:Localize>
                
<asp:Localize meta:resourcekey="str_ddl_snc" ID="LocSnc"  Visible="false" runat="server">Syncing</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fld" ID="LocFld"  Visible="false" runat="server">Failed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncCpd" ID="LocSncCpd"  Visible="false" runat="server">Sync Completed</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_fldRtvSts" ID="LocFldRtvSts"  Visible="false" runat="server">Failed to Retrieve Sync Status</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPnd" ID="LocSncTskPnd"  Visible="false" runat="server">Sync Task Pending</asp:Localize>
<asp:Localize meta:resourcekey="str_ddl_sncTskPsd" ID="LocSncTskPsd"  Visible="false" runat="server">Sync Task Paused</asp:Localize>

<asp:Localize meta:resourcekey="str_dvcFnd" ID="LocDvcFnd"  Visible="false" runat="server">Device(s) found</asp:Localize>
        
    </div>
        <script type="text/javascript">
            function CloseChildWnd() {
                var f = document.getElementById('defaultcontent');
                f.style.display = "";


                f = document.getElementById('child_body');
                f.src = "/portal/WaitWin.htm";

                f = document.getElementById('childwnd');
                f.style.display = "none";

            }
            function OpenChildWnd(t, s) {

                var f = document.getElementById('defaultcontent');
                f.style.display = "none";


                f = document.getElementById('child_body');
                f.src = s;

                f = document.getElementById('childwnd');
                f.style.display = "";

                f = document.getElementById('child_title');
                f.innerHTML = t;

            }

            function closeActiveWin() {
                CloseChildWnd();
                var e = document.getElementById("main_body");
                e.src = e.src;
            }

            function closeCancelActiveWin() {
                CloseChildWnd();
            }

        function onViewDevDetail(id, n) {
             parent.OpenSecondMenu("&#x104;",n, "/management/BackupDeviceInfo.aspx?child=1&vdid=<%=SessionDomainId%>&id=" + id);
        }
        
        function onStop(id, n) {
            gConfirm("Please confirm to disable backup of the device:" + n, "", function (btn, tex) {
                if (btn == 'yes' || btn == 'ok') {
                    var e = document.getElementById("ctl00_MainContent_StopBackup");
                    var t = document.getElementById("ctl00_MainContent_TargetId");
                    t.value = id;
                    Wait("...");
                    e.click();
                }
            });
        }

    function onTaskDetail()
        {
            OpenChildWnd("<asp:Localize runat="server" meta:resourcekey="str_dvcBkpTskSts">Device Backup Task Status</asp:Localize>" , "/management/BackupDeviceTeamFolder.aspx?child=1&vdid=<%=SessionDomainId%>&tid=<%=DeviceTeamfolderId.Value%>" );
        }
    
        
        function adjust(){
            
                var e = document.getElementById("rowcontainer");
                e.style.height = (document.documentElement.offsetHeight - 73) + "px";



                e = document.getElementById("childwnd");
                e.style.height = (document.documentElement.offsetHeight - 20) + "px";
                e = document.getElementById("child_body");
                e.style.height = (document.documentElement.offsetHeight - 120) + "px";
               
            }

            Ext.onReady(function () {
                
                adjust();   
                
            });

        </script>
</asp:Content>
