﻿<%@ Page Title="Tenant Backup Console" Language="C#" MasterPageFile="~/UIFrameWork/ManagementConsole.master"
    AutoEventWireup="true" CodeBehind="TenantBackupConsole.aspx.cs" Inherits="GladinetPayFlow.TenantBackupConsole"
    Culture="auto" UICulture="auto" EnableViewState="False" %>

<asp:Content ID="HeaderContent" runat="server" ContentPlaceHolderID="HeadContent">
    <link rel="stylesheet" href="/management/UIFrameWork/gladcoretheme.aspx"  type="text/css" />	
    <style type="text/css">       
    </style>
    <script type="text/javascript">
        function OnMMC() {
            window.location = "/management/tenantconsole";
        }
        function OnFiles() {
            window.location = "/portal/files";
        }
        function OpenDeviceBackMgr() {
            SetBreadCrumAndOpenPage("Device Backups", "/management/BackupMgr/TUI/TenantBackupDevices.aspx?child=1&vdid=<%=SessionDomainId%>", 1);
        }
        function OnDashboard() {
            SetBreadCrumAndOpenPage("Tenant Dashboard", "/management/BackupMgr/TUI/TenantBackupDashboard.aspx?vdid=<%=SessionDomainId%>", 1);
        }
        function OpenTeamFolderBackMgr() {
            SetBreadCrumAndOpenPage("Team Folder Backups", "/management/BackupMgr/TUI/TenantBackupTeamFolders.aspx?child=1&vdid=<%=SessionDomainId%>", 1);
        }
        function AddTeamFolder() {
            SetBreadCrumAndOpenPage("Add Team Folder Backup", "/management/BackupMgr/TUI/TenantBackupAddTeamFolder.aspx?child=1&vdid=<%=SessionDomainId%>", 1);
        }      
        function DeviceSettings() {
            SetBreadCrumAndOpenPage("Settings", "/management/BackupMgr/TUI/TenantBackupSettings.aspx?vdid=<%=SessionDomainId%>", 2);
        }
        function RestoreTeamFolder() {
            SetBreadCrumAndOpenPage("Restore Team Folder", "/management/BackupMgr/TUI/TenantBackupRestoreTeamFolder.aspx?child=1&vdid=<%=SessionDomainId%>", 1);
        }
        function AddDevice() {
            SetBreadCrumAndOpenPage("Add Device to Backup", "/management/BackupMgr/TUI/TenantBackupAddDevice.aspx?child=1&vdid=<%=SessionDomainId%>", 1);
        }
        function RestoreDevice() {
            SetBreadCrumAndOpenPage("Restore Device", "/management/BackupMgr/TUI/TenantBackupRestoreDevice.aspx?child=1&vdid=<%=SessionDomainId%>", 1);
        }
        function CloseChildWnd() {
            GoToPreviousBreadCrum();
        }
        


        var _isOverUserMenu = false;
        function TryCloseUserMenuNow() {
            if (!_isOverUserMenu) {
                if ($("#userMenu").is(":visible")) {
                    $("#userMenu").hide();
                    $("#managerMenuIcon").html("&#x0180;");
                }
            }
        }
        function IsOverUserMenu(boolVar) {
            _isOverUserMenu = boolVar;
            setTimeout(function () {
                TryCloseUserMenuNow();
            }, 2000);
        }
        function ToggleUserMenu() {
            if ($("#userMenu").is(":visible")) {
                ForceCloseUserMenu();
            } else {
                $("#userMenu").show();
                $("#managerMenuIcon").html("&#x017c;");
                IsOverUserMenu(false);
            }
        }
        function ForceCloseUserMenu() {
            _isOverUserMenu = false;
            $("#userMenu").hide();
            $("#managerMenuIcon").html("&#x0180;");
        }
        function OnChangePwd() {
            OpenModalPopup('/portal/ChangePasswordPage.aspx', "");
        }
        function onLogout() {
            window.location = "/portal/loginpage.aspx";
        }
    </script>
</asp:Content>
<asp:Content ID="PageBranding" runat="server" ContentPlaceHolderID="LeftMenuTop">
</asp:Content>
<asp:Content ID="MMCSwitches" runat="server" ContentPlaceHolderID="ToolBarRight">
        <asp:Localize runat="server" ID="LocFlwBrwLcl" meta:resourcekey="str_flwBrwLcl" Visible="false">Follow Browser Locale</asp:Localize>
    <asp:Localize runat="server" ID="LocEng" meta:resourcekey="str_eng" Visible="false">English</asp:Localize>
    <asp:Localize runat="server" ID="LocThmBlu" meta:resourcekey="str_thmBlu" Visible="false">Blue</asp:Localize>
    <asp:Localize runat="server" ID="LocThmSkyBlu" meta:resourcekey="str_thmSkyBlu" Visible="false">Sky Blue</asp:Localize>
    <asp:Localize runat="server" ID="LocThmStlBlu" meta:resourcekey="str_thmStlBlu" Visible="false">Steel Blue</asp:Localize>
    <asp:Localize runat="server" ID="LocThmLmeGrn" meta:resourcekey="str_thmLmeGrn" Visible="false">Lime Green</asp:Localize>
    <asp:Localize runat="server" ID="LocThmOlvGrn" meta:resourcekey="str_thmOlvGrn" Visible="false">Olive Green</asp:Localize>
    <asp:Localize runat="server" ID="LocThmTelGrn" meta:resourcekey="str_thmTelGrn" Visible="false">Teal Green</asp:Localize>
    <asp:Localize runat="server" ID="LocThmMve" meta:resourcekey="str_thmMve" Visible="false">Mauve</asp:Localize>
    <asp:Localize runat="server" ID="LocThmOrg" meta:resourcekey="str_thmOrg" Visible="false">Orange</asp:Localize>
    <asp:Localize runat="server" ID="LocThmPnk" meta:resourcekey="str_thmPnk" Visible="false">Pink</asp:Localize>
    <asp:Localize runat="server" ID="LocThmRed" meta:resourcekey="str_thmRed" Visible="false">Red</asp:Localize>
    <asp:Localize runat="server" ID="LocThmGry" meta:resourcekey="str_thmGry" Visible="false">Gray</asp:Localize>
    <asp:Localize runat="server" ID="LocThmCsc" meta:resourcekey="str_thmCsc" Visible="false">Classic</asp:Localize>
    <asp:Localize runat="server" ID="LocThmCst" meta:resourcekey="str_thmCst" Visible="false">Customized</asp:Localize>

    <div class="flexRow"> 
        <div class="flexRow icoTxtBtn" onclick="OnFiles();" style="height:38px;margin-top:6px;">
            <i class="icoTxtBtnIco gladinet-icons sectextcolor" title="<%=LocMyFls.Text %>" style="font-size:24px;line-height:24px;">f</i>
            <div class="icoTxtBtnTxt"><asp:Localize ID="LocMyFls" meta:resourcekey="str_ctrMyFls" runat="server">My Files</asp:Localize></div>
        </div>
        <div class="flexRow icoTxtBtn" onclick="OnMMC();" style="height:38px;margin-left:15px;margin-top:3px;">
            <i class="icoTxtBtnIco gladinet-icons sectextcolor" title="<%=LocTntDsh.Text %>" style="font-size:24px;line-height:24px;">t</i>
            <div class="icoTxtBtnTxt" style="margin-top:2px;"><asp:Localize ID="LocTntDsh" meta:resourcekey="str_tntDsh" runat="server">Tenant Dashboard</asp:Localize></div>
        </div>
        <div class="flexRow trbordercolor" onclick="ToggleUserMenu();" style="margin-left:50px;height:30px; width:30px; margin-top:5px;margin-right:10px; ">
            <i id="managerMenuIcon" class="icoTxtBtnIco gladinet-icons sectextcolor" title="<%=LocUsrMnu.Text %>" style="font-size:30px;">&#x180;</i>
            <div class="icoTxtBtnTxt" style="display:none;"><asp:Localize ID="LocUsrMnu" meta:resourcekey="str_usrMnu" runat="server">User Menu</asp:Localize></div>
        </div>
    </div>
    <div id="userMenu" onmouseover="IsOverUserMenu(true)" onmouseout="IsOverUserMenu(false)">
        <div onclick="ToggleUserMenu();" style="background:rgba(255,255,255,0.05);width:100%;height:40px;"></div>
        <div id="userMenuContainer">
            <ul>
                <li>
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">9</i>
                    <div class="icoTxtBtnTxt" style="margin-top:-20px;"><asp:DropDownList ID="LanguageSelect" runat="server" AutoPostBack="True" Width="200px"  cssclass="form-control newDrpDwn" OnSelectedIndexChanged="LanguageSelect_SelectedIndexChanged" onfocus="ChangingLanguage(true)" onblur="ChangingLanguage(false)"></asp:DropDownList></div>
                </li>
                 <% if (!m_DisableThemeChange){ %>
                <li>
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">B</i>
                    <div class="icoTxtBtnTxt" style="margin-top:-20px;"><asp:DropDownList ID="ThemeList" runat="server" AutoPostBack="True" Width="200px" CssClass="form-control newDrpDwn" OnSelectedIndexChanged="ThemeListSelect_SelectedIndexChanged" onfocus="ChangingTheme(true)" onblur="ChangingTheme(false)"></asp:DropDownList></div></li>
                <% } %>
                 <% if (!SessionIsAdUser) { %>
                <li onclick="OnChangePwd();">
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">r</i><div class="icoTxtBtnTxt"><asp:Localize meta:resourcekey="str_chgPwd" runat="server">Change Password</asp:Localize></div></li>
                <% } %>
                <li onclick="onLogout();">
                    <i class="icoTxtBtnIco gladinet-icons sectextcolor" style="font-size:24px;line-height:24px;">*</i><div class="icoTxtBtnTxt"><asp:Localize meta:resourcekey="str_lgt" runat="server">Logout</asp:Localize> <%=AccountEmail %></div></li>
            </ul>
        </div>
    </div>
</asp:Content>
<asp:Content ID="LeftMenuBar" runat="server" ContentPlaceHolderID="LeftMenuPanel">
	<li class="c-sidebar-nav-item" style="display:none;"><a id="navLinkDashboard" class="c-sidebar-nav-link" href="javascript:;" onclick="OnDashboard();"><i class="gladinet-icons">s</i><div><asp:Localize meta:resourcekey="str_tenDas" runat="server">Tenant Dashboard</asp:Localize></div></a></li>
	<li class="c-sidebar-nav-item"><a id="navLinkDeviceBackMgr" class="c-sidebar-nav-link" href="javascript:;" onclick="OpenDeviceBackMgr();"><i class="gladinet-icons">)</i><div><asp:Localize meta:resourcekey="str_devBac" runat="server">Device Backups</asp:Localize></div></a></li>
	<li class="c-sidebar-nav-item"><a id="navLinkTeamFolderBackMgr" class="c-sidebar-nav-link" href="javascript:;" onclick="OpenTeamFolderBackMgr();"><i class="gladinet-icons">+</i><div><asp:Localize meta:resourcekey="str_teaFolBac" runat="server">Team Folder Backups</asp:Localize></div></a></li>
</asp:Content>

<asp:Content ID="PageTailJS" runat="server" ContentPlaceHolderID="LastBodyContent">
     <script type="text/javascript">
         function adjust() {

         }
         document.addEventListener("DOMContentLoaded", function () {
             OpenDeviceBackMgr();
         });
        
    </script>
</asp:Content>